/**
 * Copyright (c) Tiny Technologies, Inc. All rights reserved.
 * Licensed under the LGPL or a commercial license.
 * For LGPL see License.txt in the project root for license information.
 * For commercial licenses see https://www.tiny.cloud/
 */

import PluginManager from 'tinymce/core/api/PluginManager';

import * as Api from './api/Api';
import * as Commands from './api/Commands';
import * as CharMap from './core/CharMap';
import * as Autocompletion from './ui/Autocompletion';
import * as Buttons from './ui/Buttons';

export default () => {
  PluginManager.add('charmap', (editor) => {
    const charMap = CharMap.getCharMap(editor);
    Commands.register(editor, charMap);
    Buttons.register(editor);

    Autocompletion.init(editor, charMap[0]);

    return Api.get(editor);
  });
};
