
// tiltdrivepro_out_3_neg_table generated by DK/circ_table_gen.py -- do not modify manually

 // variables used
 // --sig_max  -6.000000
 // --table_div  80.394349
 // --table_op  0.500000

struct tabletiltdrivepro_out_3_neg { // 1-dimensional function table
    float low;
    float high;
    float istep;
    int size;
    float data[];
};

template <int tab_size>
struct tabletiltdrivepro_out_3_neg_imp {
    float low;
    float high;
    float istep;
    int size;
    float data[tab_size];
    operator tabletiltdrivepro_out_3_neg&() const { return *(tabletiltdrivepro_out_3_neg*)this; }
};

 static tabletiltdrivepro_out_3_neg_imp<2048> tiltdrivepro_out_3_neg_table __rt_data = {
	0,0.319855,170.583,2048, {
	0.000000000000,0.000426308354,0.000852498576,0.001278570556,0.001704524183,
	0.002130359347,0.002556075936,0.002981673838,0.003407152943,0.003832513137,
	0.004257754310,0.004682876348,0.005107879138,0.005532762569,0.005957526526,
	0.006382170897,0.006806695567,0.007231100423,0.007655385350,0.008079550235,
	0.008503594961,0.008927519415,0.009351323481,0.009775007043,0.010198569986,
	0.010622012193,0.011045333550,0.011468533937,0.011891613240,0.012314571341,
	0.012737408123,0.013160123467,0.013582717256,0.014005189373,0.014427539697,
	0.014849768112,0.015271874497,0.015693858734,0.016115720702,0.016537460283,
	0.016959077356,0.017380571800,0.017801943495,0.018223192321,0.018644318155,
	0.019065320877,0.019486200365,0.019906956496,0.020327589149,0.020748098200,
	0.021168483527,0.021588745006,0.022008882515,0.022428895929,0.022848785124,
	0.023268549977,0.023688190361,0.024107706153,0.024527097227,0.024946363458,
	0.025365504719,0.025784520886,0.026203411830,0.026622177427,0.027040817548,
	0.027459332066,0.027877720854,0.028295983783,0.028714120726,0.029132131555,
	0.029550016139,0.029967774351,0.030385406060,0.030802911138,0.031220289453,
	0.031637540876,0.032054665275,0.032471662521,0.032888532481,0.033305275024,
	0.033721890018,0.034138377331,0.034554736830,0.034970968382,0.035387071855,
	0.035803047114,0.036218894025,0.036634612456,0.037050202270,0.037465663334,
	0.037880995512,0.038296198668,0.038711272668,0.039126217374,0.039541032650,
	0.039955718359,0.040370274365,0.040784700530,0.041198996716,0.041613162785,
	0.042027198598,0.042441104017,0.042854878902,0.043268523114,0.043682036514,
	0.044095418960,0.044508670313,0.044921790431,0.045334779174,0.045747636400,
	0.046160361966,0.046572955731,0.046985417552,0.047397747286,0.047809944790,
	0.048222009920,0.048633942532,0.049045742481,0.049457409623,0.049868943813,
	0.050280344905,0.050691612754,0.051102747213,0.051513748135,0.051924615375,
	0.052335348783,0.052745948214,0.053156413518,0.053566744548,0.053976941154,
	0.054387003187,0.054796930499,0.055206722938,0.055616380355,0.056025902599,
	0.056435289519,0.056844540964,0.057253656781,0.057662636819,0.058071480925,
	0.058480188946,0.058888760728,0.059297196118,0.059705494963,0.060113657106,
	0.060521682394,0.060929570671,0.061337321781,0.061744935568,0.062152411876,
	0.062559750548,0.062966951426,0.063374014353,0.063780939171,0.064187725721,
	0.064594373844,0.065000883381,0.065407254172,0.065813486057,0.066219578876,
	0.066625532467,0.067031346669,0.067437021320,0.067842556258,0.068247951320,
	0.068653206343,0.069058321165,0.069463295620,0.069868129544,0.070272822773,
	0.070677375142,0.071081786484,0.071486056634,0.071890185425,0.072294172690,
	0.072698018263,0.073101721974,0.073505283656,0.073908703141,0.074311980258,
	0.074715114839,0.075118106713,0.075520955710,0.075923661658,0.076326224388,
	0.076728643726,0.077130919501,0.077533051539,0.077935039668,0.078336883714,
	0.078738583502,0.079140138859,0.079541549609,0.079942815576,0.080343936586,
	0.080744912460,0.081145743023,0.081546428097,0.081946967504,0.082347361065,
	0.082747608603,0.083147709937,0.083547664889,0.083947473277,0.084347134920,
	0.084746649639,0.085146017251,0.085545237574,0.085944310424,0.086343235620,
	0.086742012978,0.087140642312,0.087539123439,0.087937456174,0.088335640330,
	0.088733675722,0.089131562162,0.089529299465,0.089926887442,0.090324325904,
	0.090721614664,0.091118753532,0.091515742318,0.091912580833,0.092309268884,
	0.092705806282,0.093102192834,0.093498428348,0.093894512631,0.094290445489,
	0.094686226730,0.095081856158,0.095477333578,0.095872658795,0.096267831613,
	0.096662851835,0.097057719264,0.097452433703,0.097846994953,0.098241402816,
	0.098635657091,0.099029757580,0.099423704082,0.099817496396,0.100211134320,
	0.100604617653,0.100997946191,0.101391119732,0.101784138072,0.102177001006,
	0.102569708329,0.102962259837,0.103354655322,0.103746894579,0.104138977399,
	0.104530903577,0.104922672902,0.105314285166,0.105705740159,0.106097037672,
	0.106488177494,0.106879159413,0.107269983218,0.107660648695,0.108051155633,
	0.108441503816,0.108831693032,0.109221723064,0.109611593698,0.110001304717,
	0.110390855905,0.110780247045,0.111169477917,0.111558548305,0.111947457988,
	0.112336206747,0.112724794361,0.113113220610,0.113501485271,0.113889588122,
	0.114277528941,0.114665307504,0.115052923585,0.115440376962,0.115827667407,
	0.116214794696,0.116601758600,0.116988558894,0.117375195347,0.117761667733,
	0.118147975820,0.118534119380,0.118920098182,0.119305911993,0.119691560583,
	0.120077043717,0.120462361164,0.120847512688,0.121232498055,0.121617317030,
	0.122001969376,0.122386454857,0.122770773234,0.123154924271,0.123538907727,
	0.123922723364,0.124306370941,0.124689850217,0.125073160951,0.125456302899,
	0.125839275820,0.126222079469,0.126604713601,0.126987177972,0.127369472336,
	0.127751596445,0.128133550053,0.128515332911,0.128896944770,0.129278385382,
	0.129659654495,0.130040751859,0.130421677222,0.130802430331,0.131183010933,
	0.131563418774,0.131943653600,0.132323715154,0.132703603181,0.133083317423,
	0.133462857623,0.133842223522,0.134221414862,0.134600431380,0.134979272818,
	0.135357938913,0.135736429403,0.136114744025,0.136492882514,0.136870844607,
	0.137248630037,0.137626238537,0.138003669842,0.138380923683,0.138757999791,
	0.139134897897,0.139511617731,0.139888159020,0.140264521494,0.140640704880,
	0.141016708903,0.141392533290,0.141768177765,0.142143642053,0.142518925876,
	0.142894028956,0.143268951015,0.143643691774,0.144018250952,0.144392628268,
	0.144766823440,0.145140836186,0.145514666222,0.145888313262,0.146261777023,
	0.146635057217,0.147008153558,0.147381065757,0.147753793526,0.148126336575,
	0.148498694613,0.148870867349,0.149242854490,0.149614655743,0.149986270814,
	0.150357699408,0.150728941229,0.151099995979,0.151470863362,0.151841543078,
	0.152212034828,0.152582338311,0.152952453226,0.153322379270,0.153692116140,
	0.154061663533,0.154431021141,0.154800188661,0.155169165784,0.155537952202,
	0.155906547607,0.156274951688,0.156643164135,0.157011184636,0.157379012878,
	0.157746648547,0.158114091329,0.158481340908,0.158848396967,0.159215259189,
	0.159581927254,0.159948400844,0.160314679637,0.160680763312,0.161046651547,
	0.161412344018,0.161777840399,0.162143140366,0.162508243592,0.162873149749,
	0.163237858508,0.163602369540,0.163966682514,0.164330797098,0.164694712960,
	0.165058429764,0.165421947178,0.165785264864,0.166148382485,0.166511299704,
	0.166874016181,0.167236531576,0.167598845548,0.167960957754,0.168322867852,
	0.168684575496,0.169046080341,0.169407382041,0.169768480246,0.170129374610,
	0.170490064781,0.170850550409,0.171210831141,0.171570906625,0.171930776505,
	0.172290440426,0.172649898032,0.173009148965,0.173368192866,0.173727029374,
	0.174085658129,0.174444078768,0.174802290928,0.175160294244,0.175518088350,
	0.175875672880,0.176233047464,0.176590211735,0.176947165320,0.177303907850,
	0.177660438950,0.178016758247,0.178372865366,0.178728759929,0.179084441560,
	0.179439909880,0.179795164508,0.180150205063,0.180505031163,0.180859642425,
	0.181214038462,0.181568218889,0.181922183318,0.182275931361,0.182629462628,
	0.182982776728,0.183335873268,0.183688751855,0.184041412093,0.184393853587,
	0.184746075938,0.185098078749,0.185449861619,0.185801424146,0.186152765929,
	0.186503886562,0.186854785642,0.187205462760,0.187555917511,0.187906149483,
	0.188256158267,0.188605943451,0.188955504622,0.189304841365,0.189653953265,
	0.190002839903,0.190351500863,0.190699935723,0.191048144062,0.191396125458,
	0.191743879488,0.192091405724,0.192438703741,0.192785773111,0.193132613404,
	0.193479224189,0.193825605034,0.194171755504,0.194517675166,0.194863363581,
	0.195208820313,0.195554044922,0.195899036967,0.196243796006,0.196588321595,
	0.196932613288,0.197276670640,0.197620493202,0.197964080524,0.198307432156,
	0.198650547645,0.198993426538,0.199336068378,0.199678472708,0.200020639071,
	0.200362567006,0.200704256053,0.201045705747,0.201386915625,0.201727885220,
	0.202068614065,0.202409101692,0.202749347629,0.203089351404,0.203429112544,
	0.203768630573,0.204107905015,0.204446935391,0.204785721222,0.205124262025,
	0.205462557319,0.205800606618,0.206138409436,0.206475965284,0.206813273675,
	0.207150334117,0.207487146116,0.207823709179,0.208160022810,0.208496086512,
	0.208831899784,0.209167462127,0.209502773038,0.209837832013,0.210172638545,
	0.210507192129,0.210841492253,0.211175538409,0.211509330083,0.211842866761,
	0.212176147928,0.212509173065,0.212841941654,0.213174453174,0.213506707102,
	0.213838702913,0.214170440082,0.214501918081,0.214833136380,0.215164094447,
	0.215494791751,0.215825227756,0.216155401925,0.216485313720,0.216814962601,
	0.217144348026,0.217473469452,0.217802326333,0.218130918122,0.218459244269,
	0.218787304224,0.219115097434,0.219442623345,0.219769881400,0.220096871042,
	0.220423591709,0.220750042842,0.221076223874,0.221402134242,0.221727773378,
	0.222053140713,0.222378235675,0.222703057691,0.223027606187,0.223351880586,
	0.223675880309,0.223999604776,0.224323053403,0.224646225608,0.224969120803,
	0.225291738400,0.225614077810,0.225936138439,0.226257919694,0.226579420980,
	0.226900641697,0.227221581247,0.227542239027,0.227862614434,0.228182706861,
	0.228502515701,0.228822040345,0.229141280180,0.229460234593,0.229778902967,
	0.230097284686,0.230415379130,0.230733185675,0.231050703700,0.231367932577,
	0.231684871680,0.232001520377,0.232317878037,0.232633944026,0.232949717708,
	0.233265198445,0.233580385596,0.233895278518,0.234209876569,0.234524179100,
	0.234838185463,0.235151895009,0.235465307083,0.235778421030,0.236091236195,
	0.236403751917,0.236715967536,0.237027882387,0.237339495805,0.237650807123,
	0.237961815671,0.238272520776,0.238582921764,0.238893017959,0.239202808682,
	0.239512293253,0.239821470989,0.240130341204,0.240438903211,0.240747156321,
	0.241055099843,0.241362733081,0.241670055340,0.241977065922,0.242283764126,
	0.242590149249,0.242896220586,0.243201977430,0.243507419071,0.243812544797,
	0.244117353896,0.244421845649,0.244726019339,0.245029874245,0.245333409643,
	0.245636624808,0.245939519013,0.246242091528,0.246544341620,0.246846268554,
	0.247147871595,0.247449150002,0.247750103034,0.248050729948,0.248351029997,
	0.248651002433,0.248950646505,0.249249961460,0.249548946543,0.249847600995,
	0.250145924058,0.250443914967,0.250741572958,0.251038897265,0.251335887117,
	0.251632541743,0.251928860369,0.252224842217,0.252520486509,0.252815792464,
	0.253110759297,0.253405386222,0.253699672451,0.253993617194,0.254287219656,
	0.254580479041,0.254873394553,0.255165965390,0.255458190749,0.255750069825,
	0.256041601810,0.256332785894,0.256623621265,0.256914107107,0.257204242603,
	0.257494026933,0.257783459275,0.258072538804,0.258361264694,0.258649636113,
	0.258937652232,0.259225312214,0.259512615223,0.259799560421,0.260086146964,
	0.260372374010,0.260658240711,0.260943746218,0.261228889680,0.261513670244,
	0.261798087051,0.262082139244,0.262365825962,0.262649146340,0.262932099513,
	0.263214684612,0.263496900766,0.263778747101,0.264060222741,0.264341326808,
	0.264622058422,0.264902416698,0.265182400752,0.265462009695,0.265741242636,
	0.266020098683,0.266298576939,0.266576676508,0.266854396488,0.267131735977,
	0.267408694069,0.267685269858,0.267961462433,0.268237270881,0.268512694288,
	0.268787731736,0.269062382305,0.269336645074,0.269610519117,0.269884003509,
	0.270157097318,0.270429799615,0.270702109464,0.270974025929,0.271245548070,
	0.271516674948,0.271787405618,0.272057739133,0.272327674546,0.272597210906,
	0.272866347260,0.273135082651,0.273403416123,0.273671346715,0.273938873465,
	0.274205995407,0.274472711575,0.274739020999,0.275004922707,0.275270415726,
	0.275535499079,0.275800171788,0.276064432871,0.276328281345,0.276591716225,
	0.276854736524,0.277117341251,0.277379529415,0.277641300020,0.277902652072,
	0.278163584570,0.278424096514,0.278684186900,0.278943854724,0.279203098979,
	0.279461918654,0.279720312738,0.279978280217,0.280235820076,0.280492931296,
	0.280749612857,0.281005863737,0.281261682912,0.281517069356,0.281772022040,
	0.282026539935,0.282280622007,0.282534267224,0.282787474548,0.283040242942,
	0.283292571365,0.283544458775,0.283795904129,0.284046906381,0.284297464483,
	0.284547577386,0.284797244039,0.285046463388,0.285295234378,0.285543555954,
	0.285791427055,0.286038846624,0.286285813596,0.286532326910,0.286778385499,
	0.287023988298,0.287269134237,0.287513822246,0.287758051254,0.288001820188,
	0.288245127972,0.288487973531,0.288730355787,0.288972273661,0.289213726071,
	0.289454711937,0.289695230174,0.289935279699,0.290174859424,0.290413968262,
	0.290652605125,0.290890768923,0.291128458565,0.291365672958,0.291602411008,
	0.291838671623,0.292074453704,0.292309756157,0.292544577883,0.292778917783,
	0.293012774757,0.293246147705,0.293479035526,0.293711437116,0.293943351373,
	0.294174777191,0.294405713468,0.294636159096,0.294866112970,0.295095573982,
	0.295324541025,0.295553012992,0.295780988772,0.296008467258,0.296235447339,
	0.296461927905,0.296687907847,0.296913386052,0.297138361411,0.297362832811,
	0.297586799141,0.297810259290,0.298033212146,0.298255656596,0.298477591530,
	0.298699015834,0.298919928397,0.299140328107,0.299360213853,0.299579584523,
	0.299798439007,0.300016776192,0.300234594970,0.300451894228,0.300668672859,
	0.300884929753,0.301100663801,0.301315873895,0.301530558928,0.301744717793,
	0.301958349385,0.302171452598,0.302384026328,0.302596069473,0.302807580930,
	0.303018559597,0.303229004376,0.303438914166,0.303648287871,0.303857124394,
	0.304065422640,0.304273181516,0.304480399930,0.304687076790,0.304893211009,
	0.305098801499,0.305303847174,0.305508346951,0.305712299748,0.305915704486,
	0.306118560085,0.306320865471,0.306522619570,0.306723821310,0.306924469622,
	0.307124563440,0.307324101699,0.307523083337,0.307721507295,0.307919372516,
	0.308116677946,0.308313422535,0.308509605233,0.308705224996,0.308900280781,
	0.309094771549,0.309288696263,0.309482053892,0.309674843406,0.309867063778,
	0.310058713986,0.310249793012,0.310440299840,0.310630233458,0.310819592858,
	0.311008377038,0.311196584997,0.311384215739,0.311571268273,0.311757741611,
	0.311943634771,0.312128946774,0.312313676646,0.312497823418,0.312681386125,
	0.312864363806,0.313046755508,0.313228560280,0.313409777176,0.313590405257,
	0.313770443589,0.313949891242,0.314128747292,0.314307010821,0.314484680916,
	0.314661756670,0.314838237182,0.315014121557,0.315189408905,0.315364098344,
	0.315538188996,0.315711679990,0.315884570463,0.316056859557,0.316228546419,
	0.316399630207,0.316570110082,0.316739985213,0.316909254777,0.317077917957,
	0.317245973944,0.317413421935,0.317580261135,0.317746490758,0.317912110023,
	0.318077118159,0.318241514402,0.318405297995,0.318568468191,0.318731024249,
	0.318892965437,0.319054291033,0.319215000321,0.319375092595,0.319534567157,
	0.319693423318,0.319851660398,0.320009277726,0.320166274640,0.320322650488,
	0.320478404625,0.320633536417,0.320788045241,0.320941930480,0.321095191531,
	0.321247827796,0.321399838692,0.321551223642,0.321701982082,0.321852113456,
	0.322001617219,0.322150492839,0.322298739790,0.322446357560,0.322593345648,
	0.322739703562,0.322885430821,0.323030526957,0.323174991512,0.323318824039,
	0.323462024104,0.323604591282,0.323746525163,0.323887825344,0.324028491439,
	0.324168523071,0.324307919875,0.324446681500,0.324584807604,0.324722297861,
	0.324859151956,0.324995369584,0.325130950458,0.325265894299,0.325400200843,
	0.325533869837,0.325666901045,0.325799294240,0.325931049211,0.326062165758,
	0.326192643696,0.326322482852,0.326451683070,0.326580244203,0.326708166122,
	0.326835448708,0.326962091860,0.327088095487,0.327213459515,0.327338183882,
	0.327462268544,0.327585713466,0.327708518632,0.327830684039,0.327952209698,
	0.328073095634,0.328193341889,0.328312948519,0.328431915594,0.328550243200,
	0.328667931437,0.328784980421,0.328901390283,0.329017161169,0.329132293241,
	0.329246786676,0.329360641665,0.329473858417,0.329586437155,0.329698378118,
	0.329809681561,0.329920347755,0.330030376985,0.330139769553,0.330248525778,
	0.330356645993,0.330464130549,0.330570979810,0.330677194160,0.330782773996,
	0.330887719732,0.330992031800,0.331095710645,0.331198756730,0.331301170534,
	0.331402952554,0.331504103301,0.331604623303,0.331704513105,0.331803773268,
	0.331902404369,0.332000407002,0.332097781778,0.332194529323,0.332290650282,
	0.332386145313,0.332481015093,0.332575260316,0.332668881690,0.332761879942,
	0.332854255814,0.332946010065,0.333037143471,0.333127656824,0.333217550932,
	0.333306826620,0.333395484730,0.333483526119,0.333570951663,0.333657762252,
	0.333743958793,0.333829542209,0.333914513441,0.333998873445,0.334082623193,
	0.334165763674,0.334248295893,0.334330220870,0.334411539644,0.334492253268,
	0.334572362810,0.334651869357,0.334730774008,0.334809077883,0.334886782112,
	0.334963887846,0.335040396249,0.335116308500,0.335191625795,0.335266349346,
	0.335340480380,0.335414020137,0.335486969876,0.335559330869,0.335631104404,
	0.335702291784,0.335772894325,0.335842913362,0.335912350241,0.335981206325,
	0.336049482991,0.336117181629,0.336184303647,0.336250850463,0.336316823513,
	0.336382224246,0.336447054123,0.336511314622,0.336575007232,0.336638133460,
	0.336700694821,0.336762692848,0.336824129085,0.336885005091,0.336945322436,
	0.337005082705,0.337064287494,0.337122938415,0.337181037090,0.337238585153,
	0.337295584252,0.337352036048,0.337407942212,0.337463304428,0.337518124393,
	0.337572403813,0.337626144409,0.337679347911,0.337732016060,0.337784150612,
	0.337835753328,0.337886825986,0.337937370371,0.337987388279,0.338036881517,
	0.338085851903,0.338134301264,0.338182231438,0.338229644272,0.338276541623,
	0.338322925357,0.338368797350,0.338414159488,0.338459013665,0.338503361783,
	0.338547205754,0.338590547500,0.338633388948,0.338675732035,0.338717578707,
	0.338758930917,0.338799790626,0.338840159801,0.338880040419,0.338919434463,
	0.338958343923,0.338996770796,0.339034717086,0.339072184803,0.339109175963,
	0.339145692591,0.339181736716,0.339217310371,0.339252415599,0.339287054445,
	0.339321228961,0.339354941205,0.339388193237,0.339420987126,0.339453324942,
	0.339485208763,0.339516640668,0.339547622742,0.339578157075,0.339608245758,
	0.339637890888,0.339667094565,0.339695858893,0.339724185977,0.339752077928,
	0.339779536857,0.339806564880,0.339833164114,0.339859336679,0.339885084698,
	0.339910410293,0.339935315592,0.339959802722,0.339983873812,0.340007530993,
	0.340030776397,0.340053612157,0.340076040405,0.340098063278,0.340119682909,
	0.340140901435,0.340161720991,0.340182143713,0.340202171738,0.340221807199,
	0.340241052234,0.340259908976,0.340278379560,0.340296466119,0.340314170786,
	0.340331495691,0.340348442965,0.340365014736,0.340381213132,0.340397040278,
	0.340412498297,0.340427589311,0.340442315441,0.340456678802,0.340470681511,
	0.340484325679,0.340497613417,0.340510546831,0.340523128026,0.340535359103,
	0.340547242159,0.340558779291,0.340569972588,0.340580824139,0.340591336027,
	0.340601510334,0.340611349136,0.340620854505,0.340630028509,0.340638873213,
	0.340647390677,0.340655582955,0.340663452098,0.340671000153,0.340678229161,
	0.340685141158,0.340691738175,0.340698022239,0.340703995371,0.340709659587,
	0.340715016896,0.340720069305,0.340724818811,0.340729267409,0.340733417087,
	0.340737269826,0.340740827603,0.340744092388,0.340747066144,0.340749750829,
	0.340752148394,0.340754260785,0.340756089940,0.340757637791,0.340758906263,
	0.340759897276,0.340760612741,0.340761054563,0.340761224641,0.340761124866,
	0.340760757122,0.340760123287,0.340759225230,0.340758064816,0.340756643898,
	0.340754964326,0.340753027940,0.340750836573,0.340748392053,0.340745696196,
	0.340742750815,0.340739557711,0.340736118680,0.340732435511,0.340728509983,
	0.340724343867,0.340719938929,0.340715296924,0.340710419600,0.340705308699,
	0.340699965951,0.340694393082,0.340688591807,0.340682563834,0.340676310863,
	0.340669834586,0.340663136685,0.340656218836,0.340649082705,0.340641729951,
	0.340634162224,0.340626381166,0.340618388409,0.340610185580,0.340601774293,
	0.340593156158,0.340584332774,0.340575305732,0.340566076614,0.340556646995,
	0.340547018441,0.340537192508,0.340527170745,0.340516954691,0.340506545879,
	0.340495945832,0.340485156062,0.340474178077,0.340463013373,0.340451663439,
	0.340440129755,0.340428413792,0.340416517013,0.340404440873,0.340392186816,
	0.340379756280,0.340367150693,0.340354371476,0.340341420039,0.340328297786,
	0.340315006111,0.340301546399,0.340287920027,0.340274128364,0.340260172771,
	0.340246054598,0.340231775190,0.340217335879,0.340202737994,0.340187982851,
	0.340173071760,0.340158006021,0.340142786927,0.340127415762,0.340111893802,
	0.340096222314,0.340080402557,0.340064435781,0.340048323230,0.340032066136,
	0.340015665727,0.339999123219,0.339982439822,0.339965616737,0.339948655158,
	0.339931556268,0.339914321246,0.339896951259,0.339879447468,0.339861811026,
	0.339844043078,0.339826144759,0.339808117199,0.339789961518,0.339771678830,
	0.339753270238,0.339734736841,0.339716079726,0.339697299977,0.339678398666,
	0.339659376859,0.339640235616,0.339620975985,0.339601599011,0.339582105729,
	0.339562497166,0.339542774343,0.339522938272,0.339502989959,0.339482930402,
	0.339462760591,0.339442481509,0.339422094132,0.339401599428,0.339380998359,
	0.339360291878,0.339339480932,0.339318566461,0.339297549396,0.339276430664,
	0.339255211183,0.339233891863,0.339212473609,0.339190957319,0.339169343882,
	0.339147634182,0.339125829096,0.339103929494,0.339081936238,0.339059850185,
	0.339037672185,0.339015403079,0.338993043706,0.338970594894,0.338948057467,
	0.338925432241,0.338902720027,0.338879921628,0.338857037841,0.338834069458,
	0.338811017263,0.338787882035,0.338764664545,0.338741365560,0.338717985838,
	0.338694526135,0.338670987197,0.338647369765,0.338623674575,0.338599902356,
	0.338576053832,0.338552129720,0.338528130732,0.338504057574,0.338479910944,
	0.338455691539,0.338431400045,0.338407037146,0.338382603519,0.338358099835,
	0.338333526761,0.338308884956,0.338284175076,0.338259397769,0.338234553680,
	0.338209643448,0.338184667704,0.338159627078,0.338134522192,0.338109353662,
	0.338084122102,0.338058828118,0.338033472311,0.338008055278,0.337982577612,
	0.337957039898,0.337931442717,0.337905786647,0.337880072259,0.337854300120,
	0.337828470791,0.337802584829,0.337776642788,0.337750645213,0.337724592649,
	0.337698485632,0.337672324696,0.337646110371,0.337619843180,0.337593523643,
	0.337567152275,0.337540729586,0.337514256083,0.337487732268,0.337461158637,
	0.337434535685,0.337407863899,0.337381143763,0.337354375759,0.337327560361,
	0.337300698043,0.337273789270,0.337246834507,0.337219834213,0.337192788843,
	0.337165698849,0.337138564677,0.337111386772,0.337084165571,0.337056901512,
	0.337029595024,0.337002246537,0.336974856473,0.336947425254,0.336919953294,
	0.336892441008,0.336864888803,0.336837297085,0.336809666256,0.336781996714,
	0.336754288852,0.336726543063,0.336698759732,0.336670939245,0.336643081981,
	0.336615188318,0.336587258628,0.336559293283,0.336531292648,0.336503257088,
	0.336475186962,0.336447082628,0.336418944438,0.336390772744,0.336362567893,
	0.336334330228,0.336306060092,0.336277757820,0.336249423749,0.336221058210,
	0.336192661531,0.336164234039,0.336135776055,0.336107287900,0.336078769889,
	0.336050222338,0.336021645557,0.335993039854,0.335964405533,0.335935742899,
	0.335907052250,0.335878333883,0.335849588092,0.335820815169,0.335792015402,
	0.335763189078,0.335734336480,0.335705457888,0.335676553581,0.335647623834,
	0.335618668920,0.335589689110,0.335560684672,0.335531655871,0.335502602970,
	0.335473526230,0.335444425908,0.335415302261,0.335386155542,0.335356986002,
	0.335327793889,0.335298579449,0.335269342928,0.335240084565,0.335210804601,
	0.335181503273,0.335152180816,0.335122837463,0.335093473443,0.335064088986,
	0.335034684318,0.335005259663,0.334975815242,0.334946351276,0.334916867983,
	0.334887365579,0.334857844276,0.334828304287,0.334798745822,0.334769169089,
	0.334739574292,0.334709961637,0.334680331324,0.334650683554,0.334621018525,
	0.334591336434,0.334561637474,0.334531921839,0.334502189718,0.334472441301,
	0.334442676774,0.334412896324,0.334383100134,0.334353288385,0.334323461258,
	0.334293618930,0.334263761580,0.334233889380,0.334204002506,0.334174101128,
	0.334144185417,0.334114255541,0.334084311667,0.334054353960,0.334024382583,
	0.333994397699,0.333964399468,0.333934388050,0.333904363601,0.333874326277,
	0.333844276233,0.333814213623,0.333784138597,0.333754051305,0.333723951897,
	0.333693840518,0.333663717316,0.333633582434,0.333603436016,0.333573278203,
	0.333543109135,0.333512928951,0.333482737789,0.333452535784,0.333422323073,
	0.333392099788,0.333361866062,0.333331622026,0.333301367810,0.333271103542,
	0.333240829349,0.333210545358,0.333180251694,0.333149948480,0.333119635838,
	0.333089313891,0.333058982757,0.333028642556,0.332998293406,0.332967935424,
	0.332937568724,0.332907193421,0.332876809630,0.332846417461,0.332816017026,
	0.332785608435,0.332755191797,0.332724767219,0.332694334810,0.332663894674,
	0.332633446916,0.332602991641,0.332572528950,0.332542058946,0.332511581730,
	0.332481097401,0.332450606057,0.332420107798,0.332389602720,0.332359090919,
	0.332328572490,0.332298047527,0.332267516123,0.332236978370,0.332206434361,
	0.332175884185,0.332145327932,0.332114765691,0.332084197550,0.332053623596,
	0.332023043914,0.331992458591,0.331961867711,0.331931271357,0.331900669612,
	0.331870062559,0.331839450279,0.331808832851,0.331778210356,0.331747582874,
	0.331716950480,0.331686313254,0.331655671272,0.331625024609,0.331594373341,
	0.331563717543,0.331533057286,0.331502392646,0.331471723693,0.331441050500,
	0.331410373137,0.331379691674,0.331349006180,0.331318316725,0.331287623377,
	0.331256926202,0.331226225269,0.331195520641,0.331164812386,0.331134100568,
	0.331103385251,0.331072666498,0.331041944373,0.331011218937,0.330980490253,
	0.330949758381,0.330919023383,0.330888285317,0.330857544243,0.330826800220,
	0.330796053306,0.330765303558,0.330734551033,0.330703795789,0.330673037880,
	0.330642277362,0.330611514289,0.330580748717,0.330549980698,0.330519210286,
	0.330488437534,0.330457662493,0.330426885215,0.330396105752,0.330365324153,
	0.330334540469,0.330303754750,0.330272967045,0.330242177402,0.330211385869,
	0.330180592494,0.330149797324,0.330119000407,0.330088201788,0.330057401512,
	0.330026599627,0.329995796175,0.329964991203,0.329934184753,0.329903376869,
	0.329872567596,0.329841756974,0.329810945047,0.329780131857,0.329749317444,
	0.329718501851,0.329687685117,0.329656867283,0.329626048389,0.329595228475,
	0.329564407578,0.329533585739,0.329502762995,0.329471939384,0.329441114944,
	0.329410289712,0.329379463724,0.329348637018,0.329317809629,0.329286981593,
	0.329256152945,0.329225323720,0.329194493954,0.329163663680,0.329132832932,
	0.329102001744,0.329071170149,0.329040338181,0.329009505871,0.328978673252,
	0.328947840357,0.328917007217,0.328886173862,0.328855340325,0.328824506636,
	0.328793672826,0.328762838924,0.328732004960,0.328701170965,0.328670336966,
	0.328639502994,0.328608669077,0.328577835242,0.328547001520,0.328516167936,
	0.328485334519,0.328454501296,0.328423668293,0.328392835539,0.328362003058,
	0.328331170878,0.328300339024,0.328269507522,0.328238676397,0.328207845675,
	0.328177015380,0.328146185537,0.328115356170,0.328084527304,0.328053698963,
	0.328022871170,0.327992043949,0.327961217322,0.327930391314,0.327899565946,
	0.327868741241,0.327837917222,0.327807093910,0.327776271328,0.327745449497,
	0.327714628439,0.327683808174,0.327652988724,0.327622170109,0.327591352350,
	0.327560535468,0.327529719483,0.327498904414,0.327468090281,0.327437277105,
	0.327406464903,0.327375653696,0.327344843503,0.327314034341,0.327283226231,
	0.327252419190,0.327221613236,0.327190808388,0.327160004664,0.327129202080,
	0.327098400655,0.327067600406,0.327036801350,0.327006003504,0.326975206885,
	0.326944411510,0.326913617394,0.326882824556,0.326852033009,0.326821242771,
	0.326790453857,0.326759666284,0.326728880066,0.326698095218,0.326667311757,
	0.326636529697,0.326605749052,0.326574969839,0.326544192071,0.326513415762,
	0.326482640928,0.326451867582,0.326421095738,0.326390325410,0.326359556612,
	0.326328789357,0.326298023660,0.326267259532,0.326236496988,0.326205736041,
	0.326174976702,0.326144218986,0.326113462905,0.326082708471,0.326051955697,
	0.326021204594,0.325990455176,0.325959707455,0.325928961441,0.325898217147,
	0.325867474585,0.325836733766,0.325805994701,0.325775257402,0.325744521881,
	0.325713788147,0.325683056213,0.325652326088,0.325621597785,0.325590871312,
	0.325560146682,0.325529423904,0.325498702989,0.325467983946,0.325437266787,
	0.325406551521,0.325375838157,0.325345126706,0.325314417178,0.325283709582,
	0.325253003927,0.325222300223,0.325191598480,0.325160898706,0.325130200911,
	0.325099505103,0.325068811292,0.325038119487,0.325007429695,0.324976741927,
	0.324946056190,0.324915372493,0.324884690844,0.324854011252,0.324823333725,
	0.324792658271,0.324761984899,0.324731313615,0.324700644428,0.324669977347,
	0.324639312377,0.324608649529,0.324577988807,0.324547330222,0.324516673779,
	0.324486019486,0.324455367351,0.324424717380,0.324394069581,0.324363423960,
	0.324332780526,0.324302139284,0.324271500241,0.324240863405,0.324210228782,
	0.324179596379,0.324148966201,0.324118338256,0.324087712551,0.324057089090,
	0.324026467882,0.323995848931,0.323965232245,0.323934617828,0.323904005688,
	0.323873395831,0.323842788261,0.323812182985,0.323781580009,0.323750979338,
	0.323720380979,0.323689784936,0.323659191216,0.323628599824,0.323598010764,
	0.323567424044,0.323536839667,0.323506257639,0.323475677966,0.323445100653,
	0.323414525704,0.323383953125,0.323353382921,0.323322815096,0.323292249656,
	0.323261686605,0.323231125949,0.323200567691,0.323170011837,0.323139458391,
	0.323108907359,0.323078358743,0.323047812550,0.323017268783,0.322986727446,
	0.322956188545,0.322925652083,0.322895118065,0.322864586495,0.322834057377,
	0.322803530715,0.322773006514,0.322742484776,0.322711965508,0.322681448711,
	0.322650934391,0.322620422551,0.322589913194,0.322559406326,0.322528901949,
	0.322498400067,0.322467900684,0.322437403803,0.322406909429,0.322376417564,
	0.322345928213,0.322315441378,0.322284957063,0.322254475272,0.322223996007,
	0.322193519273,0.322163045072,0.322132573408,0.322102104284,0.322071637704,
	0.322041173669,0.322010712184,0.321980253252,0.321949796875,0.321919343057,
	0.321888891800,0.321858443108,0.321827996984,0.321797553430,0.321767112449,
	0.321736674045,0.321706238219,0.321675804975,0.321645374316,0.321614946243,
	0.321584520761,0.321554097871,0.321523677576,0.321493259878,0.321462844781,
	0.321432432287,0.321402022398,0.321371615117,0.321341210446,0.321310808388,
	0.321280408944,0.321250012119,0.321219617913,0.321189226329,0.321158837369,
	0.321128451036,0.321098067333,0.321067686260,0.321037307821,0.321006932017,
	0.320976558850,0.320946188324,0.320915820439,0.320885455199,0.320855092604,
	0.320824732658,0.320794375361,0.320764020717,0.320733668726,0.320703319392,
	0.320672972715,0.320642628698,0.320612287343,0.320581948651,0.320551612624,
	0.320521279265,0.320490948574,0.320460620554,0.320430295207,0.320399972533,
	0.320369652536,0.320339335216,0.320309020575,0.320278708615,0.320248399338,
	0.320218092745,0.320187788837,0.320157487617,0.320127189085,0.320096893244,
	0.320066600095,0.320036309639,0.320006021878,0.319975736814,0.319945454447,
	0.319915174780,0.319884897813,0.319854623548
	}
};

double always_inline tiltdrivepro_out_3_negclip(double x) {
    double f = fabs(x);
    f = f * tiltdrivepro_out_3_neg_table.istep;
    int i = static_cast<int>(f);
    if (i < 0) {
        f = tiltdrivepro_out_3_neg_table.data[0];
    } else if (i >= tiltdrivepro_out_3_neg_table.size-1) {
        f = tiltdrivepro_out_3_neg_table.data[tiltdrivepro_out_3_neg_table.size-1];
    } else {
    f -= i;
    f = tiltdrivepro_out_3_neg_table.data[i]*(1-f) + tiltdrivepro_out_3_neg_table.data[i+1]*f;
    }
    return copysign(f, x);
}

