/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 *  ianjuta-environment.h -- Autogenerated from libanjuta.idl
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef _IANJUTA_ENVIRONMENT_H_
#define _IANJUTA_ENVIRONMENT_H_

#include <glib-object.h>

G_BEGIN_DECLS

#define IANJUTA_TYPE_ENVIRONMENT (ianjuta_environment_get_type ())
#define IANJUTA_ENVIRONMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), IANJUTA_TYPE_ENVIRONMENT, IAnjutaEnvironment))
#define IANJUTA_IS_ENVIRONMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), IANJUTA_TYPE_ENVIRONMENT))
#define IANJUTA_ENVIRONMENT_GET_IFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), IANJUTA_TYPE_ENVIRONMENT, IAnjutaEnvironmentIface))

#define IANJUTA_TYPE_ENVIRONMENT_ERROR (ianjuta_environment_error_get_type())

#define IANJUTA_ENVIRONMENT_ERROR ianjuta_environment_error_quark()

typedef struct _IAnjutaEnvironment IAnjutaEnvironment;
typedef struct _IAnjutaEnvironmentIface IAnjutaEnvironmentIface;

/**
   * IAnjutaEnvironmentError:
   * @IANJUTA_BUILDER_CONFIG: Configuration of the environment is wrong
   * @IANJUTA_BUILDER_OTHER_ERROR: Other Error (no unknown ;-))
   *
   * Possible build errors
   */
typedef enum {
	IANJUTA_ENVIRONMENT_CONFIG,
	IANJUTA_ENVIRONMENT_OTHER_ERROR
} IAnjutaEnvironmentError;


struct _IAnjutaEnvironmentIface {
	GTypeInterface g_iface;
	

	gchar* (*get_real_directory) (IAnjutaEnvironment *obj, gchar *dir, GError **err);
	gboolean (*override) (IAnjutaEnvironment *obj, gchar **dirp,  gchar ***argvp,  gchar ***envp, GError **err);

};

GType ianjuta_environment_error_get_type (void);

GQuark ianjuta_environment_error_quark     (void);
GType  ianjuta_environment_get_type        (void);

gchar* ianjuta_environment_get_real_directory (IAnjutaEnvironment *obj, gchar *dir, GError **err);

gboolean ianjuta_environment_override (IAnjutaEnvironment *obj, gchar **dirp,  gchar ***argvp,  gchar ***envp, GError **err);


G_END_DECLS

#endif
