/***************************************************************************

  defaults.h

  This file is part of the CBE Dictionary package

  Copyright (c) 2003 Antoby - antoby@users.sourceforge.net

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

****************************************************************************/

#ifndef _DEFAULTS_H_
#define _DEFAULTS_H_


#if HAVE_CONFIG_H
#include "config.h"
#include "config_dict.h"
#endif


#define FILENAME_LENGTH             500
#define MAX_WORD_LEN                70
#define MAX_WORDS_ALLOWED           7

// Configuration file
#define REGISTRY_FILE               ".cbedic"
#define REGISTRY_FILE_SUFFIX        "~"
#define ENV_HOME                    "HOME"

// Strings in configuration file
#define OPTION_DATA_DIR             "DictionaryDataDir"
#define OPTION_SEPARATE_MEANINGS    "SeparatedMeanings"
#define OPTION_LATIN_OUTPUT         "LatinOutput"
#define OPTION_LATIN_INPUT          "LatinInput"
#define OPTION_HTML_OUTPUT          "HTMLOutput"
#define OPTION_EXACT_MATCH          "ExactMatch"
#define OPTION_START_INTERACTIVE    "StartInteractive"

// dictionary location
#ifdef DATA_DIR_CONFIG
#define DICTIONARY_DATA_DIR         DICTIONARY_DATA_DIR_DEFAULT
#else
#define DICTIONARY_DATA_DIR        "/usr/local/share/"
#endif

// Default values
#define DEFAULT_SEPARATE_MEANINGS   false
#define DEFAULT_LATIN_OUTPUT        false
#define DEFAULT_LATIN_INPUT         false
#define DEFAULT_HTML_OUTPUT         false
#define DEFAULT_EXACT_MATCH         false
#define DEFAULT_START_INTERACTIVE   false

#endif
