from oslo_policy import policy

# Define your custom rules with descriptions
rules = [
    # Default deny rule
    policy.RuleDefault(
        name='default',
        check_str='!',
        description='Default rule that denies all actions unless explicitly allowed'
    ),

    # Role hierarchy helper rules
    policy.RuleDefault(
        name='is_admin',
        check_str='role:admin',
        description='Check if user has admin role'
    ),
    policy.RuleDefault(
        name='is_vmms_operator',
        check_str='role:vmms_operator or role:admin',
        description='Check if user has vmms_operator or admin role (can perform all operations)'
    ),
    policy.RuleDefault(
        name='is_vmms_viewer',
        check_str='role:vmms_viewer or role:vmms_operator or role:admin',
        description='Check if user has vmms_viewer, vmms_operator, or admin role (can view operations)'
    ),
    
    # API-specific rules using helper rules (cleaner and more maintainable)
    policy.DocumentedRuleDefault(
        name='vmms:add',
        check_str='rule:is_vmms_operator',
        description='Add a VM to migration scheduler',
        operations=[
            {
                'method': 'POST',
                'path': '/v2/vms'
            }
        ]
    ),
    policy.DocumentedRuleDefault(
        name='vmms:remove',
        check_str='rule:is_vmms_operator',
        description='Remove a VM from migration scheduler',
        operations=[
            {
                'method': 'DELETE',
                'path': '/v2/vms/{migration_id}'
            }
        ]
    ),
    policy.DocumentedRuleDefault(
        name='vmms:update',
        check_str='rule:is_vmms_operator',
        description='Update VM migration settings',
        operations=[
            {
                'method': 'PUT',
                'path': '/v2/vms/{migration_id}'
            }
        ]
    ),
    policy.DocumentedRuleDefault(
        name='vmms:list',
        check_str='rule:is_vmms_viewer',
        description='List all VM migrations',
        operations=[
            {
                'method': 'GET',
                'path': '/v2/vms'
            }
        ]
    ),
    policy.DocumentedRuleDefault(
        name='vmms:show',
        check_str='rule:is_vmms_viewer',
        description='Show details of a specific VM migration',
        operations=[
            {
                'method': 'GET',
                'path': '/v2/vms/{migration_id}'
            }
        ]
    ),
    policy.DocumentedRuleDefault(
        name='vmms:output',
        check_str='rule:is_vmms_viewer',
        description='Get output from VM migration',
        operations=[
            {
                'method': 'GET',
                'path': '/v2/vms/{migration_id}/output'
            }
        ]
    ),
]

def list_rules():
    return rules
