/* SPDX-License-Identifier: BSD-3-Clause
 * Copyright(c) 2025 Huawei Technologies Co., Ltd
 */

#ifndef _HINIC3_CMD_H_
#define _HINIC3_CMD_H_

#define NIC_RSS_CMD_TEMP_ALLOC			0x01
#define NIC_RSS_CMD_TEMP_FREE			0x02

#define HINIC3_RSS_TYPE_VALID_SHIFT		23
#define HINIC3_RSS_TYPE_TCP_IPV6_EXT_SHIFT	24
#define HINIC3_RSS_TYPE_IPV6_EXT_SHIFT		25
#define HINIC3_RSS_TYPE_TCP_IPV6_SHIFT		26
#define HINIC3_RSS_TYPE_IPV6_SHIFT		27
#define HINIC3_RSS_TYPE_TCP_IPV4_SHIFT		28
#define HINIC3_RSS_TYPE_IPV4_SHIFT		29
#define HINIC3_RSS_TYPE_UDP_IPV6_SHIFT		30
#define HINIC3_RSS_TYPE_UDP_IPV4_SHIFT		31
#define HINIC3_RSS_TYPE_SET(val, member)	\
	(((uint32_t)(val) & 0x1) << HINIC3_RSS_TYPE_##member##_SHIFT)

#define HINIC3_RSS_TYPE_GET(val, member)	\
	(((uint32_t)(val) >> HINIC3_RSS_TYPE_##member##_SHIFT) & 0x1)

/* NIC CMDQ MODE. */
enum hinic3_ucode_cmd {
	HINIC3_UCODE_CMD_MODIFY_QUEUE_CTX	= 0,
	HINIC3_UCODE_CMD_CLEAN_QUEUE_CONTEXT	= 1,
	HINIC3_UCODE_CMD_SET_RSS_INDIR_TABLE	= 4,
	HINIC3_UCODE_CMD_SET_RSS_CONTEXT_TABLE	= 5,
	HINIC3_UCODE_CMD_GET_RSS_INDIR_TABLE	= 6,
	HINIC3_UCODE_CMD_SET_RQ_FLUSH		= 10,
};

/* Commands between NIC to MPU. */
enum hinic3_nic_cmd {
	/* Only for PFD and VFD. */
	HINIC3_NIC_CMD_VF_REGISTER			= 0,

	/* FUNC CFG */
	HINIC3_NIC_CMD_SET_FUNC_TBL			= 5,
	HINIC3_NIC_CMD_SET_VPORT_ENABLE			= 6,
	HINIC3_NIC_CMD_SET_RX_MODE			= 7,
	HINIC3_NIC_CMD_SQ_CI_ATTR_SET			= 8,
	HINIC3_NIC_CMD_GET_VPORT_STAT			= 9,
	HINIC3_NIC_CMD_CLEAN_VPORT_STAT			= 10,
	HINIC3_NIC_CMD_CLEAR_QP_RESOURCE		= 11,
	HINIC3_NIC_CMD_CFG_FLEX_QUEUE			= 12,
	/* LRO CFG */
	HINIC3_NIC_CMD_CFG_RX_LRO			= 13,
	HINIC3_NIC_CMD_CFG_LRO_TIMER			= 14,
	HINIC3_NIC_CMD_FEATURE_NEGO			= 15,
	/* MAC & VLAN CFG */
	HINIC3_NIC_CMD_GET_MAC				= 20,
	HINIC3_NIC_CMD_SET_MAC				= 21,
	HINIC3_NIC_CMD_DEL_MAC				= 22,
	HINIC3_NIC_CMD_UPDATE_MAC			= 23,
	HINIC3_NIC_CMD_CFG_FUNC_VLAN			= 25,
	HINIC3_NIC_CMD_SET_VLAN_FILTER_EN		= 26,
	HINIC3_NIC_CMD_SET_RX_VLAN_OFFLOAD		= 27,
	/* RSS CFG */
	HINIC3_NIC_CMD_RSS_CFG				= 60,
	HINIC3_NIC_CMD_RSS_TEMP_MGR			= 61,
	HINIC3_NIC_CMD_GET_RSS_CTX_TBL			= 62,
	HINIC3_NIC_CMD_CFG_RSS_HASH_KEY			= 63,
	HINIC3_NIC_CMD_CFG_RSS_HASH_ENGINE		= 64,
	HINIC3_NIC_CMD_SET_RSS_CTX_TBL_INTO_FUNC	= 65,
	/* FDIR */
	HINIC3_NIC_CMD_ADD_TC_FLOW			= 80,
	HINIC3_NIC_CMD_DEL_TC_FLOW			= 81,
	HINIC3_NIC_CMD_FLUSH_TCAM			= 83,
	HINIC3_NIC_CMD_CFG_TCAM_BLOCK			= 84,
	HINIC3_NIC_CMD_ENABLE_TCAM			= 85,

	HINIC3_NIC_CMD_SET_FDIR_STATUS			= 91,
	/* PORT CFG */
	HINIC3_NIC_CMD_CFG_PAUSE_INFO			= 101,
	HINIC3_NIC_CMD_VF_COS				= 104,
};

/* COMM commands between driver to MPU. */
enum hinic3_mgmt_cmd {
	HINIC3_MGMT_CMD_FUNC_RESET			= 0,
	HINIC3_MGMT_CMD_FEATURE_NEGO			= 1,
	HINIC3_MGMT_CMD_SET_FUNC_SVC_USED_STATE		= 7,
	HINIC3_MGMT_CMD_SET_CMDQ_CTXT			= 20,
	HINIC3_MGMT_CMD_SET_VAT				= 21,
	HINIC3_MGMT_CMD_CFG_PAGESIZE			= 22,
	HINIC3_MGMT_CMD_CFG_MSIX_CTRL_REG		= 23,
	HINIC3_MGMT_CMD_SET_DMA_ATTR			= 25,
	HINIC3_MGMT_CMD_GET_MQM_FIX_INFO		= 40,
	HINIC3_MGMT_CMD_GET_FW_VERSION			= 60,
	HINIC3_MGMT_CMD_GET_BOARD_INFO			= 61,
	HINIC3_MGMT_CMD_FAULT_REPORT			= 100,
	HINIC3_MGMT_CMD_FFM_SET				= 103,
};

enum mag_cmd {
	SERDES_CMD_PROCESS	  = 0,

	MAG_CMD_SET_PORT_CFG      = 1,
	MAG_CMD_SET_PORT_ADAPT    = 2,
	MAG_CMD_CFG_LOOPBACK_MODE = 3,

	MAG_CMD_GET_PORT_ENABLE   = 5,
	MAG_CMD_SET_PORT_ENABLE   = 6,
	MAG_CMD_GET_LINK_STATUS   = 7,
	MAG_CMD_SET_LINK_FOLLOW   = 8,
	MAG_CMD_SET_PMA_ENABLE    = 9,
	MAG_CMD_CFG_FEC_MODE      = 10,

	/* PHY */
	MAG_CMD_GET_XSFP_INFO     = 60,
	MAG_CMD_SET_XSFP_ENABLE   = 61,
	MAG_CMD_GET_XSFP_PRESENT  = 62,
	/* sfp/qsfp single byte read/write, for equipment test. */
	MAG_CMD_SET_XSFP_RW       = 63,
	MAG_CMD_CFG_XSFP_TEMPERATURE = 64,

	MAG_CMD_WIRE_EVENT        = 100,
	MAG_CMD_LINK_ERR_EVENT    = 101,

	MAG_CMD_EVENT_PORT_INFO   = 150,
	MAG_CMD_GET_PORT_STAT     = 151,
	MAG_CMD_CLR_PORT_STAT     = 152,
	MAG_CMD_GET_PORT_INFO     = 153,
	MAG_CMD_GET_PCS_ERR_CNT   = 154,
	MAG_CMD_GET_MAG_CNT       = 155,
	MAG_CMD_DUMP_ANTRAIN_INFO = 156,

	MAG_CMD_MAX = 0xFF
};

#endif /* _HINIC3_CMD_H_ */
