import os, sys
if __name__ == '__main__':
    execfile(os.path.join(sys.path[0], 'framework.py'))

from Testing import ZopeTestCase
from Products.CMFMember.tests.CMFMemberTestCase import CMFMemberTestCase
from Products.CMFCore.utils import getToolByName
from Interface.Verify import verifyClass
from AccessControl.SecurityManagement import newSecurityManager

import Products.CMFMember

allowed_types = ('Member',)

class TestCreateMemberArea(CMFMemberTestCase):
    def afterSetUp(self):
        CMFMemberTestCase.afterSetUp(self)
        app = self.portal.getPhysicalRoot()
        self.cmf_version = app.Control_Panel.Products.CMFCore.version

    def testCreateMemberArea(self):
        # don't use 'setMemberCreationFlag' b/c it spits out html
        self.membership.memberareaCreationFlag = 1
        self.loginAsPortalOwner()
        if self.cmf_version.startswith('CMF-1.4'):
            self.membership.getAuthenticatedMember()
        else:
            self.portal.logged_in()
        self.failUnless('portal_owner' in self.portal.Members.objectIds())

    def testNoCreateMemberArea(self):
        # don't use 'setMemberCreationFlag' b/c it spits out html
        self.membership.memberareaCreationFlag = 0
        self.loginAsPortalOwner()
        if self.cmf_version.startswith('CMF-1.4'):
            self.membership.getAuthenticatedMember()
        else:
            self.portal.logged_in()
        self.failIf('portal_owner' in self.portal.Members.objectIds())
        

if __name__ == '__main__':
    import profile
    profile.run('framework(verbosity=1)','profiler')
    import pstats
    p = pstats.Stats('profiler')
    p.sort_stats('cum').print_stats('membership')
    
else:
    from unittest import TestSuite, makeSuite
    def test_suite():
        suite = TestSuite()
        suite.addTest(makeSuite(TestCreateMemberArea))
        return suite

