import os, sys
if __name__ == '__main__':
    execfile(os.path.join(sys.path[0], 'framework.py'))    

from sets import Set
from DateTime import DateTime

from Testing import ZopeTestCase
from Products.CMFMember.config import HOMEDIR
from Products.CMFMember.tests import CMFMemberTestCase
from Products.CMFCore.utils import getToolByName
from Interface.Verify import verifyClass
from AccessControl.SecurityManagement import newSecurityManager

import Products.CMFMember
from Products.CMFMember.content.member import Member

class TestMember(CMFMemberTestCase.CMFMemberTestCase):
    
    def getMember(self, u_info):
        user = self.membership.getMemberById(u_info['id'])
        return (u_info['id'], user)

    def createMember(self, id):
        md = self.memberdata
        tmp_id = id + '_tmp_id'
        md.invokeFactory(type_name='Member', id=tmp_id)
        return md._getOb(tmp_id)
        

    def testCreateNewMember(self):
        wf_tool = getToolByName(self.portal, 'portal_workflow')
        id = 'newmember'
        password = 'secret'
        mem = self.createMember(id)
        values = {'id': id,
                  'fullname': 'New Member',
                  'email': 'test@doesnotexist.com',
                  'password': password,
                  'confirm_password': password,
                  }
        review_state = wf_tool.getInfoFor(mem, 'review_state')
        self.failUnless(review_state == 'new')
        get_transaction().commit(True) # processForm needs subtxn commit 
        mem.processForm(values=values)
        self.failUnless(mem.getId() == id)
        self.failUnless(mem.getPassword() == password)
        review_state = wf_tool.getInfoFor(mem, 'review_state')
        self.failUnless(review_state == 'public')

    def testMemberDataInterface(self):
        from Products.CMFCore.interfaces.portal_memberdata \
                import MemberData as IMemberData
        verifyClass(IMemberData, Member)

    def testMemberTitle(self):
        # title should be fullname, w/ failover to member id
        id, portal_member = self.getMember(self.portal_user_info)
        fullname = 'Full Name'
        portal_member.setFullname(fullname)
        self.failUnless(portal_member.Title() == fullname)
        portal_member.setFullname('')
        self.failUnless(portal_member.Title() == id)
    
    def testMemberRoles(self):
        # test member roles
        p_u_info = self.portal_user_info
        portal_member = self.membership.getMemberById(p_u_info['id'])
        test_roles = str('Reviewer')
        test_roles_tuple = ('Reviewer','Authenticated')
        portal_member.setRoles(test_roles)
        self.failUnless(portal_member.getRoles() == test_roles_tuple)

    def testMemberPassword(self):
        # test member's password
        p_u_info = self.portal_user_info
        portal_member = self.membership.getMemberById(p_u_info['id'])
        portal_member._setPassword('newpasswd')
        self.assertEqual(portal_member.getPassword(), 'newpasswd')

    def testMemberDomains(self):
        # test member's domains
        p_u_info = self.portal_user_info
        portal_member = self.membership.getMemberById(p_u_info['id'])
        portal_member.setDomains('127.0.0.1\r\n127.0.0.2\r\n  ')
        self.assertEqual(portal_member.getDomains(), ('127.0.0.1', '127.0.0.2'))

    def testMemberEmail(self):
        # test member's email
        p_u_info = self.portal_user_info
        portal_member = self.membership.getMemberById(p_u_info['id'])
        email = 'test@test.com'
        portal_member.setEmail(email)
        self.assertEqual(portal_member.getEmail(), email)

    def testMemberLoginTime(self):
        # test member's login time
        p_u_info = self.portal_user_info
        portal_member = self.membership.getMemberById(p_u_info['id'])
        new_login_time = DateTime()
        portal_member.setLast_login_time(new_login_time)
        self.assertEqual(portal_member.getLast_login_time(), new_login_time)

    def testMemberRolesInContext(self):
        self.portal.invokeFactory(id='folder1', type_name='Folder')
        folder1 = self.portal['folder1']
        folder1.changeOwnership(self.portal_user)
        folder1.manage_addLocalRoles(self.root_user.getUserName(), ('Reviewer',))
        self.failUnless('Reviewer' in self.root_user.getRolesInContext(folder1))	

    def testMemberIsOrphan(self):
        # test if member is orphan
        p_u_info = self.portal_user_info
        portal_member = self.membership.getMemberById(p_u_info['id'])
        #self._deleteMember(portal_member)
        self.assertEqual(portal_member.isOrphan(), 0)

    def testMemberUserRolesSync(self):
        # make sure the roles always stay in sync btn member and user
        userid = self.portal_user.getId()
        uf = self.portal.acl_users
        
        member = self.membership.getMemberById(userid)
        field = member.getField('roles')
        right_roles = ('Member', 'Reviewer')
        field.getMutator(member)(right_roles)

        user = uf.getUser(userid)
        self.failUnless(Set(right_roles+('Authenticated',)) == \
                        Set(user.getRoles()))

        right_roles = ('Member', 'Manager')
        uf._updateUser(userid, None, right_roles, tuple(), [])
        # XXX when we can rely on events, user modification should
        #     trigger cache reset, for now we do it by hand *sigh*
        member._v_user = (member._getUserFromInfo(member._userInfo),)
        # roles accessor should filter implicit roles
        self.failUnless(Set(right_roles) == \
                        Set(field.getAccessor(member)()))

    def testGroupRolesStayImplicit(self):
        # this demonstrates a bug where group roles are wrongly being
        # assigned explicitly to the user
        uf = getToolByName(self.portal, 'acl_users')
        uid = self.portal_user.getId()
        # we always get the user again to make sure we don't have a
        # stale object
        user = uf.getUser(uid)
        if getattr(user, 'getGroupRoles', None) is None:
            return # no GRUF -> we can't run this test

        if self.ploneIs2_0():
            # we've got to construct the Reviewers groups
            gtool = getToolByName(self.portal, 'portal_groups')
            gtool.addGroup('Reviewers', roles=['Reviewer'])

        self.failIf('Reviewers' in user.getGroupsWithoutPrefix())
        self.failIf('Reviewer' in user.getRoles())

        member = self.membership.getMemberById(user.getId())
        #import pdb; pdb.set_trace()
        member.update(roles=('Member',), groups=('Reviewers',))
        user = uf.getUser(uid)
        self.failUnless('Reviewers' in user.getGroupsWithoutPrefix())
        self.failUnless('Reviewer' in user.getRoles())
        self.failIf('Reviewer' in user.getUserRoles())

    def testDefaultRoles(self):
        from Products.CMFMember.content.member import BaseMember
        BaseMember.default_roles = ('Member', 'Reviewer')
        wf_tool = getToolByName(self.portal, 'portal_workflow')
        id = 'newmember'
        password = 'secret'
        mem = self.createMember(id)
        values = {'id': id,
                  'fullname': 'New Member',
                  'email': 'test@doesnotexist.com',
                  'password': password,
                  'confirm_password': password,
                  }
        review_state = wf_tool.getInfoFor(mem, 'review_state')
        get_transaction().commit(True) # processForm needs subtxn commit 
        mem.processForm(values=values)
        roles = mem.getFilteredRoles()
        self.failUnless(roles == BaseMember.default_roles)
        BaseMember.default_roles = ('Member')

    """
        Standard Plone Interface Tests
    """
    def testGetFullname(self):
        # initially the full name should be set to empty string
        admin, admin_member = self.getMember(self.admin_user_info)
        id, portal_member = self.getMember(self.portal_user_info)
        
        self.failUnless(admin_member.getFullname() == '')
        self.failUnless(portal_member.getFullname() == '')
    
    def testSetFullname(self):
        id, portal_member = self.getMember(self.portal_user_info)
        
        full_name = 'Hillary Swank'
        portal_member.setFullname(full_name)
        self.failUnless(portal_member.getFullname() == full_name)

    def testSetVisibleIds(self):
        id, portal_member = self.getMember(self.portal_user_info)
        if not portal_member.Schema().has_key('visible_ids'):
            # plone 2.1 doesn't have this field
            return
        default_value = not not portal_member.getVisible_ids()
        portal_member.setVisible_ids(not default_value)
        verify_value = portal_member.getVisible_ids()
        self.failIf(verify_value == default_value)
        self.failUnless(verify_value or default_value)
        
    def testSetWysiwyg_editor(self):
        id, portal_member = self.getMember(self.portal_user_info)

        editor = 'Epoz'
        portal_member.setWysiwyg_editor(editor)
        verify_value = portal_member.getWysiwyg_editor()
        self.failUnless(verify_value == editor)
        
        portal_member.setWysiwyg_editor('')
        verify_value = portal_member.getWysiwyg_editor()
        self.failIf(verify_value == editor)
        
    def testSetPortrait(self):
        id, portal_member = self.getMember(self.portal_user_info)

        portal_member.setPortrait(None, id=id)
        no_portrait = portal_member.getPortrait(id=id)
        
        portrait = open(os.path.join(HOMEDIR,'tests','user_files','test1.png'), 'rb')
        portal_member.setPortrait(portrait, id=id)
        new_portrait = portal_member.getPortrait(id=id)
        self.failIf(new_portrait == no_portrait)	
    
    def testMemberSetSecurityProfileRoles(self):
        p_u_info = self.portal_user_info
        portal_member = self.membership.getMemberById(p_u_info['id'])
        
        new_roles = ['Manager', 'Member']
        portal_member.setSecurityProfile(roles=new_roles)
        roles = list(portal_member.getFilteredRoles())
        roles.sort()
        self.assertEqual(roles, new_roles)

    def testMemberSetGroups(self):
        p_u_info = self.portal_user_info
        portal_member = self.membership.getMemberById(p_u_info['id'])
        
        self.portal.portal_groups.addGroup('group1')
        groups = ['group1']
        portal_member.setGroups(groups)
        self.assertEqual(portal_member.getGroups(), groups) 

    def testMemberSetSecurityProfileDoesNotDeleteGroups(self):
        p_u_info = self.portal_user_info
        portal_member = self.membership.getMemberById(p_u_info['id'])

        self.portal.portal_groups.addGroup('group1')
        groups = ['group1']
        portal_member.setGroups(groups)
        
        portal_member.setSecurityProfile(roles=['Manager', 'Member'])
        self.assertEqual(portal_member.getGroups(), groups) 

if __name__ == '__main__':
    framework(verbosity=1)
else:
    from unittest import TestSuite, makeSuite
    def test_suite():
        suite = TestSuite()
        suite.addTest(makeSuite(TestMember))
        return suite
