# XMMS2tray - GNU/Linux systray integration for xmms2
# Copyright (C) 2006 Thomas Jollans
# 
# This code is based on jux_glib.py from Juxtapose (An XMMS2 Client) by
# Joe Turner
# 
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

import gobject

class GLibConnector:
    def __init__(self, xmms):
        self.xmms = xmms
        xmms.set_need_out_fun(self.need_out)
        gobject.io_add_watch(self.xmms.get_fd(), gobject.IO_IN, self.handle_in)
        self.has_out_watch = False

    def need_out(self, i):
        if self.xmms.want_ioout() and not self.has_out_watch:
            gobject.io_add_watch(self.xmms.get_fd(), gobject.IO_OUT, self.handle_out)
            self.has_out_watch = True

    def handle_in(self, source, cond):
        if cond == gobject.IO_IN:
            return self.xmms.ioin()
        return True
                
    def handle_out(self, source, cond):
        if cond == gobject.IO_OUT and self.xmms.want_ioout():
            self.xmms.ioout()
        self.has_out_watch = self.xmms.want_ioout()
        return self.has_out_watch

