/*
 * SFFloat.h
 *
 * Copyright (C) 1999 Stephen F. White
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program (see the file "COPYING" for details); if 
 * not, write to the Free Software Foundation, Inc., 675 Mass Ave, 
 * Cambridge, MA 02139, USA.
 */

#ifndef _SFFLOAT_H
#define _SFFLOAT_H

#ifndef _FIELDVALUE_H
#include "FieldValue.h"
#endif

class SFFloat : public FieldValue {
public:
			SFFloat(float value);
			SFFloat(void) { _value = 0.0; } // silly default

    virtual int         getType() const { return SFFLOAT; }
    virtual const char *getTypeName() const { return "SFFloat"; }
    virtual int	        write(int filedes, int indent) const;
//    virtual int		writeCC(int filedes, char* variableName) const;
    virtual FieldValue *copy() { return new SFFloat(*this); }

    float		getValue() const { return _value; }

    virtual bool	equals(const FieldValue *value) const;
    virtual void	clamp(const FieldValue *min, const FieldValue *max);

    MyString	        getEcmaScriptComment(MyString name, int flags) const;

    bool                isAnimateable() const { return true; }
    bool                hasAnimationSupport() { return true; }

private:
    float	       _value;
};

#endif // _SFFLOAT_H
