.Dd June 14, 2000
.Dt TKGATE 1
.Sh NAME
tkgate \- Tcl/Tk based digital circuit editor and simulator
.Sh SYNOPSIS
.Nm tkgate
.Op Fl xqs
.Op Fl X Ar script
.Op Fl l Ar file
.Op Fl p Ar file
.Op Fl P Ar printer
.Op Ar files ...
.Sh DESCRIPTION
.Nm TkGate
is a graphical editor and event driven simulator for digital circuits
with a tcl/tk-based interface.  Supported circuit elements include
basic gates (AND, OR, etc.), tri-state gates, adders, multipliers,
registers, memories and mos transistors.  Hierarchical design is also
supported with support for user defined modules.  Save files are based
on the Verilog netlist format.

The options are as follows:
.Bl -tag -width Fl
.It Fl X Ar script
Automaticaly start the simulator and execute the specified simulation script. 
.It Fl p Ar file
Print circuit to file without starting GUI.
.It Fl P Ar printer
Print circuit to printer without starting GUI.
.It Fl l Ar file
Read the specified file as a library.
.It Fl x
Automaticaly start the simulator.
.It Fl q
Suppress startup messages.
.It Fl s
Excute with a synchronous X server connection.  This option is primarily for debugging.
.It Fl L Ar lang
Specify a locality to use if tkgate has been configued for Japanese
support.  The locality should be either "ASCII" for English, or "ja_JP.EUC" for Japanese.
This option can also be set via the LANG environment variable.
.El

TkGate documentation can be found at:
.Pp
http://www.cs.cmu.edu/~hansen/tkgate/tkgate.html

.Sh HISTORY & CREDITS

TkGate begin life as an undergraduate project at Carnegie Mellon
University (CMU) in 1987.  At that time it was called simply 'gate'
and ran under the 'wm' window manager, a windowing system developed at
CMU before X11 was widely used.  In this incarnation it was used by
students in the computer architecture course at CMU to develop a
simple microprocessor (dubbed "The Bat Computer").  After laying
dormant for several years, it was resurrected in 1991 and ported to
run under X11 with the Xlib API.  In this incarnation it was used
several times by students in the introductory digital logic course,
but after the author graduated and left CMU, it went into hibernation
again.  This Tcl/Tk incarnation was begun in 1998.  While there is
certainly some cruftyness in the implementation in places due to the
multiple reincarnations, many new features have been added since the
older wm and X11 versions, and the interface has been made much easier
to use.

.Sh SEE ALSO
.Xr gmac 1

.Sh BUGS
Probably many still remaining.  In the event that a core dump does occur,
tkgate will make one attempt to save the current circuit in the file PANIC.v.

.Sh AUTHOR
Jeffery Hansen (hansen@cmu.edu)

.Sh COPYRIGHT
Copyright (c) 1987-2000 by Jeffery Hansen
.sp 1
