/****************************************************************************
    Copyright (C) 1987-2001 by Jeffery P. Hansen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    Last edit by hansen on Thu Jun 22 23:07:02 2000
****************************************************************************/
#include <stdlib.h>
#include <string.h>
#include "tkgate.h"

#define MODINT_DEBUG 0

#define MODINT_BLOCKSPACE	50

static int blknam_compare(const void *pA,const void *pB)
{
  GCElement **A = (GCElement**) pA;
  GCElement **B = (GCElement**) pB;

  return strcmp((*A)->u.block.BlockFunction,(*B)->u.block.BlockFunction);
}

GCElement *modint_find(char *name)
{
  GModuleDef *M = XGate.mid_mod;
  HashElem *E;

  for (E = Hash_first(&M->gates);E;E = Hash_next(&M->gates,E)) {
    GCElement *g = (GCElement*) HashElem_obj(E);
    if (strcmp(g->u.block.BlockFunction,name) == 0)
      return g;
  }
  return 0;
}

void modint_reset(EditState *es,GCElement *g)
{
  int i;

  if (!g || g->typeinfo->Code != BLOCK)
    return;

  for (i = 0;i < g->typeinfo->NumPads;i++) {
    GWire *w,*n_w;

    for (w = g->wires[i];w; w = n_w) {
      n_w = w->next;
      block_cutoffwire(w,es);
    }
  }

  gate_draw(g,GD_NOWIRE);
  g->u.block.gwidth = MINSIZE;
  g->u.block.gheight = MINSIZE;
  gate_draw(g,GD_NOWIRE);
}

void modint_deleteInterface(GModuleDef *M)
{
  GCElement *d = M->blockdescript;

  if (d) gate_delete(d,XGate.mid_mod,0);

  if (XGate.es->isInterface) {
    modint_arrange(XGate.es);
    FlagRedraw();
  }
}

void modint_renameInterface(GModuleDef *M)
{
  GCElement *g = M->blockdescript;

  if (g) {
    if (g->u.block.BlockFunction)
      free(g->u.block.BlockFunction);
    g->u.block.BlockFunction = strdup(M->Name);
  }

  if (XGate.es->isInterface) {
    modint_arrange(XGate.es);
    FlagRedraw();
  }
}

void modint_setInterface(GModuleDef *M,GCElement *g)
{
  GCElement *d = M->blockdescript;
  GCElement *r = 0;

  if (d)
    gate_delete(d,XGate.mid_mod,0);

  if (g) {
    r = (*g->typeinfo->ReplicateGate)(XGate.mid_mod,g,0,0,0);
    r->show_name = 0;
  } else {
    GGateInfo *bgi = gtype_get(BLOCK);
    char *args[2];
    args[0] = "-func";
    args[1] = M->Name;
    r = (*bgi->MakeFunction)(0,XGate.mid_mod,BLOCK,50,50,0,0,0,args,2);
    
  }
  M->blockdescript = r;
#if MODINT_DEBUG
  printf("modint_setInterface(%s) -> %p [n=%d]\n",
	 M->Name,r,Hash_numElems(&XGate.mid_mod->gates));
#endif
}

void modint_arrange(EditState*es)
{
  GModuleDef *M = XGate.mid_mod;
  HashElem *E;
  GCElement **blist;
  int N = Hash_numElems(&M->gates);
  int i;
  int x,y,maxh;
  int isFirst;  

  if (N < 1) return;			/* No defined blocks */

  XGate.no_set_modify = 1;
  blist = (GCElement**) calloc(N,sizeof(GCElement*));

  for (i = 0,E = Hash_first(&M->gates);E;i++, E = Hash_next(&M->gates,E))
    blist[i] = (GCElement*) HashElem_obj(E);

  qsort(blist,N,sizeof(GCElement*),blknam_compare);

  x = MODINT_BLOCKSPACE;
  y = MODINT_BLOCKSPACE;
  maxh = 0;
  isFirst = 1;
  for (i = 0;i < N;i++) {
    GCElement *g = blist[i];

#if MODINT_DEBUG
    printf("  place %s @ (%d, %d)\n",g->u.block.BlockFunction,x,y);
#endif
    g->top = g->bottom = g->right = g->left = 0;

    if (!isFirst && (x+g->u.block.gwidth + MODINT_BLOCKSPACE) > XGate.width) { 
      x = MODINT_BLOCKSPACE;
      y += MODINT_BLOCKSPACE + maxh;
    }

    gate_moveTo(g,x,y);
    x += g->u.block.gwidth + MODINT_BLOCKSPACE;
    if (g->u.block.gheight > maxh)
      maxh = g->u.block.gheight;
    isFirst = 0;
  }

  XGate.no_set_modify = 0;
}

void modint_update(EditState *es)
{
}

void modint_edit(EditState **es,GModuleDef *M)
{
  modint_arrange(*es);

  editstate_push(es,XGate.mid_mod,0);
  (*es)->isInterface = 1;
  editstate_setCurrent(*es);

  FlagRedraw();
}

