/*
 * Decompiled with CFR 0.152.
 */
package cadyts.utilities.visualization.network;

import cadyts.supply.network.MATSimNetworkLoader;
import cadyts.supply.network.Network;
import cadyts.supply.network.NetworkLoaderXML;
import cadyts.supply.network.OsmNetworkLoader;
import cadyts.utilities.misc.DynamicData;
import cadyts.utilities.visualization.network.LinkDataIO;
import cadyts.utilities.visualization.network.MATSimNetworkPreprocessor;
import cadyts.utilities.visualization.network.NetVis;
import cadyts.utilities.visualization.network.OsmNetworkPreprocessor;
import cadyts.utilities.visualization.network.RenderableDynamicData;
import cadyts.utilities.visualization.network.VisConfig;
import cadyts.utilities.visualization.network.VisNetworkData;
import java.awt.FileDialog;
import java.awt.Frame;
import java.io.File;

public class NetvisFromFileRunner {
    public static void main(String[] args) {
        RenderableDynamicData renderData;
        VisNetworkData netData;
        Network net;
        NetworkLoaderXML loader;
        String configFile;
        String defaultPath;
        if (args == null || args.length == 0) {
            FileDialog fileDialog = new FileDialog(new Frame());
            fileDialog.setVisible(true);
            defaultPath = fileDialog.getDirectory() == null ? "" : fileDialog.getDirectory();
            configFile = String.valueOf(defaultPath) + fileDialog.getFile();
        } else {
            File f = new File(args[0]);
            defaultPath = f.getParent() == null ? "" : String.valueOf(f.getParent()) + File.separator;
            configFile = String.valueOf(defaultPath) + f.getName();
        }
        VisConfig config = new VisConfig(configFile, defaultPath);
        if (VisConfig.NetworkType.MATSIM.equals((Object)config.getNetworkType())) {
            loader = new MATSimNetworkLoader();
            net = loader.load(config.getNetworkFile());
            netData = new MATSimNetworkPreprocessor().newVisData(net);
        } else if (VisConfig.NetworkType.BIOROUTE.equals((Object)config.getNetworkType())) {
            loader = new OsmNetworkLoader();
            net = loader.load(config.getNetworkFile());
            netData = new OsmNetworkPreprocessor().newVisData(net);
        } else {
            net = null;
            netData = null;
            System.out.println("unsupported network file format");
            System.exit(-1);
        }
        if (config.getLinkDataFile() != null) {
            LinkDataIO linkDataLoader = new LinkDataIO(net);
            DynamicData linkData = linkDataLoader.read(config.getLinkDataFile());
            renderData = new RenderableDynamicData(linkData);
        } else {
            renderData = null;
        }
        NetVis vis = new NetVis(config, net, netData, renderData);
        vis.run();
    }
}

