/*
 * Decompiled with CFR 0.152.
 */
package cadyts.utilities.visualization.network;

import cadyts.supply.network.Link;
import cadyts.supply.network.Network;
import cadyts.supply.network.Node;
import cadyts.utilities.visualization.network.NetJComponent;
import cadyts.utilities.visualization.network.RendererA;
import cadyts.utilities.visualization.network.VisConfig;
import cadyts.utilities.visualization.network.VisNetworkData;
import cadyts.utilities.visualization.network.VisNodeData;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;

public class LabelRenderer
extends RendererA {
    private Network network;
    int textHeight;

    public LabelRenderer(VisConfig visConfig, Network network, VisNetworkData netData) {
        super(visConfig, netData);
        this.network = network;
        this.textHeight = 12;
    }

    @Override
    protected void myRendering(Graphics2D display, AffineTransform boxTransform) {
        AffineTransform originalTransform = display.getTransform();
        NetJComponent comp = this.getNetJComponent();
        if (this.getVisConfig().getShowNodeLabels()) {
            for (Node node : this.network.getNodes()) {
                double y;
                VisNodeData nodeData = this.netData().getVisNodeData(node);
                double x = nodeData.getEasting();
                if (comp.checkViewClip(x, y = nodeData.getNorthing()) != 5) continue;
                Point2D.Double point = new Point2D.Double(x, y);
                AffineTransform nodeTransform = new AffineTransform(boxTransform);
                nodeTransform.transform(point, point);
                nodeTransform = new AffineTransform(originalTransform);
                nodeTransform.translate(((Point2D)point).getX(), ((Point2D)point).getY());
                display.setTransform(nodeTransform);
                display.setFont(new Font(display.getFont().getName(), 0, this.textHeight));
                display.setColor(Color.BLACK);
                String label = node.getId().toString();
                if (label == null || "".equals(label)) continue;
                display.drawString(label, 0, 0);
            }
        }
        display.setTransform(originalTransform);
        if (this.getVisConfig().getShowLinkLabels()) {
            for (Link link : this.network.getLinks()) {
                double endNorthing;
                double ypos;
                VisNodeData fromNodeData = this.netData().getVisNodeData(link.getFromNode());
                VisNodeData toNodeData = this.netData().getVisNodeData(link.getToNode());
                double startEasting = fromNodeData.getEasting();
                double startNorthing = fromNodeData.getNorthing();
                double endEasting = toNodeData.getEasting();
                double xpos = startEasting + (endEasting - startEasting) * 0.42;
                if (comp.checkViewClip(xpos, ypos = startNorthing + ((endNorthing = toNodeData.getNorthing()) - startNorthing) * 0.42) != 5) continue;
                Point2D.Double point = new Point2D.Double(xpos, ypos);
                AffineTransform linkTransform = new AffineTransform(boxTransform);
                linkTransform.transform(point, point);
                AffineTransform linkTransform2 = new AffineTransform(originalTransform);
                linkTransform2.translate(((Point2D)point).getX(), ((Point2D)point).getY());
                double dx = endEasting - startEasting;
                double dy = endNorthing - startNorthing;
                double theta = Math.atan2(dx, dy);
                if (theta <= 0.0) {
                    linkTransform2.rotate(theta + 1.5707963267948966);
                } else {
                    linkTransform2.rotate(theta - 1.5707963267948966);
                }
                display.setTransform(linkTransform2);
                display.setFont(new Font(display.getFont().getName(), 0, this.textHeight));
                display.setColor(Color.BLACK);
                String label = link.getId().toString();
                if (label == null || "".equals(label)) continue;
                int textWidth = display.getFontMetrics().stringWidth(label);
                int yoffset = theta <= 0.0 ? -this.textHeight / 2 : this.textHeight;
                display.drawString(label, -textWidth / 2, yoffset);
            }
        }
        display.setTransform(originalTransform);
    }
}

