/*
 * Decompiled with CFR 0.152.
 */
package cadyts.utilities.math.networks;

import cadyts.supply.network.Link;
import cadyts.supply.network.Network;
import cadyts.supply.network.Node;
import cadyts.utilities.math.networks.LinkCost;
import cadyts.utilities.math.networks.Router;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class NetworkReducer {
    private final Node origin;
    private final Node destination;
    private final LinkCost linkCost;
    private final double expansion;

    public NetworkReducer(Node origin, Node destination, LinkCost linkCost, double expansion) {
        if (origin == null) {
            throw new IllegalArgumentException("origin is null");
        }
        if (destination == null) {
            throw new IllegalArgumentException("destination is null");
        }
        if (linkCost == null) {
            throw new IllegalArgumentException("link cost is null");
        }
        if (expansion < 1.0) {
            throw new IllegalArgumentException("expansion < 1.0");
        }
        this.origin = origin;
        this.destination = destination;
        this.linkCost = linkCost;
        this.expansion = expansion;
    }

    public NetworkReducer(Node origin, Node destination, LinkCost linkCost) {
        this(origin, destination, linkCost, Double.POSITIVE_INFINITY);
    }

    private void removeNode(Node node, Network net) {
        for (Link inLink : node.getInLinks()) {
            inLink.getFromNode().getOutLinks().remove(inLink);
        }
        for (Link outLink : node.getOutLinks()) {
            outLink.getToNode().getInLinks().remove(outLink);
        }
        net.getLinks().removeAll(node.getInLinks());
        net.getLinks().removeAll(node.getOutLinks());
        net.getNodes().remove(node);
    }

    private Set<Node> upstreamNodes(Network net) {
        HashSet<Node> result = new HashSet<Node>();
        HashSet<Node> pending = new HashSet<Node>();
        pending.add(this.destination);
        while (!pending.isEmpty()) {
            Node currentNode = (Node)pending.iterator().next();
            for (Link link : currentNode.getInLinks()) {
                Node candNode = link.getFromNode();
                if (result.contains(candNode)) continue;
                pending.add(candNode);
            }
            pending.remove(currentNode);
            result.add(currentNode);
        }
        return result;
    }

    private Set<Node> downstreamNodes(Network net) {
        HashSet<Node> result = new HashSet<Node>();
        HashSet<Node> pending = new HashSet<Node>();
        pending.add(this.origin);
        while (!pending.isEmpty()) {
            Node currentNode = (Node)pending.iterator().next();
            for (Link link : currentNode.getOutLinks()) {
                Node candNode = link.getToNode();
                if (result.contains(candNode)) continue;
                pending.add(candNode);
            }
            pending.remove(currentNode);
            result.add(currentNode);
        }
        return result;
    }

    public void reduce(Network net) {
        Router router = new Router(this.linkCost);
        HashSet<Node> allNodes = new HashSet<Node>(net.getNodes());
        Map<Node, Double> fwdCost = router.fwdCost(this.origin, allNodes);
        Map<Node, Double> bwdCost = router.bwdCost(allNodes, this.destination);
        double minCost = router.cost(Router.toLinkRoute(router.bestRouteFwd(this.origin, this.destination, fwdCost)));
        double maxCost = this.expansion * minCost;
        HashSet<Object> removeNodes = new HashSet<Node>();
        for (Node node : net.getNodes()) {
            if (!(fwdCost.get(node) + bwdCost.get(node) > maxCost)) continue;
            removeNodes.add(node);
        }
        for (Node node : removeNodes) {
            this.removeNode(node, net);
        }
        Set<Node> set = this.downstreamNodes(net);
        set.retainAll(this.upstreamNodes(net));
        removeNodes = new HashSet<Node>(net.getNodes());
        removeNodes.removeAll(set);
        for (Node node : removeNodes) {
            this.removeNode(node, net);
        }
    }
}

