/*
 * Decompiled with CFR 0.152.
 */
package cadyts.utilities.math;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Random;

public class Vector
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final double[] data;
    private final boolean immutable;

    private Vector(double[] data, boolean immutable) {
        if (data == null) {
            throw new IllegalArgumentException("data must not be null");
        }
        if (data.length < 1) {
            throw new IllegalArgumentException("dimension must be strictly positive");
        }
        this.data = data;
        this.immutable = immutable;
    }

    public Vector(int dim) {
        this(dim < 0 ? null : new double[dim], false);
    }

    public Vector(double ... data) {
        this(data, false);
    }

    public Vector(List<Double> data) {
        this(data == null ? null : new double[data.size()], false);
        if (data != null) {
            int i = 0;
            while (i < data.size()) {
                this.data[i] = data.get(i);
                ++i;
            }
        }
    }

    public static Vector newGaussian(int dim, Random rnd) {
        if (rnd == null) {
            rnd = new Random();
        }
        Vector result = new Vector(dim);
        int i = 0;
        while (i < dim) {
            result.set(i, rnd.nextGaussian());
            ++i;
        }
        return result;
    }

    public static Vector newGaussian(int dim) {
        return Vector.newGaussian(dim, null);
    }

    public Vector copyEnlarged(int enlargement) {
        if (enlargement < 0) {
            throw new IllegalArgumentException("negative enlargment is not possible");
        }
        Vector result = new Vector(this.data.length + enlargement);
        System.arraycopy(this.data, 0, result.data, 0, this.data.length);
        return result;
    }

    public Vector copy() {
        return this.copyEnlarged(0);
    }

    public Vector newImmutableView() {
        return new Vector(this.data, true);
    }

    private void checkImmutable() {
        if (this.immutable) {
            throw new UnsupportedOperationException("immutable Vector cannot be changed");
        }
    }

    public void copy(Vector other) {
        this.checkImmutable();
        System.arraycopy(other.data, 0, this.data, 0, Math.min(this.size(), other.size()));
    }

    public void fill(double value) {
        this.checkImmutable();
        Arrays.fill(this.data, value);
    }

    public void clear() {
        this.checkImmutable();
        this.fill(0.0);
    }

    public void set(int pos, double value) {
        this.checkImmutable();
        this.data[pos] = value;
    }

    public void add(int pos, double value) {
        this.checkImmutable();
        int n = pos;
        this.data[n] = this.data[n] + value;
    }

    public void add(Vector other, double weight) {
        this.checkImmutable();
        if (this.size() != other.size()) {
            throw new IllegalArgumentException("vectors must be of same dimensions");
        }
        int i = 0;
        while (i < this.size()) {
            this.add(i, weight * other.get(i));
            ++i;
        }
    }

    public void mult(int pos, double value) {
        this.checkImmutable();
        int n = pos;
        this.data[n] = this.data[n] * value;
    }

    public void mult(double value) {
        this.checkImmutable();
        int i = 0;
        while (i < this.size()) {
            this.mult(i, value);
            ++i;
        }
    }

    public void normalize() {
        this.checkImmutable();
        this.mult(1.0 / this.euclNorm());
    }

    public void round(int decimals) {
        this.checkImmutable();
        double scale = Math.pow(10.0, decimals);
        int i = 0;
        while (i < this.size()) {
            this.data[i] = (double)Math.round(this.data[i] * scale) / scale;
            ++i;
        }
    }

    public void enforceBounds(double lower, double upper) {
        this.checkImmutable();
        int i = 0;
        while (i < this.size()) {
            this.data[i] = Math.max(lower, Math.min(upper, this.data[i]));
            ++i;
        }
    }

    public boolean isImmutable() {
        return this.immutable;
    }

    public int size() {
        return this.data.length;
    }

    public double get(int pos) {
        return this.data[pos];
    }

    public double min() {
        double result = Double.POSITIVE_INFINITY;
        double[] dArray = this.data;
        int n = this.data.length;
        int n2 = 0;
        while (n2 < n) {
            double x = dArray[n2];
            result = Math.min(result, x);
            ++n2;
        }
        return result;
    }

    public double max() {
        double result = Double.NEGATIVE_INFINITY;
        double[] dArray = this.data;
        int n = this.data.length;
        int n2 = 0;
        while (n2 < n) {
            double x = dArray[n2];
            result = Math.max(result, x);
            ++n2;
        }
        return result;
    }

    public double innerProd(Vector other) {
        if (this.size() != other.size()) {
            throw new IllegalArgumentException("vectors must be of same dimensions");
        }
        double result = 0.0;
        int i = 0;
        while (i < this.size()) {
            result += this.get(i) * other.get(i);
            ++i;
        }
        return result;
    }

    public double euclNorm() {
        return Math.sqrt(this.innerProd(this));
    }

    public double sum() {
        double result = 0.0;
        double[] dArray = this.data;
        int n = this.data.length;
        int n2 = 0;
        while (n2 < n) {
            double a = dArray[n2];
            result += a;
            ++n2;
        }
        return result;
    }

    public double absValueSum() {
        double result = 0.0;
        int i = 0;
        while (i < this.data.length) {
            result += Math.abs(this.data[i]);
            ++i;
        }
        return result;
    }

    public boolean isAllZeros() {
        int i = 0;
        while (i < this.data.length) {
            if (this.data[i] != 0.0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("[ ");
        int i = 0;
        while (i < this.size()) {
            result.append(String.valueOf(this.get(i)) + " ");
            ++i;
        }
        result.append("]");
        return result.toString();
    }
}

