/*
 * Decompiled with CFR 0.152.
 */
package cadyts.utilities.math;

import cadyts.utilities.math.Vector;
import java.util.Random;

public class MathHelpers {
    private MathHelpers() {
    }

    public static double overlap(double start1, double end1, double start2, double end2) {
        return Math.max(0.0, Math.min(end1, end2) - Math.max(start1, start2));
    }

    public static double round(double x, int digits) {
        double fact = Math.pow(10.0, digits);
        return (double)Math.round(x * fact) / fact;
    }

    public static int round(double x) {
        return (int)MathHelpers.round(x, 0);
    }

    public static int draw(Vector probs, Random rnd) {
        double x = rnd.nextDouble();
        int result = -1;
        double pSum = 0.0;
        while ((pSum += probs.get(++result)) < x && result < probs.size() - 1) {
        }
        return result;
    }

    public static double logOfFactorial(int x) {
        double result = 0.0;
        int y = 2;
        while (y <= x) {
            result += Math.log(y);
            ++y;
        }
        return result;
    }

    public static double logOfMultinomialCoefficient(int ... values) {
        double result = 0.0;
        int sum = 0;
        int[] nArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            int k = nArray[n2];
            result -= MathHelpers.logOfFactorial(k);
            sum += k;
            ++n2;
        }
        return result += MathHelpers.logOfFactorial(sum);
    }

    public static double[] override(double[] dest, double[] source, boolean overrideWithZeros) {
        if (source == null) {
            if (overrideWithZeros) {
                return null;
            }
            return dest;
        }
        if (dest == null) {
            double[] result = new double[source.length];
            System.arraycopy(source, 0, result, 0, source.length);
            return result;
        }
        int i = 0;
        while (i < source.length) {
            if (overrideWithZeros || source[i] != 0.0) {
                dest[i] = source[i];
            }
            ++i;
        }
        return dest;
    }
}

