/*
 * Decompiled with CFR 0.152.
 */
package cadyts.utilities.io.tabularFileParser;

import cadyts.utilities.io.tabularFileParser.TabularFileHandler;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;

public class TabularFileParser {
    private static final String ANYTHING = ".*";
    private static final String ANY_SPACE = "\\s*";
    private String startRegex = null;
    private String endRegex = null;
    private String commentRegex = null;
    private String delimiterRegex = null;
    private int minRowLength = 0;

    public void setMinRowLength(int minRowLength) {
        this.minRowLength = minRowLength;
    }

    public int getMinRowLength() {
        return this.minRowLength;
    }

    public void setStartRegex(String regex) {
        this.startRegex = regex;
    }

    public String getStartRegex() {
        return this.startRegex;
    }

    public void setEndRegex(String regex) {
        this.endRegex = regex;
    }

    public String getEndRegex() {
        return this.endRegex;
    }

    public void setCommentRegex(String regex) {
        this.commentRegex = regex;
    }

    public String getCommentRegex() {
        return this.commentRegex;
    }

    public void setDelimiterRegex(String regex) {
        this.delimiterRegex = regex;
    }

    public String getDelimiterRegex() {
        return this.delimiterRegex;
    }

    private String alternativeExpr(String[] alternatives) {
        StringBuffer result = new StringBuffer();
        if (alternatives != null) {
            int i = 0;
            while (i < alternatives.length) {
                result.append(this.quote(alternatives[i]));
                if (i < alternatives.length - 1) {
                    result.append("|");
                }
                ++i;
            }
        }
        return result.toString();
    }

    private String quote(String expr) {
        return "\\Q" + expr + "\\E";
    }

    public void setStartTag(String tag) {
        if (tag != null) {
            this.startRegex = String.valueOf(this.quote(tag)) + ANYTHING;
        }
    }

    public void setEndTag(String tag) {
        if (tag != null) {
            this.endRegex = String.valueOf(this.quote(tag)) + ANYTHING;
        }
    }

    public void setCommentTags(String[] tags) {
        this.commentRegex = String.valueOf(this.alternativeExpr(tags)) + ANYTHING;
    }

    public void setDelimiterTags(String[] tags) {
        this.delimiterRegex = tags == null || tags.length == 0 ? null : ANY_SPACE + this.alternativeExpr(tags) + ANY_SPACE;
    }

    private boolean isStart(String line) {
        String regex = this.startRegex;
        if (regex == null) {
            return true;
        }
        return line.matches(regex);
    }

    private boolean isEnd(String line) {
        String regex = this.endRegex;
        if (regex == null) {
            return false;
        }
        return line.matches(regex);
    }

    private boolean isComment(String line) {
        String regex = this.commentRegex;
        if (regex == null) {
            return false;
        }
        return line.matches(regex);
    }

    private String[] split(String line) {
        String regex = this.delimiterRegex;
        if (regex == null) {
            return new String[]{line};
        }
        String[] naiveSplit = line.split(regex);
        ArrayList<String> properSplit = new ArrayList<String>(naiveSplit.length);
        String[] stringArray = naiveSplit;
        int n = naiveSplit.length;
        int n2 = 0;
        while (n2 < n) {
            String c = stringArray[n2];
            if (c != null && c.length() > 0) {
                properSplit.add(c);
            }
            ++n2;
        }
        return properSplit.toArray(new String[0]);
    }

    public void parse(String file, TabularFileHandler handler) throws IOException {
        String line;
        if (handler == null) {
            throw new IllegalArgumentException("handler is null");
        }
        boolean started = this.startRegex == null;
        boolean ended = false;
        handler.startDocument();
        BufferedReader reader = new BufferedReader(new FileReader(file));
        while ((line = reader.readLine()) != null && !ended) {
            line = handler.preprocess(line);
            if (started) {
                String[] split;
                ended = this.isEnd(line = line.trim());
                if (ended || this.isComment(line) || (split = this.split(line)).length < this.minRowLength) continue;
                handler.startRow(split);
                continue;
            }
            started = this.isStart(line);
        }
        reader.close();
        handler.endDocument();
    }
}

