/*
 * Decompiled with CFR 0.152.
 */
package cadyts.supply;

import cadyts.demand.Demand;
import cadyts.demand.Plan;
import cadyts.measurements.SingleLinkMeasurement;
import cadyts.supply.LinkLoading;
import cadyts.utilities.math.SignalSmoother;
import cadyts.utilities.misc.TimedElement;
import java.util.HashSet;
import java.util.Set;

public class LinkLoadingProportional<L>
extends TimedElement
implements LinkLoading<L> {
    private static final long serialVersionUID = 1L;
    private final L link;
    private final SignalSmoother avgDemand_veh;
    private final SignalSmoother avgLinkFeature;
    private final SingleLinkMeasurement.TYPE type;

    public LinkLoadingProportional(L link, int startTime_s, int endTime_s, SingleLinkMeasurement.TYPE type, double regressionInertia) {
        super(startTime_s, endTime_s);
        if (link == null) {
            throw new IllegalArgumentException("link is null");
        }
        if (type == null) {
            throw new IllegalArgumentException("type is null");
        }
        this.link = link;
        this.type = type;
        this.avgDemand_veh = new SignalSmoother(1.0 - regressionInertia);
        this.avgLinkFeature = new SignalSmoother(1.0 - regressionInertia);
    }

    @Override
    public L getLink() {
        return this.link;
    }

    @Override
    public Set<L> getRelevantLinks() {
        HashSet<L> result = new HashSet<L>(1);
        result.add(this.getLink());
        return result;
    }

    @Override
    public void freeze() {
        this.avgDemand_veh.freeze();
        this.avgLinkFeature.freeze();
    }

    @Override
    public double getRegressionInertia() {
        if (this.avgDemand_veh.isFrozen()) {
            return 1.0;
        }
        return 1.0 - this.avgDemand_veh.getLastInnovationWeight();
    }

    @Override
    public double predictLinkFeature(Demand<L> demand) {
        double demand_veh = demand.getSum(this.getLink(), this.getStartTime_s(), this.getEndTime_s());
        return this.avgLinkFeature.getSmoothedValue() + this.get_dLinkFeature_dDemand(this.link) * (demand_veh - this.avgDemand_veh.getSmoothedValue());
    }

    @Override
    public double get_dLinkFeature_dDemand(L link) {
        if (this.link.equals(link)) {
            if (SingleLinkMeasurement.TYPE.FLOW_VEH_H.equals((Object)this.type)) {
                return 3600.0 / (double)this.getDuration_s();
            }
            if (SingleLinkMeasurement.TYPE.COUNT_VEH.equals((Object)this.type)) {
                return 1.0;
            }
            throw new RuntimeException("unknown measurement type " + (Object)((Object)this.type) + " -- this should not happen");
        }
        return 0.0;
    }

    @Override
    public void update(Demand<L> demand, double linkFeature) {
        this.avgDemand_veh.addValue(demand.getSum(this.getLink(), this.getStartTime_s(), this.getEndTime_s()));
        this.avgLinkFeature.addValue(linkFeature);
    }

    @Override
    public boolean isPlanListening() {
        return false;
    }

    @Override
    public void notifyPlanChoice(Plan<L> plan) {
    }
}

