/*
 * Decompiled with CFR 0.152.
 */
package cadyts.interfaces.sumo;

import cadyts.demand.Plan;
import cadyts.demand.PlanBuilder;
import cadyts.demand.PlanStep;
import cadyts.utilities.misc.DynamicData;
import java.util.Iterator;
import java.util.List;

class SumoPlan
implements Plan<String> {
    private final int routeId;
    private final String startLink;
    private final Plan<String> plan;
    private final int exitTime_s;
    private final Plan<String> plan4fileDump;

    SumoPlan(int routeId, int startTime_s, List<String> edges, List<Integer> exits, DynamicData<String> travelTimes, PlanBuilder<String> factory) {
        this.routeId = routeId;
        if (edges.size() == 0) {
            this.startLink = null;
            this.plan = null;
            this.exitTime_s = startTime_s;
            this.plan4fileDump = null;
        } else {
            if (travelTimes != null) {
                int lastLinkTT_s;
                if (exits.size() > 1) {
                    lastLinkTT_s = exits.get(exits.size() - 1) - exits.get(exits.size() - 2);
                } else if (exits.size() == 1) {
                    lastLinkTT_s = exits.get(exits.size() - 1) - startTime_s;
                } else {
                    throw new RuntimeException("route " + routeId + " has " + edges.size() + " edges but " + exits.size() + " exit times");
                }
                int time_s = startTime_s;
                int i = 0;
                while (i < exits.size() - 1) {
                    int bin = Math.max(0, Math.min(travelTimes.bin(time_s), travelTimes.getBinCnt() - 1));
                    time_s = (int)((double)time_s + travelTimes.getBinValue(edges.get(i), bin));
                    exits.set(i, time_s);
                    ++i;
                }
                exits.set(exits.size() - 1, time_s += lastLinkTT_s);
            }
            this.startLink = edges.get(0);
            factory.reset();
            factory.addEntry(this.startLink, startTime_s);
            int i = 1;
            while (i < edges.size()) {
                factory.addTurn(edges.get(i), exits.get(i - 1));
                ++i;
            }
            this.exitTime_s = exits.get(exits.size() - 1);
            factory.addExit(this.exitTime_s);
            this.plan = factory.getResult();
            PlanBuilder<String> planBuilder4fileDump = new PlanBuilder<String>();
            planBuilder4fileDump.reset();
            planBuilder4fileDump.addEntry(this.startLink, startTime_s);
            int i2 = 1;
            while (i2 < edges.size()) {
                planBuilder4fileDump.addTurn(edges.get(i2), exits.get(i2 - 1));
                ++i2;
            }
            planBuilder4fileDump.addExit(this.exitTime_s);
            this.plan4fileDump = planBuilder4fileDump.getResult();
        }
    }

    int getRouteId() {
        return this.routeId;
    }

    String getStartLink() {
        return this.startLink;
    }

    int getExitTime_s() {
        return this.exitTime_s;
    }

    boolean isStayAtHome() {
        return this.plan == null;
    }

    Plan<String> getPlan4fileDump() {
        return this.plan4fileDump;
    }

    @Override
    public Iterator<PlanStep<String>> iterator() {
        if (this.isStayAtHome()) {
            return new Iterator<PlanStep<String>>(){

                @Override
                public boolean hasNext() {
                    return false;
                }

                @Override
                public PlanStep<String> next() {
                    return null;
                }

                @Override
                public void remove() {
                }
            };
        }
        return this.plan.iterator();
    }

    @Override
    public PlanStep<String> getStep(int i) {
        return this.plan.getStep(i);
    }

    @Override
    public int size() {
        if (this.isStayAtHome()) {
            return 0;
        }
        return this.plan.size();
    }
}

