/*
 * Decompiled with CFR 0.152.
 */
package cadyts.interfaces.sumo;

import cadyts.utilities.math.simulatedannealing.SolutionGenerator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;

public class SensorLocationVariation
implements SolutionGenerator<Set<String>> {
    private final Random rnd = new Random();
    private final int sensorCnt;
    private final List<String> allLinks;

    SensorLocationVariation(int sensorCnt, Set<String> relevantLinks) {
        this.sensorCnt = sensorCnt;
        this.allLinks = new ArrayList<String>(relevantLinks);
    }

    int linkCnt() {
        return this.allLinks.size();
    }

    @Override
    public Set<String> randomGeneration() {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        Collections.shuffle(this.allLinks);
        int i = 0;
        while (i < this.sensorCnt) {
            result.add(this.allLinks.get(i));
            ++i;
        }
        return result;
    }

    @Override
    public Set<String> variation(Set<String> original) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        double keepProbability = 1.0 - 1.0 / (double)this.sensorCnt;
        for (String link : original) {
            if (!(Math.random() < keepProbability)) continue;
            result.add(link);
        }
        while (result.size() < this.sensorCnt) {
            String proposal = this.allLinks.get(this.rnd.nextInt(this.allLinks.size()));
            result.add(proposal);
        }
        return result;
    }

    @Override
    public Set<String> copy(Set<String> original) {
        return new LinkedHashSet<String>(original);
    }
}

