/*
 * Decompiled with CFR 0.152.
 */
package cadyts.interfaces.dracula;

import cadyts.interfaces.dracula.DynamicXMLFileIOStringKey;
import cadyts.utilities.misc.DynamicData;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

class DraculaDataAnalyzer {
    private final Set<String> allKeys = new LinkedHashSet<String>();
    private final List<DynamicData<String>> dataList = new ArrayList<DynamicData<String>>();

    DraculaDataAnalyzer(String prefix) {
        File f;
        DynamicXMLFileIOStringKey reader = new DynamicXMLFileIOStringKey();
        int i = 0;
        while ((f = new File(String.valueOf(prefix) + i + ".xml")).exists()) {
            DynamicData data = reader.read(f.getAbsolutePath());
            this.allKeys.addAll(data.keySet());
            this.dataList.add(data);
            ++i;
        }
        System.out.println(this.allKeys);
    }

    int getEntries() {
        return this.dataList.size();
    }

    void printDataField(String key) {
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < this.getEntries()) {
            DynamicData<String> data = this.dataList.get(i);
            int bin = 0;
            while (bin < data.getBinCnt()) {
                result.append(data.getBinValue(key, bin));
                result.append("\t");
                ++bin;
            }
            result.append("\n");
            ++i;
        }
        System.out.println();
        System.out.println(result);
        System.out.println();
    }

    public static final void main(String[] args) {
        String path = "C:\\dracula\\net1\\";
        String link = "3";
        DraculaDataAnalyzer dda = new DraculaDataAnalyzer("C:\\dracula\\net1\\flows");
        System.out.println("found " + dda.getEntries() + " entries");
        dda.printDataField("3");
        System.out.println();
        dda = new DraculaDataAnalyzer("C:\\dracula\\net1\\tt");
        System.out.println("found " + dda.getEntries() + " entries");
        dda.printDataField("3");
        System.out.println("DONE");
    }
}

