/*
 * Decompiled with CFR 0.152.
 */
package cadyts.calibrators.analytical;

import cadyts.calibrators.Calibrator;
import cadyts.demand.Plan;
import cadyts.utilities.math.MathHelpers;
import cadyts.utilities.math.Vector;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public class AnalyticalCalibrator<L>
extends Calibrator<L> {
    private static final long serialVersionUID = 1L;
    protected static final double MIN_PROB = 1.0E-6;
    public static final boolean DEFAULT_BRUTE_FORCE = false;
    private Vector lastChoiceProbs;
    private int lastChoiceIndex;
    private boolean bruteForce = false;

    public AnalyticalCalibrator(String logFile, Long randomSeed, int timeBinSize_s) {
        super(logFile, randomSeed, timeBinSize_s);
        Logger.getLogger(this.myName).info("default bruteForce is " + this.bruteForce);
    }

    public void setBruteForce(boolean bruteForce) {
        this.bruteForce = bruteForce;
        Logger.getLogger(this.myName).info("set bruteForce to " + this.bruteForce);
    }

    public boolean getBruteForce() {
        return this.bruteForce;
    }

    public double getLastChoiceProb(int index) {
        return this.lastChoiceProbs.get(index);
    }

    public int getLastChoiceIndex() {
        return this.lastChoiceIndex;
    }

    public int selectPlan(List<? extends Plan<L>> plans, Vector choiceProbs) {
        return this.selectPlan(null, plans, choiceProbs);
    }

    protected int selectPlan(Integer overrideChoice, List<? extends Plan<L>> plans, Vector choiceProbs) {
        if (plans == null) {
            throw new IllegalArgumentException("plans list ist null");
        }
        if (plans.size() == 0) {
            throw new IllegalArgumentException("plans list is empty");
        }
        if (choiceProbs == null) {
            throw new IllegalArgumentException("choice probability list is null");
        }
        if (choiceProbs.size() == 0) {
            throw new IllegalArgumentException("choice probability list is empty");
        }
        if (plans.size() != choiceProbs.size()) {
            throw new IllegalArgumentException("plans list has " + plans.size() + " elements, but choice probability list has " + choiceProbs.size() + " elements");
        }
        if (overrideChoice != null && (overrideChoice < 0 || overrideChoice >= plans.size())) {
            throw new IllegalArgumentException("overriding choice " + overrideChoice + "is not in {0,...," + (plans.size() - 1) + "}");
        }
        if (this.bruteForce) {
            ArrayList<Integer> bestIndices = new ArrayList<Integer>(plans.size());
            double bestLambda = Double.NEGATIVE_INFINITY;
            int i = 0;
            while (i < plans.size()) {
                double lambda = this.calcLinearPlanEffect(plans.get(i));
                if (lambda > bestLambda) {
                    bestIndices.clear();
                    bestIndices.add(i);
                    bestLambda = lambda;
                } else if (lambda == bestLambda) {
                    bestIndices.add(i);
                }
                ++i;
            }
            this.lastChoiceProbs = new Vector(plans.size());
            for (Integer index : bestIndices) {
                this.lastChoiceProbs.set(index, Math.max(1.0E-6, choiceProbs.get(index)));
            }
        } else {
            this.lastChoiceProbs = choiceProbs.copy();
            Vector lambdas = new Vector(plans.size());
            int i = 0;
            while (i < plans.size()) {
                lambdas.set(i, this.calcLinearPlanEffect(plans.get(i)));
                ++i;
            }
            double maxLambda = lambdas.max();
            int i2 = 0;
            while (i2 < plans.size()) {
                this.lastChoiceProbs.mult(i2, Math.exp(lambdas.get(i2) - maxLambda));
                this.lastChoiceProbs.set(i2, Math.max(1.0E-6, this.lastChoiceProbs.get(i2)));
                ++i2;
            }
        }
        this.lastChoiceProbs.mult(1.0 / this.lastChoiceProbs.sum());
        this.lastChoiceIndex = overrideChoice == null ? MathHelpers.draw(this.lastChoiceProbs, this.getRandom()) : overrideChoice;
        this.addToDemand(plans.get(this.getLastChoiceIndex()));
        return this.getLastChoiceIndex();
    }
}

