/*
 * Decompiled with CFR 0.152.
 */
package bioroute.pathgenerator.metropolishastings;

import bioroute.pathgenerator.metropolishastings.MHPath;
import cadyts.supply.network.Network;
import cadyts.supply.network.Node;
import cadyts.utilities.math.metropolishastings.MHProposal;
import cadyts.utilities.math.metropolishastings.MHTransition;
import cadyts.utilities.math.networks.UpdateRouter;
import cadyts.utilities.misc.Triple;
import java.util.LinkedList;
import java.util.Map;
import java.util.Random;

class MHPathProposal
implements MHProposal<MHPath> {
    private final Node origin;
    private final Node destination;
    private final Network network;
    private final UpdateRouter router;
    private final double scale;
    private final Random rnd;
    private final boolean DEBUG = false;
    double total = 0.0;
    double infeasible = 0.0;
    double loops = 0.0;

    MHPathProposal(Node origin, Node destination, Network network, UpdateRouter router, double scale, Random rnd) {
        if (origin == null) {
            throw new IllegalArgumentException("origin is null");
        }
        if (destination == null) {
            throw new IllegalArgumentException("destination is null");
        }
        if (network == null) {
            throw new IllegalArgumentException("network is null");
        }
        if (router == null) {
            throw new IllegalArgumentException("router is null");
        }
        if (rnd == null) {
            throw new IllegalArgumentException("rnd is null");
        }
        this.origin = origin;
        this.destination = destination;
        this.network = network;
        this.router = router;
        this.scale = scale;
        this.rnd = rnd;
    }

    static Triple<Integer, Integer, Integer> drawPoints(int n, Random rnd) {
        int u3;
        if (n < 3) {
            throw new RuntimeException("less than three alternatives!");
        }
        int u1 = rnd.nextInt(n);
        int u2 = rnd.nextInt(n - 1);
        if (u2 >= u1) {
            ++u2;
        }
        if ((u3 = rnd.nextInt(n - 2)) >= Math.min(u1, u2)) {
            ++u3;
        }
        if (u3 >= Math.max(u1, u2)) {
            ++u3;
        }
        if (u1 < u2 && u1 < u3) {
            if (u2 < u3) {
                return new Triple<Integer, Integer, Integer>(u1, u2, u3);
            }
            return new Triple<Integer, Integer, Integer>(u1, u3, u2);
        }
        if (u2 < u1 && u2 < u3) {
            if (u1 < u3) {
                return new Triple<Integer, Integer, Integer>(u2, u1, u3);
            }
            return new Triple<Integer, Integer, Integer>(u2, u3, u1);
        }
        if (u1 < u2) {
            return new Triple<Integer, Integer, Integer>(u3, u1, u2);
        }
        return new Triple<Integer, Integer, Integer>(u3, u2, u1);
    }

    private Node drawInsertNode(Map<Node, Double> node2prob) {
        double u = this.rnd.nextDouble();
        double uSum = 0.0;
        for (Map.Entry<Node, Double> entry : node2prob.entrySet()) {
            if (!((uSum += entry.getValue().doubleValue()) >= u)) continue;
            return entry.getKey();
        }
        return null;
    }

    private double transitionLogProb(MHPath fromRoute, MHPath toRoute) {
        if (!fromRoute.getNodes().equals(toRoute.getNodes())) {
            return Math.log(0.5) + Math.log(fromRoute.getInsertProbs().get(toRoute.getNodeB()));
        }
        if (fromRoute.getPoints().getA().equals(toRoute.getPoints().getA()) && fromRoute.getPoints().getC().equals(toRoute.getPoints().getC())) {
            if (fromRoute.getPoints().getB().equals(toRoute.getPoints().getB())) {
                return 0.0;
            }
            if (fromRoute.isSpliceable() && toRoute.isSpliceable()) {
                return Math.log(0.5) + Math.log(fromRoute.getInsertProbs().get(toRoute.getNodeB()) + 1.0 / (double)fromRoute.pointCombinationSize());
            }
            return -Math.log(fromRoute.pointCombinationSize());
        }
        if (fromRoute.isSpliceable()) {
            return Math.log(0.5) - Math.log(fromRoute.pointCombinationSize());
        }
        return -Math.log(fromRoute.pointCombinationSize());
    }

    @Override
    public MHPath newInitialState() {
        LinkedList<Node> nodes = this.router.bestRoute(this.origin, this.destination);
        Triple<Integer, Integer, Integer> points = MHPathProposal.drawPoints(nodes.size(), this.rnd);
        return new MHPath(nodes, points, this.network, this.router, this.scale);
    }

    @Override
    public MHTransition<MHPath> newTransition(MHPath fromRoute) {
        MHPath toRoute;
        if (fromRoute.isSpliceable() && this.rnd.nextDouble() < 0.5) {
            Map<Node, Double> insertProbs = fromRoute.getInsertProbs();
            Node insertNode = this.drawInsertNode(insertProbs);
            this.total += 1.0;
            if (insertNode == null) {
                toRoute = new MHPath(fromRoute);
                this.infeasible += 1.0;
            } else {
                MHPath proposalRoute = new MHPath(fromRoute);
                proposalRoute.insertDetour(insertNode);
                if (proposalRoute.hasCycle()) {
                    toRoute = new MHPath(fromRoute);
                    this.loops += 1.0;
                } else {
                    toRoute = proposalRoute;
                }
            }
        } else {
            toRoute = new MHPath(fromRoute);
            toRoute.setPoints(MHPathProposal.drawPoints(toRoute.size(), this.rnd));
        }
        double fwdLogProb = this.transitionLogProb(fromRoute, toRoute);
        double bwdLogProb = this.transitionLogProb(toRoute, fromRoute);
        return new MHTransition<MHPath>(fromRoute, toRoute, fwdLogProb, bwdLogProb);
    }
}

