/*
 * Decompiled with CFR 0.152.
 */
package bioroute.analysis;

import cadyts.supply.network.Link;
import cadyts.supply.network.Network;
import cadyts.supply.network.Node;
import cadyts.utilities.io.tabularFileParser.TabularFileHandler;
import cadyts.utilities.io.tabularFileParser.TabularFileParser;
import cadyts.utilities.math.networks.Router;
import cadyts.utilities.misc.DynamicData;
import cadyts.utilities.misc.DynamicDataXMLFileIO;
import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class VisualAnalyzer
extends DynamicDataXMLFileIO<Link>
implements TabularFileHandler {
    private static final long serialVersionUID = 1L;
    private final Network network;
    private String toFile = null;
    private DynamicData<Link> data = new DynamicData(0, 1, 100);
    private Set<Link> allLinks = new HashSet<Link>();
    private List<Link> lastRoute = null;
    private int nextBin = 0;

    public VisualAnalyzer(Network network) {
        if (network == null) {
            throw new IllegalArgumentException("network is null");
        }
        this.network = network;
    }

    public void run(String fromFile, String toFile) throws IOException {
        if (fromFile == null) {
            throw new IllegalArgumentException("from file is null");
        }
        this.toFile = toFile;
        TabularFileParser parser = new TabularFileParser();
        parser.setDelimiterRegex("\\s");
        parser.parse(fromFile, this);
    }

    public DynamicData<Link> getResult() {
        this.data.resize(Math.max(this.nextBin, 1));
        return this.data;
    }

    @Override
    public void startDocument() {
        this.data = new DynamicData(0, 1, 100);
        this.allLinks = new HashSet<Link>();
        this.lastRoute = null;
        this.nextBin = 0;
    }

    @Override
    public String preprocess(String line) {
        int semicolonIndex = line.indexOf(";");
        return line.substring(0, semicolonIndex);
    }

    @Override
    public void startRow(String[] row) {
        LinkedList<Node> nodeRoute = new LinkedList<Node>();
        String[] stringArray = row;
        int n = row.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            nodeRoute.add(this.network.getNode(element));
            ++n2;
        }
        List<Link> linkRoute = Router.toLinkRoute(nodeRoute);
        if (linkRoute.equals(this.lastRoute)) {
            return;
        }
        this.lastRoute = linkRoute;
        this.allLinks.addAll(linkRoute);
        if (this.nextBin >= this.data.getBinCnt()) {
            this.data.resize((int)(1.2 * (double)this.data.getBinCnt()));
        }
        for (Link link : this.allLinks) {
            this.data.put(link, this.nextBin, 1.0);
        }
        for (Link link : linkRoute) {
            this.data.put(link, this.nextBin, 2.0);
        }
        ++this.nextBin;
    }

    @Override
    public void endDocument() {
        if (this.toFile != null) {
            try {
                this.write(this.toFile, this.getResult());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    protected Link attrValue2key(String id) {
        return this.network.getLink(id);
    }

    @Override
    protected String key2attrValue(Link link) {
        return link.getId().toString();
    }
}

