/*
 * Decompiled with CFR 0.152.
 */
package trafficdefinition;

import classes.Layer;
import enums.SelectionType;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.List;
import trafficdefinition.Flow;
import trafficdefinition.TrafficDefinitionElement;

public abstract class TrafficDefinitionLayer
extends Layer<TrafficDefinitionElement>
implements Serializable {
    private static int increment = 1;
    private static final long serialVersionUID = 1L;
    protected String name = null;

    public TrafficDefinitionLayer() {
        this.name = "New Layer " + String.valueOf(increment);
        ++increment;
    }

    public TrafficDefinitionLayer(TrafficDefinitionLayer source) {
        TrafficDefinitionElement clone;
        for (TrafficDefinitionElement e : source.elements) {
            clone = e.elementClone();
            clone.setLayer(this);
            this.elements.add(clone);
        }
        for (TrafficDefinitionElement e : source.selectedElements) {
            clone = e.elementClone();
            clone.setLayer(this);
            this.selectedElements.add(e.elementClone());
        }
        this.name = "Copy of " + source.getName();
    }

    public abstract TrafficDefinitionLayer duplicate();

    public void DeleteTrafficElement(TrafficDefinitionElement t) {
        this.elements.remove(t);
    }

    public void AddTrafficElement(TrafficDefinitionElement t) {
        this.elements.add(t);
        t.setLayer(this);
        this.SelectElement(t);
        this.NotifyCollectionModified();
        this.NotifySelectionChanged();
    }

    @Override
    public void AlterSelection(Rectangle transformedRectangle, SelectionType type) {
        switch (type) {
            case New: {
                this.SelectNoneElements();
            }
            case Add: {
                super.AddToSelection(transformedRectangle);
                break;
            }
            case Remove: {
                super.RemoveFromSelection(transformedRectangle);
            }
        }
        this.NotifySelectionChanged();
    }

    @Override
    public void DeleteSelectedElements() {
        for (TrafficDefinitionElement t : this.selectedElements) {
            if (!(t instanceof Flow)) continue;
            ((Flow)t).ReleaseDependencies();
        }
        this.selectedElements.clear();
        this.NotifyCollectionModified();
        this.NotifySelectionChanged();
    }

    @Override
    public void Draw(Graphics2D g, double zoomFactor) {
        for (TrafficDefinitionElement e : this.elements) {
            e.Draw(g, zoomFactor, false, false);
        }
        for (TrafficDefinitionElement e : this.selectedElements) {
            e.Draw(g, zoomFactor, false, true);
        }
    }

    public String getName() {
        return this.name;
    }

    public List<TrafficDefinitionElement> getSelectedElements() {
        return this.selectedElements;
    }

    public boolean isElementSelected(TrafficDefinitionElement e) {
        return this.selectedElements.contains(e);
    }

    @Override
    public void SelectAllElements() {
        super.SelectAllElements();
        this.NotifySelectionChanged();
    }

    @Override
    public void SelectInverseElements() {
        super.SelectInverseElements();
        this.NotifySelectionChanged();
    }

    @Override
    public void SelectNoneElements() {
        super.SelectNoneElements();
        this.NotifySelectionChanged();
    }

    public void setName(String name) {
        this.name = name;
    }

    public String toString() {
        return this.name;
    }

    public abstract String toXML();
}

