/*
 * Decompiled with CFR 0.152.
 */
package trafficdefinition;

import classes.Pair;
import classes.Project;
import classes.TypeSelection;
import enums.MotionRestriction;
import helpers.RandomNumberProvider;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Random;
import shapes.AreaExt;
import shapes.Rectangle2DExt;
import simulation.JobType;
import tdl.XMLHelpers;
import trafficdefinition.Handle;
import trafficdefinition.TrafficDefinitionElement;

public class TrafficArea
extends TrafficDefinitionElement
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Color color = new Color((float)Math.random(), (float)Math.random(), (float)Math.random());
    private int population = 0;
    private TypeSelection<JobType> residentsJobSelection;
    private AreaExt shape;
    private TypeSelection<JobType> workersJobSelection;
    private int workPositions = 0;
    float averageAdultsPerHouse = 3.0f;
    float averageChildrenPerHouse = 2.0f;
    float possibilityAdultHasJob = 0.98f;
    float possibilityAdultIsDriver = 0.8f;
    float possibilityDriverHasCar = 0.8f;

    public TrafficArea(Shape area) {
        this.name = "Area " + String.valueOf(increment++);
        this.shape = new AreaExt(area);
        ArrayList<Handle> handles = new ArrayList<Handle>();
        handles.add(new Handle(new Point2D.Double(area.getBounds2D().getCenterX(), area.getBounds2D().getCenterY()), "location", MotionRestriction.None));
        this.addHandles(handles);
        this.residentsJobSelection = new TypeSelection();
        this.residentsJobSelection.add(new Pair<JobType, Float>(Project.getCurrentlyLoadedProject().getDefaultJobType(), Float.valueOf(1.0f)));
        this.workersJobSelection = new TypeSelection();
        this.workersJobSelection.add(new Pair<JobType, Float>(Project.getCurrentlyLoadedProject().getDefaultJobType(), Float.valueOf(1.0f)));
        this.exportPolygon = true;
    }

    public TrafficArea(TrafficArea source) {
        super(source);
        this.color = new Color(source.color.getRGB());
        this.population = source.population;
        this.workPositions = source.workPositions;
        this.shape = new AreaExt(source.shape);
    }

    @Override
    public Rectangle2DExt getBounds() {
        return new Rectangle2DExt((Rectangle2D.Double)this.shape.getBounds2D());
    }

    @Override
    public void Draw(Graphics2D g, double zoomFactor, boolean isDeleted, boolean isSelected) {
        Color prev = g.getColor();
        if (!isSelected) {
            g.setColor(new Color(this.color.getRed(), this.color.getGreen(), this.color.getBlue(), 100));
        }
        if (isSelected) {
            g.setColor(new Color(this.color.getRed(), this.color.getGreen(), this.color.getBlue(), 200));
        }
        if (this.shape != null) {
            g.fill(this.shape);
        }
        super.Draw(g, zoomFactor, isDeleted, isSelected);
        g.setColor(prev);
    }

    @Override
    public TrafficDefinitionElement elementClone() {
        return new TrafficArea(this);
    }

    public float getAverageAdultsPerHouse() {
        return this.averageAdultsPerHouse;
    }

    public float getAverageChildrenPerHouse() {
        return this.averageChildrenPerHouse;
    }

    public Color getColor() {
        return this.color;
    }

    public int getPopulation() {
        return this.population;
    }

    public float getPossibilityAdultHasJob() {
        return this.possibilityAdultHasJob;
    }

    public float getPossibilityAdultIsDriver() {
        return this.possibilityAdultIsDriver;
    }

    public float getPossibilityDriverHasCar() {
        return this.possibilityDriverHasCar;
    }

    public Point2D.Double getRandomPointInArea() {
        double areaHeight;
        double y;
        double areaWidth;
        double x;
        Point2D.Double result = null;
        Random r = RandomNumberProvider.getRandom();
        do {
            areaWidth = this.shape.getBounds2D().getMaxX() - this.shape.getBounds2D().getMinX();
            areaHeight = this.shape.getBounds2D().getMaxY() - this.shape.getBounds2D().getMinY();
        } while (!this.shape.contains(result = new Point2D.Double(x = r.nextDouble() * areaWidth + this.shape.getBounds2D().getMinX(), y = r.nextDouble() * areaHeight + this.shape.getBounds2D().getMinY())));
        return result;
    }

    public TypeSelection<JobType> getResidentsJobSelection() {
        return this.residentsJobSelection;
    }

    public AreaExt getShape() {
        return this.shape;
    }

    @Override
    public String getToolTip() {
        return "<html><b>Area: </b> " + this.name + "<br>" + "<b>Population:</b> " + this.population + "<br>" + "<b>Work positions:</b> " + this.workPositions + "</html>";
    }

    public TypeSelection<JobType> getWorkersJobSelection() {
        return this.workersJobSelection;
    }

    public int getWorkPositions() {
        return this.workPositions;
    }

    @Override
    public void handleLocationChanged(Handle h) {
        if (h.getName().equals("location")) {
            Point2D.Double previousCenter = new Point2D.Double(this.shape.getBounds2D().getCenterX(), this.shape.getBounds2D().getCenterY());
            double x = h.getLocation().x - previousCenter.x;
            double y = h.getLocation().y - previousCenter.y;
            AffineTransform tx = new AffineTransform();
            tx.translate(x, y);
            this.shape.transform(tx);
        }
    }

    @Override
    public boolean Hit(Point p) {
        return this.shape.contains(p);
    }

    @Override
    public boolean Hit(Rectangle r) {
        return this.shape.intersects(r);
    }

    public void setAverageAdultsPerHouse(float averageAdultsPerHouse) {
        this.averageAdultsPerHouse = averageAdultsPerHouse;
    }

    public void setAverageChildrenPerHouse(float averageChildrenPerHouse) {
        this.averageChildrenPerHouse = averageChildrenPerHouse;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setPopulation(int population) {
        this.population = population;
    }

    public void setPossibilityAdultHasJob(float possibilityAdultHasJob) {
        this.possibilityAdultHasJob = possibilityAdultHasJob;
    }

    public void setPossibilityAdultIsDriver(float possibilityAdultIsDriver) {
        this.possibilityAdultIsDriver = possibilityAdultIsDriver;
    }

    public void setPossibilityDriverHasCar(float possibilityDriverHasCar) {
        this.possibilityDriverHasCar = possibilityDriverHasCar;
    }

    public void setResidentsJobSelection(TypeSelection<JobType> residentsJobSelection) {
        this.residentsJobSelection = residentsJobSelection;
    }

    public void setWorkersJobSelection(TypeSelection<JobType> workersJobSelection) {
        this.workersJobSelection = workersJobSelection;
    }

    public void setWorkPositions(int workPositions) {
        this.workPositions = workPositions;
    }

    @Override
    public String getGeometryXML() {
        StringBuilder polyBuilder = new StringBuilder();
        String colorString = String.valueOf(new Float((float)this.color.getRed() / 255.0f).toString()) + "," + new Float((float)this.color.getGreen() / 255.0f).toString() + "," + new Float((float)this.color.getBlue() / 255.0f).toString();
        polyBuilder.append("<poly id=\"Traffic Area " + this.name + "\" type=\"Traffic Area\" color=\"" + colorString + "\" fill=\"true\" layer=\"-3\">");
        polyBuilder.append(XMLHelpers.shapeToXML(this.shape));
        polyBuilder.append("</poly>\n");
        return polyBuilder.toString();
    }

    @Override
    public String toXML() {
        StringBuilder sb = new StringBuilder();
        sb.append("<trafficArea name=\"" + this.name + "\" possibilityAdultIsDriver=\"" + String.valueOf(this.possibilityAdultIsDriver) + "\" possibilityDriverHasCar=\"" + String.valueOf(this.possibilityDriverHasCar) + "\" workingPositions=\"" + String.valueOf(this.workPositions) + "\" possibilityAdultHasJob=\"" + String.valueOf(this.possibilityAdultHasJob) + "\" averageChildrenPerHouse=\"" + String.valueOf(this.averageChildrenPerHouse) + "\" population=\"" + String.valueOf(this.population) + "\" averageAdultsPerHouse=\"" + String.valueOf(this.averageAdultsPerHouse) + "\">\n");
        sb.append(XMLHelpers.jobSelectionToXML("residentsJobSelection", this.residentsJobSelection));
        sb.append(XMLHelpers.jobSelectionToXML("workersJobSelection", this.workersJobSelection));
        sb.append("<shape>");
        sb.append(XMLHelpers.shapeToXML(this.shape));
        sb.append("</shape>\n");
        sb.append("</trafficArea>\n");
        return sb.toString();
    }
}

