/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.map.proj;

import com.jhlabs.map.proj.CylindricalProjection;
import com.jhlabs.map.proj.ProjectionException;
import java.awt.geom.Point2D;

public class CentralCylindricalProjection
extends CylindricalProjection {
    private double ap;
    private static final double EPS10 = 1.0E-10;

    public CentralCylindricalProjection() {
        this.minLatitude = Math.toRadians(-80.0);
        this.maxLatitude = Math.toRadians(80.0);
    }

    public Point2D.Double project(double lplam, double lpphi, Point2D.Double out) {
        if (Math.abs(Math.abs(lpphi) - 1.5707963267948966) <= 1.0E-10) {
            throw new ProjectionException("F");
        }
        out.x = lplam;
        out.y = Math.tan(lpphi);
        return out;
    }

    public Point2D.Double projectInverse(double xyx, double xyy, Point2D.Double out) {
        out.y = Math.atan(xyy);
        out.x = xyx;
        return out;
    }

    public boolean hasInverse() {
        return true;
    }

    public String toString() {
        return "Central Cylindrical";
    }
}

