#include "console.h"
#include "../../module_registry.h"

DataSetMap *Console::moduleInfo = 0;

Module* console_constructor()
{
        return new Console();
}

const DataSetMap& Console::get_module_info_instance()
{
        if (!moduleInfo) {
                moduleInfo = new DataSetMap();
                moduleInfo->set("description", DataSet("Write to the terminal"));
                moduleInfo->set("supported_vars", DataSet());
                moduleInfo->set("supported_var_types", DataSet());
                moduleInfo->set("supported_var_defaults", DataSet());
                moduleInfo->set("overridable", DataSet());
        }
        return *moduleInfo;
}

extern "C" int
#ifdef BUILDIN_CONSOLE
console_plugin_startup()
#else
plugin_startup()
#endif
{
        ModuleRegistry::instance()->add_module("Console", &console_constructor, Console::get_module_info_instance());
        return 0;
}

extern "C" void
#ifdef BUILDIN_CONSOLE
console_plugin_shutdown()
#else
plugin_shutdown()
#endif
{
        ModuleRegistry::instance()->remove_module("Console");
        Console::destroy_module_info();
}
        
void Console::updated(const string& keyName, const DataSet& data)
{
        if (keyName == "textline") {
                string tmp;
                env.getExpanded(tmp, keyName);
                cout << tmp << endl;
        }
        
}
