/***************************************************************************
 *   Copyright (C) 2007 by Dominik Riebeling                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; under version 2 of the License.         *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.         *
 ***************************************************************************/
/* Taken from the Rockbox installer, rbutilqt */

#ifndef BROWSEDIRTREE_H
#define BROWSEDIRTREE_H

#include <QtGui>
#include "ui_browsedirtree.h"

class BrowseDirtree : public QDialog
{
    Q_OBJECT

    public:
        BrowseDirtree(QWidget *parent = 0, const QString &caption="");
        void setFilter(const QDir::Filters&);
        void setDir(const QDir&);
        void setDir(const QString&);
        QString getSelected();
        void setRoot(const QString&);

    signals:
        void itemChanged(QString);

    private:
        Ui::BrowseDirtreeFrm ui;
        QDirModel model;

    private slots:
        void accept(void);
};

#endif
