## pong.m4 - Configure pong stuff. -*-Shell-script-*-
## Copyright (C) 2001 George Lebl
## Author: George Lebl
##
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2 of the License, or
## (at your option) any later version.
##
## This program is distributed in the hope that it will be useful, but
## WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
## General Public License for more details.
##
## You should have received a copy of the GNU General Public License
## along with this program; if not, write to the Free Software
## Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
##
## As a special exception to the GNU General Public License, if you
## distribute this file as part of a program that contains a
## configuration script generated by Autoconf, you may include it under
## the same distribution terms that you use for the rest of that program.

#
# Mostly stolen from xml-i18n-tools
#

# serial 1 AC_PROG_PONG
AC_DEFUN(AC_PROG_PONG,
[

dnl This is a hack - we use the expansion of AC_SUBST instead of
dnl AC_SUBST itself to avoid automake putting 
dnl PONG_SCHEMA_RULE = @PONG_SCHEMA_RULE@
dnl in all the Makefile.in's
PONG_SCHEMA_RULE='\%.schema: \%.pong\
	pong-gconf-schema-export $< $\@\
pong-install-schema-data: $(schema_DATA)\
	for n in $+ ; do \\\
		if test -e $$n ; then \\\
			gconftool --install-schema-file=$$n ; \\\
		else \\\
			gconftool --install-schema-file=$(srcdir)/$$n ; \\\
		fi ; \\\
	done\
install-data-local: pong-install-schema-data'
AC_DIVERT_PUSH(AC_DIVERSION_SED)dnl
s%@PONG_SCHEMA_RULE@%[$]PONG_SCHEMA_RULE%g
AC_DIVERT_POP()dnl

# Redirect the config.log output again, so that the ltconfig log is not
# clobbered by the next message.
exec 5>>./config.log
])

dnl old names
AC_DEFUN(AM_PROG_PONG, [indir([AC_PROG_PONG])])dnl

dnl
dnl Stolen from gob
dnl
dnl PONG_HOOK(version, extras, succeed, fail)
dnl if fail = "failure", abort if PONG not found
dnl


AC_DEFUN(PONG_HOOK,[
	PONG_VERS=$1
	if test x$PONG_VERS = x ; then
		PONG_VERS="0.0"
	fi
	if test x$GNOME_CONFIG = x ; then
		AC_PATH_PROG(GNOME_CONFIG,gnome-config)
	fi
	AC_MSG_CHECKING(for PonG >= $PONG_VERS)
	if test ! x$GNOME_CONFIG = x ; then	
		g_vers=`$GNOME_CONFIG --modversion pong`
		case $g_vers
		in
		pong-*)
			g_vers=`echo $g_vers|sed 's/pong-//'`
			g_r_ve=`echo $PONG_VERS|awk 'BEGIN { FS="." } { print [$]1 }'`
			g_r_ma=`echo $PONG_VERS|awk 'BEGIN { FS="." } { print [$]2 }'`
			g_r_pl=`echo $PONG_VERS|awk 'BEGIN { FS="." } { print [$]3 }'`
			g_ve=`echo $g_vers|awk 'BEGIN { FS="." } { print [$]1 }'`
			g_ma=`echo $g_vers|awk 'BEGIN { FS="." } { print [$]2 }'`
			g_pl=`echo $g_vers|awk 'BEGIN { FS="." } { print [$]3 }'`

			if test x$g_r_ve = x ; then g_r_ve=0 ;fi
			if test x$g_ve = x ; then g_ve=0 ;fi
			if test x$g_r_ma = x ; then g_r_ma=0 ;fi
			if test x$g_ma = x ; then g_ma=0 ;fi
			if test x$g_r_pl = x ; then g_r_pl=0 ;fi
			if test x$g_pl = x ; then g_pl=0 ;fi

			if test $g_ve -gt $g_r_ve -o ( $g_ve -eq $g_r_ve -a $g_ma -gt $g_r_ma ) -o ( $g_ve -eq $g_r_ve -a $g_ma -eq $g_r_ma -a $g_pl -ge $g_r_pl ) ; then
				AC_MSG_RESULT(ok)
			else
				AC_MSG_ERROR("found $g_ve.$g_ma.$g_pl requires $g_r_ve.$g_r_ma.$g_r_pl")
			fi
			g_line="pong"
			for n in `echo $2` ; do
				g_line="$g_line pong_$n"
			done
			PONG_CFLAGS=`$GNOME_CONFIG --cflags $(echo $g_line)`
			PONG_LIBS=`$GNOME_CONFIG --libs $(echo $g_line)`
			AC_SUBST(PONG_CFLAGS)
			AC_SUBST(PONG_LIBS)
	
			unset g_ve
			unset g_ma
			unset g_pl
			unset g_r_ve
			unset g_r_ma
			unset g_r_pl
			$3
			;;
		*)
			$4
			;;
		esac
		unset g_vers
	else
		$4
	fi
	unset PONG_VERS
])

AC_DEFUN([PONG_CHECK],[
	PONG_HOOK($1,$2,[],[AC_MSG_ERROR([Cannot find PonG, check http://www.5z.com/jirka/pong.html])])
])
