/*
 * PIMPPA - pmv
 * 
 * PIMPPA move command. Moves files from PIMPPA filearea 
 * (the one assigned to current dir) to another. First
 * tries to depend on env variable PWD, if that fails,
 * uses getcwd(). 
 *
 * Usage: pmv <files> <destarea>
 *
 */

#include <ctype.h>
#include <limits.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include "pimppa.h"

int main(int argc, char *argv[])
{
	char src_lastcomp[PATH_MAX];
	char src_true[PATH_MAX];
	char dst_path[PATH_MAX];
	unsigned long src_id, dst_id, dst_context;
	MYSQL *db;
	MYSQL_RES *sql_res;
	MYSQL_ROW sql_row;
	int i,files_moved=0,files_skipped=0;
	char *value;
	int minassnamelen;

	if(argc<3)
	{
		printf("Usage: %s <files> <destination_area>\n", argv[0]);
		return(0);
	}

	db=p_connect();
	if(!db)
		return(-1);

	if(!getcwd(src_true, PATH_MAX))
	{
		fprintf(stderr, "getcwd() failure.\n");
		return(-1);
	}

	if(!p_checkp(src_true))
		strcat(src_true, "/");

	for(i=strlen(src_true)-2;i>=0;i--)		// Find last dir component
	{
		if(src_true[i]=='/')
			break;
	}
	strcpy(src_lastcomp, &src_true[i]);

	value=p_getmisc(db, P_KEY_MINASSNAMELEN);
	if(value)
		minassnamelen=atoi(value);
	else
		minassnamelen=atoi(P_MIN_ASS_NAMELENGTH);
		
//	printf("'%s' '%s'\n", src_true, src_lastcomp);

/************** get source area *****************************/

	p_query(db, "SELECT area_id, area_path "
		    "FROM p_areas "
		    "WHERE area_path like '%%%s'", 
		src_lastcomp);
	if(mysql_error(db)[0])
	{
		fprintf(stderr, "Error: %s\n", mysql_error(db));
		return(-1);
	}
	sql_res=mysql_store_result(db);
	if(sql_res)
	{
		sql_row=mysql_fetch_row(sql_res);
		if(sql_row)
		{
			src_id=atoi(sql_row[0]);
		}
		else
		{
			fprintf(stderr, "Current dir '%s' doesn't match any area in the db.\n", src_true);
			return(-1);
		}

		mysql_free_result(sql_res);
	}
	else
		return(-2);
	
/************ get destination area ****************/
	
	p_query(db, "SELECT area_id, area_path, area_context " 
		    "FROM p_areas "
 		    "WHERE area_name='%s'", 
		argv[argc-1]);
	if(mysql_error(db)[0])
	{
		fprintf(stderr, "Error: %s\n", mysql_error(db));
		return(-1);
	}
	sql_res=mysql_store_result(db);
	if(sql_res)
	{
		sql_row=mysql_fetch_row(sql_res);
		if(sql_row)
		{
			dst_id=atoi(sql_row[0]);
			strcpy(dst_path, sql_row[1]);
			dst_context=atoi(sql_row[2]);
		}
		else
		{
			fprintf(stderr, "Area '%s' not found...\n", argv[argc-1]);
			return(-1);
		}
		mysql_free_result(sql_res);
	}
	else
		return(-3);

/************ Ok, move files ****************/

	for(i=1;i<argc-1;i++)
	{
		char fullsrc[PATH_MAX];
		char escaped_fn[2*P_LEN_FILE_NAME+1];
		unsigned int file_id=0;

		mysql_escape_string(escaped_fn, argv[i], strlen(argv[i]));

		// Check that the source file exists
		p_query(db, "SELECT file_id FROM p_files "
			    "WHERE file_name='%s' AND file_area=%ld",
			escaped_fn, src_id);
		if(mysql_error(db)[0])
		{
			fprintf(stderr, "Err: %s\n", mysql_error(db));
			return(-4);
		}
		sql_res=mysql_store_result(db);
		if(!sql_res)
			continue;
			
		if((sql_row=mysql_fetch_row(sql_res)))	// Find source
		{
			file_id=atoi(sql_row[0]);
		}
		else
		{
			mysql_free_result(sql_res);
			fprintf(stderr, "%s not found in db...\n", argv[i]);
			files_skipped++;
			continue;
		}
		
		mysql_free_result(sql_res);

		// Check if destination file exists and is not broken
		p_query(db, "SELECT 1 FROM p_files "
			    "WHERE file_name='%s' AND file_area=%ld "
			    "  AND file_integ<>%ld",
			escaped_fn, dst_id, INTEG_FAILED);
		sql_res=mysql_store_result(db);
		
		if(mysql_num_rows(sql_res)>0)
		{
			printf("Not overwriting %s on %ld\n", argv[i], dst_id);
			mysql_free_result(sql_res);
			continue;
		}
		mysql_free_result(sql_res);
		
		// If there's dest file, its broken, delete
		p_query(db, "DELETE FROM p_files "
			    "WHERE file_name='%s' AND file_area=%ld",
			escaped_fn, dst_id);

		// Ok, move it
		p_query(db, "UPDATE p_files SET file_area=%ld "
			    "WHERE file_id=%d",
			dst_id, file_id);
		if(mysql_error(db)[0])
		{
			fprintf(stderr, "Err: %s\n", mysql_error(db));
			return(-5);
		}

		if(dst_id<0)
			p_query(db, "UPDATE p_files "
				    "SET file_flags=(file_flags | %ld) "
				    "WHERE file_id=%d",
				FILE_OFFLINE, file_id);

		sprintf(fullsrc, "%s%s", src_true, argv[i]);
		if(!p_mv(fullsrc, dst_path))
		{
			fprintf(stderr, "p_mv() error from %s to %s\n",
					fullsrc, dst_path);
			break;
		}
	
		p_assign(db, argv[i], minassnamelen, dst_id, dst_context);

		files_moved++;
	}
	
	mysql_close(db);

	if(files_moved)
		fprintf(stderr, "%d files moved...\n", files_moved);
	if(files_skipped)
		fprintf(stderr, "%d files SKIPPED...\n", files_skipped);

	return(0);
}
			
