/*
 * PIMPPA: Bowser
 *
 */

#include <fcntl.h>
#include <signal.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <unistd.h>
#include "proto.h"
#include "../src/pimppa.h"

MYSQL *src_db,*dst_db,*db;	// db is used by bowser, the two others by leech routines
GtkWidget *Bowser;
GnomeClient *Client;
char FifoFile[PATH_MAX];

void zombie_handler(int sig)
{
	while ((waitpid(-1, NULL, WNOHANG)) > 0);
}

/*
 * This bastard hack kludge routine reads the first time 
 * from "source" and outputs to the info window and later
 * reads from FifoFile. The fifo is closed and opened again
 * because otherwise gtk calls this function over and over
 * again after the fifo-writing child has exited.
 *
 * I wonder why this seems to work...
 *
 */
void readinput(gpointer data, gint source, GdkInputCondition condition)
{
	char buffer[PATH_MAX];
	int bytes;
	static int fd=0;

	if(!fd)
		fd=source;

	bytes=read(fd, buffer, PATH_MAX);
	if(bytes>0)
	{
		buffer[bytes]=0;
		
		gtk_text_insert(GTK_TEXT(InfoText), NULL, &InfoText->style->black, 
			NULL, buffer, -1);
	}
	else
	{
		close(fd);
		fd=open(FifoFile, O_RDWR|O_NONBLOCK);
	}
}

/*the save_yourself handler, you can safely ignore most of the
   parameters, and just save your session and return TRUE
 *
 * FIXME: Too bad that this doesn't seem to work. Or the
 * restore won't work.
 *
 */
int 
save_yourself(void)
{
	gint x=0, y=0, w=0, h=0;
    char *prefix= gnome_client_get_config_prefix (Client);
	
//	fprintf(stderr, "DEBUG: save_yourself()\n");

    /*get the prefix for our config*/

    /* Save the state using gnome-config stuff. */
    gnome_config_push_prefix (prefix);
  
	gdk_window_get_position(Bowser->window, &x, &y);
	
	gdk_window_get_size(Bowser->window, &w, &h);

//	printf("Save: %d %d %d %d\n", x, y, w, h);

	gnome_config_set_int ("Geometry/x", x);
	gnome_config_set_int ("Geometry/y", y);
	gnome_config_set_int ("Geometry/w", w);
	gnome_config_set_int ("Geometry/h", h);
         
	gnome_config_pop_prefix ();
    gnome_config_sync();

    return TRUE;
}

static void 
restore_yourself(void) 
{
	gint x=0, y=0, w=0, h=0;
	
//	fprintf(stderr, "DEBUG: restore_yourself()\n");

	gnome_config_push_prefix
		(gnome_client_get_config_prefix (Client));

	x=gnome_config_get_int("Geometry/x");
	y=gnome_config_get_int("Geometry/y");
	w=gnome_config_get_int("Geometry/w");
	h=gnome_config_get_int("Geometry/h");  
 
//	printf("Load: %d %d %d %d\n", x, y, w, h);
 
	gnome_config_pop_prefix ();

/*
	if ((w!=0) && (h!=0)) 
		gtk_widget_set_usize(GTK_WIDGET(Bowser),w,h);
	else
*/
	gtk_widget_set_usize(GTK_WIDGET(Bowser),640,480);

	if ((x!=0) && (y!=0)) 
		gtk_widget_set_uposition(GTK_WIDGET(Bowser),x,y);
}

static gint
delete_event(GtkWidget *widget, GdkEvent *event, gpointer data)
{
	gtk_main_quit();
	mysql_close(src_db);
	mysql_close(dst_db);
	mysql_close(db);
	
	return FALSE;
}

int main(int argc, char *argv[])
{
	GtkWidget *vbox;
	int fd;

/************ Connect the gnome stuff ***************/

	gnome_init("bowser", VERSION, argc, argv);
	Bowser=gnome_app_new("bowser", "PIMPPA bowser");
	gtk_signal_connect(GTK_OBJECT(Bowser), "delete_event",
						GTK_SIGNAL_FUNC(delete_event), NULL);
	gtk_signal_connect(GTK_OBJECT(Bowser), "destroy",
						GTK_SIGNAL_FUNC(delete_event), NULL);
	
	Client=gnome_master_client();
	gtk_signal_connect (GTK_OBJECT (Client), "save_yourself",
						GTK_SIGNAL_FUNC (save_yourself),
						NULL);
	gtk_signal_connect (GTK_OBJECT (Client), "die",
						GTK_SIGNAL_FUNC (delete_event), NULL);

	if (GNOME_CLIENT_CONNECTED (Client)) 
		restore_yourself();

/******** Connect the MySQL server *********/

	// 3 connections... overkill huh
	src_db=p_connect();
	if(!src_db)
	{
		my_error_dialog("src_db mysql connect fail");
		return(-1);
	}
	dst_db=p_connect();
	if(!dst_db)
	{
		mysql_close(src_db);
		my_error_dialog("dst_db mysql connect fail");
		return(-1);
	}
	db=p_connect();
	if(!db)
	{
		mysql_close(src_db);
		mysql_close(dst_db);
		my_error_dialog("db mysql connect fail");
		return(-1);
	}

/********** Zombie handler **************/

	signal(SIGCHLD,zombie_handler);

/********** ... ***/

	createinfowindow(NULL, NULL);

	sprintf(FifoFile, "/tmp/bowser%d.fifo", getpid());
	unlink(FifoFile);
	mkfifo(FifoFile, 0600);

	fd=open(FifoFile, O_RDONLY|O_NONBLOCK);
	gdk_input_add(fd, GDK_INPUT_READ,readinput,NULL); 

/********** Ok, lets do some GUI shit ***********/

	create_menus();
    
/****** Main stuff page ***********/

	vbox=get_stuff_box();
    
	gnome_app_set_contents ( GNOME_APP (Bowser), vbox);

	// Initialize some pimppa DB values, if not already there
	p_initcfg(db);

	gtk_widget_show_all(Bowser);

	gtk_main();

	close(fd);
	unlink(FifoFile);

	mysql_close(db);
	mysql_close(src_db);
	mysql_close(dst_db);
		 
	return(0);
}

