/*
	Copyright (C) 2003 Frdric Giudicelli (contact_nos@yahoo.com). 
	All rights reserved.

	This product includes cryptographic software written by Eric Young
	(eay@cryptsoft.com)

	This program is released under the GPL with the additional exemption that
	compiling, linking, and/or using OpenSSL is allowed.

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2 of the License.

	This program is distributed in the hope that it will be useful, but WITHOUT
	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
	FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
	more details.

	You should have received a copy of the GNU General Public License along with
	this program; if not, write to the Free Software Foundation, Inc., 59 Temple
	Place, Suite 330, Boston, MA 02111-1307 USA
*/


// OcspServers.cpp: implementation of the OcspServers class.
//
//////////////////////////////////////////////////////////////////////

#include "OcspServers.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

OcspServers::OcspServers()
{

}

OcspServers::~OcspServers()
{
	Stop();
	ServersLock.LockWrite();
	std::map< mString, SockServerOCSP* >::iterator i;
	for(i = m_ListServers.begin(); i != m_ListServers.end(); i++)
	{
		// We must unload the server !
		delete i->second;
	}
	m_ListServers.clear();
	ServersLock.UnlockWrite();
}

void OcspServers::Load(PKIX_Central *Central)
{
	m_Central = Central;
}

void OcspServers::Stop()
{
	ServersLock.LockWrite();
	std::map< mString, SockServerOCSP* >::iterator i;
	for(i = m_ListServers.begin(); i != m_ListServers.end(); i++)
	{
		// We must unload the server !
		i->second->Stop();
	}
	ServersLock.UnlockWrite();
}

bool OcspServers::StartServer(const mString &EntityName, const ServerConf &Conf)
{
	ServersLock.LockWrite();
	// Is the server already loaded ?
	if(m_ListServers.find(EntityName) != m_ListServers.end())
	{
		// Was it loaded with same info ?
		if(m_ListServers[EntityName]->GetConf() == Conf)
		{
			// We do nothing
			ServersLock.UnlockWrite();
			return true;
		}
		else
		{
			// We must unload the server !
			m_ListServers[EntityName]->Stop();
			delete m_ListServers[EntityName];
			m_ListServers.erase(EntityName);
		}
	}
	ServersLock.UnlockWrite();


	SockServerOCSP * newServer;
	newServer = new SockServerOCSP();
	if(!newServer)
	{
		NEWPKIerr(PKI_ERROR_TXT, ERROR_MALLOC);
		return false;
	}

	if(!newServer->Load(m_Central, EntityName))
	{
		NEWPKIerr(PKI_ERROR_TXT, ERROR_ABORT);
		delete newServer;
		return false;
	}

	if(!newServer->Start(Conf))
	{
		NEWPKIerr(PKI_ERROR_TXT, ERROR_ABORT);
		delete newServer;
		return false;
	}

	ServersLock.LockWrite();
	m_ListServers[EntityName] = newServer;
	ServersLock.UnlockWrite();

	return true;
}

void OcspServers::StopServer(const mString &EntityName)
{
	ServersLock.LockWrite();
	// Is the server already loaded ?
	if(m_ListServers.find(EntityName) != m_ListServers.end())
	{
		// We must unload the server !
		m_ListServers[EntityName]->Stop();
		delete m_ListServers[EntityName];
		m_ListServers.erase(EntityName);
	}
	ServersLock.UnlockWrite();
}

void OcspServers::PrintStats(bool CurrConnectionsStats)
{
	ServersLock.LockRead();
	std::map< mString, SockServerOCSP* >::iterator i;
	for(i = m_ListServers.begin(); i != m_ListServers.end(); i++)
	{
		// We must unload the server !
		i->second->PrintStats(CurrConnectionsStats);
	}
	ServersLock.UnlockRead();
}

bool OcspServers::IsRunning(const mString &EntityName)
{
	ServersLock.LockRead();
	// Is the server already loaded ?
	if(m_ListServers.find(EntityName) == m_ListServers.end())
	{
		ServersLock.UnlockRead();
		return false;
	}
	ServersLock.UnlockRead();
	return true;
}
