#ifndef BACKUP_PLUGIN_H
#define BACKUP_PLUGIN_H

#include <multisync.h>

typedef enum {
  BACKUP_TYPE_SAVED = 1,
  BACKUP_TYPE_DELETED = 2,
  BACKUP_TYPE_RESTORE = 3,
  BACKUP_TYPE_REBACKUP = 4
} backup_type;

typedef struct {
  char *uid;
  backup_type type;
  sync_object_type object_type;
} backup_object;

typedef struct {
  client_connection commondata;
  sync_pair *sync_pair;
  connection_type conntype;
  char *backupdir;
  GList *entries; // The backup entries we have
  gboolean rebackupall;
  gboolean harddelete;
} backup_connection;

void backup_load_state(backup_connection *conn);
void backup_save_state(backup_connection *conn);
void backup_load_entries(backup_connection *conn);
char* backup_get_entry_data(char *card, char *key);
void backup_save_entries(backup_connection *conn);
void backup_free_entries(backup_connection *conn);
void backup_hard_delete(backup_connection *conn, backup_object *entry);
void backup_modify_or_delete(backup_connection *conn, 
			     char *comp, 
			     char *uid, sync_object_type objtype, 
			     char *uidret, int *uidretlen,
			     gboolean softdelete);
void backup_free_connection(backup_connection *conn);
gboolean backup_do_connect(gpointer data);

backup_connection* sync_connect(sync_pair* handle, connection_type type,
				sync_object_type object_types);
void sync_disconnect(backup_connection *conn);
void sync_done(backup_connection *conn, gboolean success);
void syncobj_modify(backup_connection *conn, 
		    char *comp, 
		    char *uid, sync_object_type objtype, 
		    char *uidret, int *uidretlen);
void syncobj_delete(backup_connection *conn, char *uid, 
		    sync_object_type objtype, int softdelete);
gboolean backup_do_get_changes(gpointer data);
void get_changes(backup_connection* conn, sync_object_type newdbs);
gboolean always_connected(void);
char* short_name(void);
char* long_name(void);
sync_object_type object_types(void);
void plugin_init(void);
char* plugin_info(void);




#endif
