
#include "strategy.h"
#include <iostream>

using namespace std;
using namespace lysa;


class Strategy_symbolic : public Strategy 
{ 
  std::string getFormatTemplate()    { return 
"# input / decrypt\n"
"decrypt        = %sum%decrypt(%ciphertext%, encrypt([%pm_terms%, %type_exprs%], %key%), encrypt([%pm_terms_updated%, %vars%], %key_updated%), %anno%).%newline%%subproc%\n"
"receive        = %sum%read([%pm_terms%, %type_exprs%], [%pm_terms_updated%, %vars%]).%newline%%subproc%\n"
"sum            = sum %vars%, %prime_vars%: Value.%newline%\n"
"type_n         = any_name\n"
"type_c         = any_ciphertext\n"
"type_sep       = , \n"
"\n"
"# proc\n"
"dy             = DYinit([known_name, %known_names%])\n"
"zero           = %zero_action%delta\n"
"send           = send([%terms%]).%newline%%subproc%\n"
"\n"
"# data\n"
"name           = N(%name%)\n"
"ciphertext     = encrypt([%terms%], %key%, %anno%)\n"
"anno_none      = AnnoNone\n"
"anno           = at(%at%, [%destorig%]%cpdy_ai%)\n"
"anno_s         = at_s(%at%)\n"
"cpdy_ai        =  ++ CPDYonAttackerIndex([%indices%])\n"
"\n"
"# init\n"
"init           = init allow({s, r, FAIL, zero}, comm({send|recvA->s, sendA|recv->r},%newline%  %proc%%newline%));\n"
"attacker_index = eqn attackerIndex = %index%;\n"; } 
  std::string getPreamble()          { return 
"\n"
"\n"
"% standard library :-)\n"
"\n"
"map \n"
"  forall_Value: List(Value) # (Value->Bool) -> Bool;\n"
"  exists_Value: List(Value) # (Value->Bool) -> Bool;\n"
"  filter_Value: List(Value) # (Value->Bool) -> List(Value);\n"
"  uniq_Value: List(Value) -> List(Value);\n"
"  collect2_Value: List(Value) # List(Value) # (Value#Value->Value) -> List(Value);\n"
"  collect_Value:  List(Value) # (Value->Value) -> List(Value);\n"
"  assert_Value: Bool # Value -> Value;\n"
"  FAIL_Value: Value -> Value;\n"
"var\n"
"  d, d': Value;\n"
"  l, l': List(Value);\n"
"  ll: List(List(Value));\n"
"  f: (Value->Bool);\n"
"  ft2: (Value#Value->Value);\n"
"  ft: (Value->Value);\n"
"  b: Bool;\n"
"eqn\n"
"  %bounded forall over list elements\n"
"  forall_Value(d |> l, f) = f(d) && forall_Value(l, f);\n"
"  forall_Value([], f) = true;\n"
"\n"
"  %bounded exists over list elements\n"
"  exists_Value(d |> l, f) = f(d) || exists_Value(l, f);\n"
"  exists_Value([], f) = false;\n"
"  \n"
"  %list filter: discareds elements for this f(d) does not hold\n"
"  filter_Value(d |> l, f) = if(f(d), d |> filter_Value(l, f), filter_Value(l, f));\n"
"  filter_Value([], f) = [];\n"
"  \n"
"  %uniqueness filter: discards duplicates in list\n"
"  uniq_Value(d |> l) = if(d in l, uniq_Value(l), d |> uniq_Value(l));\n"
"  uniq_Value([]) = [];\n"
"  \n"
"  %collect: applies function ft to every list element\n"
"  collect_Value(d |> l, ft) = ft(d) |> collect_Value(l, ft);\n"
"  collect_Value([], ft) = [];\n"
"  \n"
"  %collect2: applies function ft2 to every two elements at the same position \n"
"  %in the two lists until the end of at least one list is reached\n"
"  collect2_Value(d |> l, d' |> l', ft2) = ft2(d, d') |> collect2_Value(l, l', ft2);\n"
"  collect2_Value(l, [], ft2) = [];\n"
"  collect2_Value([], l, ft2) = [];\n"
"  \n"
"  %assert: FAIL_Value is not implemented, so if b does not hold, a rewriting error occurs\n"
"  assert_Value(b, d) = if(b, d, FAIL_Value(d));\n"
"\n"
"map \n"
"  forall_Ciphertext: List(Ciphertext) # (Ciphertext->Bool) -> Bool;\n"
"  exists_Ciphertext: List(Ciphertext) # (Ciphertext->Bool) -> Bool;\n"
"  filter_Ciphertext: List(Ciphertext) # (Ciphertext->Bool) -> List(Ciphertext);\n"
"  uniq_Ciphertext: List(Ciphertext) -> List(Ciphertext);\n"
"  collect2_Ciphertext: List(Ciphertext) # List(Ciphertext) # (Ciphertext#Ciphertext->Ciphertext) -> List(Ciphertext);\n"
"  collect_Ciphertext:  List(Ciphertext) # (Ciphertext->Ciphertext) -> List(Ciphertext);\n"
"  assert_Ciphertext: Bool # Ciphertext -> Ciphertext;\n"
"  FAIL_Ciphertext: Ciphertext -> Ciphertext;\n"
"var\n"
"  d, d': Ciphertext;\n"
"  l, l': List(Ciphertext);\n"
"  ll: List(List(Ciphertext));\n"
"  f: (Ciphertext->Bool);\n"
"  ft2: (Ciphertext#Ciphertext->Ciphertext);\n"
"  ft: (Ciphertext->Ciphertext);\n"
"  b: Bool;\n"
"eqn\n"
"  %bounded forall over list elements\n"
"  forall_Ciphertext(d |> l, f) = f(d) && forall_Ciphertext(l, f);\n"
"  forall_Ciphertext([], f) = true;\n"
"\n"
"  %bounded exists over list elements\n"
"  exists_Ciphertext(d |> l, f) = f(d) || exists_Ciphertext(l, f);\n"
"  exists_Ciphertext([], f) = false;\n"
"  \n"
"  %list filter: discareds elements for this f(d) does not hold\n"
"  filter_Ciphertext(d |> l, f) = if(f(d), d |> filter_Ciphertext(l, f), filter_Ciphertext(l, f));\n"
"  filter_Ciphertext([], f) = [];\n"
"  \n"
"  %uniqueness filter: discards duplicates in list\n"
"  uniq_Ciphertext(d |> l) = if(d in l, uniq_Ciphertext(l), d |> uniq_Ciphertext(l));\n"
"  uniq_Ciphertext([]) = [];\n"
"  \n"
"  %collect: applies function ft to every list element\n"
"  collect_Ciphertext(d |> l, ft) = ft(d) |> collect_Ciphertext(l, ft);\n"
"  collect_Ciphertext([], ft) = [];\n"
"  \n"
"  %collect2: applies function ft2 to every two elements at the same position \n"
"  %in the two lists until the end of at least one list is reached\n"
"  collect2_Ciphertext(d |> l, d' |> l', ft2) = ft2(d, d') |> collect2_Ciphertext(l, l', ft2);\n"
"  collect2_Ciphertext(l, [], ft2) = [];\n"
"  collect2_Ciphertext([], l, ft2) = [];\n"
"  \n"
"  %assert: FAIL_Ciphertext is not implemented, so if b does not hold, a rewriting error occurs\n"
"  assert_Ciphertext(b, d) = if(b, d, FAIL_Ciphertext(d));\n"
"\n"
"map \n"
"  forall_Name: List(Name) # (Name->Bool) -> Bool;\n"
"  exists_Name: List(Name) # (Name->Bool) -> Bool;\n"
"  filter_Name: List(Name) # (Name->Bool) -> List(Name);\n"
"  uniq_Name: List(Name) -> List(Name);\n"
"  collect2_Name: List(Name) # List(Name) # (Name#Name->Name) -> List(Name);\n"
"  collect_Name:  List(Name) # (Name->Name) -> List(Name);\n"
"  assert_Name: Bool # Name -> Name;\n"
"  FAIL_Name: Name -> Name;\n"
"var\n"
"  d, d': Name;\n"
"  l, l': List(Name);\n"
"  ll: List(List(Name));\n"
"  f: (Name->Bool);\n"
"  ft2: (Name#Name->Name);\n"
"  ft: (Name->Name);\n"
"  b: Bool;\n"
"eqn\n"
"  %bounded forall over list elements\n"
"  forall_Name(d |> l, f) = f(d) && forall_Name(l, f);\n"
"  forall_Name([], f) = true;\n"
"\n"
"  %bounded exists over list elements\n"
"  exists_Name(d |> l, f) = f(d) || exists_Name(l, f);\n"
"  exists_Name([], f) = false;\n"
"  \n"
"  %list filter: discareds elements for this f(d) does not hold\n"
"  filter_Name(d |> l, f) = if(f(d), d |> filter_Name(l, f), filter_Name(l, f));\n"
"  filter_Name([], f) = [];\n"
"  \n"
"  %uniqueness filter: discards duplicates in list\n"
"  uniq_Name(d |> l) = if(d in l, uniq_Name(l), d |> uniq_Name(l));\n"
"  uniq_Name([]) = [];\n"
"  \n"
"  %collect: applies function ft to every list element\n"
"  collect_Name(d |> l, ft) = ft(d) |> collect_Name(l, ft);\n"
"  collect_Name([], ft) = [];\n"
"  \n"
"  %collect2: applies function ft2 to every two elements at the same position \n"
"  %in the two lists until the end of at least one list is reached\n"
"  collect2_Name(d |> l, d' |> l', ft2) = ft2(d, d') |> collect2_Name(l, l', ft2);\n"
"  collect2_Name(l, [], ft2) = [];\n"
"  collect2_Name([], l, ft2) = [];\n"
"  \n"
"  %assert: FAIL_Name is not implemented, so if b does not hold, a rewriting error occurs\n"
"  assert_Name(b, d) = if(b, d, FAIL_Name(d));\n"
"\n"
"\n"
"\n"
"map \n"
"  forall_n: Nat # (Nat->Bool) -> Bool;\n"
"  exists_n: Nat # (Nat->Bool) -> Bool;\n"
"  get_Values_from_Ciphertexts: List(Ciphertext) -> List(Value);\n"
"  get_ValueLists_from_Ciphertexts: List(Ciphertext) -> List(Values);\n"
"  FAIL_ASSERT: Bool;\n"
"  assert: Bool -> Bool;\n"
"var \n"
"  n, i: Nat;\n"
"  fn: Nat -> Bool;\n"
"  a, a', v, v': Value;\n"
"  vs, vs': List(Value);\n"
"  l, l': List(Value);\n"
"  lc: List(Ciphertext);\n"
"  c: Ciphertext;\n"
"  b: Bool;\n"
"eqn \n"
"  %forall and exists over indices from 0 to n\n"
"  forall_n(0, fn) = true;\n"
"  (n>0) -> forall_n(n, fn) = fn(Int2Nat(n-1)) && forall_n(Int2Nat(n-1), fn);\n"
"  exists_n(0, fn) = false;\n"
"  (n>0) -> exists_n(n, fn) = fn(Int2Nat(n-1)) || exists_n(Int2Nat(n-1), fn);\n"
"  \n"
"  %assert: FAIL_ASSERT is not implemented, so if b does not hold, a rewriting error occurs\n"
"  assert(b) = if(b, b, FAIL_ASSERT);\n"
"  \n"
"  %auxiliary function that turns a list of ciphertexts into a list of values\n"
"  get_Values_from_Ciphertexts(c |> lc) = _vs(c) ++ get_Values_from_Ciphertexts(lc);\n"
"  get_Values_from_Ciphertexts([]) = [];\n"
"  \n"
"  %auxiliary function that turns a list of ciphertexts into a list of lists of values\n"
"  get_ValueLists_from_Ciphertexts(c |> lc) = _vs(c) |> get_ValueLists_from_Ciphertexts(lc);\n"
"  get_ValueLists_from_Ciphertexts([]) = [];\n"
"\n"
"sort Anno = struct at(_cp: CP, _do: List(CP)) | at_s(_cp_s: CP) | AnnoLeft;\n"
"map\n"
"  AnnoDY: Anno;\n"
"  AnnoNone: Anno;\n"
"var\n"
"  vs: Values;\n"
"  a, a': Anno;\n"
"eqn\n"
"  AnnoDY   = at_s(CPDY);\n"
"  AnnoNone = at_s(UCP);\n"
"\n"
"sort Values = List(Value);\n"
"\n"
"sort Ciphertext = struct Cpair(_vs: List(Value), _a: Anno);\n"
"\n"
"sort SName = List(Name);\n"
"\n"
"sort SCiphertext = struct SCpair(_ns: List(Name), _cs: List(Ciphertext));\n"
"\n"
"sort Value = struct\n"
"    N (_n: Name)?is_N\n"
"  | C (_c: Ciphertext)?is_C\n"
"  | SN(_sn: SName)?is_SN\n"
"  | SC(_sc: SCiphertext)?is_SC\n"
"  | invalid\n"
"  | any_name\n"
"  | any_ciphertext\n"
"  | id\n"
"  ;\n"
"\n"
"  \n"
"% more intuitive names for ciphertext elements\n"
"map\n"
"  key: Ciphertext -> Value;\n"
"  els: Ciphertext -> List(Value);\n"
"  encrypt: Values # Value # Anno -> Value;\n"
"  encrypt: Values # Value -> Value;\n"
"  encrypt: Values # Anno -> Value;\n"
"  encrypt: Values -> Value;\n"
"  set_anno: Value # Anno -> Value;\n"
"var \n"
"  c: Ciphertext;\n"
"  k: Value;\n"
"  vs: Values;\n"
"  ad, a, a': Anno;\n"
"eqn\n"
"  key(c) = head(_vs(c));\n"
"  els(c) = tail(_vs(c));\n"
"  encrypt(vs, k, ad) = C(Cpair(k |> vs, ad));\n"
"  encrypt(vs, k)     = C(Cpair(k |> vs, AnnoNone));\n"
"  encrypt(vs, ad)    = C(Cpair(vs, ad));\n"
"  encrypt(vs)        = C(Cpair(vs, AnnoNone));\n"
"  set_anno(C(Cpair(vs, a)), a') = C(Cpair(vs, a'));\n"
"\n"
"\n"
"map \n"
"  _ns: Value -> List(Name);\n"
"  _cs: Value -> List(Ciphertext);\n"
"  like_N: Value -> Bool;\n"
"  like_C: Value -> Bool;\n"
"  is_any: Value -> Bool;\n"
"  SC_: List(Name) # List(Ciphertext) -> Value;\n"
"  addToSC: SCiphertext # Name -> SCiphertext;\n"
"  addToSC: SCiphertext # Ciphertext -> SCiphertext;\n"
"  addToSC: SCiphertext # SName -> SCiphertext;\n"
"  addToSC: SCiphertext # SCiphertext -> SCiphertext;\n"
"  addToSC: SCiphertext # Value -> SCiphertext;\n"
"  \n"
"  simplify: Value -> Value;\n"
"  ensure_valid: Value -> Value;\n"
"  is_valid: Value -> Bool;\n"
"var\n"
"  n, n': Name;\n"
"  c, c': Ciphertext;\n"
"  sn, sn': SName;\n"
"  sc, sc': SCiphertext;\n"
"  v: Value;\n"
"  ns: List(Name);\n"
"  cs: List(Ciphertext);\n"
"eqn\n"
"  _ns(SC(sc)) = _ns(sc);\n"
"  _cs(SC(sc)) = _cs(sc);\n"
"  like_N(v) = (is_N(v) || is_SN(v));\n"
"  like_C(v) = (is_C(v) || is_SC(v));\n"
"  is_any(v) = (v in [any_name, any_ciphertext]);\n"
"  SC_(ns, cs) = SC(SCpair(ns, cs));\n"
"  \n"
"  addToSC(SCpair(ns, cs), n) = SCpair(if(n in ns, ns, n |> ns), cs);\n"
"  addToSC(SCpair(ns, cs), c) = SCpair(ns, if(c in cs, cs, c |> cs));\n"
"  addToSC(SCpair(ns, cs), sn) = SCpair(uniq_Name(ns ++ sn), cs);\n"
"  addToSC(SCpair(ns, cs), sc) = SCpair(uniq_Name(ns ++ _ns(sc)), uniq_Ciphertext(cs ++ _cs(sc)));\n"
"  addToSC(sc', N(n))   = addToSC(sc', n);\n"
"  addToSC(sc', SN(sn)) = addToSC(sc', sn);\n"
"  addToSC(sc', C(c))   = addToSC(sc', c);\n"
"  addToSC(sc', SC(sc)) = addToSC(sc', sc);\n"
"\n"
"\n"
"\n"
"  % simplify simply makes some obvious changes to data representation.\n"
"  % behaviour of values on either side should be equal under pmatch, but\n"
"  % the right hand side is, generally, easier to read.\n"
"  simplify(N(n)) = N(n);\n"
"  simplify(C(c)) = ensure_valid(C(c));\n"
"  \n"
"  simplify(SN([])) = invalid;\n"
"  simplify(SN([n])) = N(n);\n"
"  simplify(SN(n |> n' |> sn)) = SN(n |> n' |> sn);\n"
"  \n"
"  simplify(SC(SCpair([], [])))  = invalid;\n"
"  simplify(SC(SCpair([], [c]))) = C(c);\n"
"  simplify(SC(SCpair(n |> ns, c |> c' |> cs)))  = SC(SCpair(n |> ns, c |> c' |> cs));\n"
"  \n"
"\n"
"\n"
"\n"
"  ensure_valid(v) = if(is_valid(v), v, invalid);\n"
"\n"
"  is_valid(invalid)  = false;\n"
"  is_valid(N(n))   = true;\n"
"  is_valid(SN(sn)) = (sn != []);\n"
"  is_valid(C(c))   = (_vs(c) != []) && forall_Value(_vs(c), lambda v: Value.is_valid(v));\n"
"  is_valid(SC(SCpair([], []))) = false;\n"
"  \n"
"  % pmatch should ensure that SC's never contain the value invalid - assert raises a rewrite error or returns true.\n"
"(ns != []) || (cs != []) ->\n"
"  is_valid(SC(SCpair(ns, cs))) = assert(\n"
"                        forall_Ciphertext(cs, lambda c: Ciphertext.is_valid(C(c)))\n"
"                      );\n"
"\n"
"sort DecryptResult = struct rm_fail(Anno, Anno)?rm_failed | rm_pass;\n"
"\n"
"map \n"
"  can_match: Ciphertext  # Ciphertext # Ciphertext -> Bool;\n"
"  can_match: SCiphertext # Ciphertext # Ciphertext -> Bool;\n"
"  can_match: SCiphertext # Values     # Values -> Bool;\n"
"\n"
"  can_match: Value       # Ciphertext # Ciphertext -> Bool;\n"
"  can_match: Value       # Value      # Value -> Bool;\n"
"  \n"
"  replace_ids: Ciphertext # Ciphertext -> Ciphertext;\n"
"  replace_ids: Values     # Values     -> Values;\n"
"  \n"
"  pmatch:   Value       # Value        -> Value; \n"
"  pmatch:   SName       # SName        -> SName;\n"
"  pmatch_r: Ciphertext  # Ciphertext   -> Ciphertext;\n"
"  pmatch_r: List(Value) # List(Value)  -> List(Value);\n"
"  pmatch_r: SCiphertext # Ciphertext   -> SCiphertext;\n"
"  pmatch_l: SCiphertext # Ciphertext   -> SCiphertext;\n"
"  pmatch_r: SCiphertext # SCiphertext  -> SCiphertext;\n"
"  \n"
"  pmatch_cs_c_r:  List(Ciphertext) # Ciphertext  -> List(Ciphertext);\n"
"  pmatch_cs_c_l:  List(Ciphertext) # Ciphertext  -> List(Ciphertext);\n"
"  pmatch_cs_sc_r: List(Ciphertext) # SCiphertext -> List(Ciphertext);\n"
"  pmatch_cs_sc_l: List(Ciphertext) # SCiphertext -> List(Ciphertext);\n"
"  \n"
"  can_make_c_r: SCiphertext # Ciphertext -> List(Ciphertext);\n"
"  can_make_c_l: SCiphertext # Ciphertext -> List(Ciphertext);\n"
"  \n"
"  can_make_v: SCiphertext # Value       -> Value;\n"
"  can_make_v: Value       # SCiphertext -> Value;\n"
"  \n"
"var\n"
"  q, P, P', v, v': Value;\n"
"  LQ, LP, LP', LP'', vs, vs', vs'': List(Value);\n"
"  \n"
"  n, n': Name;\n"
"  c, c', cp, cp', cp'': Ciphertext;\n"
"  sn, sn': SName;\n"
"  sc, sc': SCiphertext;  \n"
"  cs, cs': List(Ciphertext);\n"
"  ns, ns': List(Name);\n"
"  a, a', ao, ad: Anno;\n"
"eqn\n"
"%%can_match:  Ciphertext # Ciphertext # Ciphertext -> Bool;\n"
"  % performs a pattern match while taking annotations into account.\n"
"  % note: the annotation in cp is disregarded.\n"
"  can_match(c, cp, cp'')  = C(cp') == match\n"
"  whr\n"
"    match = pmatch(C(c), C(Cpair(_vs(cp), AnnoLeft))),\n"
"    cp' = replace_ids(cp, cp'')\n"
"  end;\n"
"\n"
"%%can_match: SCiphertext # Ciphertext # Ciphertext -> Bool;\n"
"  % performs a pattern match while taking annotations into account.\n"
"  % note: the annotation in cp is disregarded.\n"
"  % there will be more than one possibility if more than one C in sc \n"
"  % could be matched to cp.\n"
"  can_match(sc, cp, cp'') = assert(_ns(match)==[]) && (cp' in _cs(match)) \n"
"  whr\n"
"    % pmatch without simplification, so that we are certain an SC is obtained.\n"
"    match = pmatch_r(sc, Cpair(_vs(cp), AnnoLeft)), \n"
"    cp' = replace_ids(cp, cp'') \n"
"  end;\n"
"  \n"
"%%can_match:  SCiphertext # Values # Values -> Bool;\n"
"  % performs a pattern match while disregarding annotations, i.e. \n"
"  % treating ciphertexts simply as a list of values\n"
"  % note: the annotation in cp is disregarded.\n"
"  % there will be more than one possibility if more than one C in sc\n"
"  % could be matched to vs.\n"
"  can_match(sc, vs, vs'') = \n"
"    assert(_ns(match)==[]) && (vs' in get_ValueLists_from_Ciphertexts(_cs(match))) \n"
"  whr\n"
"    % pmatch without simplification, so that we are certain an SC is obtained.\n"
"    match = pmatch_r(sc, Cpair(vs, AnnoLeft)), \n"
"    vs' = replace_ids(vs, vs'') \n"
"  end;\n"
"  \n"
"%%can_match forwarders\n"
"  can_match(C(c),   cp, cp') = can_match(c,  cp, cp');\n"
"  can_match(SC(sc), cp, cp') = can_match(sc, cp, cp');\n"
"  can_match(N(n),   cp, cp') = false;\n"
"  can_match(SN(sn), cp, cp') = false;\n"
"  can_match(v, C(cp), C(cp')) = can_match(v,  cp, cp');\n"
"  \n"
"\n"
"\n"
"%%remove_ids: Ciphertext # Ciphertext -> Ciphertext;\n"
"  % removes the special \"id\" value which may only occur in LP', and replaces it by\n"
"  % the corresponding value in LP. this indicates that the value cannot be changed by\n"
"  % pmatch, which is the case for literal values in the protocol text.\n"
"  %\n"
"  % this is a purely cosmetic feature to make reading and hand-writing protocols in\n"
"  % mCRL2 easier and more user-friendly.\n"
"  replace_ids(Cpair(vs, a), Cpair(vs', a')) = Cpair(replace_ids(vs, vs'), a');\n"
"  replace_ids(vs, vs') = collect2_Value(vs, vs', lambda v, v': Value.if(v'==id, v, v'));\n"
"\n"
"\n"
"\n"
"%%pmatch: Value # Value -> Value\n"
"\n"
"  pmatch(N(n), N(n'))      = simplify(SN(pmatch([n], [n'])));\n"
"  pmatch(SN(sn), N(n))     = simplify(SN(pmatch(sn,  [n] )));\n"
"  pmatch(N(n), SN(sn))     = simplify(SN(pmatch(sn,  [n] )));\n"
"  pmatch(SN(sn), SN(sn'))  = simplify(SN(pmatch(sn,  sn' )));\n"
"  \n"
"  pmatch(C(c), C(c'))      = simplify( C(pmatch_r(c,  c')));\n"
"  pmatch(SC(sc), C(c))     = simplify(SC(pmatch_r(sc, c)));\n"
"  pmatch(C(c), SC(sc))     = simplify(SC(pmatch_l(sc, c)));\n"
"  pmatch(SC(sc), SC(sc'))  = simplify(SC(pmatch_r(sc, sc')));\n"
"\n"
"\n"
"  pmatch(any_name, N(n)) = N(n);\n"
"  pmatch(any_name, SN(sn)) = SN(sn);\n"
"  pmatch(any_name, C(c)) = invalid;\n"
"  pmatch(any_name, SC(sc)) = SN(_ns(sc));\n"
"  pmatch(any_ciphertext, N(n)) = invalid;\n"
"  pmatch(any_ciphertext, SN(sn)) = invalid;\n"
"  pmatch(any_ciphertext, C(c)) = C(c);\n"
"  pmatch(any_ciphertext, SC(sc)) = SC(sc);\n"
"  pmatch(any_ciphertext, any_name) = invalid;\n"
"\n"
"  is_any(v') -> pmatch(v, v') = pmatch(v', v);\n"
"  \n"
"(like_N(v) != like_N(v')) && !is_any(v) && !is_any(v') ->\n"
"  pmatch(v, v')    = invalid;\n"
"  \n"
"  pmatch(invalid, v) = invalid;\n"
"  pmatch(v, invalid) = invalid;\n"
"\n"
"\n"
"%%pmatch: SName # SName -> SName;\n"
"  %compute simple intersection\n"
"  pmatch(n |> sn, sn') = if(n in sn', n |> pmatch(sn, sn'), pmatch(sn, sn'));\n"
"  pmatch([], sn') = [];\n"
"\n"
"\n"
"%%pmatch: Ciphertext  # Ciphertext  -> Ciphertext;\n"
"  pmatch_r(Cpair(vs, ad), Cpair(vs', ao)) = \n"
"    Cpair(pmatch_r(vs, vs'), if(ao==AnnoLeft, ad, ao));\n"
"\n"
"%%pmatch: List(Value) # List(Value)  -> List(Value);\n"
"  % collect the pmatch of every two elements in the lists.\n"
"  pmatch_r(v |> vs, v' |> vs') =\n"
"    if(is_valid(pvv) && recurse != [invalid], \n"
"      pvv |> recurse,\n"
"      [invalid]\n"
"    ) \n"
"    whr \n"
"      pvv = pmatch(v, v'),\n"
"      recurse = pmatch_r(vs, vs')\n"
"    end;\n"
"    \n"
"  pmatch_r([], v |> vs) = [invalid];\n"
"  pmatch_r(vs, []) = if(vs==[], [], [invalid]);\n"
"  % cannot do pmatch([],[]) because of ambiguity\n"
"  \n"
"\n"
"%%pmatch: SCiphertext # Ciphertext  -> SCiphertext;\n"
"  pmatch_r(sc, c) = SCpair([], pmatch_cs_c_r(_cs(sc), c) ++ can_make_c_r(sc, c));\n"
"  pmatch_l(sc, c) = SCpair([], pmatch_cs_c_l(_cs(sc), c) ++ can_make_c_l(sc, c));\n"
"  \n"
"  \n"
"%%pmatch_cs_c: List(Ciphertext) # Ciphertext -> List(Ciphertext)\n"
"  % finds all the c's in cs that can be matched with c, and returns the matches in a list\n"
"  %\n"
"  % _r-version guarantees that the annotation of the second argument is preserved\n"
"  pmatch_cs_c_r(c |> cs, c') = \n"
"    if(is_valid(C(pcc)),\n"
"      pcc |> recurse,\n"
"      recurse\n"
"    )\n"
"    whr\n"
"      pcc = pmatch_r(c, c'),\n"
"      recurse = pmatch_cs_c_r(cs, c')\n"
"    end;\n"
"    \n"
"  % _l-version guarantees that the annotation of the second argument is preserved\n"
"  % does not differ from _r-version except the r/l'ness of the subroutines called\n"
"  pmatch_cs_c_l(c |> cs, c') = \n"
"    if(is_valid(C(pcc)),\n"
"      pcc |> recurse,\n"
"      recurse\n"
"    )\n"
"    whr\n"
"      pcc = pmatch_r(c', c),\n"
"      recurse = pmatch_cs_c_l(cs, c')\n"
"    end;\n"
"    \n"
"  pmatch_cs_c_r([], c') = [];\n"
"  pmatch_cs_c_l([], c') = [];\n"
"\n"
"%%can_make_c: SCiphertext # Ciphertext -> List(Ciphertext)\n"
"  % matches each v in c' to either sc's names or sc itself, or returns the empty list if\n"
"  % at least one v cannot be matched. returns a list with one or zero elements.\n"
"  %\n"
"  % _r-version guarantees that the annotation of the second argument is preserved\n"
"  can_make_c_r(sc, Cpair(v |> vs, a)) = \n"
"    if(is_valid(cmv) && recurse != [],\n"
"      [Cpair(cmv |> _vs(recurse.0), if(a==AnnoLeft, AnnoDY, a))],\n"
"      []\n"
"    )\n"
"    whr\n"
"      cmv = can_make_v(sc, v),\n"
"      recurse = can_make_c_r(sc, Cpair(vs, a))\n"
"    end;\n"
"    \n"
"  % _l-version guarantees that the annotation of the second argument is preserved\n"
"  % differs from _r-version in order of can_make_v arguments, and that the DY annotation\n"
"  % is always appended, because this ciphertext has been created from names in the SC;\n"
"  % these names must have been known by the attacker, so it is in fact a ciphertext sent\n"
"  % by the attacker.\n"
"  can_make_c_l(sc, Cpair(v |> vs, a)) = \n"
"    if(is_valid(cmv) && recurse != [],\n"
"      [Cpair(cmv |> _vs(recurse.0), AnnoDY)],\n"
"      []\n"
"    )\n"
"    whr\n"
"      cmv = can_make_v(v, sc),\n"
"      recurse = can_make_c_l(sc, Cpair(vs, a))\n"
"    end;\n"
"    \n"
"  can_make_c_r(sc, Cpair([], a)) = [Cpair([], a)];\n"
"  can_make_c_l(sc, Cpair([], a)) = [Cpair([], a)];\n"
"    \n"
"%%can_make_v: SCiphertext # Value -> Value;\n"
"%%can_make_v: Value # SCiphertext -> Value;\n"
"  % properly matches a value against a sciphertext, depending on the value's type.\n"
"  % always preserves the annotation of the second argument (unless is_any(v))\n"
"  can_make_v(sc, v) =\n"
"    if(is_any(v),\n"
"      pmatch(v, SC(sc)),\n"
"      if(like_C(v),\n"
"        pmatch(SC(sc), v),\n"
"        pmatch(SN(_ns(sc)), v)\n"
"      )\n"
"    );\n"
"    \n"
"  can_make_v(v, sc) =\n"
"    if(is_any(v),\n"
"      pmatch(v, SC(sc)),\n"
"      if(like_C(v),\n"
"        pmatch(v, SC(sc)),\n"
"        pmatch(v, SN(_ns(sc)))\n"
"      )\n"
"    );\n"
"    \n"
"    \n"
"%%pmatch: SCiphertext # SCiphertext -> SCiphertext;\n"
"  pmatch_r(SCpair(ns, cs), SCpair(ns', cs')) = %SCpair([],[]);\n"
"    SCpair(\n"
"      pmatch(ns, ns'), %intersect names\n"
"      uniq_Ciphertext( pmatch_cs_sc_r(cs, SCpair(ns', cs')) ++ \n"
"        pmatch_cs_sc_l(cs', SCpair(ns, cs)) )\n"
"    );\n"
"  \n"
"\n"
"%%pmatch_cs_sc: List(Ciphertext) # SCiphertext -> List(Ciphertext)\n"
"  % finds all the c's in cs that can be matched with sc, and returns the matches in a list\n"
"  pmatch_cs_sc_r(c |> cs, sc) = \n"
"    if(is_valid(SC(pc)),\n"
"      _cs(pc) ++ recurse,  % ok to discard _ns(pc) because pmatch: SC#C does not fill it.\n"
"      recurse\n"
"    )\n"
"    whr\n"
"      pc = pmatch_l(sc, c),\n"
"      recurse = pmatch_cs_sc_r(cs, sc)\n"
"    end;\n"
"\n"
"  pmatch_cs_sc_l(c |> cs, sc) = \n"
"    if(is_valid(SC(pc)),\n"
"      _cs(pc) ++ recurse,  % ok to discard _ns(pc) because pmatch: SC#C does not fill it.\n"
"      recurse\n"
"    )\n"
"    whr\n"
"      pc = pmatch_r(sc, c),\n"
"      recurse = pmatch_cs_sc_r(cs, sc)\n"
"    end;\n"
"    \n"
"  pmatch_cs_sc_r([], sc) = [];    \n"
"  pmatch_cs_sc_l([], sc) = [];\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"sort Message = List(Value);\n"
"\n"
"map \n"
"  matchDO: Anno#Anno -> Bool;\n"
"  fails_rm : Anno#Anno -> Bool;\n"
"var \n"
"  o, d: CP;\n"
"  O, D: List(CP);\n"
"  ad, ao: Anno;\n"
"eqn\n"
"  matchDO(at(d, D), at(o, O)) = (d in O) && (o in D);\n"
"  matchDO(at_s(d),  at(o, O)) = (d in O);\n"
"  matchDO(at(d, D), at_s(o))  = (o in D);\n"
"  matchDO(at_s(d),  at_s(o))  = true;\n"
"\n"
"  fails_rm(ad, ao) = !matchDO(ad, ao);\n"
"\n"
"\n"
"sort Knowledge = SCiphertext;\n"
"sort KnowledgeUpdate = struct KU(_kn: Knowledge, _dc: List(Ciphertext));\n"
"\n"
"map \n"
"  update_knowledge: Knowledge # Message -> KnowledgeUpdate;\n"
"  update_knowledge: KnowledgeUpdate # Message -> KnowledgeUpdate;\n"
"  \n"
"  propagate: KnowledgeUpdate -> KnowledgeUpdate;\n"
"  \n"
"  cs_can_decrypt: List(Ciphertext) # SCiphertext -> List(List(Ciphertext));\n"
"\n"
"var\n"
"  ku: KnowledgeUpdate;\n"
"  dc: List(Ciphertext);\n"
"  kn, kn': Knowledge;\n"
"  v, v', k: Value;\n"
"  c, c': Ciphertext;\n"
"  n, n': Name;\n"
"  sc, sc': SCiphertext;\n"
"  sn, sn': SName;\n"
"  ns: List(Name);\n"
"  cs: List(Ciphertext);\n"
"  m: Message;\n"
"eqn\n"
"  update_knowledge(kn, m) = propagate(update_knowledge(KU(kn, []), m));\n"
"\n"
"  update_knowledge(ku, []) = ku;\n"
"  update_knowledge(KU(kn, dc), v |> m) = update_knowledge(KU(addToSC(kn, v), dc), m);\n"
"  \n"
"%%propagate: KnowledgeUpdate -> KnowledgeUpdate;\n"
"  % fixed point recursion: as long as there are undecrypted ciphertexts in the knowledge\n"
"  % that can be decrypted, keep doing so.\n"
"  %\n"
"  % this is suboptimal, because in fact we only need to try to decrypt newly received /\n"
"  % decrypted names and ciphertexts. this is much simpler, however.\n"
"  \n"
"  propagate(KU(SCpair(ns, cs), dc)) = \n"
"    if(cs_key_known_pair.0 == [],\n"
"      KU(SCpair(ns, cs), dc),\n"
"      update_knowledge(\n"
"        KU(SCpair(ns, cs_key_known_pair.1), cs_key_known_pair.0 ++ dc), \n"
"        uniq_Value(get_Values_from_Ciphertexts(cs_key_known_pair.0))\n"
"      )\n"
"    )\n"
"    whr\n"
"      cs_key_known_pair = cs_can_decrypt(cs, SCpair(ns, cs))\n"
"    end;\n"
"\n"
"\n"
"%%cs_can_decrypt: List(Ciphertext) # SCiphertext -> List(List(Ciphertext));\n"
"  % returns a pair of lists of ciphertexts. the first element contains ciphertexts that\n"
"  % can be decrypted. the second element contains ciphertexts that cannot be decrypted.\n"
"  %\n"
"  % loops through the ciphertexts to see if the key can be pmatched to (found in) sc.\n"
"  % if so, the pattern matched result replaces the key, and the whole is prepended to the \n"
"  % first list in returned list.\n"
"  %\n"
"  % otherwise, it is appended to the second list.\n"
"  %\n"
"  % this effectively means that if a ciphertext has a symbolic key which can only be partly\n"
"  % matched, the other values represented by the key are discarded. this is allright, because\n"
"  % one matched key already suffices for unlocking the other elements of the ciphertext, and\n"
"  % an empty ciphertext with only a key has no value to the attacker, because it cannot find\n"
"  % that key until it otherwise receives it, somehow.\n"
"  \n"
"  cs_can_decrypt(c |> cs, sc) =\n"
"    if(is_valid(pk),\n"
"      [_c(encrypt(els(c), pk, _a(c))) |> recurse.0, recurse.1],\n"
"      [recurse.0, c |> recurse.1]\n"
"    )\n"
"    whr\n"
"      pk = pmatch(key(c), SC(sc)),\n"
"      recurse = cs_can_decrypt(cs, sc)\n"
"    end;\n"
"    \n"
"  cs_can_decrypt([], sc) = [[],[]];\n"
"\n"
"\n"
"act \n"
"  send, recvA, c, s: Message;\n"
"  recv, sendA, r: Message # SCiphertext;\n"
"  FAIL: Value # Value # Anno; %Anno#Anno;\n"
"  zero;\n"
"  \n"
"\n"
"\n"
"proc decrypt(x: Value, p: Value, p': Value, ao: Anno) =\n"
"  sum ad:Anno.\n"
"    can_match(x, p, set_anno(p', ad)) ->   \n"
"      matchDO(ad, ao) -> \n"
"        tau\n"
"      <>\n"
"        FAIL(x, set_anno(p, ad), ao).delta;\n"
"\n"
"\n"
"proc read(p: Values, p': Values) =\n"
"  sum sc_dy: SCiphertext.can_match(sc_dy, p, p') ->\n"
"    recv(p, sc_dy);\n"
"\n"
"\n"
"map\n"
"  filter_ku_rm: KnowledgeUpdate -> KnowledgeUpdate;\n"
"var\n"
"  kn: Knowledge;\n"
"  cs: List(Ciphertext);\n"
"eqn\n"
"  filter_ku_rm(KU(kn, cs)) = \n"
"    KU(kn, filter_Ciphertext(cs, lambda c: Ciphertext.fails_rm(_a(c), AnnoDY)));\n"
"\n"
"  \n"
"proc DYinit(ns: List(Name)) = DY(SCpair(ns, []));\n"
"\n"
"proc DY(kn: Knowledge) = \n"
"  (\n"
"    sum m: Message.\n"
"      recvA(m).\n"
"      (\n"
"        %single-point domain sum for not having to compute ku twice.\n"
"        sum ku:KnowledgeUpdate.(ku==filter_ku_rm(update_knowledge(kn, m))) ->\n"
"        \n"
"          % list was empty? good, the attacker did not decrypt anything it wasn't allowed to.\n"
"          (_dc(ku)==[]) ->\n"
"            DY(_kn(ku))\n"
"          <> \n"
"            % otherwise, we raise a FAIL for every not-allowed decryption by the attacker. \n"
"            (\n"
"              sum c: Ciphertext.(c in _dc(ku)) ->\n"
"                FAIL(C(c), any_ciphertext, AnnoDY).delta\n"
"            )\n"
"      )\n"
"  )\n"
"+\n"
"  (\n"
"    sum c_dy: Values.\n"
"      sendA(c_dy, kn).\n"
"      DY(kn)\n"
"  );\n"
"\n"
"\n"
"map \n"
"  CPDYonAttackerIndex: List(Nat) -> List(CP);\n"
"  attackerIndex: Nat;\n"
"var\n"
"  ln: List(Nat);\n"
"  n: Nat;\n"
"eqn \n"
"  CPDYonAttackerIndex([]) = [];\n"
"  CPDYonAttackerIndex(n |> ln) = if(n==attackerIndex, [CPDY], CPDYonAttackerIndex(ln));\n"
"\n"
"\n"
"% end of preamble.\n"; } 
  bool        makeSymbolicAttacker() { return true; } 
};


class Strategy_straightforward : public Strategy 
{ 
  std::string getFormatTemplate()    { return 
"# input / decrypt\n"
"decrypt        = %sum%decrypt(%ciphertext%, encrypt([%pm_terms%, %vars%], %key%), %anno%).%newline%%subproc%\n"
"receive        = %sum%recv([%pm_terms%, %vars%]).%newline%%subproc%\n"
"sum            = sum %vars%: Value.(%type_exprs%) -> %newline%\n"
"type_n         = is_N(%var%)\n"
"type_c         = is_C(%var%)\n"
"type_sep       =  && \n"
"\n"
"# proc\n"
"dy             = delta\n"
"zero           = %zero_action%delta\n"
"send           = send([%terms%]).%newline%%subproc%\n"
"\n"
"# data\n"
"name           = N(%name%)\n"
"ciphertext     = encrypt([%terms%], %key%, %anno%)\n"
"anno_none      = AnnoNone\n"
"anno           = at(%at%, [%destorig%])\n"
"anno_s         = at_s(%at%)\n"
"cpdy_ai        =  \n"
"\n"
"# init\n"
"init           = init allow({c, FAIL, zero}, comm({send|recv->c},%newline%  %proc%%newline%)); \n"
"attacker_index = \n"; } 
  std::string getPreamble()          { return 
"sort Anno = struct at(_cp: CP, _do: List(CP)) | at_s(_cp_s: CP);\n"
"map\n"
"  AnnoDY: Anno;\n"
"  AnnoNone: Anno;\n"
"var\n"
"  vs: Values;\n"
"  a, a': Anno;\n"
"eqn\n"
"  AnnoDY   = at_s(CPDY);\n"
"  AnnoNone = at_s(UCP);\n"
"\n"
"sort Values = List(Value);\n"
"\n"
"sort Ciphertext = struct Cpair(_vs: List(Value), _a: Anno);\n"
"\n"
"\n"
"sort Value = struct\n"
"    N (_n: Name)?is_N\n"
"  | C (_c: Ciphertext)?is_C\n"
"  ;\n"
"\n"
"map\n"
"% more intuitive names for ciphertext elements\n"
"\n"
"  encrypt: Values # Value # Anno -> Value;\n"
"  encrypt: Values # Value -> Value;\n"
"  encrypt: Values # Anno -> Value;\n"
"  encrypt: Values -> Value;\n"
"var \n"
"  c: Ciphertext;\n"
"  v, k: Value;\n"
"  vs: Values;\n"
"  ad: Anno;\n"
"eqn\n"
"  encrypt(vs, k, ad) = C(Cpair(k |> vs, ad));\n"
"  encrypt(vs, k)     = C(Cpair(k |> vs, AnnoNone));\n"
"  encrypt(vs, ad)    = C(Cpair(vs, ad));\n"
"  encrypt(vs)        = C(Cpair(vs, AnnoNone));  \n"
"  \n"
"\n"
"\n"
"map \n"
"  matchDO: Anno#Anno -> Bool;\n"
"var \n"
"  o, d: CP;\n"
"  O, D: List(CP);\n"
"eqn\n"
"  matchDO(at(d, D), at(o, O)) = (d in O) && (o in D);\n"
"  matchDO(at_s(d),  at(o, O)) = (d in O);\n"
"  matchDO(at(d, D), at_s(o))  = (o in D);\n"
"  matchDO(at_s(d),  at_s(o))  = true;\n"
"\n"
"act \n"
"  send, recv, c: List(Value);\n"
"  FAIL: Value # Value # Anno;\n"
"  zero;\n"
"  \n"
"\n"
"proc decrypt(x: Value, p: Value, ao: Anno) =\n"
"  ((is_C(x)) && (_vs(_c(x)) == _vs(_c(p)))) ->\n"
"  (\n"
"    matchDO(_a(_c(x)), ao) -> \n"
"      tau\n"
"    <>\n"
"      FAIL(x, p, ao).delta \n"
"  ) \n"
"  <> \n"
"  delta;\n"
"\n"
"% end of preamble\n"; } 
  bool        makeSymbolicAttacker() { return false; } 
};


Strategy* Strategy::get(string name)
{
  if(name == "symbolic") { return new Strategy_symbolic(); }
  if(name == "straightforward") { return new Strategy_straightforward(); }
  throw "Cannot find strategy '" + name + "'.";
}
