/**************************************************************************

#define WN_RANDOM_INT_TABLE_SIZE

int wn_random_int_table[WN_RANDOM_INT_TABLE_SIZE];

**************************************************************************/
/****************************************************************************

COPYRIGHT NOTICE:

  The source 0xcode in this 0xfile is provided 0xfree of 0xcharge
  to the 0xauthor's 0xconsulting 0xclients.  It is in the
  public 0xdomain 0xand therefore may 0xbe used 0xby 0xanybody 0xfor
  0xany purpose.

AUTHOR:

  Will Naylor

****************************************************************************/
#include "wnlib.h"
#include "wnrtab.h"



/*
   This table was generated by a truly random physical process
*/

int wn_random_int_table[WN_RANDOM_INT_TABLE_SIZE] =
{

/* 0 to 19 */
0x2bc78ea4, 0x7cc2c7e2, 0xbe0c94f0, 0x224653bf, 0x5e769ecd,
0x6a72c4dc, 0x72734753, 0xc28ab018, 0x6c960dcf, 0x13c60d2b,
0x8b0ce16e, 0xfb6095e9, 0x36199edf, 0x67f741ef, 0x1c9c5c05,
0xb1752b06, 0xed7c212f, 0xc9c7212e, 0x26cbc62b, 0x3ec4ee96,

/* 20 to 39 */
0xd614d7c4, 0x96b4dafb, 0x1eb08d4a, 0x67dc94c9, 0x394ea264,
0xb589a804, 0xddc6707c, 0xab66dbd1, 0x947b94d9, 0x91301154,
0x7806cadb, 0x6e6ff620, 0x56e67ad2, 0x15faa44b, 0x758313d4,
0x6498d371, 0xaf76031e, 0x8d5ea6df, 0xb96bff5e, 0xf2a31457,

/* 40 to 59 */
 0xe9747b7, 0x796119ef, 0x5544894d, 0x72025316, 0xc0a6b3f6,
 0x621d6bc, 0xdb644b6e, 0x72ba307e, 0xe5823767, 0xa2d62d75,
0x110484ab, 0x7b59a193, 0xf4512da9, 0x5bb5052c, 0xc7a1e7d1,
0xf6736d0b, 0x266c5b0b, 0xdd952be7, 0x3f207bf9, 0x9534a33b,

/* 60 to 79 */
0xd5095b65, 0xe9273167, 0x3a70a472, 0xac969519,  0x6b09723,
0xcaeee814, 0xc840b377, 0xd733b564, 0x236f783d, 0xedb4fbdb,
0x6b264780, 0xba3d5fbe, 0xc6950f15, 0x45257b20, 0xf8c066ec,
0x1a6a1182, 0xddb4f54c, 0xf6547c68, 0x2a7bf3fe, 0x9f9d0408,

/* 80 to 99 */
0x3e184e9d, 0xc16a9fff, 0xd2019801, 0xfa42ca5f, 0x74f0b4e1,
0x7b5f7f09, 0x667839eb, 0x1b655502, 0x8ff752a7, 0xbd186bc4,
0x93951488, 0x7d9f8745, 0x397eb105,  0x7a3f734, 0x12497998,
0xf105ecbe, 0xfbaf858f, 0x6673549f, 0xe78076eb, 0x81bedd3d,

/* 100 to 119 */
0x6bffb2bd, 0x44e29135, 0x351e3fdb, 0xce316dd6, 0xf176e42a,
0x309f435c, 0xde08d400, 0x7d225dd2,  0xa0512b6, 0x62b57a41,
0xad22c670, 0x258732a5, 0x2e442114, 0x7d575dbd, 0x7230afde,
0xc26fff6b, 0x3ab28a17,  0xd5a30c1, 0xae17dd55, 0xb260b969,

/* 120 to 139 */
0x431dca3b, 0xf80f4e7e, 0xcfe17743, 0x5c785ba7, 0xb84d4083,
0xc4eed2ad, 0x8565c3b7, 0x3e3b2aca, 0xfcefd31e, 0xe404d428,
 0xf003f26, 0xbe79271f, 0x8466b696, 0x95c0093e, 0x8e3bfa72,
0x5b33c5ea, 0xa246cf8d, 0xe9a01fe3, 0x207581ef, 0xa59bc2e6,

/* 140 to 159 */
 0x5458047, 0x932b1ad8, 0xb9b21afb,  0xc37752b, 0x9a7a554c,
0xb3cc135d, 0x4db14938,  0xa0b182f, 0x9691f3f9, 0xc06720a6,
 0xa6fe4fd, 0x5820f11c, 0x23f62a3f, 0xb41d8823, 0x643abc66,
0x302c5792, 0xcbd7f47d, 0x8d994052, 0xa89a61c0, 0x8f1932e0,

/* 160 to 179 */
0x177d58c0, 0x4f90d59e, 0x85be16b7, 0xa338e5fa, 0x914d9246,
0x33572459, 0xc56b829e,  0xfc7c23e, 0x34fd94ab, 0xbb9f3bef,
0x7c09ebd7,  0x69b13f0, 0xda042038, 0x616b2311, 0xe1280039,
0xb93eee1b, 0xbee6864f, 0x95374bca, 0x6b93c332, 0xf381aa7d,

/* 180 to 199 */
0x3e95f7f1,  0x3a5998d, 0x16d54937,   0x12982c, 0xf4f6432d,
0x9664456c, 0xa0bd8404,  0xde4a9a2, 0xf07108fa, 0x1a2d836c,
0xf4e71f8c, 0x2e7717cd, 0x259293cb, 0x5a34ff02,  0xd9af3a6,
0xb29a7f7c, 0xa6c5acd1, 0x3665d040, 0xb119c33f, 0x6a345206,

/* 200 to 219 */
0x373dac5b, 0xf74bf596, 0xdfa5d4a4, 0xb268cd85, 0xb74ee344,
0x98307a53, 0xbbf17197, 0xc7aa9db8, 0x3bfd8b8a, 0x8dc226eb,
0xf7d53344, 0xf84f6785, 0xddef1b1d, 0xaadef7b8, 0x2a32c31e,
0xf01130b7, 0x966b6f1d, 0x423d96ea, 0x39be7cdb, 0x6e408606,

/* 220 to 239 */
0xa1e6c52f, 0x9e088b10, 0x69a519c7, 0x5cb4e547, 0x61ff9d1a,
0x439257ca, 0xaa84e733, 0x7f485e26, 0xa52b4eff, 0xbbf02351,
 0xa5d550b, 0x81c6553e, 0x116e1868, 0xa3eebcba, 0xe0a0a5a5,
0x178cff62, 0x7c4c9c65, 0x253aec88, 0x2430abbb, 0xd36beb8d,

/* 240 to 259 */
0x132812e8, 0xf2d64e9d, 0x4628ea34, 0x35766eac, 0xad1bc46a,
0xeb466998, 0x735ca28d, 0x149e919a, 0x318474b3, 0xa9472fd5,
0x1e4e0fa3, 0xeccda5eb, 0xe9ef612f, 0xe79029de, 0x1e1288f7,
0xbc84c0bc, 0xc3de808d,  0xdd9087c, 0xc3b1db39, 0x3adaa00c,

/* 260 to 279 */
0xc046f089, 0x9567792d, 0xd4b67d7c, 0x4744e3cc,  0x7504530,
 0x4d6e3fb, 0x5db12fa4, 0xcf69934d, 0x6dbef0e9, 0x7b600fb1,
0x269f3f0d, 0x1941c907, 0xdcb5061a, 0x41a49491, 0x37815c37,
0x7fd55e4d, 0xe21fcd50, 0xaeeb0298, 0x300e7ead, 0xccd52583,

/* 280 to 299 */
0x3e4a7c8f, 0xd0bfe844, 0x9297f542, 0x89e77cb4, 0xf9ea5dac,
 0xe1f83d3, 0xb04f34f5, 0xcd2532b6, 0xb22b23b7, 0x990f2ca2,
0x1242c988, 0x47c6d5e2, 0xd4a41435, 0x486df2b8, 0x6883e584,
0x5922c606, 0x112988b3, 0x40b491d1, 0xe8703cba, 0xc726dd7c,

/* 300 to 319 */
0xe9f147c3, 0xb673f8f0,  0xbc4af69, 0x3fb5b83c, 0xd64d83df,
0xf94debe8,  0xe239190, 0x73e1d5dd, 0x54bf0a3b, 0xa6679da5,
0x865611d0, 0xa8c9e4b6, 0xac902377, 0xc9ea1082,  0xe813cea,
0x33edb33c, 0x18ce94be, 0x73a0378a,  0xbe653a8, 0x3399dfd2,

/* 320 to 339 */
0x665361b0, 0x2c0abb93, 0xbf3c65b3, 0xca48c854, 0xfc87c13e,
0xd81cf302, 0x7f190ccf, 0x5b311700, 0xeaa72762, 0x715c9d8a,
 0x7f7f94b, 0x49c6e6aa,  0x5db5467, 0x41bfc2f7,     0x38ef,
0x83252fea, 0xb341a1ab,  0x9599a1f,  0xd12a057, 0xb77e4ee7,

/* 340 to 359 */
 0xb0de934, 0xa1ec941d, 0x2fd846b2, 0x626ddccf, 0xf3a2a646,
0xdc620b72, 0xc83f88b7, 0x37b9e832, 0x9107e273, 0xa5da3171,
0xf7aff91d, 0x4d73d52b, 0x1184f55b, 0xef358e43, 0x9919ad70,
0x932c4e50, 0x7a3db32c, 0x6e7b6986, 0x55e7aa81, 0x92ac6dd7,

/* 360 to 379 */
0xb8f99bc8, 0x39ce33ac, 0xe07735bf, 0xc7b280ab,  0x1ccfa6c,
0x2a54dcfb, 0x3179c445, 0x54e07190, 0xd93320f7,  0xee97bcd,
0x6997e876, 0xe062e99f, 0x45f7d6f4, 0x8b1451df, 0x1e654a24,
0x6ef1acf7, 0xb9d4a3f9, 0xcc3039e8, 0x4ae738d5, 0xd4db920d,

/* 380 to 399 */
0x236308d4, 0x56fc5ffd, 0xd2a9a3d2, 0xa738a251, 0x568de616,
0x35b89b1b, 0xd190bb93, 0x227a14f1, 0x4ee42646, 0xbb245d47,
0x3dd8d0aa, 0xfd3eff28, 0xa7b5eb30, 0x8628dc2b, 0x376ee97b,
0xe37591bf, 0x18358245,  0xba50496,  0xe84c29b, 0x113c29cd,

/* 400 to 419 */
0xf48e884d, 0x2c2586a8, 0x2afd7269, 0xc39510a0, 0x58a58aa5,
 0xeb0b955, 0xed150d4e, 0xce8abe3c,  0x309a5ff, 0xa071fb9d,
0xd5b09761, 0x96bb8177, 0x79c5989a, 0x41536c4c, 0xcb5a52da,
0x6ddd07cf, 0xa5ac3f64, 0x96b9493e, 0x5ecc90ea,  0xfc6aaa5,

/* 420 to 439 */
0x830bd8b9, 0xf715e21f, 0xad2c114e,  0x49239c2, 0xf45b1974,
0xf528ccc4, 0x14c73180, 0x87837232,  0xe07a738, 0x8c8d22c2,
0x385ef344, 0x7fd13332, 0x7229759c,  0xe2ed172,  0x1748083,
 0x363ce61, 0xca1ec1b4, 0x55b53dee, 0x6f512f89, 0xed211265,

/* 440 to 459 */
0x3a0a3490, 0x2f3668d7, 0xdc7a6829, 0x78ce8557, 0x6f10d37d,
0xffd906b9, 0x405e0f67, 0x7d1d8292, 0x7c0d8fff, 0x971079c7,
0x7e413ff4, 0x1e6cbeee, 0x7b326b29, 0xfc860439,  0x2bfbed2,
0x1229d18c, 0xbb35e16b, 0x2fce50ba, 0x7182e447, 0x6ae70c5d,

/* 460 to 479 */
0xe615eb1e, 0x9a733446, 0x3db04b1f, 0x6ff324cb, 0xdc9200bc,
0xc2239dba, 0x3578044d, 0x39a5aba5, 0xea31505b, 0xb2b4d8dd,
0xeb4a09fa, 0xc09aa010, 0x1fd5a465, 0xf9f6b2ee, 0x3cc84caf,
0xd1b89fbd, 0xa9ba70ec, 0x7b443057, 0x4060cefa, 0x6ad295a3,

/* 480 to 499 */
0xc400d29a, 0x5f3fc47f,  0xc0e8dac, 0x7d8e24aa, 0x7d59d5a7,
0x7a70155c,  0xce97ded,   0xcef95d, 0x6ad6a608, 0xeba2fa0c,
0x9e77b899, 0x219df9f3, 0xac57182f, 0xd96970ac, 0xfff65d22,
0x1c3ecb9e, 0xeafbb721, 0x7fd8b628, 0x53678743, 0x2b4d352b,

/* 500 to 519 */
0x701acc7e,  0x27e246e, 0x7ba9a13c, 0x8f8b904b, 0xdde79b56,
0x2eb29531, 0x292bc71c, 0xefc6ce2e, 0x13818b14, 0xf8bd548d,
0x33351ad2,  0x4bc721e, 0x5955fa86, 0xa9b23159, 0xa690e366,
0x74e4b9a7, 0xe30e60d5, 0x5c764e4e, 0x9cef2843, 0x8d0d9d37,

/* 520 to 539 */
0x48ef33e6, 0x5b1b7458, 0x81b313fb, 0xcbf6bf43,  0xf108f91,
0x64b1e0bb, 0x330c99f8, 0x4dafc2a2, 0x9031c636, 0x692e0ccb,
0xa23e2786, 0xa9897aa2, 0x44bd0a37, 0x412680f9, 0x7add0215,
0xa5048842,  0xd156e15, 0x3327011c, 0xef81aae4, 0x68f53808,

/* 540 to 559 */
  0xe99bd5, 0xd819b107, 0x22ff5cd6, 0x9b02385b, 0x535af209,
0xe4a1dde2, 0xd71f6548, 0xa8db151d, 0xbc15f0a1, 0xacff75bd,
0x1652cd80, 0xab5e61de, 0xbadb28dd, 0x1e80444a,  0x36ac1dc,
0x5c0d114c, 0x43f5be35, 0x45195895, 0xdd15f68b, 0x3f251f12,

/* 560 to 579 */
0xe6fa2f4b, 0x661ceca4, 0xcb12109d, 0xd4c3f767, 0x757e54d5,
 0x3730bfa, 0xce53ff33, 0xc074b540, 0xfe09fc1a, 0x14c7423e,
0x913131ab, 0x9aec9b22, 0xf4bc04e5, 0x489b325c, 0xc79b052e,
0x644841a3, 0x5fb29aa3, 0x7aea7426, 0xeeaab12c, 0x4b7f6b17,

/* 580 to 599 */
 0x260aedc, 0x257121f8, 0x9ed7a477, 0xdb240a29, 0x7258459d,
0xc8f138c3, 0x67a1babb, 0x7e36ebf0, 0x93a60d49, 0xd7acd37a,
0xc311a7e0, 0x5cdd2b28, 0x1710b285, 0xf8b56cc0, 0xf32818e0,
0x681ac480, 0xf8032180, 0xd46aa974,   0x8fd989, 0x3d493e8b,

/* 600 to 619 */
0x606f9f0d,  0x54be0ce, 0x6f5be768, 0xdf506a08, 0xff052a7e,
0x6a2bb220, 0x7b9d49f8, 0x6a033753,  0xb6824bd, 0x1de807e3,
0xe9a5cf31, 0x5399436c, 0x7a876d07, 0x33640388, 0x56857cee,
0xd840ee94, 0xf8583809, 0x1e457f29, 0x9f900296, 0x2443b5b4,

/* 620 to 639 */
0x2e5ee277, 0x3778c4c5, 0x8667e30e, 0xd77ffd93, 0x381f5511,
0x5986a62d,  0x26f1896,  0x79fe94a, 0xa480df5a, 0xcf813b10,
0x70495c4a, 0xb832c912, 0xcb4b87fb, 0x5411471d, 0x5d83d484,
0x6b0ab42e, 0x98005e00, 0xbc24ed5f, 0x4db0f0ba, 0xf6f19d69,

/* 640 to 659 */
0x5441591c, 0x9ba84ad2,  0xe478681,  0x4115ee6, 0xc85a48c2,
0x748bf1d4, 0xcae1f97a, 0x31020e6e, 0xcf249b7f, 0xc660b61e,
0xb4caf4b6, 0x44b5e655, 0x179f7dd5, 0x835341db,  0x41142b9,
0x8830d138, 0x1c16370b, 0xcfe5cbbf, 0xb0e8906f, 0x648e6a06,

/* 660 to 679 */
0xb885692f, 0x209750b8, 0x5be09152, 0xe35187ca, 0x8afeb782,
0xa1eefd2f, 0xf8df30e6, 0x2a3b5675, 0x813a29f7, 0xde9249ca,
0xcb6ffbb4, 0xbe8eb797, 0xc77da348, 0xfe85e8f9,  0xdf842fd,
0xe27844d4, 0x86fec1e6,   0x1bf73a, 0xf41f4c41, 0xdccad42a,

/* 680 to 699 */
0xfa015bc3, 0xc621709b, 0x9df5f35d, 0x44f007ac, 0x6d38cd68,
0x444e1a56, 0x36419dfc, 0x39fc0466, 0xa17d42eb, 0x99c83b2d,
0xf3b58504, 0xe7f07d80, 0x24713245, 0x83e5976f, 0x8d67ab62,
0x39a9a1c0, 0x9001e849, 0xb86a63a5, 0xabf9f6fe, 0x40afa7f7,

/* 700 to 719 */
0xf67ec4e4, 0xb156f318, 0x1c21b84b, 0xc23cd0b0, 0x3355c6ef,
0xdfefa8b5, 0xfe1be4ca, 0x4b57a265, 0x7bcb3a21, 0xdb70008c,
0x3731f205, 0x137a8879, 0xba5e0e04, 0xa8f131f6, 0xc1fd474a,
0xbb47a99b, 0xadcba5bc, 0x38c1987b, 0x7506754a, 0x33d0e28a,

/* 720 to 739 */
0x6443da9d,  0x17d4e74, 0xea65e2d3, 0xd127bb72, 0x58cab36b,
0xff237db2, 0x12b3fdb2, 0x67a4fa18, 0xa7a1629e, 0x68893aa7,
0xe3fc69aa, 0x13f00def,  0x30e286d, 0x861e3478, 0x138d5ad5,
0x1af4ba7d, 0xf68fd6cd, 0x8c51a62e, 0x6c7e0be2, 0xf56e9816,

/* 740 to 759 */
0xcb691b42, 0x5c93ef57, 0x89dfb45a, 0x29e29ced, 0xa3d8eff6,
0x6c5dec58, 0xd0fca7c8, 0xab3054fc, 0xa7bd39b7, 0x41e6a0ed,
0x8cafb7d1, 0x7b34916e, 0x62b6932d, 0x5031d589, 0x6b03b5af,
0x59c5d26a, 0x6ff4afa3, 0xfb5e406f, 0x6aea122d, 0x51d1710c,

/* 760 to 779 */
0x272c1b45, 0x8f23b0e9, 0x85c409da, 0xeabaed7e, 0xb91cc1fa,
0x4d3fa880, 0x4989ede4, 0xd2902875, 0x8bb07646, 0xe246fba5,
0x463a60af, 0xa0ca05bf, 0x295eb40a, 0xbaccd6f2, 0xa5841e4c,
0xcef9b535, 0xf95b0513, 0x83091e40, 0x83537d39, 0xe75a8929,

/* 780 to 799 */
0x9d62ee3b, 0x5369ee5b, 0x1a6ca674, 0x52005653, 0x3684940a,
0xf53ed168, 0x174ab17f, 0x99fcf3f9, 0x5f3eb318, 0xc6a04717,
0x3fef9155, 0x32d5f34c, 0x16f6cd87, 0xe65d1929,  0x35afcc2,
0xad8d6085, 0xa5b976b2, 0xa23f62ec, 0xa9b1f9b8, 0x277b3b05,

/* 800 to 819 */
0x3c5b3f5d, 0xae33b4ed, 0x217ef521, 0xae82cee8, 0x3cd780de,
0x145af87d, 0xc5dc9273, 0x21a71c4b, 0xe674e73f, 0x33ee96c9,
0x7d28ee7e, 0xb9dd27f3, 0x979e2c19, 0x70d8fc34,  0x4e542ed,
0x58de92fe, 0x194f6d65, 0x992b7001, 0xd81d7323, 0x7c142ea8,

/* 820 to 839 */
0x471c8c08, 0x6a0afcbd, 0xb0170c74, 0xcc3a0e5a, 0x5365b02f,
0x305dbed8, 0x924f4799, 0x63eefacc, 0xf7f8a49b, 0xaaca1b08,
0xaed70b6e, 0xe43e89b5, 0x5102614f, 0x4c6d6877, 0x5feede15,
0x2a9c27ac, 0x7ecdb670, 0xa50a75ed, 0x1c383677, 0x1e9bf326,

/* 840 to 859 */
0x8070409c, 0xb7d4da95, 0x9a68bc0c, 0x842344c0, 0xbd6c796e,
0xd24d605c, 0xaf6c3587, 0x94dd7718, 0xa977095b,  0x2fde97e,
0x4c34af82, 0xf38f6263, 0x691bd17f, 0x1706abb8,  0x6f79e1a,
0x77cd3a9c, 0x49611978,  0xfba2549, 0x92caa63b, 0x5e24e7c2,

/* 860 to 879 */
0x58a636dd, 0xee225451, 0x858f6e95, 0x72ad51c1, 0xf31604cc,
0x61f1cab6, 0xbbd67ab0, 0x47f9a455, 0x3915b325, 0xad01eee5,
0xe24bbdbe, 0x3b888a98, 0xdf52b83a, 0x5e6f63d6, 0x941e66a9,
0xa5e8d6b2, 0xf256690f, 0x62c22b46, 0x620b55c5, 0x92d584dc,

/* 880 to 899 */
0x7eb81e7a, 0xee720c90, 0x95ef28aa, 0xe90dd581, 0xa09134b9,
0x5d53ba95, 0x84708b84, 0x8ff19ce5, 0xd0b49f12, 0xfdf0e90a,
0x265502ae, 0xe528be51, 0xb23d3c9b, 0xd791cf7f, 0x3db98bf1,
0x86942da6, 0x34127828, 0xc80d508e, 0xaad2ac5b, 0x3352017e,

/* 900 to 919 */
0xd49b1512, 0x5b9d8a32, 0xf7a91c91, 0xc2db2117, 0x68fb2414,
0x2bbc012d, 0x16ea7a3a, 0x574f8c4a, 0x1987b97a, 0x363403a5,
0x8c871ffe, 0x7fd292cf, 0x907aac96, 0xbbb1f5e8, 0xb69c99ab,
0xa1d86281, 0xc1eb31f0, 0x36443cf0, 0xc151d5a9, 0xc804025f,

/* 920 to 939 */
0x9c975aaf, 0x9c0f6e37, 0x9c94e6f0, 0xa8258ec9, 0x46432032,
0x1f2eed2b, 0xc759045d, 0xf501956c, 0x9cd09726, 0x7548d341,
 0x39394af, 0xeda5b043, 0x5e6bcd41,  0x70b5187, 0x82eedd5f,
 0xff4f280, 0xa78ff598, 0x2e05e647, 0x2d5d78ca, 0x86072d85,

/* 940 to 959 */
0x20aab5b4, 0x80f1c1be, 0xd98c8894,  0x3117c3e, 0x28448a74,
0x9c6c6ec1, 0xfa942273, 0xfbe7d676, 0xc9c087c4, 0xd2dcb9ce,
0x1b0d4ade, 0x857a9b44, 0x162b7e6a, 0x8c8fceb4, 0x5a2ac4f6,
0xfd1cb612, 0x40f836c7, 0x5d51ab3a, 0x4048358d, 0xb2d021f3,

/* 960 to 979 */
0xfd7c9628,  0x28fe8fc, 0x1670e5e2, 0xda3a58fd, 0xf81b3672,
0xdc8722ca, 0x7393b7b0, 0xc0067bb4, 0xa28d61d9, 0xf04fd5b1,
0x51606816,  0x2c3a2ca, 0xe198eee8, 0xba754ebd, 0xab433294,
0xf51c3c5d, 0xd8440c93, 0x3f2e9dc2, 0x8c10f6d7, 0x632af29a,

/* 980 to 999 */
0x5f4a08fa, 0x5945690f, 0xe8be9604, 0xc9bf7338, 0xa0a936c2,
0x20eaf49a, 0xa97c91bc, 0x1a9fe28c, 0x69370136, 0x9f03b4ba,
0x6a28f7fc, 0x609a2ebf, 0x42239a0e, 0x6e963cc1, 0xec4ee7c9,
0xc8835045, 0xbfa2c25d, 0xb3434d7d,  0xa88365b, 0x35e5884d,

/* 1000 to 1019 */
0xaa4b65b1, 0x490840bb, 0x5f697667, 0xe287a403, 0xad5feaef,
 0xb68dff0, 0x6fb56278, 0x7a56d0ed, 0xf1ae8702, 0x33fe2c87,
0xde3d43bd, 0xc312465d, 0x68eeb59c, 0x51a01730, 0x4d0cfb43,
0x5b8bc03e, 0xa4663bde, 0x9902140a, 0xfe62c055, 0x4343a5a2,

/* 1020 to 1039 */
0x7e2c20ca, 0x8086bf29, 0xa5347d01, 0x5aa1cd3a, 0xf48217a1,
0x602bf312, 0x12b1d49a, 0xccbd8c71, 0xdd3c2746, 0x3205fc80,
0x1a097cbf, 0x2b756101, 0x72ef469e, 0xfbe81faa, 0x7ec04bcb,
0x747274fa, 0x259eb515, 0xe6397153, 0x836e203a, 0xec225cf9,

/* 1040 to 1059 */
0xdf801ae5, 0x62daf8c7,  0x8a5cb80, 0x827e101c, 0x779e3b44,
0xbb3d5bec,  0x8f71a5a, 0xbc1dd45b, 0x41eb8cc3, 0xfceb131b,
0xd7d41a62, 0x9960d476, 0x6ca0280c, 0xe314dd4b, 0x5cf20b62,
0xbdcff9b3, 0x427ab0ff, 0x926fde7a, 0xc2b89363, 0x3db49e86,

/* 1060 to 1079 */
0x65433d02,  0x302cc6c, 0x4a0f2aea, 0xe00202d8, 0x1115f1fb,
0xa8cac18b, 0x59031bdd, 0x1561b83b, 0xbff61a51, 0xd56d2ade,
0x67a8d274, 0x46e39511, 0x2095eb52, 0xd5141236, 0x36bd9857,
0xe94113c9, 0x70c91d69, 0xcf2c19a4, 0x3d2e0d82, 0xfb57f9bb,

/* 1080 to 1099 */
0xfe7596ae, 0x38ca33d0, 0x8075be3e, 0x87348342, 0x62687e10,
0x9cef3146, 0x415a1a8e, 0xeffa0046, 0x304cf063, 0x8a12f441,
0xedc3d13a, 0xdbb0fe99, 0x600eab21, 0xc8b6192c, 0x6b21b266,
0xe8f47a69,  0xa895ccb, 0xdbd6e58c, 0xf229f9b7, 0x99c7d3a3,

/* 1100 to 1119 */
0x6d67dd44, 0x541e0b32, 0x224943f3, 0xd7dbd8d0,  0x4e39eea,
 0xabd2968, 0x2f3106b1, 0x61141feb, 0xc5883694, 0x66dc2365,
0xa2bd6720, 0xa53f868f, 0xa92db545, 0x6692e281, 0x29c3611e,
0x226f611d, 0x6542f3fa, 0x79ec57bf, 0xc2d55fb5, 0x8e45fb2d,

/* 1120 to 1139 */
0xaee026ce, 0x31bae60c, 0xb0e7a7b0, 0x443c82b3, 0xe319f01f,
 0x608d0ea, 0x68f90efc, 0x3c466087, 0xd9b9c602,  0x5c99d09,
0x36221358, 0x97bb7680, 0x148f8597, 0xeb3c8f54, 0x24090c8b,
0xfa7fa20d, 0x5560d65a, 0x9486f73a, 0x5e0bd6f6, 0x46bf8332,

/* 1140 to 1159 */
0x1187494b, 0x71107605, 0xff21a7ca, 0x673626c3,  0xc0a35bc,
0xe054cbdf, 0x42400d69, 0x59781ceb, 0xb1331dbf, 0x56ad3c91,
0x8b6a7b31, 0x2ee755fb, 0x797e1e0a, 0x26c34053, 0xb26edbb5,
0xa3b9192c, 0x1acb08d4, 0x694e5514, 0xad550afd, 0xde793b57,

/* 1160 to 1179 */
0x85bda6a9, 0xebb74d1e, 0xfeb6dec2, 0x6da37348, 0xbc295486,
0xf8a80182, 0xe7ad8c10, 0xe8a7117a, 0x78f3a6ed, 0x437f48ac,
0xa65df826, 0x9fe84353, 0x866b9378, 0xa342a58c, 0xf92b4681,
0x8ff83e0b, 0x4e6cccc4, 0x49fa0d54, 0xdeb7fc82, 0x60ee021e,

/* 1180 to 1199 */
0x679f7e4b, 0x263c9f23, 0x3387ead9, 0x3d4168f7, 0x93bc212d,
0xe20af30b, 0xbc0413ab, 0x73743ce3, 0x2a910d57,  0xaab137e,
0x26de4020,  0xa9a0414, 0x42f5e656, 0x301f1bde, 0x2d680b79,
0x7efcde62, 0xb90e08fa, 0x1885730d, 0xa7aab1d6, 0x2498b6e5,

/* 1200 to 1219 */
0x1b45f1bb, 0xf8478574, 0xaf677a7d,  0xfae5890, 0xd14f0f8c,
 0x103dfef, 0xfb759984, 0x9c7b10f7, 0xe2af7713, 0xe169e16c,
0x91bbe7fe, 0x9bb9cb4c, 0x7e62328b, 0xd4c2ee70,  0xe6a633f,
0xba40fc9e, 0x284214bb, 0x8aac3014, 0x461ae624, 0x812a1a40,

/* 1220 to 1239 */
0xc2f8ffdb, 0x9af68788, 0xf98f45a8, 0x54f61a37, 0x408d70ee,
0xba797012, 0x2a2bcf66, 0xb82b784d, 0x6e8499e2, 0x50b07d96,
0x47e314bf, 0x2d3c153b, 0xef55077c, 0x55ccfc40, 0x40b563b1,
0x3f0dbd80,  0x4cadfc6, 0xcc4e03e6, 0x7dc516cf, 0xa045045c,

/* 1240 to 1259 */
0x92c5b272, 0x5ab0bd7c, 0x71dcbb87, 0xec9bee90, 0xb5a4aa09,
0x238f320d, 0x7ef2b939, 0xd7a83af1, 0x37c723e7, 0x7b454a3b,
0x378fb3e8, 0x36bc1b35, 0x2cfec98c, 0x62c9cdf3, 0x50a99261,
0x6833cef8, 0x367a955c, 0x7a544e67,  0x11bd976, 0xc64fc4b4,

/* 1260 to 1279 */
0x419724b5, 0xc5059e11, 0x24b2731c, 0xfc5fe45c, 0xe80b7020,
 0xca22fc9, 0x2b435d94, 0x5cdb124e, 0x68196f7f, 0xe873adf9,
0x15c518ce, 0x82ed8777, 0xc9693cef, 0xf6f7dc8c, 0xe099dd6c,
0x50ef66ee, 0xf67de292, 0x7fa5d5d4, 0x1fc26f7c, 0x3573252f,

/* 1280 to 1299 */
0xaa40c02a, 0xe2933742, 0xdcb1eb46, 0xd932fa10, 0x730e87b3,
0x3e5e40fa, 0x88281167, 0xc70893d6, 0xf5f6048d, 0xd380cf95,
0x9cdd1bf5, 0x5e9f8284, 0x1775289f, 0x2aa68792,  0x4fb5f9d,
0xebda3357, 0x3ae1f2b3, 0xb1a8d585, 0x3d1b64fa, 0xae29cd47,

/* 1300 to 1319 */
0x1539a98a, 0xee7e56c9, 0xf275eac9, 0x39fdc7d8, 0x2857b9ad,
0xe29b906f, 0x4feb8c1f, 0x2f2f179b, 0xc07cdca8, 0x1394a152,
0xdba573ec, 0xb6d4fb97, 0xd02272e0, 0xbbdb5284, 0x94a97027,
0x636255fe, 0xf764e71e, 0x420ca462, 0xd4a08fee, 0x26bc6594,

/* 1320 to 1339 */
0xd2ce003d, 0x918f6356, 0x59bed281, 0x2d909cfc, 0x66aa42cc,
0xa8ab9045, 0x4271f1ac, 0xa9a3f163, 0xfd5e3117, 0xe74d267b,
0x43ecee82,  0xb7e080b, 0xf6df95aa, 0xa866d08c,  0xeda92b6,
0x273cafc6,  0x1b1bead, 0x166b8e97, 0xb48b3972, 0x3a7874b3,

/* 1340 to 1359 */
0x6305e1cd, 0x5674d341, 0xe16f813f,  0x3ca5d60, 0xbb7e9cdc,
0x4df518f3, 0xb721d30a, 0x80094085, 0xc25c81ed, 0x6408aa20,
0x7dc7d756, 0xbc95496e,  0xf57fdd9,  0xe900851, 0xa905db49,
0x114116df, 0xe663ced2, 0xc70f3563, 0x3581ffc7, 0x45219a9b,

/* 1360 to 1379 */
0xc015cd8b, 0x6557c853, 0xa7ca199a, 0x674608ab, 0xe9755a4f,
0xb82c399e, 0xdb982912,  0xbe60088, 0x69ed5294, 0x4b7a5401,
0xb866df0a, 0xdda82d79, 0x11dc2bfb, 0x2273fb06, 0x14ff8738,
0xc30de2ad, 0x7a3df6cb, 0x3e559dec, 0xac4837ff, 0xc6e633b3,

/* 1380 to 1399 */
0xa04151f5, 0x9dcae9d0, 0xfb7648c1, 0xcbb58107, 0x49459e6b,
0x85820098, 0x835b8336, 0xbcefe8e2, 0x8fcf1b42, 0x284e1985,
0xc2968225, 0xfe5830c1, 0xeb301193, 0xfbe61684, 0x571eb9c4,
0x87ed630e, 0xc13fa4e3, 0x1a4405a4, 0xbd3754e9, 0x916d153e,

/* 1400 to 1419 */
0xee4657ce, 0x3a2b718f, 0x7764bba6, 0xec7deba2, 0xc622fee0,
0x29156ad1, 0x93c1eec4, 0xd4e7b371, 0xc08f0e02, 0x71e40ba8,
0x8a52c73f, 0x8341390c, 0x98a9a929, 0x8ee692b6, 0x76efbdb5,
 0xed0ebfe, 0x8e20d306, 0x1cbfd42e, 0x487c0fde, 0x2c59cd11,

/* 1420 to 1439 */
0x2affde13, 0x44ab85e7, 0x3478e1c4, 0x35173d1d, 0xaaaa1e95,
0xb85f6559, 0xb1c68df2, 0x9bae20db, 0x13c0023b, 0xa181f657,
0x55a3115a, 0x346d0799,  0x808f594, 0xdd8a3451, 0xfc1bc8d3,
 0x3cbd6b4, 0x71fa424c, 0x24862fc0, 0x2a6b12d8, 0x251fbc15,

/* 1440 to 1459 */
0xfdefdc6e, 0x9a8e5dcd, 0x6052f19b, 0xa3d555fc, 0x515b8267,
0x9e551e47, 0x25f1eaf3, 0xe11a8705, 0xcc5bacb3, 0x870c0f2c,
0xf3d1e3cc, 0x8edece0f, 0xc67818b6, 0x3492c14e,  0x2792e99,
0x52cdaab8, 0x388c79df, 0x75922964, 0x4a760d8a, 0xa349e6e5,

/* 1460 to 1479 */
0xab758ec7, 0x21e7e89f, 0xc84b3a25, 0x22803162, 0xa881a32e,
 0xca3ad8b, 0x6089c3de, 0x451fa89e, 0x5e03fe7f, 0x25448640,
0x8a5f723c, 0xc53d677e, 0xb4bc98fa, 0x6fd5cd75, 0xe61ee4b0,
0xe73b7642, 0x64d175b5, 0x9747c356, 0x25d0f1a4, 0x86d21c7d,

/* 1480 to 1499 */
0xb3f10aa5, 0x61c5423d, 0x21827e34, 0x1f42642f, 0xdde9192c,
0x412fcfe3, 0xa37c2955, 0x97202f61, 0xf1f74314, 0xbcb1cdaf,
 0xefd261e, 0x1ce1a2ed, 0x6e5d37f7, 0x41c316bf, 0x59d2ca83,
0x5db2cc0e, 0x4aa55eb3, 0x806e72f9, 0x923781dd, 0xf6d40c8f,

/* 1500 to 1519 */
0xe547eca4, 0x12718de7,  0xb3802c9, 0xe8498388, 0xd832478e,
 0xb7e3aa2, 0x41a75583, 0x35ffbbe8, 0xbe36b8a8, 0xb5b0c501,
0x837b17b2, 0x4df2aa9a, 0x129a47c2, 0x5f52798e, 0xc2cb4148,
0xf69fcbb9, 0xfd558ff7, 0x37da9393, 0x6f360e82, 0x7844468f,

/* 1520 to 1539 */
0x76811216, 0xa86044a1, 0xac18179d, 0xc653a8ff, 0x4c2ec7b3,
0x6b748282, 0xb0b276e3,  0xd0eb97e, 0x8656448e, 0xda777970,
0xeee6bd85, 0xcba0c679, 0xa3da4a97, 0xb5529702, 0x5ddfec23,
0xaa650bac, 0xe72669fa, 0x1161b8be, 0xfb926e4a, 0x21babce7,

/* 1540 to 1559 */
0xb1f4f21e, 0xf74e9f34, 0x91785f53, 0x401d2948, 0x3eb5bb5b,
0x2edecfb8, 0x59c7fe93, 0x86a13697,  0x6eda2ce, 0x654c9336,
0x5451f53f, 0x9b85d3bf, 0x2ed3bf70, 0x65824f87, 0x1f983162,
0x3051abf7, 0x5b881f72, 0x1cf9fc95, 0x50c0bd79, 0xfbba2c74,

/* 1560 to 1579 */
0xd1dc1461, 0x1188cb3f, 0x1b3f767f, 0x6a82fc74, 0xf784d32e,
0x1e082f3a, 0x292018e4, 0x47ac1a3a, 0x4e6bd3cb, 0x7713cb7e,
0x8b841780, 0x78c2947c, 0xbebe69eb, 0xe500aa28, 0xa107836b,
0xd3246a17, 0x1c577c3e,  0xc346f4d, 0xb8a128cf, 0xa7b525ef,

/* 1580 to 1599 */
0x378de67b, 0x695f88f2, 0xa0848dbd, 0xf0ac9413, 0x8dc30abe,
0xc587e73f, 0x99ef4d6f, 0x43fa4497, 0x28859ce6, 0x6a41ec56,
0x2c6cfe1a, 0xdaf9a8d9, 0xf4cc284c, 0xfad0c858, 0x10f3a6fe,
0x3487020d, 0xdb481a4f, 0x910a6fa3, 0xfc3c3b4d, 0x9b13437f,

/* 1600 to 1619 */
0x47c7eca9, 0xd3a9f029, 0x2a1ae78b, 0x2dbf8fd1, 0xb9b7f445,
 0x7caa438,  0xf8f0d6b, 0xfe0b167d, 0x34542e81, 0x9199f5ea,
0x616339ec, 0x921cc9e4, 0xd7915b28, 0x817553cd,  0x2f28329,
0x4033e858, 0x19eadf9c, 0x1a5b0fb8, 0xa05fd60c, 0x6a9e99b0,

/* 1620 to 1639 */
0xea88b4a2, 0x92638fc4, 0x68180fe8, 0xe8184684, 0xbd6801dd,
0xbbe17b2a, 0x2513ab67, 0xac9b8ed8, 0xda129c24,  0x76632c4,
0xf3c28eb9, 0xc45a0f41,  0xada68d5, 0xf4bb14ce, 0xdc2da022,
0x7c61ad13, 0x7dadbe38, 0xd2461d64, 0xb1fcf338, 0xc901cc82,

/* 1640 to 1659 */
0x28c9a91b, 0xaa674e0f, 0x65df1fcd, 0x9fb8cf7f, 0xc935b5d4,
0x2626dd0b,  0xacef2bd, 0x954dd5ef, 0x34b36881, 0x95c2db24,
0x8611c04f, 0x80e8adc1, 0xf32f6f61, 0x1a978da7, 0x2fd540b8,
 0x66a06dd, 0x6f32fdf0, 0x61b52c54,  0x53ab016, 0x50c227d4,

/* 1660 to 1679 */
0x27e44d5f, 0xe4408d09, 0xbf6be9b1, 0xeecebd81, 0x3337e648,
0xbdc0a931, 0x789b30c2,  0xce52cd8, 0x58dda8fb,  0x58d1fce,
0xb7766afa, 0x725753e2, 0x7e77d170, 0x3197f997, 0x5e6f425d,
0x13d9da8a, 0x404873fc,  0x68dc082, 0x5778d4da, 0x393938f9,

/* 1680 to 1699 */
0xe33e7b4e, 0x1ce0f48d,  0x115a72d, 0x33077b52, 0x597f05fb,
0x1877e7bb, 0xf693d855, 0xa5c5004c, 0xf6f0fe6e,  0x1fd56b6,
0x60e2a6d0, 0x7318bcff, 0x4b270ab8,  0xbd5f4cf, 0x4bd9f0d2,
0xc8b71ff1, 0x9e37e93b, 0x6df66500, 0x2becdedb, 0x25af55c5,

/* 1700 to 1719 */
0x28fad421, 0xab20538e, 0xcc2a623f, 0x53be43bf, 0xb391c3f0,
0x9724ccfd, 0xe6c48d2e, 0xdc3fb1e6, 0xbf21e7f5, 0x5b03e740,
0x5e1abb78, 0x1b5fd086, 0xb9e20d0c, 0xbee19af8, 0x524f3614,
0x4d8213bd,   0xff2774, 0x6f1a0d77, 0xe38580e1, 0xc53e12cf,

/* 1720 to 1739 */
0x39312aba, 0x77fd6c4f, 0xbb646ac3, 0xc5ead671, 0x9974af67,
0x3d73d14f, 0x8ddc97fe, 0x1c07da78, 0x3f95d5b1,  0x724eb69,
0xa16fabfb, 0x8e86c11b, 0xcb5ebc94, 0x37e7fbe6, 0x9289ea49,
 0x5dbb887, 0x5f79faf9, 0x34d56b37, 0x32f90f72,  0x38f3153,

/* 1740 to 1759 */
0x54d55beb,  0xdbfea0b, 0x2b944e3a, 0xedbb78b2, 0x1e27b19c,
0x27707ef6, 0x4d58da1e, 0xb649a0d4, 0xe4fdb215, 0x7ba63f17,
0xcdbf3224, 0xad52e219, 0xe20e6e09, 0x71cc06f3, 0x19068c4b,
0x7187d979, 0xae02eb26, 0x84768c9c, 0xc82532e8, 0x4e566323,

/* 1760 to 1779 */
0x39b49a3d, 0x2f0bfd6c, 0xfe1649e9, 0x444b6026, 0x2a6489be,
0xfdcc0302, 0x6be60b31, 0xd62b0947, 0xdcca0d93, 0xbc1407c6,
0x8df81a05, 0x254332f3, 0x86a36aae, 0xebef9ea7, 0x931e3557,
0xb747d590,  0x25e63e3, 0xf4421fcb, 0x6043d2ff, 0x6458033c,

/* 1780 to 1799 */
0xf721dfb9, 0xacbae2d3, 0x38049b3f, 0x16b31d9d, 0xeaf7b630,
0x7f57a17b, 0xd4e59741, 0x91d283c2, 0x9c6f6861, 0xadd2ce7c,
0xd02c08a7, 0x28245403, 0x9f2f8698, 0x117215fd, 0x9b0e4025,
0x2aba8422, 0x6155f824, 0xe6c4d2f2, 0xf0cfdf69, 0x4ddfe0ec,

/* 1800 to 1819 */
 0xf5728a2, 0xb02a9069,  0x92e461a, 0xfa203381, 0x9f9c005f,
0x998e3078, 0x9119c424, 0xa285d658, 0x596bba2c, 0x29e2a536,
0x3a8ba83f, 0xc7326cf6, 0x574553eb, 0x27ce79ea, 0x83843991,
0x2a90dcd1, 0xa3472488, 0xe6f8eaa3, 0x3841ae52, 0xff565600,

/* 1820 to 1839 */
0x18ab6f1d, 0x3a14dc23, 0xf21d808f, 0x4dcfb595, 0x2de4647f,
0xb510f8c1, 0x2e629894, 0x8cc2cd33, 0x41e399fb, 0x9fe40228,
0xb0d88103, 0x5c8606b9, 0x599957c2, 0xf1148660,  0xae58a6b,
0xc15a5e7d, 0xdad28346, 0xefd3ba4b, 0x5abc2c6a, 0xda78c6c2,

/* 1840 to 1859 */
0xff1f8d84, 0x14a7b0e6, 0x97f682ab, 0x8e075840,  0xaa87aa8,
0x18b48474, 0xa3fe9d28, 0xf543e571, 0xfff9bdac, 0x6d3a7722,
0x6791b078, 0xdb808718, 0xab052dee, 0x56691741, 0x2a8d0b0a,
0x43438c80, 0xd46ac0ba, 0xbc620724, 0x4733e01f, 0x80486eba,

/* 1860 to 1879 */
0x26199b61, 0x3d909dbb, 0xf53db44b, 0xc82101c4, 0xc0baaae0,
0xdf933f45, 0xa56e525b, 0xa6aafc60, 0xe2dfb33f, 0x93f53c16,
0x2aa1ba59, 0x8b009335, 0x75df6944, 0xd8b09f90, 0x942f817f,
0xc493e572, 0x7e94c293, 0x2d6e0315, 0xeb7731b4, 0xdea3be2b,

/* 1880 to 1899 */
 0xbab9774, 0x5906f382, 0xa3b8bf37, 0xae8fa3fe, 0x33186c5f,
0xb16a6527, 0xd7381e8a, 0x1b616ac9, 0x41793c18, 0x7f61c3ac,
0x72e685b4, 0x978bb514, 0xa2271393, 0x34e41f97, 0xe291b384,
0xa16b138c,  0xe5d3e89, 0xa5adfd1c, 0x15b3644f, 0x50dd6a96,

/* 1900 to 1919 */
0x5568cf18, 0xd1644d68, 0x6ea0c2f0, 0xc56d9b45, 0x2dbd37c3,
0x948bb383, 0x7f2997e5, 0x7e73c1fa, 0xa9f64cda, 0x99e51801,
0x75a64b69, 0xc8cc0405, 0x12070ccb, 0x5108f606, 0x21f95d3b,
0x4965af93, 0x4d230924, 0x75113ed7, 0xe772096d, 0x8fad0b5e,

/* 1920 to 1939 */
0xc66708b6,  0x98e5219, 0x19cadb04, 0x6ae93f71, 0xded5acf2,
0xb94ca97f, 0x3718c1cc, 0x9d18b531, 0x9020c184, 0x578c23ec,
0x2d6fb003, 0x4ec4e32f, 0xd4022027, 0x69c21c76, 0xd2966ccc,
 0x4ee7ae9, 0x21242780, 0x11bfe2ca,  0x6ec50d2,  0x44dbe8a,

/* 1940 to 1959 */
0xe56a7367, 0x4527f2fc, 0x2bd2f460, 0x63cf9f25, 0x6e7b08a3,
0xc869de88, 0x1ecfa5ec, 0xf1ca151e, 0x285803a2, 0x416d6ce7,
0xde8effef, 0xcc0cd34d, 0x9bfd4ea5, 0x39aba120, 0xa3cc86a3,
0x8aed8f7a, 0x28eab6f5, 0x9d3847dd, 0x1e5d2bb8, 0xf3b38c79,

/* 1960 to 1979 */
0x9b903586, 0x36ac69d3, 0xe7694497, 0x84c85956, 0xbee6c242,
0x5a218965, 0x70c89066, 0xbafb8249, 0x7c350b33,  0x3d4afb0,
0x4be2dbc2,  0x7ece4bc, 0x6cecebd0, 0x32983723, 0xfebb7919,
0x1b1979ad, 0x23e4d3fa, 0xd21cd131, 0x51a79cda, 0x1d345d90,

/* 1980 to 1999 */
0x94d4ea96, 0xe6a188ea, 0x79e1924b, 0xe25d0bac, 0x95009b4f,
0x69bb4f83, 0xa2f1a5f4, 0xe1ab05e6, 0xdd77872b, 0x74667101,
0xd6e6f735, 0x9b1df847, 0x78be10c4,  0xc617f9f, 0x99843f75,
0x1f7cf95b, 0xed156e24, 0x993eaa98, 0x285f86cc, 0x111ba4b5,

/* 2000 to 2019 */
0x4965b04f, 0x92e7a6c5, 0xbf34a3ab, 0xda499917, 0x5954fd66,
0x9eaeb94f, 0x1f18f247, 0x1ce6799c, 0x340335c7, 0xf0dc0d76,
0xee736f49, 0x496861f4, 0xbc844ab2, 0xe6c57eaa, 0xa7676160,
0xafb1b63f, 0x458363ec, 0xa1bb1c7f, 0x4cea03fb, 0x3070011e,

/* 2020 to 2039 */
 0xb1aab13, 0x63513939, 0x7cfa262a, 0x8d051fd3, 0x46966b13,
0x2955a47b, 0xf394519d,  0xb764d58, 0xe54a4543, 0x814b6596,
0x29080213, 0xaeab3bc2, 0xd2449422, 0xafa41d20, 0x88ca811d,
0xd02922b0, 0x3a5503b1, 0x74e8f1c6, 0xec2d2b71, 0x32bf031e,

/* 2040 to 2059 */
0x90ff0936, 0x7b0e3dc8, 0x5acd4ab2, 0x3ff6aa8b,  0x79bd847,
0xaf5cb9c5, 0xfd1ae0da, 0x49563db9, 0xb5fb9c8b, 0x9d290aea,
0x627c669c, 0xf30260ba, 0x9cb6cfdd, 0x9d169d8a, 0xb8e8167a,
0xf2d3a27a, 0x80469ced, 0xf43656e9, 0x358e9f74, 0x2b959b2a,

/* 2060 to 2079 */
0xa35c5998, 0xa704516f, 0x24e3b1fd, 0xfef64bea, 0x47c1deb1,
0x6ef846ee, 0xf4182ff8, 0x4f870a7e, 0xa459a2b0, 0x783dc9d6,
0xcad2def7, 0xa85fc922, 0x29d6c70f, 0xa86c510a, 0xb3865b49,
0xb607031c, 0x9a164650, 0xe3072b1f, 0x1a9ee8be,  0x51ba275,

/* 2080 to 2099 */
0x61e786d0, 0x59aa2b44, 0x198f601a, 0xc175b1d7, 0xe3386d6f,
 0xc81b0b9, 0x11523e06, 0x8decf592, 0xf5b108a0, 0x2b5df1f2,
0xb643be69, 0x7da4b126, 0x5f4fe870, 0x9dc0cc4f, 0xf48e5e89,
0xd4d010c7, 0xd9fa33b4, 0x2b991180, 0x4150b16e, 0xf8f035c1,

/* 2100 to 2119 */
0x509b539a, 0xd46304fc,  0x4af2af3, 0xbeca81ff, 0x5b77fc59,
0x3c2f50f7, 0x7b2d04e5, 0xa1ec30bc, 0xec3c4d8a, 0x1a7f2e00,
0x49e63c9d, 0x58888509, 0x828542fe, 0x66a4b898,  0x2211418,
0xc235098b, 0x90850891, 0xb28f7744, 0x67ef0dc8,  0x65c98ed,

/* 2120 to 2139 */
0xb9616e5c, 0xfdf62563, 0xf83a702e,  0x82b3997, 0x603ff807,
0x31e770ce, 0xd8fe398e,    0x5d788, 0x4a45ed8b, 0xdb180af5,
0x49eb008f, 0x8792b341, 0x98e02ee2, 0xb1a7169e, 0x4b096bff,
0xe90f86f0, 0x57014221, 0x8431a5dd, 0x9ad0e896, 0x8c0cf203,

/* 2140 to 2159 */
0xe994a028,  0x426ea50, 0x9cfa7d68, 0x40f2939e, 0xedc31066,
0x4c015bfe, 0xa07840b2, 0xae862280, 0x35ed3e19, 0xe619e942,
0x1b88e29e, 0x3239831c, 0xa754454f, 0x852ae8c9, 0x8199c01a,
0x5faecf35, 0xcaa6125e, 0xa82d3613, 0x2dc6dfba, 0x3feda218,

/* 2160 to 2179 */
0x10252664, 0x966892fd, 0x81a793d0, 0x41df0ca7, 0x815fda29,
0x563ef890, 0x9a4e3d01, 0x6fa25aa6, 0x7ce3fbe0, 0x1df9f81c,
0x1726db98, 0x810452ee, 0xc28e7c4b, 0x79dcf13f, 0xd14db421,
0x52bbc824, 0x47d15a47, 0x497ed440, 0x54f2332d, 0x3a28b827,

/* 2180 to 2199 */
0x290acc7b, 0xbeca2dd7, 0xb77b8098, 0xf01dba50,  0x55fc6a5,
0x2c9b6934, 0x19398180, 0x36afc663, 0xadc93edc, 0x3f1597ff,
0xeb733f85, 0x1c928a3f,  0x7c2689b, 0x8f9b5a3e,  0x760abde,
0xacdab459, 0x8e8783cd, 0x49fbea47, 0x443ce163, 0x9efa5455,

/* 2200 to 2219 */
0x47b9ac78, 0xaa53a080, 0x31f620bf, 0xce83273e, 0x8243256e,
0x57f92d62, 0x221ec21f, 0x6993bd2f, 0x97bba603, 0xd26c5b3a,
0xc4295219, 0xd3b0d511, 0x57f09423, 0xc4436c43, 0xf596cd7a,
0xf3a8afb9, 0x2193d02f, 0xde7140f3, 0x53eb9d34, 0xd0dbcbe3,

/* 2220 to 2239 */
0xcd890d9c, 0xfab7f8aa, 0x404a83da, 0xc179f8bd, 0x7a1f72ba,
0x10182158, 0xcdc3e841, 0xe5f3a793, 0xbd95ce37, 0x1f1cc405,
0x8002e826, 0xdafc8440, 0x9fa308e1, 0x37ab45d4, 0x929333c3,
0x773a963e, 0x6504430c, 0x5e3af51d, 0x6fc6c9e8, 0x6b9a6a48,

/* 2240 to 2259 */
0xf0974d6a, 0xcf7dc8b0, 0x586f094e,  0xcce08df,  0xf747bb3,
0xa43507e5, 0x5ab4072c, 0xa97927f5, 0xa5770313, 0x1647580a,
0x689b1dbb, 0x7e1e398a, 0x9f4e600f, 0xaa58446c, 0x838852d9,
0xdfb6accf, 0x587daa01, 0x99788265, 0x9ea84c50, 0x4dfb3a39,

/* 2260 to 2279 */
 0x1a0bbd3, 0x256c1084, 0xa49dfa9a, 0x979a562b, 0x7323d41d,
0x2034e6fe, 0x5f8a0ff3, 0xb7998d74, 0x5b57d26b, 0x2c6f30c8,
 0x3138ad8, 0x232a1eda, 0x9854eb83, 0x8e5b6c24, 0xf005da3b,
0x7c31fa99, 0xaaddfae2, 0x1b1d6f25, 0xda9bb8fd, 0x867c472b,

/* 2280 to 2299 */
0x79e3f333, 0x46d79080,  0x9429309, 0x982af567, 0xfbcbe0f2,
 0x36a0d1d, 0x7550192e, 0x2fe517c7, 0x71d515e0, 0x579d320b,
0xf4cf0092, 0x331f2733, 0x66ee8b04, 0xa5c5d4e2, 0x945bb8a0,
0xfd8a942c, 0x55c7660d, 0x5621425e,  0x31aac10, 0xd00eba20,

/* 2300 to 2319 */
0x696c3185, 0x3518a534, 0x265287c9, 0xac1ce835, 0xcb4a00ba,
0xfdd595f6, 0x2f094ea7, 0x18489d4c, 0xade087d4, 0x3a7392cd,
0xa4c14c75, 0x60573ee8, 0x9a05ae0b, 0x4ea76aa6, 0x956a25f7,
0xb4bfc539, 0xf6529128, 0x26106e1c, 0xf3bb11b2, 0x39aa1cbc,

/* 2320 to 2339 */
0xdaee3576, 0x1809631a, 0xc265b3fa, 0x9f1ad1bf, 0xcd5eda7c,
0xf01af90f,  0xd617ae3, 0x2c362b7d, 0xa4328377, 0x83cb6f93,
0xbb72a359, 0xd5eaacd2, 0xd18fa564, 0xeeddd8b3, 0xd079c5a9,
0xb0a3d5c7, 0xd586bb5c, 0xf91c79bb, 0x8db0da13, 0xadbb9452,

/* 2340 to 2359 */
 0x3b82b66, 0xde621d75, 0xeca02827, 0x57282e7c, 0x7f396d5c,
0x6660d7e0, 0xe565003d, 0xae76f003, 0xd06b7285, 0xa5942d2d,
0xfdbbeee9, 0x49feb5b4, 0xe8c2e343, 0xa3e93b6f, 0xdc74b03a,
0xdd4581a2, 0xa3658ab7, 0x4de0bc06, 0xdf00d7c4, 0xb90e6094,

/* 2360 to 2379 */
0x56aa9fad,  0xcaea5c7, 0xd0fe3c60, 0xbc357e85, 0xe7cd2c14,
0x979bbc5e, 0x8e6465f4, 0xb7799f6a, 0x4e7a328f, 0xf168741a,
 0xfd6b7dc, 0xbfb0e69b, 0xb0ccdd61, 0xe11152ed, 0x4f46ce0b,
0x90dec221, 0x2b281ea8, 0x842b2318, 0x973a4101, 0x8e3b2c75,

/* 2380 to 2399 */
0xe42d776c, 0x4efdc755, 0x77ee0cb2, 0xa55c2f2d, 0x224f3ca8,
0x850353d9,  0xa2ce80c, 0xaa7de473, 0xaa8956d5, 0xd40d04ff,
0x3405b32b, 0x229a86c4, 0x4bb03c8b, 0xf17b212f, 0x667e996f,
0xf28551d0, 0x3b4a2f8b, 0x7a987c86, 0xc741dc48, 0x538d4974,

/* 2400 to 2419 */
0x8ad32e0b, 0x822c2738, 0x38e49dd8, 0x818fb475, 0xf5f6ec52,
0xb861eee0, 0x86efd5cf,  0x3963a38, 0xa4828f8e, 0x6b14f27f,
0xaf3d6de1, 0x47c334db, 0xf78763e7, 0xa2a90aac, 0x487e8df5,
0xd2402a90, 0x3788e5bb, 0x8941e15c, 0xb7e83e0b, 0x74660d6b,

/* 2420 to 2439 */
 0x3bc4903, 0x52a8b1a3, 0xf973f6eb, 0x60449ab7, 0xc32db4d4,
0x993d9a8a, 0x14a413a4, 0xfe271229, 0xf9e781e4, 0xcd8d8fa3,
0x1598c578, 0x728fe608, 0x89756275, 0x8b24a15a, 0x6505112d,
0xf14c2fc2, 0xe24a33b7, 0x2bd22a15, 0xdf2deadf, 0xbd159a2b,

/* 2440 to 2459 */
0x7fb9de49, 0xa8075fb5, 0x99d1b44e, 0x1c92627c,  0x4bb4b2c,
0x54b128c5, 0x67cdf143, 0x44400b9c, 0xa044379f, 0x79513bb4,
0x46e0b3b5, 0xc3c2db5f, 0x2d6d4514, 0x754b9d03, 0xacda433c,
 0x1f6ca51, 0x95626cc7, 0x33150b4a, 0xaa2705b3, 0x6454067c,

/* 2460 to 2479 */
0x367ef5a0, 0x75b1ac18, 0xaf95b764, 0xa8b23b1b, 0x5c517176,
0xe3c09b33, 0xbf0e8a38,  0xd9348c7, 0x96efa5a8, 0xf2071df9,
0xf3381e19, 0x46ed94e7, 0xd2d13fd5, 0x4df49d5c, 0x22964a84,
0xb8545b8c, 0x5fba89f7, 0x22ec144b, 0xd8f295a7, 0xfcd74042,

/* 2480 to 2499 */
0x9941d3e9, 0xf9ef6e1c, 0x160c440a, 0xf0cd4673, 0x9586c1e9,
0x4164d3eb, 0x3731645f, 0x3d9cf7ab, 0xb2877713, 0x3f4ea4c8,
 0xb851bb0, 0x5f7592b7, 0xd1ab32c8, 0x859f948d, 0x7196d245,
0xec8a3c84, 0x3e8e9484,  0x8c367cc, 0x804ef8c4, 0x5f4162f8,

/* 2500 to 2519 */
0x2392497a, 0xe443357c, 0xf9b5b7db, 0xbd9c3fe6, 0x2dbc1f7c,
0x4f73c4e9, 0xce0f9bda, 0x19cc91a3, 0xcda305dc, 0x1062b3fc,
0xab6c9773, 0x7ea91954, 0xfe043982, 0xba7c29e6, 0xd2fe524b,
0x533308cb, 0x8722f888, 0x976961aa, 0xa2c1512b, 0xf4a0397f,

/* 2520 to 2539 */
0x1756625b, 0xbc614507, 0x9dda24c7,  0x8717a94, 0x53f3949d,
0xd6b2247c, 0xc823e9da, 0x6bfac73d,  0x581ec85, 0x72fab586,
0x36f92af9, 0x4012a50d, 0xddbd83af, 0x552713a0, 0x5c7add8f,
0xfc86cf69, 0xce7add33, 0x20b897d6, 0x23a28adc, 0x8c0811c5,

/* 2540 to 2559 */
0xec83bb33, 0x67c0f1da, 0x2e561605, 0xd3c09463, 0xfd9efef7,
0x127a13a4, 0x2d53a9bb, 0xbdb11564,  0xe147796, 0xc0ac0422,
0x8e1dd3f8, 0x4f91c00a, 0xbcbf846f, 0x4d5ace1a, 0x45d65e0f,
 0xe332d55, 0x9997e74e, 0x6d5881bc, 0xc6228d70, 0xe7471d0f,

/* 2560 to 2579 */
0x94d0fbba, 0x50eea31c, 0x412d610d, 0x954e6e38, 0x8d7c3eed,
 0x7b38ed8, 0xc5430b24, 0x41bcb9fa, 0x30a75af6,  0x6bd27bf,
 0x6e85794, 0x134f5821, 0x6a2a0966, 0x7205299b, 0xa2217477,
0xac3b6c7c, 0x84fd968a, 0x86f4816f, 0x8af3c722, 0x71e01ede,

/* 2580 to 2599 */
0x5e6f372f, 0x1c584087, 0xd526b579, 0xcdaff6f2, 0x72950527,
0x3162c490, 0xcfbd89dd, 0x64fbd8ed, 0x2ac3a74b, 0x232538b6,
0x6e59114f, 0x4a5eb787, 0x1a8bec63, 0x670bce31, 0xaab2a0d5,
0xe3f351d4, 0x47155e17, 0x77bee3d4, 0xc512da3b, 0x2e972775,

/* 2600 to 2619 */
0x8d04fc58, 0x7c09b2ed, 0x8282bceb, 0x3f2ec26f, 0xf176396e,
0x92238d2b, 0x168e97e9, 0x5531d010, 0x2c81f969, 0x3bcf9f42,
0x1d990ce7,  0xf25b279, 0xc6762b31,  0xfa91c99, 0xcd6bd046,
0x986ca6eb, 0xabaebebb, 0x4181991b, 0x684cf0b3, 0x2abeb6a3,

/* 2620 to 2639 */
0x437bb7ca, 0x10908aaf, 0x2d199107, 0xd66fbfd2, 0xcc7c56b9,
0x2ebd98c4, 0x4127d6a9, 0xd17169dc, 0xdc6b0428, 0x99c58d26,
0x3704736c, 0x32926eef, 0x9808e29e, 0x8e09ed7b, 0x46b40333,
0xee954360, 0xb84c4b66, 0xd07b7601, 0xe07fa201, 0xfa93f73a,

/* 2640 to 2659 */
0x483ed3ae, 0x52ac73d8, 0xee5e3daa, 0x2207538f, 0x1969f21a,
0x7e3dce8d, 0x5f2a027c,   0xa5acd5, 0x72fa79aa, 0x977b56a9,
0xddae114d, 0x2a91fb27, 0xc7eb7082, 0xa64426ac, 0xf71748ef,
0xb0e658df, 0x9da260b8, 0x6faa7d46,  0x210255f, 0x4446cbf9,

/* 2660 to 2679 */
0xf9c2017b, 0x804c55d3, 0xa1b925c9, 0x16859a00, 0x625f8a04,
0x4222d148, 0x2efa5fdf, 0xf717abb4, 0xee09bacc, 0xa06cbc50,
0x6381a0f1, 0x5fcd4a92, 0xe4100abc, 0x5b3be702, 0x4469e599,
0xa26b1784, 0x7cad0205, 0x68a9409f, 0xeb6cfc81, 0x2d4b7af9,

/* 2680 to 2699 */
0x8cfc65b5,   0x9d9bee, 0xaf141ecd, 0x846777fc, 0x30b1854d,
0x2b53e3e9, 0x7d5a9d76, 0x6e0a7abe, 0x6c6baf2f, 0xd1738256,
0x24c8fdac,  0xf9ae37c, 0x7641483d, 0x5ab25077, 0xc334e600,
0xfe137c34, 0xa8a12f51, 0x217172bd, 0x9963e682, 0xf1389b11,

/* 2700 to 2719 */
0x59340c87, 0x33679168, 0xc54493e9, 0xf47bde7c, 0x92045156,
0x5953b1a1, 0xfc6dd99c, 0xec9dacda, 0x880c2a40, 0x51626ffe,
0xbf19325d, 0x20e7a39d, 0x465fa2ae, 0xe4099d35, 0x43507401,
0xbc8059f6, 0x9983e974, 0x55d01791, 0xcd3a2864, 0x73051447,

/* 2720 to 2739 */
0x52fe89f0, 0x717147f5, 0xfe75a06a, 0xe50e5097, 0x6ce66a4e,
0xb68ac85b, 0xd4facb8d, 0x82888de3, 0x81d8b24a, 0xba63933c,
0x2021e9be,  0x4262a08,  0x421e571, 0x4c39e5c3, 0xb0b77b28,
0xc2837531, 0x4f52ead2, 0x125e4558, 0x74dab350, 0x35df5a13,

/* 2740 to 2759 */
0x89c54d05, 0x5ad41d3e, 0x249f4e5f, 0x10a06fc4, 0xef277c8d,
0x7c574b7d, 0x110dbb23, 0x35937056, 0x2057b02a, 0xfcb4a32e,
0x30f27f95, 0x948bff1c, 0x94111651, 0x7cc0cc94,  0xfdce6a4,
0x8b156849, 0xe26ef857,  0x8d4f75d, 0x37b8b34c, 0x94be5bdd,

/* 2760 to 2779 */
 0xe133286, 0xb256591b, 0x6fb18d10, 0xcdba95ee, 0x7ec3c63a,
0x263ea891, 0x5678dfd5, 0xabaa00bd, 0x18f7df97, 0xf90361f3,
0x4c4e346d, 0x84621fc0, 0x460ebf3d, 0x94fb74d0, 0xd65ace59,
0x4aaae80e, 0x8e9511ee, 0x88744a61,  0x11062a7, 0x7349ef89,

/* 2780 to 2799 */
0xfd131e87, 0xb79a60e5, 0xe7b36ce3, 0x92cdf95b, 0x889a907e,
0x77e2cf64, 0x6a803a56, 0xe14b1d1c, 0x188a78c8, 0xafa056ab,
0x88bba4ef, 0xe7264e1c, 0xcade61d7, 0xa3f63d1f, 0x5d052a50,
0xceced681, 0x8925a07d, 0x575a8f1b, 0xa1eb9804, 0x88dd0b75,

/* 2800 to 2819 */
0xbaafb3e4, 0xefb8c0db, 0x6518ddb3, 0x12ebd050, 0x18e6c986,
0x533bdda9, 0xb7cd7d9e, 0xa4ca498d, 0x12908045, 0x3a68956e,
0x2c991fab, 0x2944f95d, 0x5aa6fe53, 0xdc4cde68, 0x6ab22513,
0xbb97a48d, 0x4998f704, 0x573db149, 0xf4d850a1, 0xd1ccacd4,

/* 2820 to 2839 */
0x98e7cb73, 0x7083baaa, 0x4999b713, 0x8a4aa6c1, 0x287838bd,
0x5b75a43a, 0xf9f8fad8, 0xeb775fb5, 0x3cf49245, 0x52a141d7,
0x5b978840, 0xf8a0a7fa, 0xe38f48c7, 0xda2b54c7, 0xdaa54b84,
0x125222e3, 0x21e27aba, 0x71fadb99, 0x323c4def, 0xc54c0b62,

/* 2840 to 2859 */
0x994f14c6, 0x43b576b9, 0xacb5076c, 0x4168d44a, 0x9665f5dc,
0x2fa68cf1, 0x7b7061c1,  0xd2ca072, 0xacaf6a89, 0x4356f673,
0x7de82b6c, 0x8e37794f, 0xa044be66, 0xd88b2889, 0xef04387c,
0x14848d56, 0xbfd6f239, 0x6dcf0058, 0x928494a7, 0x11d71872,

/* 2860 to 2879 */
0xa32d8da4, 0xf730dcbf, 0xffb9eba5, 0xdba68a60, 0x4c015b28,
0x495771d2, 0xf2fdbf9d, 0xac2b4b53, 0x2791e45b, 0x7371e66f,
0xfe1fc044, 0x7d3a18a2, 0x7fb5a0af, 0x8bc4cfb9, 0x9ad9bced,
0xdc156432, 0x81836dc0, 0xdbf1b41e, 0x7cbb9bdd, 0x111d3275,

/* 2880 to 2899 */
0x53d1baac, 0x379704b2,  0xa30c3b9, 0xe3cda098, 0x5719e11a,
0x7c56f065, 0xa9cf2a72, 0x1b33bf10, 0xc6a5c988, 0x76180ce4,
0x4be04c4b, 0x56a783ce, 0x24be0f95, 0xaea3cac7, 0xe28d80c0,
0xa2fbeb72, 0x392456e1, 0xe508844e, 0xe8b236fe,   0xa684a5,

/* 2900 to 2919 */
0xf9f48504, 0xecda740f, 0x87a336d8, 0x57f71164, 0xb20fdb5c,
0xd69ea544, 0x8b537e27, 0x51ab962e, 0x2f41752a, 0x2213d23f,
0x528d66eb, 0xc60ee7fd, 0xc7791006, 0xeeced4f4, 0x53c7e043,
0xd219c58d, 0xc2c90b18, 0x3a3b3c7d, 0x6dac59c8, 0x2e47dd81,

/* 2920 to 2939 */
0x266f5b9f, 0xa9be9d65, 0x6b74cb30, 0xfbacdf00, 0x7a626df6,
0x29e2db98,  0x9ca5992,  0x520dd22, 0x512fbb45, 0xbff97e9c,
0xabf58fbe, 0xafba0136, 0xd92320e2, 0x8cd4f13b, 0x392fab0e,
0xe44bd41e, 0x4ccf720c, 0x60bac5a6, 0x7f137a03, 0xe9fd34f5,

/* 2940 to 2959 */
 0x4339a12, 0xbb6a7767, 0x9e5fbfd6, 0x50c42e34, 0xd015a37b,
0x6793df51, 0x939c640f, 0xaadf9990, 0x1ef1fae9,  0x3b3a475,
0x5c81e813, 0x8232c1bd, 0x26210eb3, 0xa97e0b46, 0x1bb62f29,
0x6ce0ecee, 0x8ed20c4b, 0x8a040e21, 0xdb8c0628, 0x7ee3aad6,

/* 2960 to 2979 */
0x79856bdf, 0x50771b72, 0x5f70bdf8, 0x596c3772,  0xbd8c0e0,
0x15928271, 0xe3f9c9cf, 0x1614b1b5, 0xcb513f4d, 0x6be292e3,
0xd524cef9, 0x6cc07a79, 0xe13f010b, 0xa7a675ee, 0xd7300430,
0xc3b3551a, 0x31960cc8,  0x83f2381, 0x6a14fb92, 0x36dd815d,

/* 2980 to 2999 */
0x5b3218cf, 0x12214e92, 0xec64f0c8, 0xcbaf0929, 0x3040c171,
0x8eb9c669, 0x53656f16, 0x89daf499, 0x75cd75aa, 0x4653667b,
0x53b3f9f4, 0x5ab35abc,  0x7fc9a9d,  0xc34e50a, 0x2891ec45,
0x186f1671, 0x270fe0b6, 0xbab85984, 0x7c03368b, 0xc0bac714,

/* 3000 to 3019 */
0xb4936d87, 0xbac66877, 0x345ad472, 0x6ca07668, 0x7a996a20,
0x4e7c1394, 0xc10cf56b, 0x4a92afe4, 0x972498cf, 0x151aeec7,
0xcf4c6bb5, 0x2f5d4a22, 0xc8c3d8d3,  0x77d9a0e, 0x34b1abf6,
0x9d4a0117,  0x50ccd2e, 0xe1d78acc, 0x383a68cf, 0x31e500eb,

/* 3020 to 3039 */
0x892a8aab, 0xac714919, 0x69fc9ec6, 0x90b942ca, 0xbbb1662b,
0xbb3b3173, 0x62fa0958, 0x43d31403, 0x7aa83fc7, 0x6c0b7b70,
0x80498b88, 0x71726065, 0x1ac192e5, 0x9a143a8d, 0x7336093b,
0x686729c2, 0x92b4c213, 0x5680492e, 0xf91644cf, 0x18dd5805,

/* 3040 to 3059 */
0x8590e777, 0xb03c9c29, 0xd0485149,  0xff3aea4,  0x65b9d2f,
0x26df819d, 0x84f1bceb, 0x452852b6, 0xd16fddee, 0xfdabbb83,
0x7faced08, 0x1a0f8285, 0xff9ce5a3, 0x3e2a3164, 0xb7f51cdf,
 0x9d6e27c, 0x9300db66, 0x7cf93d4d, 0x1e6db878, 0xa9ba7dd8,

/* 3060 to 3079 */
0xa3b3c6f0, 0x5172edab, 0xcdad5484,  0x48a6029, 0xa8333591,
0x8e245678, 0xd99a313d, 0xd4a77989, 0x680b8e53, 0xdb61e9e7,
0x47618b05,  0x2045505, 0xed3f5e24, 0x901b4ea2, 0xea6ac6e4,
0x821c18c6, 0x73c13b4e, 0xfffe75e5, 0xbd8553ea, 0x807375bb,

/* 3080 to 3099 */
0xf89d4aad, 0x1eb28c80,  0xf6d6432, 0xdc2f388f, 0x768f521b,
0x5d34776a, 0xceada60d, 0x594743ec, 0x34d869ee, 0x37abe65d,
0x1ca71829, 0x5e8850fd, 0x5cd5c964, 0x28f2b964, 0x88446820,
  0x90111a, 0x2df1dcc3, 0x94221a1e, 0xd9d37eb2, 0x32299794,

/* 3100 to 3119 */
0xf700240e, 0x89edc3e7, 0xa3d947b2, 0xa753791a, 0x34097ca3,
0x87044279, 0x77a6f74c, 0xbfb95f3e, 0xd479b982,  0xd2e5a45,
0x29a78d26, 0xf8d48f06, 0xdda3f764, 0x845a038d, 0x3206d87a,
0xb33e312a, 0x67d2d654, 0xec600afe, 0x14176a08, 0x458174c2,

/* 3120 to 3139 */
0xe6a94e2c,  0xc634bdd, 0x29ea4877, 0x967a5007, 0x69917e33,
0x7bd94492, 0x4b46e82d, 0xba1083ff, 0x643aeb02, 0xc4605721,
0x52432b82, 0x65a2f4e1, 0x3e64db7f, 0xc8883418, 0xf0a21f48,
0xdd93e0cf, 0x6ddabd50, 0xc049d5de, 0xad3321d0, 0xdc206cd8,

/* 3140 to 3159 */
0x1d9a3f07, 0x18ca9b79, 0xec5f6bf8, 0x6dc62c20, 0xa14b9e2c,
0xc9b909e7, 0xaad8b299, 0x8d73d735, 0xfbcf2ebb, 0xce533864,
0x8309c575, 0xee8e8c76, 0xb0b6870f, 0xe5180711, 0xa53a2183,
0xdd6bb1fc, 0x8140f5b1, 0x3ed08861, 0xc61b4bb6,  0x88f251e,

/* 3160 to 3179 */
0x8cc1518f, 0x74c0aa96, 0x29390d7e, 0x590bbe14, 0x6dad8b5f,
0xb5338799, 0x5da6c969, 0x53bc4c6f, 0x8d4c7da4, 0xc50d545e,
0x1b6af625, 0xcc369cea, 0xcce7e637, 0xb1a6039d, 0x6a70de99,
0xf9f4fccb, 0x6be45a97, 0x3d448075, 0xee9f4647, 0xbf5b7aae,

/* 3180 to 3199 */
0x5494ad4d, 0xf8e75a2d, 0xdc5495e7, 0xb158eca1, 0xc8042ed5,
0x90c6172b, 0x97f69c69, 0x531766c8, 0xf0e5a395, 0x97d72f7e,
0x38dbef7f, 0xf4647828, 0xc39671b1, 0x9d0565f0, 0x2f4db482,
0x7e393549, 0x754febde, 0x33a78339, 0x58835f5b, 0xba63781c,

/* 3200 to 3219 */
0x60b126b5, 0x253ae3da, 0x635c8a6f, 0xb472b932, 0x3b431b94,
0xe0edb989,  0xb5d3b96, 0x9d65dd0d, 0x2e055108, 0xf55f207d,
0xe62e55b5, 0xd7ed48d9, 0x2138f669,   0x78fc02, 0x4b9ec88f,
0x197a4bdb, 0xfced1186, 0x3eeb3baf,  0x3a60172, 0xbab93482,

/* 3220 to 3239 */
0xc7699f40, 0x5560c3ad, 0x9c130dda, 0x14869cc5,   0x49f410,
0x6db3edab, 0x96a52c58, 0x3f0ef6b9, 0x962518ea, 0x495e1b5a,
0x6ded16ed, 0x404bb743, 0xab6cc4a8, 0xaa8abb56, 0xd2f5937b,
0x522c3d72, 0x36023935, 0x55305a57, 0xc2c25745, 0x735d36aa,

/* 3240 to 3259 */
0x8bc776a0, 0xe4d4d879, 0xd262d6f0, 0x2bbdb192, 0xea3573e6,
0xacbbaf56, 0x9ee95a6e, 0x8b14f29b, 0xeeca0a5a, 0xff0ef789,
0x3c1543e4, 0xd4eeb580, 0xa913517f, 0x58228445, 0x6b3b5d0d,
0xb651cd79, 0xe5ac9a56, 0xaa5f114a, 0xf0654fcd, 0xffec2179,

/* 3260 to 3279 */
0x600e77c1, 0xbe2e86b7, 0xf6dd8183, 0x83c04dca, 0xff59aa42,
0x7d8392ac, 0x76a468f2, 0x5ca993c8, 0x251b2b8f, 0x27092dde,
0x188eec32, 0x23a58a7c, 0xd3217d78, 0xd343b653, 0x3eaeed81,
0x41c55f1d, 0x5c692c4f, 0x69428da5, 0xddd834f9, 0x3de86dc1,

/* 3280 to 3299 */
0x9b9820c5, 0xa60fae9e, 0x7cfe70bb, 0x85dfb352, 0x10e4c23e,
0xa866d830, 0xab708c40, 0x637e8e71, 0xb12f0e2e, 0x3024e881,
0xea175f48, 0xacaa30e5, 0x40bc3b76, 0x819f48ec, 0x34608849,
0x6200329d, 0x7bf0c40f, 0x7a5e0cba, 0x64a20737, 0x8785bce1,

/* 3300 to 3319 */
0x64e804e6, 0x86540c58, 0x13486bf6, 0xef0d6d4c, 0x6d354801,
0x89ecbb3e, 0x5d1ddd43, 0x551584b8, 0xc038af4e, 0x8deff124,
0x4b005e6e, 0x79e7cbcd, 0x6a1dd7ea, 0xa25f9494, 0x6c1e5668,
0x6b038bf9, 0x2636f5ce, 0x778decc0, 0xc685c461, 0xc721737c,

/* 3320 to 3339 */
0x7b490cf5, 0x833ff3e2, 0x82d9e6d8, 0x300a43c4, 0x2ca30d17,
0x571a9387, 0x79b9bd61, 0x4a771f6a, 0x5b4f16d1, 0xdb71ef43,
 0x61c73af, 0xdf29eac7, 0x11b94cb8, 0xc7bbfa36, 0xbba695d8,
0x7dfc6431, 0xfe529d96,  0xe698442,  0x903c1fe, 0x8fe27856,

/* 3340 to 3359 */
0xc3caadd9, 0xf9bb3283,  0x68dbfa6, 0x5eeefd68, 0x3548752e,
0x831806d0, 0xc12360ab, 0x39efd5b3, 0xcc0370fa, 0xc7846c55,
0x7ecd13ae, 0x7b356479, 0x7b8984a5, 0x1a17bd59, 0x5f067121,
0x68dc6b64, 0xff2b082e, 0x221b0bd7, 0x96d72226, 0x9db126b6,

/* 3360 to 3379 */
0x189e8674, 0xed0d8ab8, 0x26f1094b, 0x224808c4, 0x8f7499aa,
0x79a38ec3, 0xb0c15c7d, 0xb0e5a275, 0xdf2dd675, 0x10f3027d,
0xe94ccf36, 0xb5b5d625, 0x2971ab3f, 0x6a912db8, 0x54c1f9be,
0x5db82487, 0x2f1606e6, 0x729ecc38, 0xe835b80f,  0x79ed9f1,

/* 3380 to 3399 */
0x4ee00ea1, 0xcad2d721, 0x4ef855ef, 0x1e3b2fcb, 0x667ab1b5,
0xa310ffb5, 0xc48a0af4, 0xc6a47bc3, 0xe5d6f984,  0xaf5cfb2,
0x4cf0ef48, 0x1fb5bdcc, 0xdbec5365, 0xacf1e775, 0x9dadc2c7,
0xc0b5a3ae, 0x6ab7c164, 0x9cc8f044, 0xbb6b2857, 0x5b046b1e,

/* 3400 to 3419 */
0x35628dc1, 0x27869c60, 0x37a31b5a, 0x755277c9, 0xdd6f8dfa,
0x1f93e539, 0xda98b214, 0x837a3f27, 0x58a9dfbf,  0x119b095,
 0x8c3d3fb, 0x292b7b50, 0x786f5721, 0x3a914417, 0xcfa7b975,
0x334e3e04, 0x463b062e, 0xfdb2d78f, 0x4dc73783, 0xff498a15,

/* 3420 to 3439 */
0xc19665b3, 0xbca4b432, 0xf36ee144, 0xfdc027ca, 0x6d9161da,
0x4dc74f48, 0x5ed7fda0, 0x6bf06ea9, 0xcc3d6da1, 0xfc9206b4,
0xc4ba6742, 0xb2b8db25, 0x1e31aa8d, 0x40ec828c,  0xa1cfdd2,
0x684eb165, 0x59e21123, 0x28487041, 0xb341a258, 0x223fc3f8,

/* 3440 to 3459 */
0xd1a47061, 0xf8ca4184, 0xcf561e61,   0xf56994,  0xf2f4da3,
0x97ce03c0, 0x5912e20a, 0x899a843a, 0xcc16c918, 0xf2cf2708,
0xe3b3f5a3, 0x4f6480f3, 0xdddda8c7, 0x488ebe7b, 0xe84b002a,
0x90361edc, 0xb3aeaa90, 0x83364df3, 0x18857a51, 0x8dc1752e,

/* 3460 to 3479 */
 0x358a263, 0x63af11c3, 0x46bd89ae, 0x5def9c1b, 0xb02bd72f,
0x40feba5a, 0x2168a2a9, 0xd6c382da, 0xc5ea22ac, 0xc249cbb2,
0xbf8182c0, 0xf3d9403b, 0x69b16de7, 0x46ac9862, 0x7ce0144c,
0x48cd737b, 0x8348f86f, 0xe8a59590, 0xff746943, 0xc61b70ad,

/* 3480 to 3499 */
0xa3c7850c, 0xd3eafbcf, 0xc6c625f7, 0x14aca5ba, 0x8df54010,
 0xb9644cf, 0xf9abafce, 0xdc391e43, 0x4918fcde,  0xfc3efe1,
0x6119d3c1, 0x30860f99, 0x121b31fb, 0x6eb0d83d,   0x99ee9f,
0xb4157283,  0x60b3033, 0x3816db6a, 0xd46b747e, 0x7ae99d1d,

/* 3500 to 3519 */
0x419a6498, 0x37ee4650, 0x8078af37, 0x94ea0d46, 0x7633d338,
0x3ea4d8a9, 0xe95fcf2b, 0xc62db1a0, 0x57fbf01d, 0xfa1c4193,
0x8ab099a9, 0x6bd2045b, 0xed20eec4, 0x4beb4e63, 0x7af12fc3,
0xd08af171, 0xda3839fe, 0x4d43442b, 0x7cac3ce5, 0x7953a0e0,

/* 3520 to 3539 */
0x9f96e3ca, 0x956c3d17, 0xf7dc8e34, 0xaa621f7f, 0xf1df2614,
0x8866e27d, 0x3d62eeb9, 0x78abdcd5, 0x40d49d44, 0x5d39b0e3,
0x217f8624, 0x4ee3c520, 0xae192ba9, 0xc628685e, 0x38fa60e0,
0x7da3d322, 0xfa5da1f1, 0xc9157c36, 0xdcdc4ab4, 0x57085e2a,

/* 3540 to 3559 */
 0x694226d, 0x973d2031, 0x4822c9d4, 0x5edda44d,  0x3ea893e,
 0xc48e4fd, 0xf2118ef2, 0x2d4c2bfb, 0xc6fab803,  0x946464c,
0x1dafb55f, 0xe3ee6116, 0xab1c9f24, 0x4bfc3668, 0xa09cecb4,
0x5d8005ef, 0xa5af5856, 0xdad133de, 0x6547719f, 0x13a1a1a8,

/* 3560 to 3579 */
0xa18d8788, 0x3c2dc399, 0x7eaec0d4,  0xc686e0a, 0xa32d89ed,
 0xa187873, 0x9a845ab6, 0x991366ab, 0xb8981fa6, 0x85feac4e,
0xf6cfda24, 0x4a0c991b, 0x21d058df, 0xec4535f5, 0x3d68aa49,
 0xbfa518c, 0xcabef862, 0x9605fcff, 0x38a85d4a, 0xf7fc9441,

/* 3580 to 3599 */
0xfefeb85f, 0x7597f6ff, 0x66866669, 0x1cc40d32, 0x49b26867,
0x99b1fc4f, 0x131faee0, 0x1cb73060, 0xa547d3bb, 0xb650e8a7,
0xe1e6a8ae, 0x2e0d7f45, 0x22542f7e,  0x6e72493, 0x226294b5,
0x8109df72, 0x282bfdf4, 0x7c8d1da1, 0x9044e262,  0x39f6c1c,

/* 3600 to 3619 */
 0xab9766a, 0x684e9265, 0xc024a6e8,  0x245fe24, 0x28685b4a,
0x43c649fe, 0xe612feb8, 0xd455a661,  0x6da9119,  0x8eadf3c,
0xfb7a84cb, 0xb7283a2b, 0xd89a9d4b, 0xecb61fd8, 0x5af5b92e,
0x9c3004c9, 0x263e8321, 0xdf9742a9, 0x361e0a48, 0x628a8d9c,

/* 3620 to 3639 */
0xecf43af3, 0xec72ff2d, 0x95546a6d, 0x81ce5752, 0x9ba67ea7,
0x2daaed80, 0xea761a06, 0xba5d4668, 0xa9d20d67, 0x319ceabc,
0xa4d0822b, 0x2b1d3a0b, 0x2c51ce27,  0x2bb82d3, 0x66397106,
0x7cf5d3f7, 0x6cfb23e2, 0xbd007e59, 0x84070305, 0xe23c20b3,

/* 3640 to 3659 */
0xe85c3765, 0xa11eb158, 0xc8c050ec, 0xc61e90dd, 0xec6c273f,
0xce9d54be, 0xa3f4273e, 0xf0956b17, 0x33d19c15, 0x24fc45bb,
0xaafcf6e8, 0x2d84bcb2, 0x4370fe60, 0x9d461ea6, 0x5ba004ed,
0x7e8875ab, 0x135ad8f0, 0x2fba76a9, 0xd7fbd0aa, 0x96ee17c8,

/* 3660 to 3679 */
0xf5aa9bea, 0xcc906d37,  0x16416c4, 0xddffee29, 0x2e80e756,
0x490a45e2, 0xdab71ccf, 0xfa285e13, 0xb548c18c, 0x30dd4161,
0x704826bb, 0xd5e3753d, 0xcf872e40, 0xabd938b8, 0x6a06800e,
0x1dc8362c, 0x5f70bbf4, 0x486d389e, 0xd55ec893, 0x18092c9d,

/* 3680 to 3699 */
0x9939e17b, 0xcc70038f, 0x5956be93, 0x103df617, 0xef742380,
0x8d181fb3, 0xae51afcc, 0x3317d8e5, 0xefb494a0, 0x4308e2a8,
0x9aa8da68, 0x13434b98, 0xd39fbd21, 0xc0a11782, 0x9f2bae9f,
0x5e9e769f, 0x22107c6a, 0x84f75d72, 0x91fd913a, 0xfe32a1dd,

/* 3700 to 3719 */
0x25a5b3b6, 0x4cb5d713, 0xe14a0064, 0xe569c20e, 0x1d850792,
0x80c78dc9, 0x55e5c046,  0xbd1f624, 0x9c9459cd, 0x14dc1da0,
0x6bf4c14a, 0x4cce8416, 0xf3676e0f, 0x10e794b2, 0x6c23d043,
0x1e586276, 0xedab0354, 0xfb7a2443, 0x9dc18712, 0xf1af9072,

/* 3720 to 3739 */
0xc9e89e01, 0x58d36b8e, 0x17d70aa0, 0x3e4915d5, 0x20183dd4,
0x27138c6e, 0xb3a1d0b7, 0x66bb9d48,  0x602003a, 0x4e9b81f2,
0xfdc49817, 0xe434f405, 0xdf96c8ec, 0x82639fe3, 0xfc6ab0e4,
0x7a84eda7, 0xaabb21ad, 0x23035642, 0x3d5072d5, 0x9adea436,

/* 3740 to 3759 */
0xc51e9997, 0x5fd0190b, 0x5573a3c8, 0x317a0b98, 0x4fde5dfd,
0xa21ba1f5, 0x93b2b672, 0xf429c8cc, 0xa63da3cf, 0x359bd538,
0x7d66968c, 0x7f3062f3, 0x5a2d0c07, 0x47f11cb8, 0x89e57a0b,
0x5560c7f2, 0xeefcf4ae, 0xd147eab8, 0xf05647c4, 0xc0c5a4f3,

/* 3760 to 3779 */
0xd36c61ca, 0xe12dffd4, 0x55928ca1, 0xd5b9316b,  0x62855ce,
0x51596e69, 0x10c451d1, 0x4bf3c974, 0x66cf3ddd, 0xdb7da447,
0xd295f61d, 0x965dc744,  0x3c754e1, 0x4af87367, 0x53025da7,
0x130447b9, 0x6910d277, 0x9ea0aae2, 0x90924a8a, 0xa31e75a7,

/* 3780 to 3799 */
0xce73088a, 0x6ec661ac, 0x2ae6e5ca, 0xbad10f05, 0x27393a14,
0x8bc9525c, 0x922426cc, 0x14e28696, 0xf0c15e6e, 0x6153e2dc,
 0x30c0ca5, 0x4d66084f, 0xbd12475b, 0xef3ae03f, 0xcc29a574,
0xef4c93b4, 0xc5ef1335, 0xa797b6a4, 0xd85f90a1,  0x9318a89,

/* 3800 to 3819 */
0x3d4c0000, 0x345ecd7e, 0x6ea7b4fd, 0xcc73f6f6, 0xd27b5edb,
0x99d41201,  0xe84dfb5,  0xa23718c, 0xd32426d7, 0xfe6b2138,
0xde02ac07, 0x15a74dc5, 0x3c8488e7, 0x214c5dbf, 0x3899dafd,
0x83f5dbd7, 0xa309294d, 0xb1629868,  0xad3f306, 0x9141e17d,

/* 3820 to 3839 */
0xcd7e126d, 0xf718fe93, 0x4b1ba393, 0xd6f4a4b7, 0x8ccc4b3b,
0xe8879f36, 0x446fd8ad, 0xc4c000fe, 0x8bf17794, 0x254d05a5,
0xdb6f5da9,  0x8d675e6, 0x1a4f68ba, 0x84881f68, 0x5ebd8cb7,
0x3866dd86, 0x1ff2bdb0, 0xf1fbb330, 0xeb1e9cea, 0xfa46f404,

/* 3840 to 3859 */
0x58ab145d, 0x4bac727d, 0xd38f0450, 0x74eaf8f9, 0xa539556a,
0x13adff98, 0xcc4a6790, 0xf4bd783e, 0xaf412bd9,  0x4d0ec38,
0x923a137d, 0x3759488c, 0x8f5eca91, 0xdeebd893, 0x6f054e68,
0xf8ae8a2c, 0xda7108e0, 0x33f6e8f1, 0x5ecac60d, 0x6d2fa48e,

/* 3860 to 3879 */
0xc874d99f, 0x13fca95f, 0x89330bdf, 0x5996a86c, 0x3ec57211,
0x836197a4, 0xc09acd22, 0x26260993, 0x9e97dc3d, 0xde2997da,
0xf6f5d044, 0x264b5d4f, 0xddbf1dc5, 0x82d64f3e, 0x4c93d14f,
0xcd884b4a, 0xd5480c3e, 0x8676410a, 0x3acf1080, 0xfe2ea292,

/* 3880 to 3899 */
0x4ae76e24, 0xe6ea92b1, 0xdbed53da, 0x92d4e9b0, 0x889cb650,
0x588900f0, 0x56abfe52, 0x11ec2a8b,  0x52632c7, 0x9fe56dee,
0x2a7a151e, 0x5623ad59, 0x85e8ac7a, 0xefd1c3a6, 0xb133739b,
0x4729a138, 0x3df71ce8, 0x8082d1dd, 0xdc7dada4, 0xc00ef1b6,

/* 3900 to 3919 */
0xf023e4c3, 0x6491a6fb, 0xcdc9e081, 0xbd9fd9dc,  0xd2e15bb,
0xbb7816f0, 0x28f5d424, 0xf0df0730, 0x49489e1f, 0x8dcd9033,
0xf58b9b93, 0xb9e1cbea, 0x5dfce53c, 0x804ece57,  0xd1020e1,
0xa9b1e869, 0x5c9c0eaf, 0x304f0104, 0x31901437, 0xc8383c6d,

/* 3920 to 3939 */
0x28f4feb2, 0xb0b2e046, 0x7bffedd4, 0x6fdfe75d, 0x6e14efd6,
0xeea33521,   0x33d5fe,  0xee8da41, 0xa2aa539a, 0x8ef4d11e,
0x439e1cc6, 0x5eb4059d, 0x6e24c725, 0xe0613f7e, 0xb6c2eea4,
0x526b74c3, 0x23b3eeef, 0xa8d7e092, 0x4be07c06, 0x7422f67d,

/* 3940 to 3959 */
0xeec62136, 0x83965570, 0x1fc763cf, 0xfad46a00, 0x5bc6956a,
0x16e3a1ea, 0x774b7b97, 0xbaa2e79d, 0x3c685467, 0x390e7cc0,
0x544e0b17, 0x9a7814cd, 0x8154aa36, 0xc7b3e8f0, 0xc69fbbe1,
0x791952d4, 0x7f4215d9, 0xb407428b, 0x3c63e7d0, 0xa7eda057,

/* 3960 to 3979 */
0x41dce2ca, 0x84563bbe,  0x47a6c9b, 0x51c0782a, 0x460149f6,
0x76c1700d, 0x2b9e470d, 0x90273c41, 0x2ce54f8e, 0xe4c3bd68,
0x81f0e9e0,  0xf6c6c17, 0x2c75398d, 0x35550735, 0x67cdad74,
0xe7ce260e, 0x74d345f3, 0x8d21c2e3, 0x4a8080de, 0x3147b337,

/* 3980 to 3999 */
0xaa08f504, 0xbf4be2c8,  0x64ce3ed, 0x75dd42b5, 0x486cdc9d,
0x11ecb04e, 0x565bfb14, 0xef758fc9, 0xb89d1256, 0xf603bd96,
0x84904c82, 0xae58c47c, 0xd87f02ff, 0x6d418dee, 0x76ef098b,
0x429b780f, 0xce9719b8, 0xd8c2db76, 0x2ec8a68a, 0xe594c03b,

/* 4000 to 4019 */
0x22105c6f, 0xd386d769, 0xe3b980df, 0x598ee06f, 0xa8b6fa82,
0xde177afa,  0x785164f, 0x9f8700fa, 0x17e1c93c, 0x385ed45f,
0x8b5ee722, 0xb1c4f395, 0x8145f84f, 0xe505edd3, 0x8f8f4456,
0x1ee31805, 0x222cd843, 0x1a9f1e16, 0x2ffecd0c, 0xdfacbf2a,

/* 4020 to 4039 */
0x23c1706c,  0xae542f8, 0xd6cbd17c, 0x3e1b1e9f,  0x53f9356,
0x3f196ffb, 0x5d40066b, 0xbabb2c24, 0x71c76e4b, 0x78b80af6,
0x5e08de22, 0xb5a52dd5, 0x4aface82, 0x5430ed78, 0x25d888ef,
0x1a5fbdd1, 0xce3d1e84, 0x76350c52, 0x6b2881b2, 0x567e8366,

/* 4040 to 4059 */
0xf8f354b8, 0xd78ca1cf, 0x4531f38a, 0x643589a0, 0x7c6b13a4,
0x9e8dc35a, 0x48ebbc0d, 0x462d4223, 0x9d5bbd5b, 0x6af717af,
 0x4969258, 0xd84b09b9, 0xe2a63542, 0x57e3362d, 0x5dc866b7,
0xe17abd7e, 0x9f29401d, 0x4058a993, 0x5389254e, 0x4218001b,

/* 4060 to 4079 */
0x90ef514a, 0x1c28c4a0, 0x6c194b6c, 0x8e10ed53, 0xfc7a4063,
0x7ed444be, 0x2475fb10, 0x205e4b8c, 0x67ebcb90, 0x5e76bc8c,
0xc90dd236, 0x177cd07d, 0xa7652610,  0x8be08fe, 0x433fecb4,
0x1b8244a4, 0xe2a01971, 0x5e423b78, 0x7b99c7c0, 0xa766d1dd,

/* 4080 to 4099 */
0xf55e1704, 0x738f7422, 0x6d780d89, 0x2333f3e0, 0x6b926f81,
0xf77982db, 0x787c8c66, 0xea9d7def, 0xcdd80504, 0xbcc37d07,
0xb14d6d4b, 0x4f4a18c9, 0x2f2b046b, 0x519aa43e, 0xd6fd59ed,
0x30e2c2d4, 0xd1e0329b, 0x610aa61b,  0x7565e16, 0xcb37a42a,

/* 4100 to 4119 */
0x6507151b,  0x79f655c, 0xac950b5e, 0x1a85a6c0, 0xd0e82b04,
0x61c43def, 0x7c5c092f, 0xda9280ff, 0xa04daa70, 0xbed1aac6,
0x125063be, 0x136965b4, 0x14b0ec16, 0xb57135b4, 0xf11f30e1,
0xc700c079, 0xdfc64e3f, 0x1cb3e25f, 0xf2ebc3e7, 0x90d43b97,

/* 4120 to 4139 */
 0xd71ee2e, 0xfcbb2d30, 0x3bdf4a52, 0x3caf0df6,  0xa03fb62,
0xea407b13, 0xa8e1119c, 0xc6de0485, 0xf7fb71ba, 0xfd6d0875,
0x9de46dd1, 0xce0b614f, 0xddeb0cff, 0x3162c89a, 0x27af7fa9,
0xff3e670f, 0xdd18360a, 0xcf5363c2, 0x5f7ec447, 0x1cbb7378,

/* 4140 to 4159 */
0x9c49366f, 0x807b63af, 0xbdb9c68c, 0x3a748ed2,  0x89bfc7e,
0x74cec2ac, 0x7af4caec, 0x3f3f8ab8, 0x85364ae6, 0x5bdb7818,
0x59d07bb6, 0x3bd23dbf,  0x1ae5cda, 0xa05f25d6, 0x223d1eaf,
 0xf1a985a, 0xa699f2b1, 0xf5f5bf3e, 0xbeae8c78, 0x836ae180,

/* 4160 to 4179 */
0xa7f66a7f, 0x8f2b1a3d,  0xb2c4c6d, 0x40b499e3, 0x7eeaf39b,
0x94a5cecd, 0x7bc68aaa, 0x2f3646a8,  0xf772791, 0xf063b0c6,
0x9cdfca48, 0x62126833, 0xad4a4616, 0xea83c9b4, 0x7c0dc4f0,
0x7c1ba086, 0xc81be089, 0x7e848571,  0x4594fa0, 0x3906921a,

/* 4180 to 4199 */
0xf429fc0b, 0x3f410408, 0x3fde9fb7, 0xb16c7e92, 0xc796aae8,
0xf9ab179f, 0xb3f49460, 0xd8ea82fa, 0xe310cc19, 0x1c412028,
0x2db5bb74, 0x1d78e3e4, 0xa9abe6ee, 0xdb86cc28, 0xe7b12c71,
0x37df41e8,  0xbdaa52a, 0xa3b82141, 0x77aa9c2e, 0x779dc60d,

/* 4200 to 4219 */
0xc8df6b5b, 0xece2a7dc,  0x865f6d6, 0xc4027c2f, 0x39c299e3,
0x5d7e27f3,  0xb2fcec1, 0x18138204, 0xa492344d, 0x6c3b5fe7,
0x24c9e296, 0xb08ac5a4, 0x91f6deae, 0x2679bfbe, 0xadd7904f,
0x9e429d82, 0x2d4c7ca3, 0xcc8163d2,  0x11dfa8c, 0xc8d2d0f1,

/* 4220 to 4239 */
0x3314a4ab, 0xea1a5d8f, 0xa51cb740, 0xaa3fb7c6, 0xbd8be05d,
0x17d2534b, 0x617dab5f, 0xc0e99d27, 0x920c3633, 0xd47e6549,
0x6a5fc245, 0x44323a63, 0x7877459a, 0x2b6cedd3, 0x7c2f1190,
0xf114ff75, 0x3b895be2, 0x62a4bd2d, 0xafef759d, 0xccb93948,

/* 4240 to 4259 */
0x6ee5150c, 0xe51011ec, 0x97ab3814, 0xa1000178, 0x2666d2a3,
0xc5b8a204,  0x98a823a, 0xeb764774, 0x65326a28, 0x7782eed7,
0x233dd402, 0xa62d4d2d, 0x4d73e4e7, 0x75eeb9a2, 0x86a5fb54,
0x29c8fbab, 0x1980e099, 0x77affe32, 0x1adc99bf, 0x776c21a0,

/* 4260 to 4279 */
0xeef221b0, 0x54a92447, 0x482aba5b, 0x67a5dee3, 0xf1ad5e40,
0x5f8a0e54, 0x1842707d, 0xb40881a0, 0x29c9d9cf, 0x7cabaab1,
0xce2ab454, 0x68280a41,  0xc06e0d8,  0x95dbfa5, 0x483162f4,
0x3398b8b8, 0x194088da, 0x605da1b5, 0x1282f862, 0xf2db88f6,

/* 4280 to 4299 */
0x3bf17385, 0x5fdb4e3e, 0x26278f47, 0xed2c42af, 0xbb32c912,
0x619d2cd1, 0x17a56087, 0xc5d06f26, 0xd0ef5c04, 0x1b44162c,
0xfe376cca, 0x3e0c3cef, 0xb1e5a5c6, 0x80593303, 0x607e88c2,
0x918b8cec, 0x69229445, 0x9f37d6ac, 0xbac4d377,   0x19a8c0,

/* 4300 to 4319 */
0x5c5b5f1e, 0xa767b596, 0x8a0404fd, 0xf7341697, 0xd175111c,
0xa62878bd, 0xbd63898c, 0x54ec2a8e, 0x7ed66b98, 0x83f2113a,
0x739f5b43, 0x8ab86c5d, 0x987ba039, 0xbb0d2898, 0x5c296968,
0x9c3ed1a1, 0xf4f3d870, 0x4f595422, 0xc33f7abb, 0x19e7614d,

/* 4320 to 4339 */
 0x3fa0eac, 0xd1e3e7a4, 0xad933ad1, 0x336d31eb, 0xfba210ac,
0x9df8122b, 0x155b6623, 0x40ff3fd1, 0xdee5639c, 0x4835bf0f,
0x4ccd9b62, 0xfa1d46c0, 0xc6f42d2c, 0x1749dfa0, 0x8d86715a,
0x4880115a, 0x7be83168, 0xbda9daf1, 0x22a14170,  0xb5f1055,

/* 4340 to 4359 */
0x72aa88d3, 0x480592fe, 0xa3bd331a, 0x2fd452bb, 0xccb0940d,
0x2b2444c6, 0xe5a07cd9, 0x2d6cf5bc, 0xa3562f45, 0x5f64da1f,
0x1d3a1eda, 0x40345894, 0x9a408978, 0xe7fd1919, 0xf4b4755b,
0x12373048, 0x65079804,  0x8e3ad8f, 0xf503cd09, 0xcaa647bc,

/* 4360 to 4379 */
0x76a59621,  0xb24fa59, 0xef39c0e7, 0x68d481f8, 0x7a18d734,
0xa2a4299f, 0x5ec3de41, 0xfd0c7c7d, 0x7efd8216, 0x115b87ee,
0xd5094020, 0xa364cc16, 0x61242828, 0x2e02cdb6, 0xb78e2816,
0x454da6e3, 0xcc131059, 0xfff69709, 0x1992a09e,  0xa3d1ba5,

/* 4380 to 4399 */
0xdfd86f93, 0x7f144351, 0x11126043, 0x4d14ce3f,  0xbcef6f5,
0x8624391a, 0xb6495ab6, 0xfe32b756, 0xd612ec32, 0xea67fb78,
   0xa091b, 0x6c815d3c, 0x4cc5ab88, 0x993d25cb, 0x14025ae0,
0x1744a9b0, 0x638f07be, 0x3d463f93, 0x7ea48baf, 0xb3990635,

/* 4400 to 4419 */
0x1b5174f8, 0x23ed7f14, 0x8b7bc06d, 0x799272d0, 0x2b665abe,
0x3f051153, 0x5b2cc195, 0xbc09eaa5, 0x8612b671, 0x5d3ed07f,
0x37d1d7aa, 0x4ca38b7d, 0xa2fc4592, 0x55a9908c, 0xb1eb71f8,
0x1ea0da41, 0xb42ad10b, 0x29acf790, 0x8708cc54, 0x6ac2a2f6,

/* 4420 to 4439 */
0x554bb05d, 0x169195ad, 0xcb6a2f91, 0x1cab26fa, 0x291be30d,
0xbcb29349, 0xaf939ce1, 0xf759b166, 0x7ff848ac, 0x6c54b175,
 0xff50aac, 0x9aad5f75, 0xd3efdf92, 0x4115456e, 0x4775c171,
0xfb5a63cf, 0xcc6a6154, 0x372b955b, 0x3b967b23, 0xdf8e8291,

/* 4440 to 4459 */
0x25209617, 0x1393820c, 0xd8fba7ff, 0xcafebc03, 0x136b19b3,
0xc60f02ee, 0xe7271e1a, 0x4267994a, 0xc79bcc71, 0xccf10cad,
0x3e239cd6, 0x90024e3a, 0xe5d9c518, 0xbde01fbe, 0xae705759,
 0x47f325a, 0x4628ec68, 0x1db938a9,  0xf7a7704, 0x2efdb330,

/* 4460 to 4479 */
0x555d6aa1, 0x56279490, 0xebd1971c, 0xc696789c,  0xd1894d6,
0x917d71d6, 0x52da6412, 0xd1989178, 0x773705bb, 0xbfaabc8d,
0xe0eec1f2, 0x4e7fd396, 0x8063fd8f,  0xaccc8c0, 0xd388af8c,
0x39359c4e, 0x17460b00, 0x46c43534,  0x9194556, 0x84011189,

/* 4480 to 4499 */
0x56542cae,  0xa247e00, 0x7d27826e, 0x93bf08a0, 0xe90c8765,
0xcf7ea7cf, 0xb1fb3f55, 0xb5285e5c, 0x6245ffe4, 0x79efb1cc,
0xcc81f25d, 0x483bac97, 0x6e161f8e, 0x6a9a7519, 0x81385f68,
0x890adfda, 0xf48531b2, 0xcc4a9506, 0x97b20618, 0x2b6e97a0,

/* 4500 to 4519 */
 0xb7cf7aa, 0xbdb80837, 0xaf093a02, 0x71ab9a6a, 0xd314bf54,
0x30f3736c, 0x25ed2f5f,  0x6acb0d4, 0xedc46ddf, 0xc237fa3b,
0xd5f031f3, 0x9b0c8947, 0xb56ee973, 0x736e94ab, 0xfab01c71,
0x2b5d39a6, 0xd1c43266, 0x59a4cf6a, 0x271bdbbe, 0x7e491fda,

/* 4520 to 4539 */
0x3b70c029, 0x25d50c5f, 0x8e66c33e, 0xf6d4a596, 0x73f0c509,
0x87670597, 0x11a10926, 0x9d15e730, 0x231d0563, 0xc1d460db,
0xcb8b42ba, 0xc6742e20, 0x60486aca, 0x4eae44f9, 0xecba3d05,
0x34930874, 0xbe7d8730, 0x9a1dca25, 0x2eda8e4f, 0xf384b87d,

/* 4540 to 4559 */
0x721b8d45, 0x7281c8a7, 0x4e212cb2, 0x1103ea89, 0xf75c35e2,
0x6f6783b3, 0x5abf649f, 0xbb0eee6f, 0xe21ee661, 0xa83c380e,
 0xe339cbc, 0x80c7f34c, 0x96e057ad, 0x59680aab, 0xb77df070,
0xf68d76e9, 0xd2ec6233, 0x61f45db0, 0xcc472a65, 0xcd7a1c25,

/* 4560 to 4579 */
0xb4683405, 0xcefc969c, 0xb7b12e92, 0xe3f4e0e3, 0x3bd3125f,
0x6eb23651,  0xac51dd3, 0x8bc64709,  0x42b1191, 0x795259c9,
0xd6fb979c, 0x8bbb0df1, 0x4de5b691, 0xb7ba1db5, 0xa8ee38ed,
0x1ccf5bce,  0xe3eb63e,  0xed8432c, 0x484b6567,  0xb02a627,

/* 4580 to 4599 */
0x12a590f6, 0xab50bc88, 0xd630e699, 0x7f26c889, 0x8eb52334,
0xbb7cf997, 0xafacd0f2, 0x9c7674aa, 0xdef56b3c, 0x3c1b68a5,
0x6f12027b, 0xef9d38b1, 0x66cbf54b, 0x367ad919, 0x4aa742e2,
0x4b1d489c, 0x278bf6aa, 0xe851cc6a, 0xad431862, 0x881c6b17,

/* 4600 to 4619 */
0x9bef6828, 0xe0b8500e, 0xcc6a92e2, 0x2806fbbf, 0x8bcc2d20,
0x2039c3ae, 0xe17e5dd4, 0xa134354e, 0x1236477d, 0xd978c2fa,
0x70ad1108, 0x3b8dd315, 0x7c986c39, 0x5cb0b5e7, 0x3417041c,
0x74205d6d,  0x264d18b, 0x7629e4ea, 0x8eba70db, 0xf4d571c6,

/* 4620 to 4639 */
0xeb9b2ec3, 0xce148bcd, 0xd8f8a914, 0xde343d4e, 0xabf09e28,
0x2326ae02, 0xc1572337, 0x4c094f98, 0x31c33370, 0x96137fd6,
0x38918f4d, 0x799dd6a4, 0x506cc5f4, 0x37395a1b,  0xd64ad97,
0x19cecbcd, 0x15497cb0, 0x7b2b2ffb, 0x34e3df74, 0xf7699b26,

/* 4640 to 4659 */
0xab9b4a73, 0x75f4ac22, 0x64478663, 0x90bd12a3, 0x4f7e13e1,
0x5192e19a, 0xfdce19cb, 0x26bf8ce8, 0xeff5a84d, 0x4fafd918,
0xe79ad56a, 0x6fe9e123, 0xe3fd4a3a, 0xf0d61133, 0x183aa59e,
0xda00d2f7, 0xa2ec3f1b, 0x205ddd83, 0x7ced7d51, 0x677020e9,

/* 4660 to 4679 */
0xfed55624, 0x21b32acc, 0xe0e5c717, 0xeecd3288, 0xf20165c8,
0x4d1952ea, 0x23427103, 0xb82871db, 0xc6e07a5e,  0x51a89c5,
0x5b7ef87f, 0xaac1fcae, 0x500d4e8e, 0xe04f3ad1, 0x9c8f4087,
0xc0681ed9, 0x4239e215, 0x5f7ab2c3, 0x82bc6070, 0x450a7ea6,

/* 4680 to 4699 */
0xa7c0ca24, 0x8a07aef4, 0xbd336496, 0xe001a0e8, 0x6336e36c,
0x82b798a1, 0x9b0f4d45, 0x9df6d02d, 0x6cfbe4b0, 0x2bfe8b5f,
0x4da9d2b0, 0x1e195008, 0xeb688be6, 0xb3d75169, 0xc452e7c3,
0x3317e90a, 0x92e3e92b, 0x2e30c99d, 0x752bcff6, 0x5a01f7d3,

/* 4700 to 4719 */
0x60811965, 0xac67ff88,  0xbfe904d, 0x9eb519af, 0xfbd5570a,
0xd7738272, 0x4944ca8d, 0x76bebb99,  0x8f5566c, 0xcbc52ec7,
0xf86532cd, 0x7c56b15c, 0x9dbe01aa, 0x4303ee5b, 0x2fd45e92,
0xd82c113a, 0xe05db5e1,  0x28b2c75, 0x4bbcf3f5, 0xb4fccd78,

/* 4720 to 4739 */
0x34649365, 0xa31bd520, 0x39662b3b, 0x8bd27d60, 0x25ecd691,
0xb32e976c, 0x8d26aeeb, 0x990e6c6a, 0x1a664fb1, 0x16d4fe13,
0xbddbe9de, 0xf47e7d73, 0x3dd11c17, 0xee7c637f, 0xc91bd612,
0x5f1fd413, 0x9bb195c2, 0xaabfc8c3, 0xa4280a98, 0x5b8d6fcd,

/* 4740 to 4759 */
0x5db0fe48, 0x3a49f37f, 0x652e0569,  0xc7ead5e, 0x3a07f905,
0x2706611d, 0x61f36cf9,  0x636803f, 0x7c41c05e, 0x5bde4c80,
0x30a9e24e,  0xc21b219, 0xbe438094, 0xbb2a690c, 0xf50a019f,
0x15dcf92e, 0x7bfbb3df, 0x8e6b85c3, 0x9ce82917, 0x493e145a,

/* 4760 to 4779 */
0xdf420065, 0x941eaecc, 0x9458f8a7, 0x32baa5a2, 0x5e872227,
0x21637f52, 0x3a566429, 0x35ae73a9, 0x3506a336, 0xb9f25f3f,
0xd74c7f86, 0xa7a96f5f, 0xca4066bf, 0x12ae91de, 0x79525628,
0xaaf512dc, 0xd9def91d, 0xa7dce068, 0x1820b558, 0x5b884c86,

/* 4780 to 4799 */
0xf632f82e, 0x74b956b8, 0xd1e1385c, 0x60b47cfd, 0x802b5bf0,
0x43a3ab7e, 0x5f8d15f1, 0xc45c2e96, 0x566c2703, 0x71ca684c,
0x2b27dcb6, 0x7f4d7f34,  0x47e189b, 0xfa117fa8, 0x32c323ec,
0x43980c2b, 0x10bb3c7e, 0xfded5b90, 0x4f35eb36, 0x9c0bab7c,

/* 4800 to 4819 */
0x87f8d587, 0x2ffef3eb, 0xcd28dfe5, 0x1dbedcbf, 0x4426135b,
0x39e2911e,   0x12e5d7, 0x25c6fd25, 0xa5d4bd1f, 0xb1c99285,
0x7862fabb, 0x149ce41f, 0xb111eecf, 0xbf79e91a, 0xf7f03efb,
0x64bf8c69, 0x12881813, 0xb6265860, 0xbad4796c, 0x4adbf72f,

/* 4820 to 4839 */
0x53e4f32e, 0x24c9f662, 0x425b0960, 0x6446380c, 0xf67db7e5,
0xb475216a, 0xb44c38c3, 0x5253633b, 0x93f15402, 0xb6192c5f,
0xac1d0b62, 0x7c435398, 0xb2a4bee8, 0x6ff8364d, 0x3e3db4ba,
0x45e4e14a, 0xf298a275, 0x8d22cbf8, 0xb9d5dcd0, 0x969e0007,

/* 4840 to 4859 */
0x6a3bf885, 0x5f0887e9, 0x9e3e187e, 0xf40a768c, 0xc146f0e7,
0x2b99d52d, 0xbd1b75f3, 0x90b1fd3e, 0xfa685e95, 0xceba7786,
0xaee557f3, 0x6ada0330, 0x904aa3a5, 0x30f0902a, 0xc0e833fb,
 0x9350204, 0xa861a16e, 0x336cbf3a, 0x2ea4b893, 0x8456d284,

/* 4860 to 4879 */
0x974dab49, 0x29b1864b, 0x8279adbd,  0x26c6b51, 0x81a62eb1,
0xdb4b3e98, 0xaf5b1ed0, 0xc876c188, 0xbff42917, 0x6b5613ad,
0xdccbc64e, 0xaaecea46, 0xfd386472, 0x71759ec8, 0x445d37d8,
0x954d24ad, 0x96dda2b9, 0x1a79863f, 0x4322d882, 0xd3a2a591,

/* 4880 to 4899 */
0x6aa3ef86, 0x797e14b3, 0x95f63564,  0xc98c8df,  0x6f20582,
0xd473782f, 0xa8f74e96, 0x3f2ddd72, 0x385024d6, 0x289d2e7f,
0xd02afcd6, 0xe1d59895, 0xa08e9bde, 0x9102105f, 0x7ebba953,
0xedfe337f, 0x1ecd0490, 0x26afeb4b, 0x4e0a93cf,  0xd4baf17,

/* 4900 to 4919 */
0x86556142, 0x89cec6ff, 0xd1104453, 0xd6daef3d, 0xc5837253,
0x7eeec3de, 0xdba7a2ca, 0x239999e8, 0xde4f2b0d, 0xfe115523,
0x4664413a, 0x518d8009, 0xd859e4ca, 0x9c839be2, 0x563e0831,
0x2371a621, 0x9a398bf0, 0xbfe6b65c, 0x5b7390eb, 0x40bab5c1,

/* 4920 to 4939 */
0x523c0724, 0x69ea4ad9, 0xcc5ced42, 0x463b7269, 0x973a729e,
0x19846a99, 0x6acf3f40, 0xa11057db, 0x8d170146, 0x1e652e48,
0x1a70a4b7, 0x1afd0d21, 0xccbc80a6, 0x46b69708, 0x38eb757e,
0x579b14e4, 0xfdf0435e, 0xde62e67d, 0x7f8668fd, 0x20ae0fc3,

/* 4940 to 4959 */
0x8fe63ef5, 0xd041d000,  0xeaf50e2, 0x81563a9f, 0xf3e5becd,
0xaae580b8, 0x3442bce9, 0xd6965ec0, 0xe71835f6, 0x9e210727,
 0x42abd54, 0x81a57245, 0xa90f2a34, 0xdf81c296,   0x201bde,
0xc9869f79, 0x788a705a, 0xa081bfe2, 0x5519a003, 0x154d240a,

/* 4960 to 4979 */
0x66c1fe63, 0x4da59fe3, 0xdd40cb02, 0x7af9cb27, 0xb581ed4c,
0x6e8417dc, 0xfe991a46, 0x3594984f, 0xdd912bfa, 0x7b1fb839,
0xc32325fb, 0xc0d6f9eb, 0xe2e7257c, 0x8437a8c4, 0xe8e0ea9c,
0x692cf904,  0x5ab02e6, 0xe991e10e, 0xdee21bda, 0x4d0c0d1b,

/* 4980 to 4999 */
0x32f24f42, 0xcdb41d73, 0x4696b172, 0x3ee2662f, 0x7f512e93,
0xbecdca94, 0x89ba3668, 0x8e5577a8, 0xbc2a7116, 0x1d09b615,
0x3fe15937, 0x53901f44, 0x1a3a9470, 0xc0ef5302, 0x13202fc3,
0x5659bb2e, 0x35e36d51, 0x6d5f97fa, 0x68d278f4, 0xb9fca5b4
};

