/*
 * $Id: zmalloc.h,v 1.2 2000/06/27 13:07:28 linus Exp $
 * Copyright (C) 1991  Lysator Academic Computer Association.
 *
 * This file is part of the LysKOM server.
 * 
 * LysKOM is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by 
 * the Free Software Foundation; either version 1, or (at your option) 
 * any later version.
 * 
 * LysKOM is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with LysKOM; see the file COPYING.  If not, write to
 * Lysator, c/o ISY, Linkoping University, S-581 83 Linkoping, SWEDEN,
 * or the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, 
 * MA 02139, USA.
 *
 * Please mail bug reports to bug-lyskom@lysator.liu.se. 
 */
/*
 * $Id: zmalloc.h,v 1.2 2000/06/27 13:07:28 linus Exp $
 *
 *  zmalloc.h  --  Memory allocation routines with reference counts
 *
 *
 *  Copyright (C) 1990	Lysator Computer Club,
 *			Linkoping University,  Sweden
 *
 *  Everyone is granted permission to copy, modify and redistribute
 *  this code, provided the people they give it to can.
 *
 *
 *  Author:	Thomas Bellman
 *		Lysator Computer Club
 *		Linkoping University
 *		Sweden
 *
 *  email:	Bellman@Lysator.LiU.SE
 */


#ifndef  _ZMALLOC_H_INCLUDED__
#define  _ZMALLOC_H_INCLUDED__


/* Declare 'size_t' */
#include <stddef.h>

/*
 *  Allocate a piece of memory and set its reference count to 1.
 *  Allocating a zero sized object is allowed, and results in a
 *  unique pointer that can be used by all the other routines in
 *  this package, and must be released using zfree(), but it
 *  points to "nothing".
 */
extern  void *
zmalloc (size_t	   size);


/*
 *  Allocate N contigous objects of size SIZE, set the contents
 *  to binary 0 and set the reference count to 1.  Allocating 0
 *  objecs, or objects of size zero, is allowed, and results in a
 *  unique pointer that can be used by all the other routines in
 *  this package, and must be released using zfree(), but it
 *  points to "nothing".
 */
extern  void *
zcalloc (size_t	   n,
	 size_t	   size);


/*

 *  Reallocate the storage PTR points to the size SIZE.  If
 *  "others" are still holding references to this memory, they
 *  can still use it, and the caller of zrealloc() gets a copy of
 *  the original memory area.  NULL is returned if the request
 *  couldn't be honored, and the memory area is still in use by
 *  the caller.  Reallocating the NULL pointer is equivalent to
 *  doing a zmalloc() with the same size.  The same rules for
 *  allocating objects of size 0 as for zmalloc() and zcalloc()
 *  applies.

 */
extern  void *
zrealloc (void	  * ptr,
	  size_t    size);


/*
 *  Indicate that the memory pointed to by PTR is not used anymore
 *  by the caller, i e the reference count is decremented by one.
 *  The memory pointed to might be released as a result of this
 *  call.  Freeing the NULL pointer is a no-op.
 */
extern  void
zfree (void	* ptr);



/*
 *  Free the area pointed to by PTR regardless of how many are
 *  referencing it.  This invalidiates all pointers to the area.
 *  Calling zdestruct() on a NULL pointer is a no-op.
 */
extern  void
zdestruct (void	  * ptr);



/*
 *  Add onother user of the memory pointed to by PTR, i e increase
 *  the reference count by one.  Return value is PTR.  Using the
 *  NULL pointer is a no-op, i e it just returns NULL.
 */
extern  void *
zuse (void	* ptr);



/*
 *  Get a private copy of the area pointed to by PTR.  If
 *  necessary, i e if others are holding references to the area,
 *  copies the contents to a new place, and releases the original
 *  area.  If you want to keep a reference to the old area, you
 *  should do 'zown(zuse(p))'.
 */
extern  void *
zown (void	* ptr);


#endif  /*  _ZMALLOC_H_INCLUDED__  */
