/*
 * $Id: client.h,v 1.2 1995/04/10 16:41:31 linus Exp $
 * Copyright (C) 1991  Lysator Academic Computer Association.
 *
 * This file is part of the LysKOM server.
 * 
 * LysKOM is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by 
 * the Free Software Foundation; either version 1, or (at your option) 
 * any later version.
 * 
 * LysKOM is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with LysKOM; see the file COPYING.  If not, write to
 * Lysator, c/o ISY, Linkoping University, S-581 83 Linkoping, SWEDEN,
 * or the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, 
 * MA 02139, USA.
 *
 * Please mail bug reports to bug-lyskom@lysator.liu.se. 
 */
/*
 * $Id: client.h,v 1.2 1995/04/10 16:41:31 linus Exp $
 *
** isc/client.h                     structures and defines used in a ISC client
**
** history:
**   900509 pen       initial coding
*/

#ifndef _CLIENT_H_INCLUDED__
#define _CLIENT_H_INCLUDED__

#ifdef HAVE_SYS_SELECT_H
#include <sys/select.h>
#endif

typedef struct
{
  int fd;               /* Server TCP/IP file descriptor. */
  FILE *in;		/* FILE * for things from the server */
  FILE *out;		/* FILE * for things to the server */
} ISC;


#define KS kom_server		/* I know I'm lazy :-) /ceder */
extern ISC *kom_server;		/* The server that is used. */


/*
 * Open a connection to a server. host == NULL means this machine.
 */
extern ISC *
isc_connect(const char *host,
	    int port);



/*
 * Shut down the connection
 */
extern Success
isc_disconnect(ISC *isc_si);



/*
 * Wait for a message from the server. I opt_readset != NULL also wait for
 * messages on those fds.
 *
 * Return value:
 *	< 0	error
 *	> 0	there is a message from the server (and maybe also
 *		in opt_readset)
 *	= 0	there is a message in the opt_readset.
 */
extern int
isc_wait(ISC *isc_si,
	 int timeout,
	 fd_set *opt_readset);
 
    
#endif
