.\" ============================================================
.\"
.\"	 Linux Network Administrators' Guide
.\"		Compilation Guide
.\"
.\"	     Copyright 1994 O. Kirch
.\"
.\" ============================================================
.\" This document requires the GNU mm macro package.
.\" 
.PH "''''
.po 3n
.sp |2c
.ce 3
Building the Linux Network Administrators Guide

Olaf Kirch
.PH "'Networking Guide 1.0''Source Notes'
.PF "''- % -''
.sp 1c
.\" ============================================================
.H 1 "Introduction
.\" ============================================================
The Network Administrators' Guide (NAG) allows you to produce a couple
of different output formats from the same source. Currently, the main
supported targets are DVI, PostScript(TM), and GNU roff (using the mm
macro package). You can select these different formats by invoking
the \fBMakefile\fR with the appropriate target name.
.P
The NAG is intended to compile on as many TeX platforms as possible.
To fine-tune its behavior, you have to adapt the main configuration
file, \fBConfig.tex\fR.  The options you can set in this file are 
described below.
.P
As I'm not a LaTeX guru, and as there are quite a number of different
LaTeX version around, compiling the NAG may fail on your system.
If this happens to you, I'd be glad to hear from you if and
how you solved your problems, and incorporate your fixes in a future
release.

.\" ============================================================
.H 1 "Different output formats
.\" ============================================================
The NAG can be compiled for three different output formats at
the moment. These are
.BVL 3n
.LI DVI
DVI is the generic LaTeX output format. This should be relatively
painless on virtually all systems. But it isn't always, which is
one of the reasons this installation guide is so long.
.P
To produce the DVI output,
simply go to the source directory and type
.P
.VERBON
         make dvi
.VERBOFF
.P
This should produce the file \fBnag.dvi\fR as output.
.P
There's a minor \fBcaveat\fR here:
The NAG contains a couple of figures that were produced with the
\fBxfig\fR drawing program, and converted to eepic for inclusion
with the NAG. You have to have a working \fBepic.sty\fR and
\fBeepic.sty\fR macro file for this. The source for the NAG
contains these files in the \fBstyles/latex\fR directory. If these
fail to work with your TeX installation, but you have a working pair
of style files installed on your system, you may want to remove
the included eepic style files.  You can also find a set
of eepic style files in the \fBtransfig\fR package.
.P
To print the DVI version, you will need a printer driver that understands
the \fB\\special\fR instrutions generated by the eepic package. The
drivers from Nelson Beebe's driver package should do. The latest
version of \fBdvieps\fR I've seen (0.6) didn't have support for
these \fB\\special\fRs. If you do use \fBdvieps\fR, you
might want to print the document with it, and produce the pictures
separately. One possible way to do this is to take the EPSF versions
of them and print them with \fBghostscript\fR.
.\" ============================================================
.LI PostScript
To generate PostScript output, the \fBMakefile\fR first builds a DVI
version of the NAG, and converts it to PostScript afterwards using
Tom Rokicki's \fBdvips\fR program. You will want to use \fBdvips\fR;
I tried \fBdvitops\fR, but it didn't work out for me. You should
also use a recent version of \fBdvips\fR, a version prior to 5.512
I had didn't work right for me.
.P
The DVI version generated for PostScript output is 
\fBdifferent\fR from the version built when doing ordinary DVI
output, as it uses the EPSF versions of the pictures instead.
The EPSF versions look much better than the eepic versions.
.P
Normally, when converting DVI to PostScript, \fBdvips\fR includes
font images of all fonts used in the DVI file in the resulting PS
file. This greatly increases the size of the resulting output
file, and makes it dependent on the resolution of the output device
(300dpi by default). If you have a printer capable of PostScript, you
may choose to have the output file use the real PostScript fonts
instead of the cmr fonts. The exact requirements for this are
discussed in a later paragraph.
.P
To build the PostScript version, you go to the source directory
and type the following command:
.P
.VERBON
         make ps
.VERBOFF
.P
This should produce the file \fBnag.ps\fR as output.
.P
.LI "GNU roff
This output format isn't exactly the greatest thing since sliced
bread, but it's included for the sake of those who don't have the
disk space for a full TeX installation, and don't have access to
PostScript laser printers. It allows you to produce an ASCII-only
output of the NAG that doesn't look too bad. However, there are
no figures in the roff version. Anyone with a faible for ASCII
arts is invited to try his or her hand on this. I will gladly
include the results in a future release.
.P
The TeX source has been converted to GNU roff using the
\fBlotex\fR utility I wrote. The output uses the GNU version of
the mm macro set. To format the roff source, you have to have
\fBgroff\fR version 1.08 or later. To create the roff output and
format it, go to the source directory and type:
.P
.VERBON
         make mm
         groff -t -mgm -Tlatin1 nag.mm | less
.VERBOFF
.P
There is also a \fBMakefile\fR target that generates an `ASCII'
version; this is basically the formatted roff version piped through
\fBcolcrt\fR to get rid of all the character sequences used for
highlighting and such. Note that some printers, like the HP Deskjet,
will happily grok the backspacing sequences generated by \fBgroff\fR
and produce real underlining and boldface text.
.LE
.\" ============================================================
.H 1 "The Config.tex file
.\" ============================================================
The \fBConfig.tex\fR allows you to set a couple of options that
fine-tune the compilation of the NAG.  You set these options
by defining special LaTeX macros like \fB\\footrue\fR, which sets
the foo option, or \fB\\foofalse\fR, which unsets it.
.P
At the moment, the following are valid options (showing the default
settings):
.BVL 3n
.LI \fB\E\latexetrue\fR
If you run LaTeX2e, you must set this option to true. Otherwise,
\fBlatex\fR will choke horribly when compilig the NAG. (Thanks go
to Peter Williams for adapting \fBlinuxdoc.sty\fR for LaTeX2e).
.P
Be warned that setting this option may not be enough to make the NAG
compile cleanly on your LaTeX setup.  The dreary details are
discussed in a separate section below.
.LI \fB\E\ltxbeta\fR
This is yet another option dealing with LaTeX2e.  There are points in
which the latest release of LaTeX2e apparently differs from the Beta
version that has been included in Slackware for quite some time. The
\fB\\ltxbeta\fR switch determines which of these version the NAG will
attempt to take care of.
.LI \fB\E\veryoldtexfalse\fR
If you run a very old LaTeX installation, you should set this to
true. It disables a macro (\fB\\namedlabel\fR) which \fBlatex\fR
refused to grok on an installation I once tried it on.
I'm not really familiar with LaTeX version numbers, but I guess
anything prior to 1992 qualifies as old in this context.
.LI \fB\E\squeezefale\fR
Setting this option to true will reduce the size of the output
file from about 350 pages to 250 pages. The document's appearance will 
suffer a bit, but it saves you ink and paper.
.LI \fB\E\psfontsfalse\fR
This option tells \fBlatex\fR whether to use PostScript or
cmr font metrics whene generating the DVI output for the PostScript
version. This option has no effect when compiling the NAG for
DVI-only output. Again, setting this option may not be the only
thing you have to do to get PS fonts. Please stay tuned...
.LE
.\" ============================================================
.H 1 "Building the NAG with LaTeX2e
.\" ============================================================
There are a couple of things you should check before you can
\fBlatex\fR the Networking Guide with LaTeX2e:
.BL
.LI
In some versions of LaTeX2e,
\fBreport.cls\fR (and several other cls files) have a bug in the
definition of the makeindex option. There's a line
that reads
.P
.VERBON
       \\newcommand\\see##1##2{...
.VERBOFF
.P
This should actually read
.P
.VERBON
       \\def\\see##1##2{...
.VERBOFF
Note that this problem is likely to be gone in the latest version of
LaTeX2e.
.LI
If \fBlatex\fR complains about not finding the \fBifthen.sty\fR package,
you have to go to your \fB/usr/TeX/lib/texmf/tex/latex2e\fR directory,
and run the following command:
.P
.VERBON
      latex l2eextra.ins
.VERBOFF
.P
This unpacks a couple of extra packages, among them \fBifthen.sty\fR.
The script asks you a couple of questions about fonts, which
you can answer with yes (these questions apply to a couple of
other packages, like cyrillic fonts, which the NAG doesn't use:-)
.LI
To use PostScript fonts with LaTeX2e, you may have to unpack
yet another package.  If building the NAG fails with error messages
about not finding \fBpsfonts.sty\fR, or not finding fonts like
\fBOT1pcr\fR, then you have to go to the
\fB/usr/TeX/lib/texmf/tex/nfss2\fR directory
and execute
.P
.VERBON
      latex psfonts.ins
.VERBOFF
.LE
As a conclusion, let me vent my personal opinion on LaTeX2e. Although
the discussion above may give you the impression that LaTeX2e is a load
of crap and utterly broken, this is not true. After coming to terms with
some of the new features, I was very pleased how well-behaved it is.
The problems I've encountered (and which you will prossibly face, too)
actually seem to be problems of Slackware. Slackware used to come with a
Beta-testing version, which, in addition, didn't have all crucial files
unpacked. I haven't checked Slackware 2.0, though, so your mileage may vary.
.\" ============================================================
.H 1 "PostScript Fonts with LaTeX 2.09 or earlier
.\" ============================================================
To use Postscript fonts with LaTeX version 2.09 or even older, you have to
have two macro files from the psfonts package, being \fBpsfonts.sty\fR and
\fBtimes.sty\fR.  If you don't have them, get them from the latest release
of Thomas Rokicki's \fBdvips\fR package.
