/***************************************************************************
                          optionsdialog.h  -  description
                             -------------------
    begin                : Tue Jul 10 2001
    copyright            : (C) 2001 by The KXMLEditor Team
    email                : lvanek@eanet.cz
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef OPTIONSDIALOG_H
#define OPTIONSDIALOG_H

#include <qwidget.h>
#include <kdialogbase.h>

#include <qstrlist.h>

class QCheckBox;
class QLineEdit;
class QListView;
class QListViewItem;
class QButtonGroup;
class QRadioButton;
class KConfig;

/**Application options dialog
  *@author Lumir Vanek
  */

class OptionsDialog : public KDialogBase
{
   Q_OBJECT

enum enPage
{
	pageXml = 0, pageTreeView, pageTarGzExt, pageSpecChars
};

public:

enum enXmlParser
{
	parserSAX2 = 0, parserDOM
};

	OptionsDialog(QWidget *parent=0, const char *name=0, bool = true);
	~OptionsDialog();
	
	
protected: // Protected methods

  /** Setup page with tree view options  */
  void setupTreeViewPage();

  /** Setup page for list of files extensions that is TarGz */
  void setupTarGzExtPage();

  /** Setup page for defining special characters list */
  void setupSpecCharactersPage();

  /** Setup page with XML options  */
  void setupXmlPage();

public:

	/** Reads the configuration from the given config file. */
	static void readConfiguration( KConfig * );
	/** Saves the current configuration to the given config file. */
	static void saveConfiguration( KConfig * );

	static bool getTreeViewRootDecorated();
	static unsigned int getTreeViewExpandToLevel();
	static bool getTreeViewEnableDragDrop();
	static int getTreeViewElemDisplayMode();

	static QStrList getListOfTarGzExtensions();

	static QStrList getListOfSpecCharacters();

	static enXmlParser getXmlParser();
	static bool getXmlDontConvertAmpersand();
	static bool getXmlAppendCRLF();

protected:

struct SAppOptionsTreeView
{
	bool bRootDecorated;
	unsigned int  iExpandToLevel;
	bool	bEnableDragDrop;
	int		iElemDisplayMode;
};

struct SAppOptionsTarGzExt
{
	QStrList strListOfTarGzExtensions;
};

struct SAppOptionsSpecChars
{
	QStrList strListOfSpecCharacters;
};

struct SAppOptionsXml
{
	enXmlParser	eParser;
	bool	bDontConvertAmpersand;
	bool	bAppendCRLF;
};

static	SAppOptionsTreeView		m_AppOptionsTreeView;
static	SAppOptionsTarGzExt		m_AppOptionsTarGzExt;
static	SAppOptionsSpecChars	m_AppOptionsSpecChars;
static  SAppOptionsXml				m_AppOptionsXml;

struct SWidgetsTreeView
{
	QCheckBox 		*pCheckBoxRootDecorated;
	QLineEdit			*pLineEditExpandToLevel;
	QCheckBox 		*pCheckBoxEnableDragDrop;
	
	QButtonGroup	*pButtonGroupElemDisplayMode;
	QRadioButton	*pRadioBtnDisplOnlyElements;
	QRadioButton	*pRadioBtnDisplAttrNames;
	QRadioButton	*pRadioBtnDisplAttrValues;
};

struct SWidgetsTarGzExt
{
	QListView			*pListView;
	QListViewItem *pItemCurrent;
	QLabel				*pLabelExtension;
	QLineEdit			*pEditExtension;
};

struct SWidgetsSpecChars
{
	QListView			*pListView;
	QListViewItem *pItemCurrent;
	QLabel				*pLabelSpecCharacter;
	QLineEdit			*pEditSpecCharacter;
};

struct SWidgetsXml
{
	QButtonGroup	*pButtonGroupParser;
	QRadioButton	*pRadioBtnParserSAX2;
	QRadioButton	*pRadioBtnParserDOM;
	
	QCheckBox 		*pCheckBoxDontConvertAmpersand;
	QCheckBox 		*pCheckBoxAppendCRLF;
};

	SWidgetsTreeView		m_WidgetsTreeView;
	SWidgetsTarGzExt		m_WidgetsTarGzExt;
	SWidgetsSpecChars		m_WidgetsSpecChars;
	SWidgetsXml					m_WidgetsXml;

protected slots: // Protected slots

  /** Called when user press Apply button */
  void slotApply();

  /** Called when user press OK button */
  void slotOk();

  /** Called, when Delete button clicked */
  void slotDeleteExtension();

  /** Called, when New button clicked */
  void slotNewExtension();

  /** Called, when text in edit line changed  */
  void slotExtensionChanged(const QString&);

  /** Called, when user select item in list of extensions */
  void slotListTarGzExtSelChanged();

  /** Called, when text in edit line changed  */
	void slotSpecCharacterChanged(const QString &);
	
	/** Called, when New button clicked */
	void slotNewSpecCharacter();
	
	/** Called, when Delete button clicked */
	void slotDeleteSpecCharacter();

	/** Called, when user select item in list of extensions */
	void slotListSpecCharsSelChanged();

signals: // Signals

  /** Emited, when user press Apply or Ok buttons */
  void configurationChanged();
};

#endif
