/***************************************************************************
                          kxmleditoractions.h  -  description
                             -------------------
    begin                : Wed Jul 25 2001
    copyright            : (C) 2001 by the KXML Editor developers
    email                : lvanek@eanet.cz, olaf@punkbands.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KXMLEDITORACTIONS_H
#define KXMLEDITORACTIONS_H

class KAction;
class KRecentFilesAction;
class KToolBarPopupAction;
class KToggleAction;
class KXmlEditorComboAction;

/** This structure contains pointers to the actions used in the mainwindow. */
struct KXMLEditorActions
{
	KAction* fileNew;
	KAction* fileOpen;
	KRecentFilesAction* fileOpenRecent;
	KAction* fileSave;
	KAction* fileSaveAs;
	KAction* fileClose;
	KAction* filePrint;
	KAction* fileQuit;

	KAction* editCut;
	KAction* editCopy;
	KAction* editPaste;
	KAction* editFind;
	KAction* editFindNext;

	KAction* goUp;

	KAction* xmlInsertElement;
	KAction* xmlEditElement;
	KAction* xmlDeleteElement;
	KAction* xmlInsertAttribute;
	KAction* xmlEditAttribute;
	KAction* xmlDeleteAttribute;
	KAction* xmlInsertContents;
	KAction* xmlEditContents;
	KAction* xmlDeleteContents;
	KAction* xmlInsertProcInstr;
	KAction* xmlEditProcInstr;
	KAction* xmlDeleteProcInstr;
	KAction* xmlMoveItemUp;
	KAction* xmlMoveItemDown;
	KToolBarPopupAction* xmlExpandNode;
	KToolBarPopupAction* xmlCollapseNode;

	KAction* bookmarksToggle;
	KAction* bookmarksPrev;
	KAction* bookmarksNext;

	KToggleAction* settingsShowToolBar;
	KToggleAction* settingsShowXmlToolBar;
	KToggleAction* settingsShowPathBar;
	KToggleAction* settingsShowStatusBar;

	KXmlEditorComboAction* pathCombo;
};

#endif
