/***************************************************************************
 *   Copyright (C) 2004 Nadeem Hasan <nhasan@kde.org>                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef SYNCONFIGWIDGET_H
#define SYNCONFIGWIDGET_H

#include "synconfigwidgetbase.h"
#include "adjborderwizard.h"


class SynConfigWidget : public SynConfigWidgetBase
{
  Q_OBJECT

  public:
    SynConfigWidget( QWidget *parent, const char *name );
    void load();
    void save();

  protected slots:
    void useTappingChanged( bool );
    void useSmartModeChanged( bool );
    void useDockingChanged( bool );
    void tapFingerChanged( int );
    void tapButtonChanged( int );
    void scrollTriggerChanged( int );
    void horizScrollChanged( bool );
    void vertScrollChanged( bool );
    void circScrollChanged( bool );
    void alpsOptionClicked( );

    void widgetModified();
    void invokeBorderWizard();

    void enableDocking( bool );

    // disables completely everything ( in case there's no usable driver )
    void disableEverything( bool = true );
    // disabled everything ( when the pad is disabled on user's demand )
    void disableNearlyEverything( bool = true );

  signals:
    void changed();

  private:
    AdjBorderWizard *m_borderWizard;
};
#endif // SYNCONFIGWIDGET_H
