#line 1 "klscan.rl"
/*
 *  Copyright 2006 Adrian Thurston <thurston@cs.queensu.ca>
 */

/*  This file is part of Kelbt.
 *
 *  Kelbt is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Kelbt is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Kelbt; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
 */

#include <iostream>
#include <fstream>
#include <string.h>

#include "kelbt.h"
#include "klparse.h"

using std::ifstream;
using std::istream;
using std::ostream;
using std::cout;
using std::cerr;
using std::endl;


#line 39 "klscan.cpp"
static const int section_parser_start = 7;
static const int section_parser_first_final = 7;
static const int section_parser_error = 0;

static const int section_parser_en_main = 7;

#line 39 "klscan.rl"


struct Scanner
{
	Scanner( char *fileName, istream &input, 
			ParserDict &parserDict, int include_depth ) : 
		fileName(fileName), input(input), 
		parserDict(parserDict), include_depth(include_depth),
		parser(0), curline(1)
	{
		
#line 58 "klscan.cpp"
	{
	cs = section_parser_start;
	}
#line 50 "klscan.rl"
	}
	
	void startSection( bool singleLineSpec );
	void endSection();

	void do_scan();
	void try_token( int tokid );
	void try_token( int tokid, char *start, char *end );

	/* Open an error message with the file name and line. */
	ostream &error()
	{
		/* Keep the error count. */
		gblErrorCount += 1;
	
		cerr << fileName << ":" << curline << ": ";
		return cerr;
	}

	char *fileName;
	istream &input;
	ParserDict &parserDict;
	int include_depth;
	Parser *parser;
	int curline, inline_start_line;
	bool singleLineSpec;

	/* Write statements seen. */
	bool writeInstanceData;
	bool writeTokenDefs;
	bool writeTypes; 
	bool writeData;
	bool writeInit;
	bool writeExec;
	bool writeFinish;

	/* For section parser. */
	int cs;
	char *captured;
};

void Scanner::startSection( bool singleLineSpec )
{
	this->singleLineSpec = singleLineSpec;
	writeInstanceData = false;
	writeTokenDefs = false;
	writeTypes = false;
	writeData = false;
	writeInit = false;
	writeExec = false;
	writeFinish = false;
}

void Scanner::endSection()
{
	if ( !::generateGraphviz ) {
		if ( writeInstanceData )
			parser->pd.generateInstanceData();
		if ( writeTokenDefs )
			parser->pd.generateTokenDefs();
		if ( writeTypes )
			parser->pd.generateTypes();
		if ( writeInit )
			parser->pd.generateInit();
		if ( writeData )
			parser->pd.generateData();
		if ( writeExec )
			parser->pd.generateExec();
		if ( writeFinish )
			parser->pd.generateFinish();
		
		if ( ! inhibitLineDirectives )
			*outStream << "#line " << curline << " \"" << fileName << "\"\n";
	}
}

void Scanner::try_token( int tokid )
{
	try_token( tokid, 0, 0 );
}

void Scanner::try_token( int tokid, char *start, char *end )
{
	char *tokdata = 0;
	int *p = &tokid, *pe = &tokid + 1;

	if ( start != 0 ) {
		int len = end-start;
		tokdata = new char[len+1];
		memcpy( tokdata, start, len );
		tokdata[len] = 0;
	}


#line 157 "klscan.cpp"
	{
	if ( p == pe )
		goto _out;
	switch ( cs )
	{
tr2:
#line 151 "klscan.rl"
	{
		//cout << "PARSER STATEMENT" << endl;

		char *parserName = captured;
		ParserDictEl *pdEl = parserDict.find( parserName );
		if ( pdEl != 0 ) {
			//cout << "USING EXISTING PARSER" << endl;
			delete[] parserName;
		}
		else {
			//cout << "CREATING NEW PARSER" << endl;
			pdEl = new ParserDictEl;
			pdEl->name = parserName;
			pdEl->parser = new Parser( fileName, parserName, *outStream );
			pdEl->parser->init();
			parserDict.insert( pdEl );
		}

		parser = pdEl->parser;
	}
	goto st7;
tr4:
#line 173 "klscan.rl"
	{
		/* FIXME: Need to check for parser. */
		char *includeFileName = captured;

		//cout << "INCLUDE STATEMENT " << includeFileName << endl;

		/* Open the input file for reading. */
		ifstream *inFile = new ifstream( includeFileName );
		istream *inStream = inFile;
		if ( ! inFile->is_open() )
			error() << "include: could not open " << includeFileName << " for reading" << endl;

		Scanner subScanner( includeFileName, *inStream, parserDict, include_depth+1 );
		subScanner.do_scan();

		delete inFile;
	}
	goto st7;
tr6:
#line 192 "klscan.rl"
	{
		if ( include_depth == 0 ) {
			char *writeArg = captured;
			if ( strcmp( writeArg, "instance_data" ) == 0 )
				writeInstanceData = true;
			else if ( strcmp( writeArg, "token_defs" ) == 0 )
				writeTokenDefs = true;
			else if ( strcmp( writeArg, "types" ) == 0 )
				writeTypes = true;
			else if ( strcmp( writeArg, "data" ) == 0 )
				writeData = true;
			else if ( strcmp( writeArg, "init" ) == 0 )
				writeInit = true;
			else if ( strcmp( writeArg, "exec" ) == 0 )
				writeExec = true;
			else if ( strcmp( writeArg, "finish" ) == 0 )
				writeFinish = true;
		}
	}
	goto st7;
tr7:
#line 213 "klscan.rl"
	{
		if ( parser == 0 )
			error() << "no section name and no previously named section" << endl;
		else {
			int line = TK_Inline ? inline_start_line : curline;
			int result = parser->token( line, tokid, tokdata );
			if ( result < 0 )
				error() << "parse error on or near this line" << endl;
		}
	}
	goto st7;
st7:
	if ( ++p == pe )
		goto _out7;
case 7:
#line 245 "klscan.cpp"
	switch( (*p) ) {
		case 128: goto st1;
		case 129: goto st3;
		case 130: goto st5;
	}
	goto tr7;
st1:
	if ( ++p == pe )
		goto _out1;
case 1:
	if ( (*p) == 143 )
		goto tr0;
	goto st0;
st0:
	goto _out0;
tr0:
#line 224 "klscan.rl"
	{ captured = tokdata; }
	goto st2;
st2:
	if ( ++p == pe )
		goto _out2;
case 2:
#line 269 "klscan.cpp"
	if ( (*p) == 59 )
		goto tr2;
	goto st0;
st3:
	if ( ++p == pe )
		goto _out3;
case 3:
	if ( (*p) == 144 )
		goto tr3;
	goto st0;
tr3:
#line 225 "klscan.rl"
	{ captured = tokdata; }
	goto st4;
st4:
	if ( ++p == pe )
		goto _out4;
case 4:
#line 288 "klscan.cpp"
	if ( (*p) == 59 )
		goto tr4;
	goto st0;
st5:
	if ( ++p == pe )
		goto _out5;
case 5:
	if ( (*p) == 143 )
		goto tr5;
	goto st0;
tr5:
#line 224 "klscan.rl"
	{ captured = tokdata; }
	goto st6;
st6:
	if ( ++p == pe )
		goto _out6;
case 6:
#line 307 "klscan.cpp"
	if ( (*p) == 59 )
		goto tr6;
	goto st0;
	}
	_out7: cs = 7; goto _out; 
	_out1: cs = 1; goto _out; 
	_out0: cs = 0; goto _out; 
	_out2: cs = 2; goto _out; 
	_out3: cs = 3; goto _out; 
	_out4: cs = 4; goto _out; 
	_out5: cs = 5; goto _out; 
	_out6: cs = 6; goto _out; 

	_out: {}
	}
#line 241 "klscan.rl"

}

#line 383 "klscan.rl"



#line 331 "klscan.cpp"
static const int klscan_start = 21;
static const int klscan_first_final = 21;
static const int klscan_error = 0;

static const int klscan_en_inline_code = 30;
static const int klscan_en_access_stmt = 40;
static const int klscan_en_parser_def = 42;
static const int klscan_en_main = 21;

#line 386 "klscan.rl"

void Scanner::do_scan()
{
	int bufsize = 8;
	char *buf = new char[bufsize];
	const char last_char = 0;
	char *tokstart, *tokend;
	int cs, act, have = 0;
	int curly_count = 0;
	char *inline_start = 0;
	char *litstart = 0, *litend = 0;
	char *identstart = 0, *identend = 0;
	bool execute = true;

	
#line 357 "klscan.cpp"
	{
	cs = klscan_start;
	tokstart = 0;
	tokend = 0;
	act = 0;
	}
#line 401 "klscan.rl"

	while ( execute ) {
		char *p = buf + have;
		int space = bufsize - have;

		if ( space == 0 ) {
			/* We filled up the buffer trying to scan a token. Grow it. */
			bufsize = bufsize * 2;
			char *newbuf = new char[bufsize];
			//cout << "FULL BUFFER, NEW SIZE: " << bufsize << endl;

			/* Recompute p and space. */
			p = newbuf + have;
			space = bufsize - have;

			/* Patch up pointers possibly in use. */
			if ( tokstart != 0 )
				tokstart = newbuf + ( tokstart - buf );
			if ( inline_start != 0 )
				inline_start = newbuf + ( inline_start - buf );
			tokend = newbuf + ( tokend - buf );
			litstart = newbuf + ( litstart - buf );
			litend = newbuf + ( litend - buf );
			identstart = newbuf + ( identstart - buf );
			identend = newbuf + ( identend - buf );

			/* Copy the new buffer in. */
			memcpy( newbuf, buf, have );
			delete[] buf;
			buf = newbuf;
		}

		input.read( p, space );
		int len = input.gcount();

		/* If we see eof then append the EOF char. */
	 	if ( len == 0 ) {
			p[0] = last_char, len = 1;
			execute = false;
		}

		char *pe = p + len;
		
#line 408 "klscan.cpp"
	{
	if ( p == pe )
		goto _out;
	switch ( cs )
	{
tr1:
#line 359 "klscan.rl"
	{{
		if ( !generateGraphviz && gblErrorCount == 0 && include_depth == 0 )
			outStream->write( tokstart, tokend-tokstart );
	}{p = ((tokend))-1;}}
	goto st21;
tr2:
#line 359 "klscan.rl"
	{tokend = p+1;{
		if ( !generateGraphviz && gblErrorCount == 0 && include_depth == 0 )
			outStream->write( tokstart, tokend-tokstart );
	}{p = ((tokend))-1;}}
	goto st21;
tr9:
#line 359 "klscan.rl"
	{tokend = p+1;{
		if ( !generateGraphviz && gblErrorCount == 0 && include_depth == 0 )
			outStream->write( tokstart, tokend-tokstart );
	}{p = ((tokend))-1;}}
	goto st21;
tr11:
#line 251 "klscan.rl"
	{ curline++; }
#line 359 "klscan.rl"
	{tokend = p+1;{
		if ( !generateGraphviz && gblErrorCount == 0 && include_depth == 0 )
			outStream->write( tokstart, tokend-tokstart );
	}{p = ((tokend))-1;}}
	goto st21;
tr33:
#line 359 "klscan.rl"
	{tokend = p+1;{
		if ( !generateGraphviz && gblErrorCount == 0 && include_depth == 0 )
			outStream->write( tokstart, tokend-tokstart );
	}{p = ((tokend))-1;}}
	goto st21;
tr34:
#line 379 "klscan.rl"
	{tokend = p+1;{p = ((tokend))-1;}}
	goto st21;
tr43:
#line 359 "klscan.rl"
	{tokend = p;{
		if ( !generateGraphviz && gblErrorCount == 0 && include_depth == 0 )
			outStream->write( tokstart, tokend-tokstart );
	}{p = ((tokend))-1;}}
	goto st21;
tr44:
#line 359 "klscan.rl"
	{tokend = p;{
		if ( !generateGraphviz && gblErrorCount == 0 && include_depth == 0 )
			outStream->write( tokstart, tokend-tokstart );
	}{p = ((tokend))-1;}}
	goto st21;
tr46:
#line 370 "klscan.rl"
	{tokend = p;{
			startSection( true );
			{{p = ((tokend))-1;}{goto st42;}}
		}{p = ((tokend))-1;}}
	goto st21;
tr47:
#line 374 "klscan.rl"
	{tokend = p+1;{ 
			startSection( false );
			{{p = ((tokend))-1;}{goto st42;}}
		}{p = ((tokend))-1;}}
	goto st21;
tr48:
#line 359 "klscan.rl"
	{tokend = p;{
		if ( !generateGraphviz && gblErrorCount == 0 && include_depth == 0 )
			outStream->write( tokstart, tokend-tokstart );
	}{p = ((tokend))-1;}}
	goto st21;
tr49:
#line 359 "klscan.rl"
	{tokend = p;{
		if ( !generateGraphviz && gblErrorCount == 0 && include_depth == 0 )
			outStream->write( tokstart, tokend-tokstart );
	}{p = ((tokend))-1;}}
	goto st21;
st21:
#line 1 "klscan.rl"
	{tokstart = 0;}
	if ( ++p == pe )
		goto _out21;
case 21:
#line 1 "klscan.rl"
	{tokstart = p;}
#line 505 "klscan.cpp"
	switch( (*p) ) {
		case 0: goto tr34;
		case 9: goto st22;
		case 10: goto tr36;
		case 13: goto st22;
		case 32: goto st22;
		case 34: goto tr37;
		case 37: goto st24;
		case 39: goto tr39;
		case 47: goto tr40;
		case 95: goto st29;
	}
	if ( (*p) < 65 ) {
		if ( 48 <= (*p) && (*p) <= 57 )
			goto st28;
	} else if ( (*p) > 90 ) {
		if ( 97 <= (*p) && (*p) <= 122 )
			goto st29;
	} else
		goto st29;
	goto tr33;
tr36:
#line 251 "klscan.rl"
	{ curline++; }
	goto st22;
st22:
	if ( ++p == pe )
		goto _out22;
case 22:
#line 535 "klscan.cpp"
	switch( (*p) ) {
		case 9: goto st22;
		case 10: goto tr36;
		case 13: goto st22;
		case 32: goto st22;
	}
	goto tr43;
tr37:
#line 1 "klscan.rl"
	{tokend = p+1;}
	goto st23;
st23:
	if ( ++p == pe )
		goto _out23;
case 23:
#line 551 "klscan.cpp"
	switch( (*p) ) {
		case 10: goto tr44;
		case 13: goto tr44;
		case 34: goto tr2;
		case 92: goto st2;
	}
	goto st1;
st1:
	if ( ++p == pe )
		goto _out1;
case 1:
	switch( (*p) ) {
		case 10: goto tr1;
		case 13: goto tr1;
		case 34: goto tr2;
		case 92: goto st2;
	}
	goto st1;
st2:
	if ( ++p == pe )
		goto _out2;
case 2:
	if ( (*p) == 10 )
		goto tr1;
	goto st1;
st24:
	if ( ++p == pe )
		goto _out24;
case 24:
	if ( (*p) == 37 )
		goto st25;
	goto tr44;
st25:
	if ( ++p == pe )
		goto _out25;
case 25:
	if ( (*p) == 123 )
		goto tr47;
	goto tr46;
tr39:
#line 1 "klscan.rl"
	{tokend = p+1;}
	goto st26;
st26:
	if ( ++p == pe )
		goto _out26;
case 26:
#line 599 "klscan.cpp"
	switch( (*p) ) {
		case 10: goto tr44;
		case 13: goto tr44;
		case 39: goto tr2;
		case 92: goto st4;
	}
	goto st3;
st3:
	if ( ++p == pe )
		goto _out3;
case 3:
	switch( (*p) ) {
		case 10: goto tr1;
		case 13: goto tr1;
		case 39: goto tr2;
		case 92: goto st4;
	}
	goto st3;
st4:
	if ( ++p == pe )
		goto _out4;
case 4:
	if ( (*p) == 10 )
		goto tr1;
	goto st3;
tr40:
#line 1 "klscan.rl"
	{tokend = p+1;}
	goto st27;
st27:
	if ( ++p == pe )
		goto _out27;
case 27:
#line 633 "klscan.cpp"
	switch( (*p) ) {
		case 42: goto st5;
		case 47: goto st7;
	}
	goto tr44;
tr7:
#line 251 "klscan.rl"
	{ curline++; }
	goto st5;
st5:
	if ( ++p == pe )
		goto _out5;
case 5:
#line 647 "klscan.cpp"
	switch( (*p) ) {
		case 10: goto tr7;
		case 42: goto st6;
	}
	goto st5;
st6:
	if ( ++p == pe )
		goto _out6;
case 6:
	switch( (*p) ) {
		case 10: goto tr7;
		case 42: goto st6;
		case 47: goto tr9;
	}
	goto st5;
st7:
	if ( ++p == pe )
		goto _out7;
case 7:
	if ( (*p) == 10 )
		goto tr11;
	goto st7;
st28:
	if ( ++p == pe )
		goto _out28;
case 28:
	if ( 48 <= (*p) && (*p) <= 57 )
		goto st28;
	goto tr48;
st29:
	if ( ++p == pe )
		goto _out29;
case 29:
	if ( (*p) == 95 )
		goto st29;
	if ( (*p) < 65 ) {
		if ( 48 <= (*p) && (*p) <= 57 )
			goto st29;
	} else if ( (*p) > 90 ) {
		if ( 97 <= (*p) && (*p) <= 122 )
			goto st29;
	} else
		goto st29;
	goto tr49;
tr13:
#line 291 "klscan.rl"
	{{p = ((tokend))-1;}}
	goto st30;
tr14:
#line 270 "klscan.rl"
	{tokend = p+1;{p = ((tokend))-1;}}
	goto st30;
tr21:
#line 269 "klscan.rl"
	{tokend = p+1;{p = ((tokend))-1;}}
	goto st30;
tr23:
#line 251 "klscan.rl"
	{ curline++; }
#line 269 "klscan.rl"
	{tokend = p+1;{p = ((tokend))-1;}}
	goto st30;
tr50:
#line 291 "klscan.rl"
	{tokend = p+1;{p = ((tokend))-1;}}
	goto st30;
tr60:
#line 273 "klscan.rl"
	{tokend = p+1;{ curly_count += 1; }{p = ((tokend))-1;}}
	goto st30;
tr61:
#line 275 "klscan.rl"
	{tokend = p+1;{ 
			if ( --curly_count == 0 ) {
				/* Send the entire block and free the inline_start pointer. */
				try_token( TK_Inline, inline_start, tokend );
				inline_start = 0;
				{{p = ((tokend))-1;}{goto st42;}}
			}
		}{p = ((tokend))-1;}}
	goto st30;
tr62:
#line 271 "klscan.rl"
	{tokend = p;{p = ((tokend))-1;}}
	goto st30;
tr63:
#line 291 "klscan.rl"
	{tokend = p;{p = ((tokend))-1;}}
	goto st30;
tr64:
#line 284 "klscan.rl"
	{tokend = p+1;{
			if ( inline_start < tokstart )
				try_token( TK_Inline, inline_start, tokstart );
			try_token( TK_Reference, tokstart, tokend );
			inline_start = tokend;
		}{p = ((tokend))-1;}}
	goto st30;
tr66:
#line 284 "klscan.rl"
	{tokend = p;{
			if ( inline_start < tokstart )
				try_token( TK_Inline, inline_start, tokstart );
			try_token( TK_Reference, tokstart, tokend );
			inline_start = tokend;
		}{p = ((tokend))-1;}}
	goto st30;
tr67:
#line 268 "klscan.rl"
	{tokend = p;{p = ((tokend))-1;}}
	goto st30;
tr68:
#line 267 "klscan.rl"
	{tokend = p;{p = ((tokend))-1;}}
	goto st30;
st30:
#line 1 "klscan.rl"
	{tokstart = 0;}
	if ( ++p == pe )
		goto _out30;
case 30:
#line 1 "klscan.rl"
	{tokstart = p;}
#line 771 "klscan.cpp"
	switch( (*p) ) {
		case 9: goto st31;
		case 10: goto tr52;
		case 13: goto st31;
		case 32: goto st31;
		case 34: goto tr53;
		case 36: goto st33;
		case 39: goto tr55;
		case 47: goto tr56;
		case 64: goto st38;
		case 95: goto st39;
		case 123: goto tr60;
		case 125: goto tr61;
	}
	if ( (*p) < 65 ) {
		if ( 48 <= (*p) && (*p) <= 57 )
			goto st37;
	} else if ( (*p) > 90 ) {
		if ( 97 <= (*p) && (*p) <= 122 )
			goto st39;
	} else
		goto st39;
	goto tr50;
tr52:
#line 251 "klscan.rl"
	{ curline++; }
	goto st31;
st31:
	if ( ++p == pe )
		goto _out31;
case 31:
#line 803 "klscan.cpp"
	switch( (*p) ) {
		case 9: goto st31;
		case 10: goto tr52;
		case 13: goto st31;
		case 32: goto st31;
	}
	goto tr62;
tr53:
#line 1 "klscan.rl"
	{tokend = p+1;}
	goto st32;
st32:
	if ( ++p == pe )
		goto _out32;
case 32:
#line 819 "klscan.cpp"
	switch( (*p) ) {
		case 10: goto tr63;
		case 13: goto tr63;
		case 34: goto tr14;
		case 92: goto st9;
	}
	goto st8;
st8:
	if ( ++p == pe )
		goto _out8;
case 8:
	switch( (*p) ) {
		case 10: goto tr13;
		case 13: goto tr13;
		case 34: goto tr14;
		case 92: goto st9;
	}
	goto st8;
st9:
	if ( ++p == pe )
		goto _out9;
case 9:
	if ( (*p) == 10 )
		goto tr13;
	goto st8;
st33:
	if ( ++p == pe )
		goto _out33;
case 33:
	if ( (*p) == 36 )
		goto tr64;
	if ( 48 <= (*p) && (*p) <= 57 )
		goto st34;
	goto tr63;
st34:
	if ( ++p == pe )
		goto _out34;
case 34:
	if ( 48 <= (*p) && (*p) <= 57 )
		goto st34;
	goto tr66;
tr55:
#line 1 "klscan.rl"
	{tokend = p+1;}
	goto st35;
st35:
	if ( ++p == pe )
		goto _out35;
case 35:
#line 869 "klscan.cpp"
	switch( (*p) ) {
		case 10: goto tr63;
		case 13: goto tr63;
		case 39: goto tr14;
		case 92: goto st11;
	}
	goto st10;
st10:
	if ( ++p == pe )
		goto _out10;
case 10:
	switch( (*p) ) {
		case 10: goto tr13;
		case 13: goto tr13;
		case 39: goto tr14;
		case 92: goto st11;
	}
	goto st10;
st11:
	if ( ++p == pe )
		goto _out11;
case 11:
	if ( (*p) == 10 )
		goto tr13;
	goto st10;
tr56:
#line 1 "klscan.rl"
	{tokend = p+1;}
	goto st36;
st36:
	if ( ++p == pe )
		goto _out36;
case 36:
#line 903 "klscan.cpp"
	switch( (*p) ) {
		case 42: goto st12;
		case 47: goto st14;
	}
	goto tr63;
tr19:
#line 251 "klscan.rl"
	{ curline++; }
	goto st12;
st12:
	if ( ++p == pe )
		goto _out12;
case 12:
#line 917 "klscan.cpp"
	switch( (*p) ) {
		case 10: goto tr19;
		case 42: goto st13;
	}
	goto st12;
st13:
	if ( ++p == pe )
		goto _out13;
case 13:
	switch( (*p) ) {
		case 10: goto tr19;
		case 42: goto st13;
		case 47: goto tr21;
	}
	goto st12;
st14:
	if ( ++p == pe )
		goto _out14;
case 14:
	if ( (*p) == 10 )
		goto tr23;
	goto st14;
st37:
	if ( ++p == pe )
		goto _out37;
case 37:
	if ( 48 <= (*p) && (*p) <= 57 )
		goto st37;
	goto tr67;
st38:
	if ( ++p == pe )
		goto _out38;
case 38:
	if ( (*p) == 64 )
		goto tr64;
	if ( 48 <= (*p) && (*p) <= 57 )
		goto st34;
	goto tr63;
st39:
	if ( ++p == pe )
		goto _out39;
case 39:
	if ( (*p) == 95 )
		goto st39;
	if ( (*p) < 65 ) {
		if ( 48 <= (*p) && (*p) <= 57 )
			goto st39;
	} else if ( (*p) > 90 ) {
		if ( 97 <= (*p) && (*p) <= 122 )
			goto st39;
	} else
		goto st39;
	goto tr68;
tr71:
#line 296 "klscan.rl"
	{tokend = p+1;{ 
			try_token( ';' ); 
			{{p = ((tokend))-1;}{goto st42;}}
		}{p = ((tokend))-1;}}
	goto st40;
tr72:
#line 295 "klscan.rl"
	{tokend = p;{ try_token( TK_AccessData, tokstart, tokend ); }{p = ((tokend))-1;}}
	goto st40;
st40:
#line 1 "klscan.rl"
	{tokstart = 0;}
	if ( ++p == pe )
		goto _out40;
case 40:
#line 1 "klscan.rl"
	{tokstart = p;}
#line 990 "klscan.cpp"
	switch( (*p) ) {
		case 0: goto st0;
		case 59: goto tr71;
	}
	goto st41;
st41:
	if ( ++p == pe )
		goto _out41;
case 41:
	switch( (*p) ) {
		case 0: goto tr72;
		case 59: goto tr72;
	}
	goto st41;
st0:
	goto _out0;
tr25:
#line 356 "klscan.rl"
	{{ try_token( *tokstart, 0, 0 ); }{p = ((tokend))-1;}}
	goto st42;
tr26:
#line 330 "klscan.rl"
	{tokend = p+1;{ try_token( TK_String, tokstart+1, tokend-1 ); }{p = ((tokend))-1;}}
	goto st42;
tr29:
#line 251 "klscan.rl"
	{ curline++; }
#line 333 "klscan.rl"
	{tokend = p+1;{p = ((tokend))-1;}}
	goto st42;
tr30:
#line 329 "klscan.rl"
	{tokend = p+1;{ try_token( TK_Literal, tokstart+1, tokend-1 ); }{p = ((tokend))-1;}}
	goto st42;
tr32:
#line 335 "klscan.rl"
	{tokend = p+1;{ 
			endSection();
			{{p = ((tokend))-1;}{goto st21;}}
		}{p = ((tokend))-1;}}
	goto st42;
tr73:
#line 356 "klscan.rl"
	{tokend = p+1;{ try_token( *tokstart, 0, 0 ); }{p = ((tokend))-1;}}
	goto st42;
tr75:
#line 251 "klscan.rl"
	{ curline++; }
#line 342 "klscan.rl"
	{tokend = p+1;{
			if ( singleLineSpec ) {
				endSection();
				{{p = ((tokend))-1;}{goto st21;}}
			}
		}{p = ((tokend))-1;}}
	goto st42;
tr91:
#line 349 "klscan.rl"
	{tokend = p+1;{ 
			inline_start_line = curline;
			inline_start = tokstart;
			curly_count = 1; 
			{{p = ((tokend))-1;}{goto st30;}}
		}{p = ((tokend))-1;}}
	goto st42;
tr93:
#line 340 "klscan.rl"
	{tokend = p;{p = ((tokend))-1;}}
	goto st42;
tr94:
#line 356 "klscan.rl"
	{tokend = p;{ try_token( *tokstart, 0, 0 ); }{p = ((tokend))-1;}}
	goto st42;
tr96:
#line 331 "klscan.rl"
	{tokend = p;{ try_token( TK_Number, tokstart, tokend ); }{p = ((tokend))-1;}}
	goto st42;
tr97:
#line 1 "klscan.rl"
	{	switch( act ) {
	case 12:
	{ try_token( KW_Commit ); }
	break;
	case 13:
	{ try_token( KW_Try ); }
	break;
	case 14:
	{ try_token( KW_Undo ); }
	break;
	case 15:
	{ try_token( KW_Final ); }
	break;
	case 16:
	{ try_token( KW_Translate ); }
	break;
	case 17:
	{ try_token( KW_Token ); }
	break;
	case 18:
	{ try_token( KW_NonTerm ); }
	break;
	case 19:
	{ try_token( KW_Uses ); }
	break;
	case 20:
	{ try_token( KW_Type ); }
	break;
	case 21:
	{ try_token( KW_Parser ); }
	break;
	case 22:
	{ try_token( KW_Include ); }
	break;
	case 23:
	{ try_token( KW_Pri ); }
	break;
	case 24:
	{ try_token( KW_Write ); }
	break;
	case 25:
	{ try_token( KW_Class ); }
	break;
	case 26:
	{ try_token( KW_Shortest ); }
	break;
	case 28:
	{ try_token( TK_Word, tokstart, tokend ); }
	break;
	default: break;
	}
	{p = ((tokend))-1;}}
	goto st42;
tr98:
#line 328 "klscan.rl"
	{tokend = p;{ try_token( TK_Word, tokstart, tokend ); }{p = ((tokend))-1;}}
	goto st42;
tr104:
#line 320 "klscan.rl"
	{tokend = p;{ 
			try_token( KW_Access );
			{{p = ((tokend))-1;}{goto st40;}}
		}{p = ((tokend))-1;}}
	goto st42;
st42:
#line 1 "klscan.rl"
	{tokstart = 0;}
	if ( ++p == pe )
		goto _out42;
case 42:
#line 1 "klscan.rl"
	{tokstart = p;}
#line 1142 "klscan.cpp"
	switch( (*p) ) {
		case 9: goto st43;
		case 10: goto tr75;
		case 13: goto st43;
		case 32: goto st43;
		case 34: goto tr76;
		case 35: goto tr77;
		case 39: goto tr78;
		case 95: goto tr80;
		case 97: goto st49;
		case 99: goto st56;
		case 102: goto st64;
		case 105: goto st68;
		case 110: goto st74;
		case 112: goto st80;
		case 115: goto st86;
		case 116: goto st93;
		case 117: goto st106;
		case 119: goto st111;
		case 123: goto tr91;
		case 125: goto tr92;
	}
	if ( (*p) < 65 ) {
		if ( 48 <= (*p) && (*p) <= 57 )
			goto st47;
	} else if ( (*p) > 90 ) {
		if ( 98 <= (*p) && (*p) <= 122 )
			goto tr80;
	} else
		goto tr80;
	goto tr73;
st43:
	if ( ++p == pe )
		goto _out43;
case 43:
	switch( (*p) ) {
		case 9: goto st43;
		case 13: goto st43;
		case 32: goto st43;
	}
	goto tr93;
tr76:
#line 1 "klscan.rl"
	{tokend = p+1;}
	goto st44;
st44:
	if ( ++p == pe )
		goto _out44;
case 44:
#line 1192 "klscan.cpp"
	switch( (*p) ) {
		case 10: goto tr94;
		case 13: goto tr94;
		case 34: goto tr26;
		case 92: goto st16;
	}
	goto st15;
st15:
	if ( ++p == pe )
		goto _out15;
case 15:
	switch( (*p) ) {
		case 10: goto tr25;
		case 13: goto tr25;
		case 34: goto tr26;
		case 92: goto st16;
	}
	goto st15;
st16:
	if ( ++p == pe )
		goto _out16;
case 16:
	if ( (*p) == 10 )
		goto tr25;
	goto st15;
tr77:
#line 1 "klscan.rl"
	{tokend = p+1;}
	goto st45;
st45:
	if ( ++p == pe )
		goto _out45;
case 45:
#line 1226 "klscan.cpp"
	if ( (*p) == 10 )
		goto tr29;
	goto st17;
st17:
	if ( ++p == pe )
		goto _out17;
case 17:
	if ( (*p) == 10 )
		goto tr29;
	goto st17;
tr78:
#line 1 "klscan.rl"
	{tokend = p+1;}
	goto st46;
st46:
	if ( ++p == pe )
		goto _out46;
case 46:
#line 1245 "klscan.cpp"
	switch( (*p) ) {
		case 10: goto tr94;
		case 13: goto tr94;
		case 39: goto tr94;
		case 92: goto st19;
	}
	goto st18;
st18:
	if ( ++p == pe )
		goto _out18;
case 18:
	if ( (*p) == 39 )
		goto tr30;
	goto tr25;
st19:
	if ( ++p == pe )
		goto _out19;
case 19:
	goto st18;
st47:
	if ( ++p == pe )
		goto _out47;
case 47:
	if ( 48 <= (*p) && (*p) <= 57 )
		goto st47;
	goto tr96;
tr80:
#line 1 "klscan.rl"
	{tokend = p+1;}
#line 328 "klscan.rl"
	{act = 28;}
	goto st48;
tr111:
#line 1 "klscan.rl"
	{tokend = p+1;}
#line 317 "klscan.rl"
	{act = 25;}
	goto st48;
tr115:
#line 1 "klscan.rl"
	{tokend = p+1;}
#line 304 "klscan.rl"
	{act = 12;}
	goto st48;
tr119:
#line 1 "klscan.rl"
	{tokend = p+1;}
#line 307 "klscan.rl"
	{act = 15;}
	goto st48;
tr125:
#line 1 "klscan.rl"
	{tokend = p+1;}
#line 314 "klscan.rl"
	{act = 22;}
	goto st48;
tr131:
#line 1 "klscan.rl"
	{tokend = p+1;}
#line 310 "klscan.rl"
	{act = 18;}
	goto st48;
tr137:
#line 1 "klscan.rl"
	{tokend = p+1;}
#line 313 "klscan.rl"
	{act = 21;}
	goto st48;
tr138:
#line 1 "klscan.rl"
	{tokend = p+1;}
#line 315 "klscan.rl"
	{act = 23;}
	goto st48;
tr145:
#line 1 "klscan.rl"
	{tokend = p+1;}
#line 318 "klscan.rl"
	{act = 26;}
	goto st48;
tr151:
#line 1 "klscan.rl"
	{tokend = p+1;}
#line 309 "klscan.rl"
	{act = 17;}
	goto st48;
tr153:
#line 1 "klscan.rl"
	{tokend = p+1;}
#line 305 "klscan.rl"
	{act = 13;}
	goto st48;
tr159:
#line 1 "klscan.rl"
	{tokend = p+1;}
#line 308 "klscan.rl"
	{act = 16;}
	goto st48;
tr161:
#line 1 "klscan.rl"
	{tokend = p+1;}
#line 312 "klscan.rl"
	{act = 20;}
	goto st48;
tr165:
#line 1 "klscan.rl"
	{tokend = p+1;}
#line 306 "klscan.rl"
	{act = 14;}
	goto st48;
tr167:
#line 1 "klscan.rl"
	{tokend = p+1;}
#line 311 "klscan.rl"
	{act = 19;}
	goto st48;
tr171:
#line 1 "klscan.rl"
	{tokend = p+1;}
#line 316 "klscan.rl"
	{act = 24;}
	goto st48;
st48:
	if ( ++p == pe )
		goto _out48;
case 48:
#line 1372 "klscan.cpp"
	if ( (*p) == 95 )
		goto tr80;
	if ( (*p) < 65 ) {
		if ( 48 <= (*p) && (*p) <= 57 )
			goto tr80;
	} else if ( (*p) > 90 ) {
		if ( 97 <= (*p) && (*p) <= 122 )
			goto tr80;
	} else
		goto tr80;
	goto tr97;
st49:
	if ( ++p == pe )
		goto _out49;
case 49:
	switch( (*p) ) {
		case 95: goto tr80;
		case 99: goto st50;
	}
	if ( (*p) < 65 ) {
		if ( 48 <= (*p) && (*p) <= 57 )
			goto tr80;
	} else if ( (*p) > 90 ) {
		if ( 97 <= (*p) && (*p) <= 122 )
			goto tr80;
	} else
		goto tr80;
	goto tr98;
st50:
	if ( ++p == pe )
		goto _out50;
case 50:
	switch( (*p) ) {
		case 95: goto tr80;
		case 99: goto st51;
	}
	if ( (*p) < 65 ) {
		if ( 48 <= (*p) && (*p) <= 57 )
			goto tr80;
	} else if ( (*p) > 90 ) {
		if ( 97 <= (*p) && (*p) <= 122 )
			goto tr80;
	} else
		goto tr80;
	goto tr98;
st51:
	if ( ++p == pe )
		goto _out51;
case 51:
	switch( (*p) ) {
		case 95: goto tr80;
		case 101: goto st52;
	}
	if ( (*p) < 65 ) {
		if ( 48 <= (*p) && (*p) <= 57 )
			goto tr80;
	} else if ( (*p) > 90 ) {
		if ( 97 <= (*p) && (*p) <= 122 )
			goto tr80;
	} else
		goto tr80;
	goto tr98;
st52:
	if ( ++p == pe )
		goto _out52;
case 52:
	switch( (*p) ) {
		case 95: goto tr80;
		case 115: goto st53;
	}
	if ( (*p) < 65 ) {
		if ( 48 <= (*p) && (*p) <= 57 )
			goto tr80;
	} else if ( (*p) > 90 ) {
		if ( 97 <= (*p) && (*p) <= 122 )
			goto tr80;
	} else
		goto tr80;
	goto tr98;
st53:
	if ( ++p == pe )
		goto _out53;
case 53:
	switch( (*p) ) {
		case 95: goto tr80;
		case 115: goto st54;
	}
	if ( (*p) < 65 ) {
		if ( 48 <= (*p) && (*p) <= 57 )
			goto tr80;
	} else if ( (*p) > 90 ) {
		if ( 97 <= (*p) && (*p) <= 122 )
			goto tr80;
	} else
		goto tr80;
	goto tr98;
st54:
	if ( ++p == pe )
		goto _out54;
case 54:
	switch( (*p) ) {
		case 9: goto st55;
		case 10: goto tr106;
		case 13: goto st55;
		case 32: goto st55;
		case 95: goto tr80;
	}
	if ( (*p) < 65 ) {
		if ( 48 <= (*p) && (*p) <= 57 )
			goto tr80;
	} else if ( (*p) > 90 ) {
		if ( 97 <= (*p) && (*p) <= 122 )
			goto tr80;
	} else
		goto tr80;
	goto tr104;
tr106:
#line 251 "klscan.rl"
	{ curline++; }
	goto st55;
st55:
	if ( ++p == pe )
		goto _out55;
case 55:
#line 1497 "klscan.cpp"
	switch( (*p) ) {
		case 9: goto st55;
		case 10: goto tr106;
		case 13: goto st55;
		case 32: goto st55;
	}
	goto tr104;
st56:
	if ( ++p == pe )
		goto _out56;
case 56:
	switch( (*p) ) {
		case 95: goto tr80;
		case 108: goto st57;
		case 111: goto st60;
	}
	if ( (*p) < 65 ) {
		if ( 48 <= (*p) && (*p) <= 57 )
			goto tr80;
	} else if ( (*p) > 90 ) {
		if ( 97 <= (*p) && (*p) <= 122 )
			goto tr80;
	} else
		goto tr80;
	goto tr98;
st57:
	if ( ++p == pe )
		goto _out57;
case 57:
	switch( (*p) ) {
		case 95: goto tr80;
		case 97: goto st58;
	}
	if ( (*p) < 65 ) {
		if ( 48 <= (*p) && (*p) <= 57 )
			goto tr80;
	} else if ( (*p) > 90 ) {
		if ( 98 <= (*p) && (*p) <= 122 )
			goto tr80;
	} else
		goto tr80;
	goto tr98;
st58:
	if ( ++p == pe )
		goto _out58;
case 58:
	switch( (*p) ) {
		case 95: goto tr80;
		case 115: goto st59;
	}
	if ( (*p) < 65 ) {
		if ( 48 <= (*p) && (*p) <= 57 )
			goto tr80;
	} else if ( (*p) > 90 ) {
		if ( 97 <= (*p) && (*p) <= 122 )
			goto tr80;
	} else
		goto tr80;
	goto tr98;
st59:
	if ( ++p == pe )
		goto _out59;
case 59:
	switch( (*p) ) {
		case 95: goto tr80;
		case 115: goto tr111;
	}
	if ( (*p) < 65 ) {
		if ( 48 <= (*p) && (*p) <= 57 )
			goto tr80;
	} else if ( (*p) > 90 ) {
		if ( 97 <= (*p) && (*p) <= 122 )
			goto tr80;
	} else
		goto tr80;
	goto tr98;
st60:
	if ( ++p == pe )
		goto _out60;
case 60:
	switch( (*p) ) {
		case 95: goto tr80;
		case 109: goto st61;
	}
	if ( (*p) < 65 ) {
		if ( 48 <= (*p) && (*p) <= 57 )
			goto tr80;
	} else if ( (*p) > 90 ) {
		if ( 97 <= (*p) && (*p) <= 122 )
			goto tr80;
	} else
		goto tr80;
	goto tr98;
st61:
	if ( ++p == pe )
		goto _out61;
case 61:
	switch( (*p) ) {
		case 95: goto tr80;
		case 109: goto st62;
	}
	if ( (*p) < 65 ) {
		if ( 48 <= (*p) && (*p) <= 57 )
			goto tr80;
	} else if ( (*p) > 90 ) {
		if ( 97 <= (*p) && (*p) <= 122 )
			goto tr80;
	} else
		goto tr80;
	goto tr98;
st62:
	if ( ++p == pe )
		goto _out62;
case 62:
	switch( (*p) ) {
		case 95: goto tr80;
		case 105: goto st63;
	}
	if ( (*p) < 65 ) {
		if ( 48 <= (*p) && (*p) <= 57 )
			goto tr80;
	} else if ( (*p) > 90 ) {
		if ( 97 <= (*p) && (*p) <= 122 )
			goto tr80;
	} else
		goto tr80;
	goto tr98;
st63:
	if ( ++p == pe )
		goto _out63;
case 63:
	switch( (*p) ) {
		case 95: goto tr80;
		case 116: goto tr115;
	}
	if ( (*p) < 65 ) {
		if ( 48 <= (*p) && (*p) <= 57 )
			goto tr80;
	} else if ( (*p) > 90 ) {
		if ( 97 <= (*p) && (*p) <= 122 )
			goto tr80;
	} else
		goto tr80;
	goto tr98;
st64:
	if ( ++p == pe )
		goto _out64;
case 64:
	switch( (*p) ) {
		case 95: goto tr80;
		case 105: goto st65;
	}
	if ( (*p) < 65 ) {
		if ( 48 <= (*p) && (*p) <= 57 )
			goto tr80;
	} else if ( (*p) > 90 ) {
		if ( 97 <= (*p) && (*p) <= 122 )
			goto tr80;
	} else
		goto tr80;
	goto tr98;
st65:
	if ( ++p == pe )
		goto _out65;
case 65:
	switch( (*p) ) {
		case 95: goto tr80;
		case 110: goto st66;
	}
	if ( (*p) < 65 ) {
		if ( 48 <= (*p) && (*p) <= 57 )
			goto tr80;
	} else if ( (*p) > 90 ) {
		if ( 97 <= (*p) && (*p) <= 122 )
			goto tr80;
	} else
		goto tr80;
	goto tr98;
st66:
	if ( ++p == pe )
		goto _out66;
case 66:
	switch( (*p) ) {
		case 95: goto tr80;
		case 97: goto st67;
	}
	if ( (*p) < 65 ) {
		if ( 48 <= (*p) && (*p) <= 57 )
			goto tr80;
	} else if ( (*p) > 90 ) {
		if ( 98 <= (*p) && (*p) <= 122 )
			goto tr80;
	} else
		goto tr80;
	goto tr98;
st67:
	if ( ++p == pe )
		goto _out67;
case 67:
	switch( (*p) ) {
		case 95: goto tr80;
		case 108: goto tr119;
	}
	if ( (*p) < 65 ) {
		if ( 48 <= (*p) && (*p) <= 57 )
			goto tr80;
	} else if ( (*p) > 90 ) {
		if ( 97 <= (*p) && (*p) <= 122 )
			goto tr80;
	} else
		goto tr80;
	goto tr98;
st68:
	if ( ++p == pe )
		goto _out68;
case 68:
	switch( (*p) ) {
		case 95: goto tr80;
		case 110: goto st69;
	}
	if ( (*p) < 65 ) {
		if ( 48 <= (*p) && (*p) <= 57 )
			goto tr80;
	} else if ( (*p) > 90 ) {
		if ( 97 <= (*p) && (*p) <= 122 )
			goto tr80;
	} else
		goto tr80;
	goto tr98;
st69:
	if ( ++p == pe )
		goto _out69;
case 69:
	switch( (*p) ) {
		case 95: goto tr80;
		case 99: goto st70;
	}
	if ( (*p) < 65 ) {
		if ( 48 <= (*p) && (*p) <= 57 )
			goto tr80;
	} else if ( (*p) > 90 ) {
		if ( 97 <= (*p) && (*p) <= 122 )
			goto tr80;
	} else
		goto tr80;
	goto tr98;
st70:
	if ( ++p == pe )
		goto _out70;
case 70:
	switch( (*p) ) {
		case 95: goto tr80;
		case 108: goto st71;
	}
	if ( (*p) < 65 ) {
		if ( 48 <= (*p) && (*p) <= 57 )
			goto tr80;
	} else if ( (*p) > 90 ) {
		if ( 97 <= (*p) && (*p) <= 122 )
			goto tr80;
	} else
		goto tr80;
	goto tr98;
st71:
	if ( ++p == pe )
		goto _out71;
case 71:
	switch( (*p) ) {
		case 95: goto tr80;
		case 117: goto st72;
	}
	if ( (*p) < 65 ) {
		if ( 48 <= (*p) && (*p) <= 57 )
			goto tr80;
	} else if ( (*p) > 90 ) {
		if ( 97 <= (*p) && (*p) <= 122 )
			goto tr80;
	} else
		goto tr80;
	goto tr98;
st72:
	if ( ++p == pe )
		goto _out72;
case 72:
	switch( (*p) ) {
		case 95: goto tr80;
		case 100: goto st73;
	}
	if ( (*p) < 65 ) {
		if ( 48 <= (*p) && (*p) <= 57 )
			goto tr80;
	} else if ( (*p) > 90 ) {
		if ( 97 <= (*p) && (*p) <= 122 )
			goto tr80;
	} else
		goto tr80;
	goto tr98;
st73:
	if ( ++p == pe )
		goto _out73;
case 73:
	switch( (*p) ) {
		case 95: goto tr80;
		case 101: goto tr125;
	}
	if ( (*p) < 65 ) {
		if ( 48 <= (*p) && (*p) <= 57 )
			goto tr80;
	} else if ( (*p) > 90 ) {
		if ( 97 <= (*p) && (*p) <= 122 )
			goto tr80;
	} else
		goto tr80;
	goto tr98;
st74:
	if ( ++p == pe )
		goto _out74;
case 74:
	switch( (*p) ) {
		case 95: goto tr80;
		case 111: goto st75;
	}
	if ( (*p) < 65 ) {
		if ( 48 <= (*p) && (*p) <= 57 )
			goto tr80;
	} else if ( (*p) > 90 ) {
		if ( 97 <= (*p) && (*p) <= 122 )
			goto tr80;
	} else
		goto tr80;
	goto tr98;
st75:
	if ( ++p == pe )
		goto _out75;
case 75:
	switch( (*p) ) {
		case 95: goto tr80;
		case 110: goto st76;
	}
	if ( (*p) < 65 ) {
		if ( 48 <= (*p) && (*p) <= 57 )
			goto tr80;
	} else if ( (*p) > 90 ) {
		if ( 97 <= (*p) && (*p) <= 122 )
			goto tr80;
	} else
		goto tr80;
	goto tr98;
st76:
	if ( ++p == pe )
		goto _out76;
case 76:
	switch( (*p) ) {
		case 95: goto tr80;
		case 116: goto st77;
	}
	if ( (*p) < 65 ) {
		if ( 48 <= (*p) && (*p) <= 57 )
			goto tr80;
	} else if ( (*p) > 90 ) {
		if ( 97 <= (*p) && (*p) <= 122 )
			goto tr80;
	} else
		goto tr80;
	goto tr98;
st77:
	if ( ++p == pe )
		goto _out77;
case 77:
	switch( (*p) ) {
		case 95: goto tr80;
		case 101: goto st78;
	}
	if ( (*p) < 65 ) {
		if ( 48 <= (*p) && (*p) <= 57 )
			goto tr80;
	} else if ( (*p) > 90 ) {
		if ( 97 <= (*p) && (*p) <= 122 )
			goto tr80;
	} else
		goto tr80;
	goto tr98;
st78:
	if ( ++p == pe )
		goto _out78;
case 78:
	switch( (*p) ) {
		case 95: goto tr80;
		case 114: goto st79;
	}
	if ( (*p) < 65 ) {
		if ( 48 <= (*p) && (*p) <= 57 )
			goto tr80;
	} else if ( (*p) > 90 ) {
		if ( 97 <= (*p) && (*p) <= 122 )
			goto tr80;
	} else
		goto tr80;
	goto tr98;
st79:
	if ( ++p == pe )
		goto _out79;
case 79:
	switch( (*p) ) {
		case 95: goto tr80;
		case 109: goto tr131;
	}
	if ( (*p) < 65 ) {
		if ( 48 <= (*p) && (*p) <= 57 )
			goto tr80;
	} else if ( (*p) > 90 ) {
		if ( 97 <= (*p) && (*p) <= 122 )
			goto tr80;
	} else
		goto tr80;
	goto tr98;
st80:
	if ( ++p == pe )
		goto _out80;
case 80:
	switch( (*p) ) {
		case 95: goto tr80;
		case 97: goto st81;
		case 114: goto st85;
	}
	if ( (*p) < 65 ) {
		if ( 48 <= (*p) && (*p) <= 57 )
			goto tr80;
	} else if ( (*p) > 90 ) {
		if ( 98 <= (*p) && (*p) <= 122 )
			goto tr80;
	} else
		goto tr80;
	goto tr98;
st81:
	if ( ++p == pe )
		goto _out81;
case 81:
	switch( (*p) ) {
		case 95: goto tr80;
		case 114: goto st82;
	}
	if ( (*p) < 65 ) {
		if ( 48 <= (*p) && (*p) <= 57 )
			goto tr80;
	} else if ( (*p) > 90 ) {
		if ( 97 <= (*p) && (*p) <= 122 )
			goto tr80;
	} else
		goto tr80;
	goto tr98;
st82:
	if ( ++p == pe )
		goto _out82;
case 82:
	switch( (*p) ) {
		case 95: goto tr80;
		case 115: goto st83;
	}
	if ( (*p) < 65 ) {
		if ( 48 <= (*p) && (*p) <= 57 )
			goto tr80;
	} else if ( (*p) > 90 ) {
		if ( 97 <= (*p) && (*p) <= 122 )
			goto tr80;
	} else
		goto tr80;
	goto tr98;
st83:
	if ( ++p == pe )
		goto _out83;
case 83:
	switch( (*p) ) {
		case 95: goto tr80;
		case 101: goto st84;
	}
	if ( (*p) < 65 ) {
		if ( 48 <= (*p) && (*p) <= 57 )
			goto tr80;
	} else if ( (*p) > 90 ) {
		if ( 97 <= (*p) && (*p) <= 122 )
			goto tr80;
	} else
		goto tr80;
	goto tr98;
st84:
	if ( ++p == pe )
		goto _out84;
case 84:
	switch( (*p) ) {
		case 95: goto tr80;
		case 114: goto tr137;
	}
	if ( (*p) < 65 ) {
		if ( 48 <= (*p) && (*p) <= 57 )
			goto tr80;
	} else if ( (*p) > 90 ) {
		if ( 97 <= (*p) && (*p) <= 122 )
			goto tr80;
	} else
		goto tr80;
	goto tr98;
st85:
	if ( ++p == pe )
		goto _out85;
case 85:
	switch( (*p) ) {
		case 95: goto tr80;
		case 105: goto tr138;
	}
	if ( (*p) < 65 ) {
		if ( 48 <= (*p) && (*p) <= 57 )
			goto tr80;
	} else if ( (*p) > 90 ) {
		if ( 97 <= (*p) && (*p) <= 122 )
			goto tr80;
	} else
		goto tr80;
	goto tr98;
st86:
	if ( ++p == pe )
		goto _out86;
case 86:
	switch( (*p) ) {
		case 95: goto tr80;
		case 104: goto st87;
	}
	if ( (*p) < 65 ) {
		if ( 48 <= (*p) && (*p) <= 57 )
			goto tr80;
	} else if ( (*p) > 90 ) {
		if ( 97 <= (*p) && (*p) <= 122 )
			goto tr80;
	} else
		goto tr80;
	goto tr98;
st87:
	if ( ++p == pe )
		goto _out87;
case 87:
	switch( (*p) ) {
		case 95: goto tr80;
		case 111: goto st88;
	}
	if ( (*p) < 65 ) {
		if ( 48 <= (*p) && (*p) <= 57 )
			goto tr80;
	} else if ( (*p) > 90 ) {
		if ( 97 <= (*p) && (*p) <= 122 )
			goto tr80;
	} else
		goto tr80;
	goto tr98;
st88:
	if ( ++p == pe )
		goto _out88;
case 88:
	switch( (*p) ) {
		case 95: goto tr80;
		case 114: goto st89;
	}
	if ( (*p) < 65 ) {
		if ( 48 <= (*p) && (*p) <= 57 )
			goto tr80;
	} else if ( (*p) > 90 ) {
		if ( 97 <= (*p) && (*p) <= 122 )
			goto tr80;
	} else
		goto tr80;
	goto tr98;
st89:
	if ( ++p == pe )
		goto _out89;
case 89:
	switch( (*p) ) {
		case 95: goto tr80;
		case 116: goto st90;
	}
	if ( (*p) < 65 ) {
		if ( 48 <= (*p) && (*p) <= 57 )
			goto tr80;
	} else if ( (*p) > 90 ) {
		if ( 97 <= (*p) && (*p) <= 122 )
			goto tr80;
	} else
		goto tr80;
	goto tr98;
st90:
	if ( ++p == pe )
		goto _out90;
case 90:
	switch( (*p) ) {
		case 95: goto tr80;
		case 101: goto st91;
	}
	if ( (*p) < 65 ) {
		if ( 48 <= (*p) && (*p) <= 57 )
			goto tr80;
	} else if ( (*p) > 90 ) {
		if ( 97 <= (*p) && (*p) <= 122 )
			goto tr80;
	} else
		goto tr80;
	goto tr98;
st91:
	if ( ++p == pe )
		goto _out91;
case 91:
	switch( (*p) ) {
		case 95: goto tr80;
		case 115: goto st92;
	}
	if ( (*p) < 65 ) {
		if ( 48 <= (*p) && (*p) <= 57 )
			goto tr80;
	} else if ( (*p) > 90 ) {
		if ( 97 <= (*p) && (*p) <= 122 )
			goto tr80;
	} else
		goto tr80;
	goto tr98;
st92:
	if ( ++p == pe )
		goto _out92;
case 92:
	switch( (*p) ) {
		case 95: goto tr80;
		case 116: goto tr145;
	}
	if ( (*p) < 65 ) {
		if ( 48 <= (*p) && (*p) <= 57 )
			goto tr80;
	} else if ( (*p) > 90 ) {
		if ( 97 <= (*p) && (*p) <= 122 )
			goto tr80;
	} else
		goto tr80;
	goto tr98;
st93:
	if ( ++p == pe )
		goto _out93;
case 93:
	switch( (*p) ) {
		case 95: goto tr80;
		case 111: goto st94;
		case 114: goto st97;
		case 121: goto st104;
	}
	if ( (*p) < 65 ) {
		if ( 48 <= (*p) && (*p) <= 57 )
			goto tr80;
	} else if ( (*p) > 90 ) {
		if ( 97 <= (*p) && (*p) <= 122 )
			goto tr80;
	} else
		goto tr80;
	goto tr98;
st94:
	if ( ++p == pe )
		goto _out94;
case 94:
	switch( (*p) ) {
		case 95: goto tr80;
		case 107: goto st95;
	}
	if ( (*p) < 65 ) {
		if ( 48 <= (*p) && (*p) <= 57 )
			goto tr80;
	} else if ( (*p) > 90 ) {
		if ( 97 <= (*p) && (*p) <= 122 )
			goto tr80;
	} else
		goto tr80;
	goto tr98;
st95:
	if ( ++p == pe )
		goto _out95;
case 95:
	switch( (*p) ) {
		case 95: goto tr80;
		case 101: goto st96;
	}
	if ( (*p) < 65 ) {
		if ( 48 <= (*p) && (*p) <= 57 )
			goto tr80;
	} else if ( (*p) > 90 ) {
		if ( 97 <= (*p) && (*p) <= 122 )
			goto tr80;
	} else
		goto tr80;
	goto tr98;
st96:
	if ( ++p == pe )
		goto _out96;
case 96:
	switch( (*p) ) {
		case 95: goto tr80;
		case 110: goto tr151;
	}
	if ( (*p) < 65 ) {
		if ( 48 <= (*p) && (*p) <= 57 )
			goto tr80;
	} else if ( (*p) > 90 ) {
		if ( 97 <= (*p) && (*p) <= 122 )
			goto tr80;
	} else
		goto tr80;
	goto tr98;
st97:
	if ( ++p == pe )
		goto _out97;
case 97:
	switch( (*p) ) {
		case 95: goto tr80;
		case 97: goto st98;
		case 121: goto tr153;
	}
	if ( (*p) < 65 ) {
		if ( 48 <= (*p) && (*p) <= 57 )
			goto tr80;
	} else if ( (*p) > 90 ) {
		if ( 98 <= (*p) && (*p) <= 122 )
			goto tr80;
	} else
		goto tr80;
	goto tr98;
st98:
	if ( ++p == pe )
		goto _out98;
case 98:
	switch( (*p) ) {
		case 95: goto tr80;
		case 110: goto st99;
	}
	if ( (*p) < 65 ) {
		if ( 48 <= (*p) && (*p) <= 57 )
			goto tr80;
	} else if ( (*p) > 90 ) {
		if ( 97 <= (*p) && (*p) <= 122 )
			goto tr80;
	} else
		goto tr80;
	goto tr98;
st99:
	if ( ++p == pe )
		goto _out99;
case 99:
	switch( (*p) ) {
		case 95: goto tr80;
		case 115: goto st100;
	}
	if ( (*p) < 65 ) {
		if ( 48 <= (*p) && (*p) <= 57 )
			goto tr80;
	} else if ( (*p) > 90 ) {
		if ( 97 <= (*p) && (*p) <= 122 )
			goto tr80;
	} else
		goto tr80;
	goto tr98;
st100:
	if ( ++p == pe )
		goto _out100;
case 100:
	switch( (*p) ) {
		case 95: goto tr80;
		case 108: goto st101;
	}
	if ( (*p) < 65 ) {
		if ( 48 <= (*p) && (*p) <= 57 )
			goto tr80;
	} else if ( (*p) > 90 ) {
		if ( 97 <= (*p) && (*p) <= 122 )
			goto tr80;
	} else
		goto tr80;
	goto tr98;
st101:
	if ( ++p == pe )
		goto _out101;
case 101:
	switch( (*p) ) {
		case 95: goto tr80;
		case 97: goto st102;
	}
	if ( (*p) < 65 ) {
		if ( 48 <= (*p) && (*p) <= 57 )
			goto tr80;
	} else if ( (*p) > 90 ) {
		if ( 98 <= (*p) && (*p) <= 122 )
			goto tr80;
	} else
		goto tr80;
	goto tr98;
st102:
	if ( ++p == pe )
		goto _out102;
case 102:
	switch( (*p) ) {
		case 95: goto tr80;
		case 116: goto st103;
	}
	if ( (*p) < 65 ) {
		if ( 48 <= (*p) && (*p) <= 57 )
			goto tr80;
	} else if ( (*p) > 90 ) {
		if ( 97 <= (*p) && (*p) <= 122 )
			goto tr80;
	} else
		goto tr80;
	goto tr98;
st103:
	if ( ++p == pe )
		goto _out103;
case 103:
	switch( (*p) ) {
		case 95: goto tr80;
		case 101: goto tr159;
	}
	if ( (*p) < 65 ) {
		if ( 48 <= (*p) && (*p) <= 57 )
			goto tr80;
	} else if ( (*p) > 90 ) {
		if ( 97 <= (*p) && (*p) <= 122 )
			goto tr80;
	} else
		goto tr80;
	goto tr98;
st104:
	if ( ++p == pe )
		goto _out104;
case 104:
	switch( (*p) ) {
		case 95: goto tr80;
		case 112: goto st105;
	}
	if ( (*p) < 65 ) {
		if ( 48 <= (*p) && (*p) <= 57 )
			goto tr80;
	} else if ( (*p) > 90 ) {
		if ( 97 <= (*p) && (*p) <= 122 )
			goto tr80;
	} else
		goto tr80;
	goto tr98;
st105:
	if ( ++p == pe )
		goto _out105;
case 105:
	switch( (*p) ) {
		case 95: goto tr80;
		case 101: goto tr161;
	}
	if ( (*p) < 65 ) {
		if ( 48 <= (*p) && (*p) <= 57 )
			goto tr80;
	} else if ( (*p) > 90 ) {
		if ( 97 <= (*p) && (*p) <= 122 )
			goto tr80;
	} else
		goto tr80;
	goto tr98;
st106:
	if ( ++p == pe )
		goto _out106;
case 106:
	switch( (*p) ) {
		case 95: goto tr80;
		case 110: goto st107;
		case 115: goto st109;
	}
	if ( (*p) < 65 ) {
		if ( 48 <= (*p) && (*p) <= 57 )
			goto tr80;
	} else if ( (*p) > 90 ) {
		if ( 97 <= (*p) && (*p) <= 122 )
			goto tr80;
	} else
		goto tr80;
	goto tr98;
st107:
	if ( ++p == pe )
		goto _out107;
case 107:
	switch( (*p) ) {
		case 95: goto tr80;
		case 100: goto st108;
	}
	if ( (*p) < 65 ) {
		if ( 48 <= (*p) && (*p) <= 57 )
			goto tr80;
	} else if ( (*p) > 90 ) {
		if ( 97 <= (*p) && (*p) <= 122 )
			goto tr80;
	} else
		goto tr80;
	goto tr98;
st108:
	if ( ++p == pe )
		goto _out108;
case 108:
	switch( (*p) ) {
		case 95: goto tr80;
		case 111: goto tr165;
	}
	if ( (*p) < 65 ) {
		if ( 48 <= (*p) && (*p) <= 57 )
			goto tr80;
	} else if ( (*p) > 90 ) {
		if ( 97 <= (*p) && (*p) <= 122 )
			goto tr80;
	} else
		goto tr80;
	goto tr98;
st109:
	if ( ++p == pe )
		goto _out109;
case 109:
	switch( (*p) ) {
		case 95: goto tr80;
		case 101: goto st110;
	}
	if ( (*p) < 65 ) {
		if ( 48 <= (*p) && (*p) <= 57 )
			goto tr80;
	} else if ( (*p) > 90 ) {
		if ( 97 <= (*p) && (*p) <= 122 )
			goto tr80;
	} else
		goto tr80;
	goto tr98;
st110:
	if ( ++p == pe )
		goto _out110;
case 110:
	switch( (*p) ) {
		case 95: goto tr80;
		case 115: goto tr167;
	}
	if ( (*p) < 65 ) {
		if ( 48 <= (*p) && (*p) <= 57 )
			goto tr80;
	} else if ( (*p) > 90 ) {
		if ( 97 <= (*p) && (*p) <= 122 )
			goto tr80;
	} else
		goto tr80;
	goto tr98;
st111:
	if ( ++p == pe )
		goto _out111;
case 111:
	switch( (*p) ) {
		case 95: goto tr80;
		case 114: goto st112;
	}
	if ( (*p) < 65 ) {
		if ( 48 <= (*p) && (*p) <= 57 )
			goto tr80;
	} else if ( (*p) > 90 ) {
		if ( 97 <= (*p) && (*p) <= 122 )
			goto tr80;
	} else
		goto tr80;
	goto tr98;
st112:
	if ( ++p == pe )
		goto _out112;
case 112:
	switch( (*p) ) {
		case 95: goto tr80;
		case 105: goto st113;
	}
	if ( (*p) < 65 ) {
		if ( 48 <= (*p) && (*p) <= 57 )
			goto tr80;
	} else if ( (*p) > 90 ) {
		if ( 97 <= (*p) && (*p) <= 122 )
			goto tr80;
	} else
		goto tr80;
	goto tr98;
st113:
	if ( ++p == pe )
		goto _out113;
case 113:
	switch( (*p) ) {
		case 95: goto tr80;
		case 116: goto st114;
	}
	if ( (*p) < 65 ) {
		if ( 48 <= (*p) && (*p) <= 57 )
			goto tr80;
	} else if ( (*p) > 90 ) {
		if ( 97 <= (*p) && (*p) <= 122 )
			goto tr80;
	} else
		goto tr80;
	goto tr98;
st114:
	if ( ++p == pe )
		goto _out114;
case 114:
	switch( (*p) ) {
		case 95: goto tr80;
		case 101: goto tr171;
	}
	if ( (*p) < 65 ) {
		if ( 48 <= (*p) && (*p) <= 57 )
			goto tr80;
	} else if ( (*p) > 90 ) {
		if ( 97 <= (*p) && (*p) <= 122 )
			goto tr80;
	} else
		goto tr80;
	goto tr98;
tr92:
#line 1 "klscan.rl"
	{tokend = p+1;}
	goto st115;
st115:
	if ( ++p == pe )
		goto _out115;
case 115:
#line 2522 "klscan.cpp"
	if ( (*p) == 37 )
		goto st20;
	goto tr94;
st20:
	if ( ++p == pe )
		goto _out20;
case 20:
	if ( (*p) == 37 )
		goto tr32;
	goto tr25;
	}
	_out21: cs = 21; goto _out; 
	_out22: cs = 22; goto _out; 
	_out23: cs = 23; goto _out; 
	_out1: cs = 1; goto _out; 
	_out2: cs = 2; goto _out; 
	_out24: cs = 24; goto _out; 
	_out25: cs = 25; goto _out; 
	_out26: cs = 26; goto _out; 
	_out3: cs = 3; goto _out; 
	_out4: cs = 4; goto _out; 
	_out27: cs = 27; goto _out; 
	_out5: cs = 5; goto _out; 
	_out6: cs = 6; goto _out; 
	_out7: cs = 7; goto _out; 
	_out28: cs = 28; goto _out; 
	_out29: cs = 29; goto _out; 
	_out30: cs = 30; goto _out; 
	_out31: cs = 31; goto _out; 
	_out32: cs = 32; goto _out; 
	_out8: cs = 8; goto _out; 
	_out9: cs = 9; goto _out; 
	_out33: cs = 33; goto _out; 
	_out34: cs = 34; goto _out; 
	_out35: cs = 35; goto _out; 
	_out10: cs = 10; goto _out; 
	_out11: cs = 11; goto _out; 
	_out36: cs = 36; goto _out; 
	_out12: cs = 12; goto _out; 
	_out13: cs = 13; goto _out; 
	_out14: cs = 14; goto _out; 
	_out37: cs = 37; goto _out; 
	_out38: cs = 38; goto _out; 
	_out39: cs = 39; goto _out; 
	_out40: cs = 40; goto _out; 
	_out41: cs = 41; goto _out; 
	_out0: cs = 0; goto _out; 
	_out42: cs = 42; goto _out; 
	_out43: cs = 43; goto _out; 
	_out44: cs = 44; goto _out; 
	_out15: cs = 15; goto _out; 
	_out16: cs = 16; goto _out; 
	_out45: cs = 45; goto _out; 
	_out17: cs = 17; goto _out; 
	_out46: cs = 46; goto _out; 
	_out18: cs = 18; goto _out; 
	_out19: cs = 19; goto _out; 
	_out47: cs = 47; goto _out; 
	_out48: cs = 48; goto _out; 
	_out49: cs = 49; goto _out; 
	_out50: cs = 50; goto _out; 
	_out51: cs = 51; goto _out; 
	_out52: cs = 52; goto _out; 
	_out53: cs = 53; goto _out; 
	_out54: cs = 54; goto _out; 
	_out55: cs = 55; goto _out; 
	_out56: cs = 56; goto _out; 
	_out57: cs = 57; goto _out; 
	_out58: cs = 58; goto _out; 
	_out59: cs = 59; goto _out; 
	_out60: cs = 60; goto _out; 
	_out61: cs = 61; goto _out; 
	_out62: cs = 62; goto _out; 
	_out63: cs = 63; goto _out; 
	_out64: cs = 64; goto _out; 
	_out65: cs = 65; goto _out; 
	_out66: cs = 66; goto _out; 
	_out67: cs = 67; goto _out; 
	_out68: cs = 68; goto _out; 
	_out69: cs = 69; goto _out; 
	_out70: cs = 70; goto _out; 
	_out71: cs = 71; goto _out; 
	_out72: cs = 72; goto _out; 
	_out73: cs = 73; goto _out; 
	_out74: cs = 74; goto _out; 
	_out75: cs = 75; goto _out; 
	_out76: cs = 76; goto _out; 
	_out77: cs = 77; goto _out; 
	_out78: cs = 78; goto _out; 
	_out79: cs = 79; goto _out; 
	_out80: cs = 80; goto _out; 
	_out81: cs = 81; goto _out; 
	_out82: cs = 82; goto _out; 
	_out83: cs = 83; goto _out; 
	_out84: cs = 84; goto _out; 
	_out85: cs = 85; goto _out; 
	_out86: cs = 86; goto _out; 
	_out87: cs = 87; goto _out; 
	_out88: cs = 88; goto _out; 
	_out89: cs = 89; goto _out; 
	_out90: cs = 90; goto _out; 
	_out91: cs = 91; goto _out; 
	_out92: cs = 92; goto _out; 
	_out93: cs = 93; goto _out; 
	_out94: cs = 94; goto _out; 
	_out95: cs = 95; goto _out; 
	_out96: cs = 96; goto _out; 
	_out97: cs = 97; goto _out; 
	_out98: cs = 98; goto _out; 
	_out99: cs = 99; goto _out; 
	_out100: cs = 100; goto _out; 
	_out101: cs = 101; goto _out; 
	_out102: cs = 102; goto _out; 
	_out103: cs = 103; goto _out; 
	_out104: cs = 104; goto _out; 
	_out105: cs = 105; goto _out; 
	_out106: cs = 106; goto _out; 
	_out107: cs = 107; goto _out; 
	_out108: cs = 108; goto _out; 
	_out109: cs = 109; goto _out; 
	_out110: cs = 110; goto _out; 
	_out111: cs = 111; goto _out; 
	_out112: cs = 112; goto _out; 
	_out113: cs = 113; goto _out; 
	_out114: cs = 114; goto _out; 
	_out115: cs = 115; goto _out; 
	_out20: cs = 20; goto _out; 

	_out: {}
	}
#line 444 "klscan.rl"

		/* Check if we failed. */
		if ( cs == klscan_error ) {
			/* Machine failed before finding a token. */
			cout << "PARSE ERROR" << endl;
			exit(1);
		}

		/* Decide if we need to preserve anything. */
		char *preserve = tokstart;
		if ( inline_start != 0 && ( preserve == 0 || inline_start < preserve ) )
			preserve = inline_start;

		/* Now set up the prefix. */
		if ( preserve == 0 )
			have = 0;
		else {
			/* There is data that needs to be shifted over. */
			have = pe - preserve;
			memmove( buf, preserve, have );
			unsigned int shiftback = preserve - buf;
			if ( tokstart != 0 )
				tokstart -= shiftback;
			if ( inline_start != 0 )
				inline_start -= shiftback;

			tokend -= shiftback;
			litstart -= shiftback;
			litend -= shiftback;
			identstart -= shiftback;
			identend -= shiftback;

			preserve = buf;
		}
	}

	delete[] buf;
}

void scan( char *fileName, istream &input )
{
	ParserDict parserDict;
	Scanner scanner( fileName, input, parserDict, 0 );
	scanner.do_scan();
}
