; example2.nsi
;
; This script is based on example1.nsi, but adds uninstall support
; and (optionally) start menu shortcuts.
;
; It will install notepad.exe into a directory that the user selects,
;

; The name of the installer
Name "Reign of the Just"

; The file to write
OutFile "reign.exe"

EnabledBitmap tick.bmp
DisabledBitmap untick.bmp

; The default installation directory
InstallDir "$PROGRAMFILES\Reign of the Just"
; Registry key to check for directory (so if you install again, it will 
; overwrite the old one automatically)
InstallDirRegKey HKLM SOFTWARE\ReignOfTheJust "Install_Dir"

; The text to prompt the user to enter a directory
ComponentText "This will install Reign of the Just on your computer. Select which optional things you want installed."
; The text to prompt the user to enter a directory
DirText "Choose a directory to install in to:"

; The stuff to install
Section "Game Engine (required)"
  ; Set output path to the installation directory.
  SetOutPath $INSTDIR
  ; Put file there
  File /r "C:\irerel\*.*"
  ; Write the installation path into the registry
  WriteRegStr HKLM SOFTWARE\ReignOfTheJust "Install_Dir" "$INSTDIR"
  ; Write the uninstall keys for Windows
  WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\ReignOfTheJust" "DisplayName" "Reign of the Just (remove only)"
  WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\ReignOfTheJust" "UninstallString" '"$INSTDIR\uninstall.exe"'
  WriteUninstaller "uninstall.exe"
SectionEnd

; optional section
Section "Start Menu Shortcuts"
  CreateDirectory "$SMPROGRAMS\Reign Of The Just"
  CreateShortCut "$SMPROGRAMS\Reign Of The Just\Uninstall.lnk" "$INSTDIR\uninstall.exe" "" "$INSTDIR\uninstall.exe" 0
  CreateShortCut "$SMPROGRAMS\Reign Of The Just\Reign.lnk" "$INSTDIR\Reign.exe" "" "$INSTDIR\Reign.exe" 0
  CopyFiles /SILENT "$INSTDIR\docs\readme.txt" "$SMPROGRAMS\Reign Of The Just\readme.txt" 
  CopyFiles /SILENT "$INSTDIR\docs\trouble.txt" "$SMPROGRAMS\Reign Of The Just\troubleshooting.txt" 
SectionEnd

; uninstall stuff

UninstallText "This will uninstall Reign of the Just. Hit next to continue."

; special uninstall section.
Section "Uninstall"
  ; remove registry keys
  DeleteRegKey HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\ReignOfTheJust"
  DeleteRegKey HKLM SOFTWARE\ReignOfTheJust
  ; remove files
  Delete $INSTDIR\*.*
  ; MUST REMOVE UNINSTALLER, too
  Delete $INSTDIR\uninstall.exe
  ; remove shortcuts, if any.
  Delete "$SMPROGRAMS\Reign Of The Just\*.*"
  ; remove directories used.
  RMDir "$SMPROGRAMS\Reign Of The Just"
  RMDir /r $INSTDIR\CACHE
  RMDir /r $INSTDIR\IRE
  MessageBox MB_YESNO|MB_ICONEXCLAMATION|MB_DEFBUTTON2 "Delete the savegames?" IDNO KeepSaves
  RMDIR /r $INSTDIR
  KeepSaves:
  Delete $INSTDIR\*.*
  RMDIR $INSTDIR
SectionEnd

; eof
