//  This file is part of ff3d - http://www.freefem.org/ff3d
//  Copyright (C) 2001, 2002, 2003 Stphane Del Pino

//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2, or (at your option)
//  any later version.

//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.

//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software Foundation,
//  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  

//  $Id: VariationalOperatorFgradGgradV.hpp,v 1.4 2004/11/21 18:37:29 delpinux Exp $

#ifndef VARIATIONAL_OPERATOR_F_GRAD_G_GRAD_V_HPP
#define VARIATIONAL_OPERATOR_F_GRAD_G_GRAD_V_HPP

#include <VariationalLinearOperator.hpp>

#include <UserFunction.hpp>

/**
 * @file   VariationalOperatorFgradGgradV.hpp
 * @author Stephane Del Pino
 * @date   Sun Jun  2 21:55:49 2002
 * 
 * @brief  \f$ l(v) = \int \nabla f\cdot \nabla v \f$
 * 
 */
class VariationalOperatorFgradGgradV
  : public VariationalLinearOperator
{
private:
  ReferenceCounting<UserFunction> __f; /**< the \f$ f\f$ function */
  ReferenceCounting<UserFunction> __g; /**< the \f$ g\f$ function */

public:
  /** 
   * 
   * Access to \f$ f\f$
   * 
   * @return *__f
   */
  const UserFunction& f() const
  {
    return *__f;
  }

  /** 
   * 
   * Access to \f$ g\f$
   * 
   * @return *__g
   */
  const UserFunction& g() const
  {
    return *__g;
  }

  /** 
   * "Multiplies" the operator by a function
   * 
   * @param u the given function
   * 
   * @return the new operator
   */
  ReferenceCounting<VariationalLinearOperator>
  operator * (ConstReferenceCounting<UserFunction> u) const
  {
    VariationalOperatorFgradGgradV* newOperator = new VariationalOperatorFgradGgradV(*this);
    (*newOperator).__f = new MulUserFunction(__f, u);
    return newOperator;
  }

  /** 
   * Constructor
   * 
   * @param testFunctionNumber 
   * @param f 
   * @param g 
   * 
   */
  VariationalOperatorFgradGgradV(const size_t testFunctionNumber,
				 ReferenceCounting<UserFunction> f,
				 ReferenceCounting<UserFunction> g)
    : VariationalLinearOperator(VariationalLinearOperator::FgradGgradV,
				testFunctionNumber),
      __f(f),
      __g(g)
  {
    ;
  }

  /** 
   * Copy constructor
   * 
   * @param fv another VariationalOperatorFgradGgradV
   * 
   */
  VariationalOperatorFgradGgradV(const VariationalOperatorFgradGgradV& fv)
    : VariationalLinearOperator(fv),
      __f(fv.__f),
      __g(fv.__g)
  {
    ;
  }

  /** 
   * Destructor
   * 
   * 
   */
  ~VariationalOperatorFgradGgradV()
  {
    ;
  }
};

#endif // VARIATIONAL_OPERATOR_F_GRAD_G_GRAD_V_HPP

