/*
 * Copyright (C) Michael Stickel <michael@cubic.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#ifndef __DMX4LINUX_SUNLITE_FIRMWARE_H__
#define __DMX4LINUX_SUNLITE_FIRMWARE_H__


#define sunlite_DATE "20000106"

/*
struct sunlite_hex_record {
  __u16	address;
  __u8	data_size;
  __u8	data[16];
};
*/


static const struct sunlite_hex_record   sunlite_firmware[] =
  {
    { 32658, 1, { 0x1 } }, /* reset=1 */
    { 32658, 1, { 0x1 } }, /* reset=1 */
    { 5228, 16, { 0xc2, 0x00, 0x90, 0x7f, 0xa5, 0xe0, 0x54, 0x18, 0xff, 0x13, 0x13, 0x13, 0x54, 0x1f, 0x44, 0x50 } },
    { 5244, 16, { 0xf5, 0x1c, 0x13, 0x92, 0x01, 0xd2, 0xe8, 0x90, 0x7f, 0xab, 0x74, 0xff, 0xf0, 0x90, 0x7f, 0xa9 } },
    { 5260, 16, { 0xf0, 0x90, 0x7f, 0xaa, 0xf0, 0x53, 0x91, 0xef, 0x90, 0x7f, 0x95, 0xe0, 0x44, 0xc0, 0xf0, 0x90 } },
    { 5276, 16, { 0x7f, 0xaf, 0xe0, 0x44, 0x01, 0xf0, 0x90, 0x7f, 0xae, 0xe0, 0x44, 0x05, 0xf0, 0xd2, 0xaf, 0x12 } },
    { 5292, 13, { 0x17, 0x5f, 0x30, 0x00, 0xfd, 0x12, 0x11, 0x00, 0xc2, 0x00, 0x80, 0xf6, 0x22 } },
    { 4352, 16, { 0x90, 0x7f, 0xe9, 0xe0, 0x24, 0x5d, 0x60, 0x0d, 0x14, 0x70, 0x03, 0x02, 0x12, 0x44, 0x24, 0x02 } },
    { 4368, 16, { 0x60, 0x03, 0x02, 0x12, 0x4a, 0x90, 0x7f, 0xea, 0xe0, 0x75, 0x08, 0x00, 0xf5, 0x09, 0xa3, 0xe0 } },
    { 4384, 16, { 0xfe, 0xe4, 0x25, 0x09, 0xf5, 0x09, 0xee, 0x35, 0x08, 0xf5, 0x08, 0x90, 0x7f, 0xee, 0xe0, 0x75 } },
    { 4400, 16, { 0xa, 0x00, 0xf5, 0x0b, 0xa3, 0xe0, 0xfe, 0xe4, 0x25, 0x0b, 0xf5, 0x0b, 0xee, 0x35, 0x0a, 0xf5 } },
    { 4416, 16, { 0xa, 0x90, 0x7f, 0xe8, 0xe0, 0x64, 0xc0, 0x60, 0x03, 0x02, 0x11, 0xd4, 0xe5, 0x0b, 0x45, 0x0a } },
    { 4432, 16, { 0x70, 0x03, 0x02, 0x12, 0x4a, 0xc3, 0xe5, 0x0b, 0x94, 0x40, 0xe5, 0x0a, 0x94, 0x00, 0x50, 0x08 } },
    { 4448, 16, { 0x85, 0x0a, 0x0c, 0x85, 0x0b, 0x0d, 0x80, 0x06, 0x75, 0x0c, 0x00, 0x75, 0x0d, 0x40, 0x90, 0x7f } },
    { 4464, 16, { 0xe9, 0xe0, 0xb4, 0xa3, 0x25, 0xae, 0x0c, 0xaf, 0x0d, 0xaa, 0x08, 0xa9, 0x09, 0x7b, 0x01, 0xc0 } },
    { 4480, 16, { 0x3, 0xc0, 0x02, 0xc0, 0x01, 0x7a, 0x7f, 0x79, 0x00, 0x78, 0x00, 0x7c, 0x7f, 0xad, 0x03, 0xd0 } },
    { 4496, 16, { 0x1, 0xd0, 0x02, 0xd0, 0x03, 0x12, 0x13, 0x56, 0x80, 0x0f, 0xaf, 0x09, 0xae, 0x08, 0xad, 0x0d } },
    { 4512, 16, { 0x7a, 0x7f, 0x79, 0x00, 0x7b, 0x00, 0x12, 0x15, 0xa4, 0x90, 0x7f, 0xb5, 0xe5, 0x0d, 0xf0, 0xe5 } },
    { 4528, 16, { 0xd, 0x25, 0x09, 0xf5, 0x09, 0xe5, 0x0c, 0x35, 0x08, 0xf5, 0x08, 0xc3, 0xe5, 0x0b, 0x95, 0x0d } },
    { 4544, 16, { 0xf5, 0x0b, 0xe5, 0x0a, 0x95, 0x0c, 0xf5, 0x0a, 0x90, 0x7f, 0xb4, 0xe0, 0x20, 0xe2, 0x03, 0x02 } },
    { 4560, 16, { 0x11, 0x4c, 0x80, 0xf4, 0x90, 0x7f, 0xe8, 0xe0, 0x64, 0x40, 0x70, 0x6e, 0xe5, 0x0b, 0x45, 0x0a } },
    { 4576, 16, { 0x60, 0x68, 0xe4, 0x90, 0x7f, 0xc5, 0xf0, 0x90, 0x7f, 0xb4, 0xe0, 0x20, 0xe3, 0xf9, 0x90, 0x7f } },
    { 4592, 16, { 0xc5, 0xe0, 0x75, 0x0c, 0x00, 0xf5, 0x0d, 0x90, 0x7f, 0xe9, 0xe0, 0xb4, 0xa3, 0x15, 0xae, 0x0c } },
    { 4608, 16, { 0xaf, 0x0d, 0xa8, 0x09, 0xac, 0x08, 0x7d, 0x01, 0x7b, 0x01, 0x7a, 0x7e, 0x79, 0xc0, 0x12, 0x13 } },
    { 4624, 16, { 0x56, 0x80, 0x0f, 0xaf, 0x09, 0xae, 0x08, 0xad, 0x0d, 0x7a, 0x7f, 0x79, 0x00, 0x7b, 0x00, 0x12 } },
    { 4640, 16, { 0x14, 0xb9, 0xe5, 0x0d, 0x25, 0x09, 0xf5, 0x09, 0xe5, 0x0c, 0x35, 0x08, 0xf5, 0x08, 0xc3, 0xe5 } },
    { 4656, 16, { 0xb, 0x95, 0x0d, 0xf5, 0x0b, 0xe5, 0x0a, 0x95, 0x0c, 0xf5, 0x0a, 0x90, 0x7f, 0xb4, 0xe0, 0x44 } },
    { 4672, 10, { 0x2, 0xf0, 0x80, 0x98, 0x90, 0x7f, 0xea, 0xe0, 0xf5, 0x1c } },
    { 4682, 1, { 0x22 } },
    { 5464, 6, { 0xab, 0x07, 0xaa, 0x06, 0xac, 0x05 } },
    { 5470, 16, { 0xe4, 0xfd, 0x30, 0x01, 0x11, 0xea, 0xff, 0xae, 0x05, 0x0d, 0xee, 0x24, 0x00, 0xf5, 0x82, 0xe4 } },
    { 5486, 16, { 0x34, 0xe0, 0xf5, 0x83, 0xef, 0xf0, 0xeb, 0xae, 0x05, 0x0d, 0x74, 0x00, 0x2e, 0xf5, 0x82, 0xe4 } },
    { 5502, 16, { 0x34, 0xe0, 0xf5, 0x83, 0xeb, 0xf0, 0xaf, 0x05, 0x0d, 0x74, 0x00, 0x2f, 0xf5, 0x82, 0xe4, 0x34 } },
    { 5518, 16, { 0xe0, 0xf5, 0x83, 0xec, 0xf0, 0xaf, 0x1c, 0x7a, 0xe0, 0x7b, 0x00, 0x12, 0x17, 0x20, 0x7f, 0x0a } },
    { 5534, 5, { 0x7e, 0x00, 0x12, 0x17, 0x3c } },
    { 5539, 1, { 0x22 } },
    { 5305, 10, { 0x8e, 0x0e, 0x8f, 0x0f, 0x8d, 0x10, 0x8a, 0x11, 0x8b, 0x12 } },
    { 5315, 16, { 0xe4, 0xf5, 0x13, 0xe5, 0x13, 0xc3, 0x95, 0x10, 0x50, 0x20, 0x05, 0x0f, 0xe5, 0x0f, 0xae, 0x0e } },
    { 5331, 16, { 0x70, 0x02, 0x05, 0x0e, 0x14, 0xff, 0xe5, 0x12, 0x25, 0x13, 0xf5, 0x82, 0xe4, 0x35, 0x11, 0xf5 } },
    { 5347, 10, { 0x83, 0xe0, 0xfd, 0x12, 0x15, 0x58, 0x05, 0x13, 0x80, 0xd9 } },
    { 5357, 1, { 0x22 } },
    { 5540, 10, { 0x8e, 0x0e, 0x8f, 0x0f, 0x8d, 0x10, 0x8a, 0x11, 0x8b, 0x12 } },
    { 5550, 16, { 0xe4, 0xfd, 0x30, 0x01, 0x12, 0xe5, 0x0e, 0xff, 0xae, 0x05, 0x0d, 0xee, 0x24, 0x03, 0xf5, 0x82 } },
    { 5566, 16, { 0xe4, 0x34, 0xe0, 0xf5, 0x83, 0xef, 0xf0, 0xe5, 0x0f, 0xae, 0x05, 0x0d, 0x74, 0x03, 0x2e, 0xf5 } },
    { 5582, 16, { 0x82, 0xe4, 0x34, 0xe0, 0xf5, 0x83, 0xe5, 0x0f, 0xf0, 0xaf, 0x1c, 0x7a, 0xe0, 0x7b, 0x03, 0x12 } },
    { 5598, 13, { 0x17, 0x20, 0xaf, 0x1c, 0xad, 0x10, 0xab, 0x12, 0xaa, 0x11, 0x12, 0x17, 0x04 } },
    { 5611, 1, { 0x22 } },
    { 5742, 16, { 0xc0, 0xe0, 0xc0, 0x83, 0xc0, 0x82, 0xc0, 0x85, 0xc0, 0x84, 0xc0, 0x86, 0x75, 0x86, 0x00, 0xd2 } },
    { 5758, 16, { 0x0, 0x53, 0x91, 0xef, 0x90, 0x7f, 0xab, 0x74, 0x01, 0xf0, 0xd0, 0x86, 0xd0, 0x84, 0xd0, 0x85 } },
    { 5774, 7, { 0xd0, 0x82, 0xd0, 0x83, 0xd0, 0xe0, 0x32 } },
    { 5700, 16, { 0xc0, 0xe0, 0xc0, 0x83, 0xc0, 0x82, 0xc0, 0x85, 0xc0, 0x84, 0xc0, 0x86, 0x75, 0x86, 0x00, 0x90 } },
    { 5716, 16, { 0x7f, 0xc4, 0xe4, 0xf0, 0x53, 0x91, 0xef, 0x90, 0x7f, 0xab, 0x74, 0x04, 0xf0, 0xd0, 0x86, 0xd0 } },
    { 5732, 10, { 0x84, 0xd0, 0x85, 0xd0, 0x82, 0xd0, 0x83, 0xd0, 0xe0, 0x32 } },
    { 5781, 16, { 0xc0, 0xe0, 0xc0, 0x83, 0xc0, 0x82, 0xc0, 0x85, 0xc0, 0x84, 0xc0, 0x86, 0x75, 0x86, 0x00, 0x53 } },
    { 5797, 16, { 0x91, 0xef, 0x90, 0x7f, 0xab, 0x74, 0x02, 0xf0, 0xd0, 0x86, 0xd0, 0x84, 0xd0, 0x85, 0xd0, 0x82 } },
    { 5813, 5, { 0xd0, 0x83, 0xd0, 0xe0, 0x32 } },
    { 5818, 16, { 0xc0, 0xe0, 0xc0, 0x83, 0xc0, 0x82, 0xc0, 0x85, 0xc0, 0x84, 0xc0, 0x86, 0x75, 0x86, 0x00, 0x53 } },
    { 5834, 16, { 0x91, 0xef, 0x90, 0x7f, 0xab, 0x74, 0x10, 0xf0, 0xd0, 0x86, 0xd0, 0x84, 0xd0, 0x85, 0xd0, 0x82 } },
    { 5850, 5, { 0xd0, 0x83, 0xd0, 0xe0, 0x32 } },
    { 5375, 1, { 0x32 } },
    { 5855, 16, { 0xc0, 0xe0, 0xc0, 0x83, 0xc0, 0x82, 0xc0, 0x85, 0xc0, 0x84, 0xc0, 0x86, 0x75, 0x86, 0x00, 0x53 } },
    { 5871, 16, { 0x91, 0xef, 0x90, 0x7f, 0xab, 0x74, 0x08, 0xf0, 0xd0, 0x86, 0xd0, 0x84, 0xd0, 0x85, 0xd0, 0x82 } },
    { 5887, 5, { 0xd0, 0x83, 0xd0, 0xe0, 0x32 } },
    { 5991, 1, { 0x32 } },
    { 5992, 1, { 0x32 } },
    { 5993, 1, { 0x32 } },
    { 5994, 1, { 0x32 } },
    { 5995, 1, { 0x32 } },
    { 5996, 1, { 0x32 } },
    { 5997, 1, { 0x32 } },
    { 5998, 1, { 0x32 } },
    { 5999, 1, { 0x32 } },
    { 6000, 1, { 0x32 } },
    { 6001, 1, { 0x32 } },
    { 6002, 1, { 0x32 } },
    { 6003, 1, { 0x32 } },
    { 6004, 1, { 0x32 } },
    { 6005, 1, { 0x32 } },
    { 6006, 1, { 0x32 } },
    { 67, 3, { 0x2, 0x15, 0x00 } },
    { 5376, 16, { 0x2, 0x16, 0x6e, 0x00, 0x02, 0x16, 0x95, 0x00, 0x02, 0x16, 0x44, 0x00, 0x02, 0x16, 0xdf, 0x00 } },
    { 5392, 16, { 0x2, 0x16, 0xba, 0x00, 0x02, 0x14, 0xff, 0x00, 0x02, 0x17, 0x67, 0x00, 0x02, 0x17, 0x68, 0x00 } },
    { 5408, 16, { 0x2, 0x17, 0x69, 0x00, 0x02, 0x17, 0x6a, 0x00, 0x02, 0x17, 0x6b, 0x00, 0x02, 0x17, 0x6c, 0x00 } },
    { 5424, 16, { 0x2, 0x17, 0x6d, 0x00, 0x02, 0x17, 0x6e, 0x00, 0x02, 0x17, 0x6f, 0x00, 0x02, 0x17, 0x70, 0x00 } },
    { 5440, 16, { 0x2, 0x17, 0x71, 0x00, 0x02, 0x17, 0x72, 0x00, 0x02, 0x17, 0x73, 0x00, 0x02, 0x17, 0x74, 0x00 } },
    { 5456, 8, { 0x2, 0x17, 0x75, 0x00, 0x02, 0x17, 0x76, 0x00 } },
    { 5948, 16, { 0x8e, 0x14, 0x8f, 0x15, 0xe5, 0x15, 0x15, 0x15, 0xae, 0x14, 0x70, 0x02, 0x15, 0x14, 0x4e, 0x60 } },
    { 5964, 7, { 0x5, 0x12, 0x14, 0xee, 0x80, 0xee, 0x22 } },
    { 5983, 8, { 0xe4, 0xf5, 0x1b, 0xd2, 0xe9, 0xd2, 0xaf, 0x22 } },
    { 5657, 16, { 0xa9, 0x07, 0xe5, 0x1b, 0x70, 0x23, 0x90, 0x7f, 0xa5, 0xe0, 0x44, 0x80, 0xf0, 0xe9, 0x25, 0xe0 } },
    { 5673, 16, { 0x90, 0x7f, 0xa6, 0xf0, 0x8d, 0x16, 0xaf, 0x03, 0xa9, 0x07, 0x75, 0x17, 0x01, 0x8a, 0x18, 0x89 } },
    { 5689, 11, { 0x19, 0xe4, 0xf5, 0x1a, 0x75, 0x1b, 0x01, 0xd3, 0x22, 0xc3, 0x22 } },
    { 5612, 16, { 0xa9, 0x07, 0xe5, 0x1b, 0x70, 0x25, 0x90, 0x7f, 0xa5, 0xe0, 0x44, 0x80, 0xf0, 0xe9, 0x25, 0xe0 } },
    { 5628, 16, { 0x44, 0x01, 0x90, 0x7f, 0xa6, 0xf0, 0x8d, 0x16, 0xaf, 0x03, 0xa9, 0x07, 0x75, 0x17, 0x01, 0x8a } },
    { 5644, 13, { 0x18, 0x89, 0x19, 0xe4, 0xf5, 0x1a, 0x75, 0x1b, 0x03, 0xd3, 0x22, 0xc3, 0x22 } },
    { 75, 3, { 0x2, 0x13, 0x7f } },
    { 4991, 16, { 0xc0, 0xe0, 0xc0, 0x83, 0xc0, 0x82, 0xc0, 0x85, 0xc0, 0x84, 0xc0, 0x86, 0x75, 0x86, 0x00, 0xc0 } },
    { 5007, 16, { 0xd0, 0x75, 0xd0, 0x00, 0xc0, 0x00, 0xc0, 0x01, 0xc0, 0x02, 0xc0, 0x03, 0xc0, 0x06, 0xc0, 0x07 } },
    { 5023, 16, { 0x90, 0x7f, 0xa5, 0xe0, 0x30, 0xe2, 0x06, 0x75, 0x1b, 0x06, 0x02, 0x14, 0x4e, 0x90, 0x7f, 0xa5 } },
    { 5039, 16, { 0xe0, 0x20, 0xe1, 0x0c, 0xe5, 0x1b, 0x64, 0x02, 0x60, 0x06, 0x75, 0x1b, 0x07, 0x02, 0x14, 0x4e } },
    { 5055, 16, { 0xaf, 0x1b, 0xef, 0x24, 0xfe, 0x60, 0x48, 0x14, 0x60, 0x2c, 0x24, 0xfe, 0x60, 0x77, 0x24, 0x04 } },
    { 5071, 16, { 0x60, 0x03, 0x02, 0x14, 0x4e, 0xab, 0x17, 0xaa, 0x18, 0xa9, 0x19, 0xaf, 0x1a, 0x05, 0x1a, 0x8f } },
    { 5087, 16, { 0x82, 0x75, 0x83, 0x00, 0x12, 0x12, 0x4b, 0x90, 0x7f, 0xa6, 0xf0, 0xe5, 0x1a, 0x65, 0x16, 0x70 } },
    { 5103, 16, { 0x5e, 0x75, 0x1b, 0x05, 0x80, 0x59, 0x90, 0x7f, 0xa6, 0xe0, 0xab, 0x17, 0xaa, 0x18, 0xa9, 0x19 } },
    { 5119, 16, { 0xae, 0x1a, 0x8e, 0x82, 0x75, 0x83, 0x00, 0x12, 0x12, 0x78, 0x75, 0x1b, 0x02, 0x80, 0x40, 0xe5 } },
    { 5135, 16, { 0x16, 0x24, 0xfe, 0xb5, 0x1a, 0x07, 0x90, 0x7f, 0xa5, 0xe0, 0x44, 0x20, 0xf0, 0xe5, 0x16, 0x14 } },
    { 5151, 16, { 0xb5, 0x1a, 0x0a, 0x90, 0x7f, 0xa5, 0xe0, 0x44, 0x40, 0xf0, 0x75, 0x1b, 0x00, 0x90, 0x7f, 0xa6 } },
    { 5167, 16, { 0xe0, 0xab, 0x17, 0xaa, 0x18, 0xa9, 0x19, 0xae, 0x1a, 0x8e, 0x82, 0x75, 0x83, 0x00, 0x12, 0x12 } },
    { 5183, 16, { 0x78, 0x05, 0x1a, 0x80, 0x0a, 0x90, 0x7f, 0xa5, 0xe0, 0x44, 0x40, 0xf0, 0x75, 0x1b, 0x00, 0x53 } },
    { 5199, 16, { 0x91, 0xdf, 0xd0, 0x07, 0xd0, 0x06, 0xd0, 0x03, 0xd0, 0x02, 0xd0, 0x01, 0xd0, 0x00, 0xd0, 0xd0 } },
    { 5215, 13, { 0xd0, 0x86, 0xd0, 0x84, 0xd0, 0x85, 0xd0, 0x82, 0xd0, 0x83, 0xd0, 0xe0, 0x32 } },
    { 5892, 16, { 0x12, 0x15, 0xec, 0xe5, 0x1b, 0x24, 0xfa, 0x60, 0x0e, 0x14, 0x60, 0x06, 0x24, 0x07, 0x70, 0xf3 } },
    { 5908, 12, { 0xd3, 0x22, 0xe4, 0xf5, 0x1b, 0xd3, 0x22, 0xe4, 0xf5, 0x1b, 0xd3, 0x22 } },
    { 5920, 16, { 0x12, 0x16, 0x19, 0xe5, 0x1b, 0x24, 0xfa, 0x60, 0x0e, 0x14, 0x60, 0x06, 0x24, 0x07, 0x70, 0xf3 } },
    { 5936, 12, { 0xd3, 0x22, 0xe4, 0xf5, 0x1b, 0xd3, 0x22, 0xe4, 0xf5, 0x1b, 0xd3, 0x22 } },
    { 5358, 16, { 0x74, 0x00, 0xf5, 0x86, 0x90, 0xfd, 0xa5, 0x7c, 0x05, 0xa3, 0xe5, 0x82, 0x45, 0x83, 0x70, 0xf9 } },
    { 5374, 1, { 0x22 } },
    { 0, 3, { 0x2, 0x17, 0x53 } },
    { 5971, 12, { 0x78, 0x7f, 0xe4, 0xf6, 0xd8, 0xfd, 0x75, 0x81, 0x20, 0x02, 0x14, 0x6c } },
    { 4683, 16, { 0xbb, 0x01, 0x0c, 0xe5, 0x82, 0x29, 0xf5, 0x82, 0xe5, 0x83, 0x3a, 0xf5, 0x83, 0xe0, 0x22, 0x50 } },
    { 4699, 16, { 0x6, 0xe9, 0x25, 0x82, 0xf8, 0xe6, 0x22, 0xbb, 0xfe, 0x06, 0xe9, 0x25, 0x82, 0xf8, 0xe2, 0x22 } },
    { 4715, 13, { 0xe5, 0x82, 0x29, 0xf5, 0x82, 0xe5, 0x83, 0x3a, 0xf5, 0x83, 0xe4, 0x93, 0x22 } },
    { 4728, 16, { 0xf8, 0xbb, 0x01, 0x0d, 0xe5, 0x82, 0x29, 0xf5, 0x82, 0xe5, 0x83, 0x3a, 0xf5, 0x83, 0xe8, 0xf0 } },
    { 4744, 16, { 0x22, 0x50, 0x06, 0xe9, 0x25, 0x82, 0xc8, 0xf6, 0x22, 0xbb, 0xfe, 0x05, 0xe9, 0x25, 0x82, 0xc8 } },
    { 4760, 2, { 0xf2, 0x22 } },
    { 4762, 16, { 0xe7, 0x09, 0xf6, 0x08, 0xdf, 0xfa, 0x80, 0x46, 0xe7, 0x09, 0xf2, 0x08, 0xdf, 0xfa, 0x80, 0x3e } },
    { 4778, 16, { 0x88, 0x82, 0x8c, 0x83, 0xe7, 0x09, 0xf0, 0xa3, 0xdf, 0xfa, 0x80, 0x32, 0xe3, 0x09, 0xf6, 0x08 } },
    { 4794, 16, { 0xdf, 0xfa, 0x80, 0x6e, 0xe3, 0x09, 0xf2, 0x08, 0xdf, 0xfa, 0x80, 0x66, 0x88, 0x82, 0x8c, 0x83 } },
    { 4810, 16, { 0xe3, 0x09, 0xf0, 0xa3, 0xdf, 0xfa, 0x80, 0x5a, 0x89, 0x82, 0x8a, 0x83, 0xe0, 0xa3, 0xf6, 0x08 } },
    { 4826, 16, { 0xdf, 0xfa, 0x80, 0x4e, 0x89, 0x82, 0x8a, 0x83, 0xe0, 0xa3, 0xf2, 0x08, 0xdf, 0xfa, 0x80, 0x42 } },
    { 4842, 16, { 0x80, 0xd2, 0x80, 0xfa, 0x80, 0xc6, 0x80, 0xd4, 0x80, 0x55, 0x80, 0xf2, 0x80, 0x29, 0x80, 0x10 } },
    { 4858, 16, { 0x80, 0xa6, 0x80, 0xea, 0x80, 0x9a, 0x80, 0xa8, 0x80, 0xda, 0x80, 0xe2, 0x80, 0xca, 0x80, 0x29 } },
    { 4874, 16, { 0x88, 0x84, 0x8c, 0x85, 0x89, 0x82, 0x8a, 0x83, 0xe4, 0x93, 0xa3, 0x05, 0x86, 0xf0, 0xa3, 0x05 } },
    { 4890, 16, { 0x86, 0xdf, 0xf5, 0xde, 0xf3, 0x80, 0x0b, 0x89, 0x82, 0x8a, 0x83, 0xe4, 0x93, 0xa3, 0xf6, 0x08 } },
    { 4906, 16, { 0xdf, 0xf9, 0xec, 0xfa, 0xa9, 0xf0, 0xed, 0xfb, 0x22, 0x88, 0x84, 0x8c, 0x85, 0x89, 0x82, 0x8a } },
    { 4922, 16, { 0x83, 0xe0, 0xa3, 0x05, 0x86, 0xf0, 0xa3, 0x05, 0x86, 0xdf, 0xf6, 0xde, 0xf4, 0x80, 0xe3, 0x89 } },
    { 4938, 16, { 0x82, 0x8a, 0x83, 0xe4, 0x93, 0xa3, 0xf2, 0x08, 0xdf, 0xf9, 0x80, 0xd6, 0x88, 0xf0, 0xed, 0x24 } },
    { 4954, 16, { 0x2, 0xb4, 0x04, 0x00, 0x50, 0xcc, 0xf5, 0x82, 0xeb, 0x24, 0x02, 0xb4, 0x04, 0x00, 0x50, 0xc2 } },
    { 4970, 16, { 0x23, 0x23, 0x45, 0x82, 0xf5, 0x82, 0xef, 0x4e, 0x60, 0xb8, 0xef, 0x60, 0x01, 0x0e, 0xe5, 0x82 } },
    { 4986, 5, { 0x23, 0x90, 0x12, 0xea, 0x73 } },
    { 32658, 1, { 0x0 } }, /* reset=0 */
    { 32658, 1, { 0x1 } }, /* reset=1 */
    { 1717, 16, { 0xd2, 0x00, 0x90, 0x7f, 0xa1, 0x74, 0x01, 0xf0, 0xe4, 0x90, 0x7f, 0x93, 0xf0, 0x90, 0x7f, 0x94 } },
    { 1733, 16, { 0xf0, 0x90, 0x7f, 0x95, 0x74, 0x03, 0xf0, 0x90, 0x7f, 0x9c, 0x74, 0x30, 0xf0, 0xe4, 0x90, 0x7f } },
    { 1749, 16, { 0x9d, 0xf0, 0x90, 0x7f, 0x9e, 0x74, 0xf2, 0xf0, 0x90, 0x7f, 0x96, 0x74, 0x20, 0xf0, 0x90, 0x7f } },
    { 1765, 16, { 0x98, 0x74, 0xf2, 0xf0, 0x12, 0x0a, 0x6a, 0x12, 0x0a, 0x86, 0x90, 0x7f, 0xde, 0xe0, 0x44, 0x02 } },
    { 1781, 16, { 0xf0, 0x90, 0x7f, 0xdf, 0xe0, 0x44, 0x02, 0xf0, 0x90, 0x7f, 0xad, 0xe0, 0x44, 0x02, 0xf0, 0x90 } },
    { 1797, 16, { 0x7f, 0xac, 0xe0, 0x44, 0x02, 0xf0, 0x12, 0x09, 0x90, 0x90, 0x7f, 0xb7, 0x74, 0x20, 0xf0, 0x22 } },
    { 2879, 1, { 0x22 } },
    { 2867, 2, { 0xd3, 0x22 } },
    { 2869, 2, { 0xd3, 0x22 } },
    { 2871, 2, { 0xd3, 0x22 } },
    { 2847, 8, { 0x90, 0x7f, 0xea, 0xe0, 0xf5, 0x0f, 0xd3, 0x22 } },
    { 2796, 14, { 0x90, 0x7f, 0x00, 0xe5, 0x0f, 0xf0, 0x90, 0x7f, 0xb5, 0x74, 0x01, 0xf0, 0xd3, 0x22 } },
    { 2855, 8, { 0x90, 0x7f, 0xea, 0xe0, 0xf5, 0x0e, 0xd3, 0x22 } },
    { 2810, 14, { 0x90, 0x7f, 0x00, 0xe5, 0x0e, 0xf0, 0x90, 0x7f, 0xb5, 0x74, 0x01, 0xf0, 0xd3, 0x22 } },
    { 2873, 2, { 0xd3, 0x22 } },
    { 2875, 2, { 0xd3, 0x22 } },
    { 2877, 2, { 0xd3, 0x22 } },
    { 2598, 16, { 0x90, 0x7f, 0xe8, 0xe0, 0x30, 0xe6, 0x1a, 0xa3, 0xe0, 0x24, 0xf0, 0x70, 0x12, 0x7f, 0x06, 0x12 } },
    { 2614, 16, { 0x7, 0x15, 0x90, 0x7f, 0x00, 0xef, 0xf0, 0x90, 0x7f, 0xb5, 0x74, 0x01, 0xf0, 0x80, 0x02, 0xd3 } },
    { 2630, 3, { 0x22, 0xc3, 0x22 } },
    { 2370, 16, { 0xc0, 0xe0, 0xc0, 0x83, 0xc0, 0x82, 0xc0, 0x85, 0xc0, 0x84, 0xc0, 0x86, 0x75, 0x86, 0x00, 0xd2 } },
    { 2386, 16, { 0x1, 0x53, 0x91, 0xef, 0x90, 0x7f, 0xab, 0x74, 0x01, 0xf0, 0xd0, 0x86, 0xd0, 0x84, 0xd0, 0x85 } },
    { 2402, 7, { 0xd0, 0x82, 0xd0, 0x83, 0xd0, 0xe0, 0x32 } },
    { 2487, 16, { 0xc0, 0xe0, 0xc0, 0x83, 0xc0, 0x82, 0xc0, 0x85, 0xc0, 0x84, 0xc0, 0x86, 0x75, 0x86, 0x00, 0x53 } },
    { 2503, 16, { 0x91, 0xef, 0x90, 0x7f, 0xab, 0x74, 0x04, 0xf0, 0xd0, 0x86, 0xd0, 0x84, 0xd0, 0x85, 0xd0, 0x82 } },
    { 2519, 5, { 0xd0, 0x83, 0xd0, 0xe0, 0x32 } },
    { 2524, 16, { 0xc0, 0xe0, 0xc0, 0x83, 0xc0, 0x82, 0xc0, 0x85, 0xc0, 0x84, 0xc0, 0x86, 0x75, 0x86, 0x00, 0x53 } },
    { 2540, 16, { 0x91, 0xef, 0x90, 0x7f, 0xab, 0x74, 0x02, 0xf0, 0xd0, 0x86, 0xd0, 0x84, 0xd0, 0x85, 0xd0, 0x82 } },
    { 2556, 5, { 0xd0, 0x83, 0xd0, 0xe0, 0x32 } },
    { 2561, 16, { 0xc0, 0xe0, 0xc0, 0x83, 0xc0, 0x82, 0xc0, 0x85, 0xc0, 0x84, 0xc0, 0x86, 0x75, 0x86, 0x00, 0x53 } },
    { 2577, 16, { 0x91, 0xef, 0x90, 0x7f, 0xab, 0x74, 0x10, 0xf0, 0xd0, 0x86, 0xd0, 0x84, 0xd0, 0x85, 0xd0, 0x82 } },
    { 2593, 5, { 0xd0, 0x83, 0xd0, 0xe0, 0x32 } },
    { 2880, 1, { 0x32 } },
    { 2409, 16, { 0xc0, 0xe0, 0xc0, 0x83, 0xc0, 0x82, 0xc0, 0x85, 0xc0, 0x84, 0xc0, 0x86, 0x75, 0x86, 0x00, 0xd2 } },
    { 2425, 16, { 0x3, 0x53, 0x91, 0xef, 0x90, 0x7f, 0xab, 0x74, 0x08, 0xf0, 0xd0, 0x86, 0xd0, 0x84, 0xd0, 0x85 } },
    { 2441, 7, { 0xd0, 0x82, 0xd0, 0x83, 0xd0, 0xe0, 0x32 } },
    { 2881, 1, { 0x32 } },
    { 2882, 1, { 0x32 } },
    { 1903, 16, { 0xc0, 0xe0, 0xc0, 0xf0, 0xc0, 0x83, 0xc0, 0x82, 0xc0, 0x85, 0xc0, 0x84, 0xc0, 0x86, 0x75, 0x86 } },
    { 1919, 16, { 0x0, 0xc0, 0xd0, 0x75, 0xd0, 0x00, 0xc0, 0x00, 0xc0, 0x01, 0xc0, 0x02, 0xc0, 0x03, 0xc0, 0x04 } },
    { 1935, 16, { 0xc0, 0x05, 0xc0, 0x06, 0xc0, 0x07, 0x12, 0x09, 0x90, 0x90, 0x7f, 0xb7, 0x74, 0x20, 0xf0, 0x90 } },
    { 1951, 16, { 0x7f, 0xa9, 0x74, 0x02, 0xf0, 0x53, 0x91, 0xef, 0xd0, 0x07, 0xd0, 0x06, 0xd0, 0x05, 0xd0, 0x04 } },
    { 1967, 16, { 0xd0, 0x03, 0xd0, 0x02, 0xd0, 0x01, 0xd0, 0x00, 0xd0, 0xd0, 0xd0, 0x86, 0xd0, 0x84, 0xd0, 0x85 } },
    { 1983, 9, { 0xd0, 0x82, 0xd0, 0x83, 0xd0, 0xf0, 0xd0, 0xe0, 0x32 } },
    { 1619, 16, { 0xc0, 0xe0, 0xc0, 0xf0, 0xc0, 0x83, 0xc0, 0x82, 0xc0, 0x85, 0xc0, 0x84, 0xc0, 0x86, 0x75, 0x86 } },
    { 1635, 16, { 0x0, 0xc0, 0xd0, 0x75, 0xd0, 0x00, 0xc0, 0x00, 0xc0, 0x01, 0xc0, 0x02, 0xc0, 0x03, 0xc0, 0x04 } },
    { 1651, 16, { 0xc0, 0x05, 0xc0, 0x06, 0xc0, 0x07, 0x90, 0x7f, 0x9b, 0xe0, 0x64, 0x80, 0x90, 0x7f, 0x98, 0xf0 } },
    { 1667, 16, { 0x53, 0x91, 0xef, 0x90, 0x7f, 0xaa, 0x74, 0x02, 0xf0, 0x12, 0x0b, 0x08, 0x90, 0x7f, 0xc7, 0xe4 } },
    { 1683, 16, { 0xf0, 0xd0, 0x07, 0xd0, 0x06, 0xd0, 0x05, 0xd0, 0x04, 0xd0, 0x03, 0xd0, 0x02, 0xd0, 0x01, 0xd0 } },
    { 1699, 16, { 0x0, 0xd0, 0xd0, 0xd0, 0x86, 0xd0, 0x84, 0xd0, 0x85, 0xd0, 0x82, 0xd0, 0x83, 0xd0, 0xf0, 0xd0 } },
    { 1715, 2, { 0xe0, 0x32 } },
    { 2883, 1, { 0x32 } },
    { 2884, 1, { 0x32 } },
    { 2885, 1, { 0x32 } },
    { 2886, 1, { 0x32 } },
    { 2887, 1, { 0x32 } },
    { 2888, 1, { 0x32 } },
    { 2889, 1, { 0x32 } },
    { 2890, 1, { 0x32 } },
    { 2891, 1, { 0x32 } },
    { 2892, 1, { 0x32 } },
    { 2893, 1, { 0x32 } },
    { 2894, 1, { 0x32 } },
    { 875, 16, { 0xe4, 0xf5, 0x31, 0xf5, 0x30, 0xf5, 0x2f, 0xf5, 0x2e, 0xc2, 0x03, 0xc2, 0x00, 0xc2, 0x02, 0xc2 } },
    { 891, 16, { 0x1, 0x12, 0x06, 0xb5, 0x7e, 0x05, 0x7f, 0x06, 0x8e, 0x08, 0x8f, 0x09, 0x75, 0x0a, 0x05, 0x75 } },
    { 907, 16, { 0xb, 0x18, 0x75, 0x0c, 0x05, 0x75, 0x0d, 0x38, 0xee, 0x54, 0xe0, 0x70, 0x03, 0x02, 0x04, 0x77 } },
    { 923, 16, { 0x75, 0x32, 0x00, 0x75, 0x33, 0x80, 0x8e, 0x34, 0x8f, 0x35, 0xc3, 0x74, 0x74, 0x9f, 0xff, 0x74 } },
    { 939, 16, { 0x5, 0x9e, 0xcf, 0x24, 0x02, 0xcf, 0x34, 0x00, 0xfe, 0xe4, 0x8f, 0x2d, 0x8e, 0x2c, 0xf5, 0x2b } },
    { 955, 16, { 0xf5, 0x2a, 0xf5, 0x29, 0xf5, 0x28, 0xf5, 0x27, 0xf5, 0x26, 0xaf, 0x2d, 0xae, 0x2c, 0xad, 0x2b } },
    { 971, 16, { 0xac, 0x2a, 0xab, 0x29, 0xaa, 0x28, 0xa9, 0x27, 0xa8, 0x26, 0xc3, 0x12, 0x08, 0x9e, 0x50, 0x26 } },
    { 987, 16, { 0xe5, 0x33, 0x25, 0x29, 0xf5, 0x82, 0xe5, 0x32, 0x35, 0x28, 0xf5, 0x83, 0x74, 0xcd, 0xf0, 0xe5 } },
    { 1003, 16, { 0x29, 0x24, 0x01, 0xf5, 0x29, 0xe4, 0x35, 0x28, 0xf5, 0x28, 0xe4, 0x35, 0x27, 0xf5, 0x27, 0xe4 } },
    { 1019, 16, { 0x35, 0x26, 0xf5, 0x26, 0x80, 0xc4, 0xe4, 0xf5, 0x29, 0xf5, 0x28, 0xf5, 0x27, 0xf5, 0x26, 0xaf } },
    { 1035, 16, { 0x2d, 0xae, 0x2c, 0xad, 0x2b, 0xac, 0x2a, 0xab, 0x29, 0xaa, 0x28, 0xa9, 0x27, 0xa8, 0x26, 0xc3 } },
    { 1051, 16, { 0x12, 0x08, 0x9e, 0x50, 0x31, 0xae, 0x28, 0xaf, 0x29, 0xe5, 0x35, 0x2f, 0xf5, 0x82, 0xe5, 0x34 } },
    { 1067, 16, { 0x3e, 0xf5, 0x83, 0xe0, 0xfd, 0xe5, 0x33, 0x2f, 0xf5, 0x82, 0xe5, 0x32, 0x3e, 0xf5, 0x83, 0xed } },
    { 1083, 16, { 0xf0, 0xef, 0x24, 0x01, 0xf5, 0x29, 0xe4, 0x3e, 0xf5, 0x28, 0xe4, 0x35, 0x27, 0xf5, 0x27, 0xe4 } },
    { 1099, 16, { 0x35, 0x26, 0xf5, 0x26, 0x80, 0xb9, 0x85, 0x32, 0x08, 0x85, 0x33, 0x09, 0x74, 0x06, 0x24, 0x80 } },
    { 1115, 16, { 0xff, 0x74, 0x05, 0x34, 0xff, 0xfe, 0xc3, 0xe5, 0x0b, 0x9f, 0xf5, 0x0b, 0xe5, 0x0a, 0x9e, 0xf5 } },
    { 1131, 16, { 0xa, 0xc3, 0xe5, 0x0d, 0x9f, 0xf5, 0x0d, 0xe5, 0x0c, 0x9e, 0xf5, 0x0c, 0xd2, 0xe8, 0x43, 0xd8 } },
    { 1147, 16, { 0x20, 0x90, 0x7f, 0xab, 0x74, 0xff, 0xf0, 0x90, 0x7f, 0xaf, 0xe0, 0x44, 0x01, 0xf0, 0x90, 0x7f } },
    { 1163, 16, { 0xae, 0xe0, 0x44, 0x1d, 0xf0, 0xd2, 0xaf, 0x20, 0x01, 0x41, 0x20, 0x01, 0x05, 0xd2, 0x04, 0x12 } },
    { 1179, 16, { 0x8, 0xaf, 0xe4, 0xf5, 0x31, 0xf5, 0x30, 0xf5, 0x2f, 0xf5, 0x2e, 0x7f, 0x40, 0x7e, 0x92, 0x7d } },
    { 1195, 16, { 0x4, 0x7c, 0x00, 0xab, 0x31, 0xaa, 0x30, 0xa9, 0x2f, 0xa8, 0x2e, 0xc3, 0x12, 0x08, 0x9e, 0x50 } },
    { 1211, 16, { 0xd6, 0x20, 0x01, 0xd3, 0xe5, 0x31, 0x24, 0x01, 0xf5, 0x31, 0xe4, 0x35, 0x30, 0xf5, 0x30, 0xe4 } },
    { 1227, 16, { 0x35, 0x2f, 0xf5, 0x2f, 0xe4, 0x35, 0x2e, 0xf5, 0x2e, 0x80, 0xd0, 0x53, 0x8e, 0xf8, 0x12, 0x0b } },
    { 1243, 16, { 0x16, 0x30, 0x01, 0x05, 0x12, 0x00, 0x80, 0xc2, 0x01, 0x30, 0x03, 0x1a, 0x12, 0x0b, 0x33, 0x50 } },
    { 1259, 16, { 0x15, 0xc2, 0x03, 0x12, 0x0a, 0x49, 0x20, 0x00, 0x07, 0x90, 0x7f, 0xd6, 0xe0, 0x20, 0xe7, 0xf3 } },
    { 1275, 11, { 0x12, 0x0a, 0xa1, 0x12, 0x0b, 0x35, 0x12, 0x0b, 0x3f, 0x80, 0xd6 } },
    { 128, 16, { 0x90, 0x7f, 0xe9, 0xe0, 0x70, 0x03, 0x02, 0x02, 0x10, 0x14, 0x70, 0x03, 0x02, 0x02, 0x8c, 0x24 } },
    { 144, 16, { 0xfe, 0x70, 0x03, 0x02, 0x03, 0x03, 0x24, 0xfb, 0x70, 0x03, 0x02, 0x02, 0x0a, 0x14, 0x70, 0x03 } },
    { 160, 16, { 0x2, 0x02, 0x04, 0x14, 0x70, 0x03, 0x02, 0x01, 0xf8, 0x14, 0x70, 0x03, 0x02, 0x01, 0xfe, 0x24 } },
    { 176, 16, { 0x5, 0x60, 0x03, 0x02, 0x03, 0x57, 0x12, 0x0b, 0x37, 0x40, 0x03, 0x02, 0x03, 0x63, 0x90, 0x7f } },
    { 192, 16, { 0xeb, 0xe0, 0x24, 0xfe, 0x60, 0x19, 0x14, 0x60, 0x45, 0x24, 0x02, 0x60, 0x03, 0x02, 0x01, 0xee } },
    { 208, 16, { 0xe5, 0x08, 0x90, 0x7f, 0xd4, 0xf0, 0xe5, 0x09, 0x90, 0x7f, 0xd5, 0xf0, 0x02, 0x03, 0x63, 0x90 } },
    { 224, 16, { 0x7f, 0xea, 0xe0, 0xff, 0x12, 0x09, 0x00, 0xaa, 0x06, 0xa9, 0x07, 0x7b, 0x01, 0x8b, 0x36, 0x8a } },
    { 240, 16, { 0x37, 0x89, 0x38, 0xea, 0x49, 0x60, 0x0d, 0xee, 0x90, 0x7f, 0xd4, 0xf0, 0xef, 0x90, 0x7f, 0xd5 } },
    { 256, 16, { 0xf0, 0x02, 0x03, 0x63, 0x90, 0x7f, 0xb4, 0xe0, 0x44, 0x01, 0xf0, 0x02, 0x03, 0x63, 0x90, 0x7f } },
    { 272, 16, { 0xea, 0xe0, 0xff, 0x12, 0x07, 0xc8, 0xaa, 0x06, 0xa9, 0x07, 0x7b, 0x01, 0x8b, 0x36, 0x8a, 0x37 } },
    { 288, 9, { 0x89, 0x38, 0xea, 0x49, 0x70, 0x03, 0x02, 0x01, 0xe4 } },
    { 297, 16, { 0xab, 0x36, 0x8b, 0x3d, 0x8a, 0x3e, 0x89, 0x3f, 0x12, 0x08, 0x58, 0xf5, 0x40, 0x90, 0x7f, 0xee } },
    { 313, 16, { 0xe0, 0xff, 0xe5, 0x40, 0xd3, 0x9f, 0x40, 0x03, 0xe0, 0xf5, 0x40, 0xe5, 0x40, 0x70, 0x03, 0x02 } },
    { 329, 16, { 0x1, 0xd6, 0xe4, 0xf5, 0x3c, 0xf5, 0x3b, 0xf5, 0x3a, 0xf5, 0x39, 0xe5, 0x40, 0xc3, 0x94, 0x40 } },
    { 345, 16, { 0x50, 0x04, 0xaf, 0x40, 0x80, 0x02, 0x7f, 0x40, 0xe4, 0xfc, 0xfd, 0xfe, 0xab, 0x3c, 0xaa, 0x3b } },
    { 361, 16, { 0xa9, 0x3a, 0xa8, 0x39, 0xc3, 0x12, 0x08, 0x9e, 0x50, 0x32, 0xe5, 0x3f, 0x25, 0x3c, 0xf5, 0x82 } },
    { 377, 16, { 0xe5, 0x3e, 0x35, 0x3b, 0xf5, 0x83, 0xe0, 0xff, 0x74, 0x00, 0x25, 0x3c, 0xf5, 0x82, 0xe4, 0x34 } },
    { 393, 16, { 0x7f, 0xf5, 0x83, 0xef, 0xf0, 0xe5, 0x3c, 0x24, 0x01, 0xf5, 0x3c, 0xe4, 0x35, 0x3b, 0xf5, 0x3b } },
    { 409, 16, { 0xe4, 0x35, 0x3a, 0xf5, 0x3a, 0xe4, 0x35, 0x39, 0xf5, 0x39, 0x80, 0xaf, 0xe5, 0x40, 0xc3, 0x94 } },
    { 425, 16, { 0x40, 0x50, 0x04, 0xaf, 0x40, 0x80, 0x02, 0x7f, 0x40, 0x90, 0x7f, 0xb5, 0xef, 0xf0, 0xe5, 0x40 } },
    { 441, 16, { 0xc3, 0x94, 0x40, 0x50, 0x04, 0xaf, 0x40, 0x80, 0x02, 0x7f, 0x40, 0xc3, 0xe5, 0x40, 0x9f, 0xf5 } },
    { 457, 16, { 0x40, 0x90, 0x7f, 0xb4, 0xe0, 0x20, 0xe2, 0x03, 0x02, 0x01, 0x44, 0x80, 0xf4, 0xe4, 0x90, 0x7f } },
    { 473, 8, { 0xb5, 0xf0, 0x90, 0x7f, 0xb4, 0x74, 0x02, 0xf0 } },
    { 481, 16, { 0x2, 0x03, 0x63, 0x90, 0x7f, 0xb4, 0xe0, 0x44, 0x01, 0xf0, 0x02, 0x03, 0x63, 0x90, 0x7f, 0xb4 } },
    { 497, 16, { 0xe0, 0x44, 0x01, 0xf0, 0x02, 0x03, 0x63, 0x12, 0x0a, 0xfa, 0x02, 0x03, 0x63, 0x12, 0x0b, 0x27 } },
    { 513, 16, { 0x2, 0x03, 0x63, 0x12, 0x0b, 0x1f, 0x02, 0x03, 0x63, 0x12, 0x0a, 0xec, 0x02, 0x03, 0x63, 0x12 } },
    { 529, 16, { 0xb, 0x39, 0x40, 0x03, 0x02, 0x03, 0x63, 0x90, 0x7f, 0xe8, 0xe0, 0x24, 0x7f, 0x60, 0x24, 0x14 } },
    { 545, 16, { 0x60, 0x31, 0x24, 0x02, 0x70, 0x5b, 0xa2, 0x00, 0xe4, 0x33, 0xff, 0x25, 0xe0, 0xff, 0xa2, 0x02 } },
    { 561, 16, { 0xe4, 0x33, 0x4f, 0x90, 0x7f, 0x00, 0xf0, 0xe4, 0xa3, 0xf0, 0x90, 0x7f, 0xb5, 0x74, 0x02, 0xf0 } },
    { 577, 16, { 0x2, 0x03, 0x63, 0xe4, 0x90, 0x7f, 0x00, 0xf0, 0xa3, 0xf0, 0x90, 0x7f, 0xb5, 0x74, 0x02, 0xf0 } },
    { 593, 16, { 0x2, 0x03, 0x63, 0x90, 0x7f, 0xec, 0xe0, 0xf4, 0x54, 0x80, 0xff, 0xc4, 0x54, 0x0f, 0xff, 0xe0 } },
    { 609, 16, { 0x54, 0x07, 0x2f, 0x25, 0xe0, 0x24, 0xb4, 0xf5, 0x82, 0xe4, 0x34, 0x7f, 0xf5, 0x83, 0xe0, 0x54 } },
    { 625, 16, { 0x1, 0x90, 0x7f, 0x00, 0xf0, 0xe4, 0xa3, 0xf0, 0x90, 0x7f, 0xb5, 0x74, 0x02, 0xf0, 0x02, 0x03 } },
    { 641, 16, { 0x63, 0x90, 0x7f, 0xb4, 0xe0, 0x44, 0x01, 0xf0, 0x02, 0x03, 0x63, 0x12, 0x0b, 0x3b, 0x40, 0x03 } },
    { 657, 16, { 0x2, 0x03, 0x63, 0x90, 0x7f, 0xe8, 0xe0, 0x24, 0xfe, 0x60, 0x1d, 0x24, 0x02, 0x60, 0x03, 0x02 } },
    { 673, 16, { 0x3, 0x63, 0x90, 0x7f, 0xea, 0xe0, 0xb4, 0x01, 0x05, 0xc2, 0x00, 0x02, 0x03, 0x63, 0x90, 0x7f } },
    { 689, 16, { 0xb4, 0xe0, 0x44, 0x01, 0xf0, 0x02, 0x03, 0x63, 0x90, 0x7f, 0xea, 0xe0, 0x70, 0x3b, 0x90, 0x7f } },
    { 705, 16, { 0xec, 0xe0, 0xf4, 0x54, 0x80, 0xff, 0xc4, 0x54, 0x0f, 0xff, 0xe0, 0x54, 0x07, 0x2f, 0x25, 0xe0 } },
    { 721, 16, { 0x24, 0xb4, 0xf5, 0x82, 0xe4, 0x34, 0x7f, 0xf5, 0x83, 0xe4, 0xf0, 0x90, 0x7f, 0xec, 0xe0, 0x54 } },
    { 737, 16, { 0x80, 0xff, 0x13, 0x13, 0x13, 0x54, 0x1f, 0xff, 0xe0, 0x54, 0x07, 0x2f, 0x90, 0x7f, 0xd7, 0xf0 } },
    { 753, 3, { 0xe4, 0xf5, 0x3d } },
    { 756, 16, { 0xe0, 0x44, 0x20, 0xf0, 0x80, 0x69, 0x90, 0x7f, 0xb4, 0xe0, 0x44, 0x01, 0xf0, 0x80, 0x60, 0x12 } },
    { 772, 16, { 0xb, 0x3d, 0x50, 0x5b, 0x90, 0x7f, 0xe8, 0xe0, 0x24, 0xfe, 0x60, 0x18, 0x24, 0x02, 0x70, 0x4f } },
    { 788, 16, { 0x90, 0x7f, 0xea, 0xe0, 0xb4, 0x01, 0x04, 0xd2, 0x00, 0x80, 0x44, 0x90, 0x7f, 0xb4, 0xe0, 0x44 } },
    { 804, 16, { 0x1, 0xf0, 0x80, 0x3b, 0x90, 0x7f, 0xea, 0xe0, 0x70, 0x20, 0x90, 0x7f, 0xec, 0xe0, 0xf4, 0x54 } },
    { 820, 16, { 0x80, 0xff, 0xc4, 0x54, 0x0f, 0xff, 0xe0, 0x54, 0x07, 0x2f, 0x25, 0xe0, 0x24, 0xb4, 0xf5, 0x82 } },
    { 836, 16, { 0xe4, 0x34, 0x7f, 0xf5, 0x83, 0x74, 0x01, 0xf0, 0x80, 0x15, 0x90, 0x7f, 0xb4, 0xe0, 0x44, 0x01 } },
    { 852, 16, { 0xf0, 0x80, 0x0c, 0x12, 0x0a, 0x26, 0x50, 0x07, 0x90, 0x7f, 0xb4, 0xe0, 0x44, 0x01, 0xf0, 0x90 } },
    { 868, 6, { 0x7f, 0xb4, 0xe0, 0x44, 0x02, 0xf0 } },
    { 874, 1, { 0x22 } },
    { 51, 3, { 0x2, 0x0b, 0x2f } },
    { 2863, 4, { 0x53, 0xd8, 0xef, 0x32 } },
    { 1286, 16, { 0x12, 0x01, 0x00, 0x01, 0x00, 0x00, 0x00, 0x40, 0x62, 0x09, 0x01, 0x20, 0x01, 0x00, 0x01, 0x02 } },
    { 1302, 16, { 0x0, 0x01, 0x09, 0x02, 0x20, 0x00, 0x01, 0x01, 0x00, 0xa0, 0x00, 0x09, 0x04, 0x00, 0x00, 0x02 } },
    { 1318, 16, { 0xff, 0x00, 0x00, 0x00, 0x07, 0x05, 0x01, 0x02, 0x20, 0x00, 0x00, 0x07, 0x05, 0x81, 0x02, 0x20 } },
    { 1334, 16, { 0x0, 0x00, 0x04, 0x03, 0x09, 0x04, 0x26, 0x03, 0x44, 0x00, 0x69, 0x00, 0x67, 0x00, 0x69, 0x00 } },
    { 1350, 16, { 0x74, 0x00, 0x61, 0x00, 0x6c, 0x00, 0x20, 0x00, 0x41, 0x00, 0x72, 0x00, 0x74, 0x00, 0x20, 0x00 } },
    { 1366, 16, { 0x53, 0x00, 0x79, 0x00, 0x73, 0x00, 0x74, 0x00, 0x65, 0x00, 0x6d, 0x00, 0x12, 0x03, 0x53, 0x00 } },
    { 1382, 16, { 0x55, 0x00, 0x49, 0x00, 0x44, 0x00, 0x49, 0x00, 0x2d, 0x00, 0x45, 0x00, 0x43, 0x00, 0x00, 0x00 } },
    { 67, 3, { 0x2, 0x08, 0x00 } },
    { 2048, 16, { 0x2, 0x09, 0x42, 0x00, 0x02, 0x09, 0xdc, 0x00, 0x02, 0x09, 0xb7, 0x00, 0x02, 0x09, 0x69, 0x00 } },
    { 2064, 16, { 0x2, 0x0a, 0x01, 0x00, 0x02, 0x0b, 0x40, 0x00, 0x02, 0x0b, 0x41, 0x00, 0x02, 0x0b, 0x42, 0x00 } },
    { 2080, 16, { 0x2, 0x07, 0x6f, 0x00, 0x02, 0x06, 0x53, 0x00, 0x02, 0x0b, 0x43, 0x00, 0x02, 0x0b, 0x44, 0x00 } },
    { 2096, 16, { 0x2, 0x0b, 0x45, 0x00, 0x02, 0x0b, 0x46, 0x00, 0x02, 0x0b, 0x47, 0x00, 0x02, 0x0b, 0x48, 0x00 } },
    { 2112, 16, { 0x2, 0x0b, 0x49, 0x00, 0x02, 0x0b, 0x4a, 0x00, 0x02, 0x0b, 0x4b, 0x00, 0x02, 0x0b, 0x4c, 0x00 } },
    { 2128, 8, { 0x2, 0x0b, 0x4d, 0x00, 0x02, 0x0b, 0x4e, 0x00 } },
    { 2721, 16, { 0x90, 0x7f, 0xd6, 0xe0, 0x30, 0xe7, 0x12, 0xe0, 0x44, 0x01, 0xf0, 0x7f, 0x14, 0x7e, 0x00, 0x12 } },
    { 2737, 10, { 0xa, 0xd5, 0x90, 0x7f, 0xd6, 0xe0, 0x54, 0xfe, 0xf0, 0x22 } },
    { 2633, 16, { 0x90, 0x7f, 0xd6, 0xe0, 0x44, 0x80, 0xf0, 0x43, 0x87, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22 } },
    { 2223, 7, { 0x90, 0x7f, 0xd6, 0xe0, 0x44, 0x08, 0xf0 } },
    { 2230, 3, { 0xe4, 0xf5, 0x36 } },
    { 2233, 4, { 0xe0, 0x54, 0xfb, 0xf0 } },
    { 2237, 3, { 0xe4, 0xf5, 0x36 } },
    { 2240, 16, { 0xe0, 0x44, 0x08, 0xf0, 0x30, 0x04, 0x04, 0xe0, 0x44, 0x02, 0xf0, 0x7f, 0xdc, 0x7e, 0x05, 0x12 } },
    { 2256, 16, { 0xa, 0xd5, 0x90, 0x7f, 0x92, 0xe0, 0x30, 0xe3, 0x07, 0x7f, 0xdc, 0x7e, 0x05, 0x12, 0x0a, 0xd5 } },
    { 2272, 16, { 0x90, 0x7f, 0xab, 0x74, 0xff, 0xf0, 0x90, 0x7f, 0xa9, 0xf0, 0x90, 0x7f, 0xaa, 0xf0, 0x53, 0x91 } },
    { 2288, 8, { 0xef, 0x90, 0x7f, 0xd6, 0xe0, 0x54, 0xf7, 0xf0 } },
    { 2296, 3, { 0xe4, 0xf5, 0x36 } },
    { 2299, 5, { 0xe0, 0x44, 0x04, 0xf0, 0x22 } },
    { 1992, 2, { 0xa9, 0x07 } },
    { 1994, 16, { 0xae, 0x0c, 0xaf, 0x0d, 0x8f, 0x82, 0x8e, 0x83, 0xa3, 0xe0, 0x64, 0x03, 0x70, 0x17, 0xad, 0x01 } },
    { 2010, 16, { 0x19, 0xed, 0x70, 0x01, 0x22, 0x8f, 0x82, 0x8e, 0x83, 0xe0, 0x7c, 0x00, 0x2f, 0xfd, 0xec, 0x3e } },
    { 2026, 9, { 0xfe, 0xaf, 0x05, 0x80, 0xdf, 0x7e, 0x00, 0x7f, 0x00 } },
    { 2035, 1, { 0x22 } },
    { 2304, 16, { 0xe4, 0xfe, 0xac, 0x0a, 0xad, 0x0b, 0x8d, 0x82, 0x8c, 0x83, 0xa3, 0xe0, 0x64, 0x02, 0x70, 0x2d } },
    { 2320, 16, { 0xab, 0x06, 0x0e, 0xeb, 0xb5, 0x07, 0x05, 0xaf, 0x05, 0xae, 0x04, 0x22, 0x8d, 0x82, 0x8c, 0x83 } },
    { 2336, 16, { 0xa3, 0xa3, 0xe0, 0xf5, 0x41, 0xa3, 0xe0, 0xf5, 0x42, 0x62, 0x41, 0xe5, 0x41, 0x62, 0x42, 0xe5 } },
    { 2352, 16, { 0x42, 0x62, 0x41, 0x2d, 0xfb, 0xe5, 0x41, 0x3c, 0xfc, 0xad, 0x03, 0x80, 0xc9, 0x7e, 0x00, 0x7f } },
    { 2368, 1, { 0x0 } },
    { 2369, 1, { 0x22 } },
    { 2773, 16, { 0x8e, 0x37, 0x8f, 0x38, 0xe5, 0x38, 0x15, 0x38, 0xae, 0x37, 0x70, 0x02, 0x15, 0x37, 0x4e, 0x60 } },
    { 2789, 7, { 0x5, 0x12, 0x0a, 0x59, 0x80, 0xee, 0x22 } },
    { 2649, 16, { 0x74, 0x00, 0xf5, 0x86, 0x90, 0xfd, 0xa5, 0x7c, 0x05, 0xa3, 0xe5, 0x82, 0x45, 0x83, 0x70, 0xf9 } },
    { 2665, 1, { 0x22 } },
    { 2666, 16, { 0xe4, 0xff, 0xfe, 0x7e, 0x02, 0x7f, 0x00, 0x90, 0x0d, 0xff, 0xe4, 0xf0, 0xa3, 0xdf, 0xfc, 0xde } },
    { 2682, 11, { 0xfa, 0x7f, 0x06, 0x12, 0x07, 0x15, 0x90, 0x0f, 0xfe, 0xef, 0xf0 } },
    { 2693, 1, { 0x22 } },
    { 2694, 16, { 0xd2, 0x9f, 0xd2, 0x9e, 0xd2, 0x9d, 0xc2, 0x9c, 0xd2, 0x9b, 0xd2, 0xbc, 0xc2, 0xc9, 0xd2, 0xcc } },
    { 2710, 11, { 0xd2, 0xcd, 0x75, 0xcb, 0xff, 0x75, 0xca, 0xfd, 0xd2, 0xca, 0x22 } },
    { 2448, 16, { 0x90, 0x7f, 0x9b, 0xe0, 0xff, 0x25, 0xe0, 0x25, 0xe0, 0x54, 0x30, 0xff, 0x90, 0x7e, 0x40, 0xe0 } },
    { 2464, 16, { 0x54, 0x0f, 0x4f, 0x90, 0x7e, 0x80, 0xf0, 0x90, 0x7f, 0x9a, 0xe0, 0x90, 0x7e, 0x81, 0xf0, 0xa3 } },
    { 2480, 7, { 0x74, 0x01, 0xf0, 0xe4, 0xa3, 0xf0, 0x22 } },
    { 2838, 9, { 0xc2, 0x99, 0xc2, 0x98, 0xd2, 0xac, 0x02, 0x0a, 0xbb } },
    { 2747, 16, { 0x75, 0xcb, 0xff, 0x75, 0xca, 0xf8, 0x75, 0x10, 0x02, 0x75, 0x11, 0x59, 0xe4, 0xf5, 0x99, 0x90 } },
    { 2763, 10, { 0x7f, 0x9b, 0xe0, 0x64, 0x40, 0x90, 0x7f, 0x98, 0xf0, 0x22 } },
    { 35, 3, { 0x2, 0x05, 0x76 } },
    { 1398, 16, { 0xc0, 0xe0, 0xc0, 0x83, 0xc0, 0x82, 0xc0, 0x85, 0xc0, 0x84, 0xc0, 0x86, 0x75, 0x86, 0x00, 0xc0 } },
    { 1414, 16, { 0xd0, 0xc2, 0x99, 0xc3, 0xe5, 0x10, 0x94, 0x02, 0x50, 0x19, 0x74, 0xff, 0x25, 0x11, 0xf5, 0x82 } },
    { 1430, 16, { 0x74, 0x0d, 0x35, 0x10, 0xf5, 0x83, 0xe0, 0xf5, 0x99, 0x05, 0x11, 0xe5, 0x11, 0x70, 0x32, 0x05 } },
    { 1446, 16, { 0x10, 0x80, 0x2e, 0xe4, 0xb5, 0x11, 0x0a, 0xe5, 0x10, 0xb4, 0x02, 0x05, 0x12, 0x0a, 0xbb, 0x80 } },
    { 1462, 16, { 0x20, 0xe5, 0x11, 0xb4, 0x59, 0x16, 0xe5, 0x10, 0xb4, 0x02, 0x11, 0x75, 0xcb, 0xff, 0x75, 0xca } },
    { 1478, 16, { 0xfd, 0x75, 0x10, 0x00, 0x75, 0x11, 0x00, 0x75, 0x99, 0x00, 0x80, 0x05, 0x30, 0x98, 0x02, 0xc2 } },
    { 1494, 16, { 0x98, 0xd0, 0xd0, 0xd0, 0x86, 0xd0, 0x84, 0xd0, 0x85, 0xd0, 0x82, 0xd0, 0x83, 0xd0, 0xe0, 0x32 } },
    { 2824, 14, { 0x90, 0x7e, 0x40, 0xe0, 0x54, 0xf0, 0x24, 0x80, 0x70, 0x03, 0x12, 0x05, 0xe6, 0x22 } },
    { 1510, 16, { 0x75, 0x22, 0x01, 0x7a, 0x7e, 0x79, 0x41, 0x75, 0x23, 0x01, 0x75, 0x24, 0x7e, 0x75, 0x25, 0x41 } },
    { 1526, 16, { 0xab, 0x23, 0xaa, 0x24, 0xa9, 0x25, 0x12, 0x08, 0x58, 0x75, 0xf0, 0x02, 0xa4, 0xff, 0xae, 0xf0 } },
    { 1542, 16, { 0x90, 0x00, 0x01, 0x12, 0x08, 0x71, 0xf5, 0x21, 0x74, 0x02, 0x25, 0x25, 0xf5, 0x25, 0xe4, 0x35 } },
    { 1558, 16, { 0x24, 0xf5, 0x24, 0xe5, 0x21, 0x54, 0x0f, 0xfd, 0xed, 0x60, 0x29, 0xab, 0x23, 0xaa, 0x24, 0xa9 } },
    { 1574, 16, { 0x25, 0x12, 0x08, 0x58, 0xfc, 0x74, 0xff, 0x2f, 0xf5, 0x82, 0x74, 0x0d, 0x3e, 0xf5, 0x83, 0xec } },
    { 1590, 16, { 0xf0, 0x74, 0x01, 0x25, 0x25, 0xf5, 0x25, 0xe4, 0x35, 0x24, 0xf5, 0x24, 0x0f, 0xbf, 0x00, 0x01 } },
    { 1606, 12, { 0xe, 0x1d, 0x80, 0xd4, 0xe5, 0x21, 0x54, 0x80, 0xf5, 0x22, 0x70, 0xa4 } },
    { 1618, 1, { 0x22 } },
    { 1813, 16, { 0xae, 0xe8, 0xc2, 0xe9, 0x90, 0x7f, 0xa5, 0xe0, 0x44, 0x80, 0xf0, 0x90, 0x7f, 0xa6, 0x74, 0xa0 } },
    { 1829, 16, { 0xf0, 0x90, 0x7f, 0xa5, 0xe0, 0x30, 0xe0, 0xf9, 0x90, 0x7f, 0xa6, 0xef, 0xf0, 0x90, 0x7f, 0xa5 } },
    { 1845, 16, { 0xe0, 0x30, 0xe0, 0xf9, 0x90, 0x7f, 0xa5, 0xe0, 0x44, 0x80, 0xf0, 0x90, 0x7f, 0xa6, 0x74, 0xa1 } },
    { 1861, 16, { 0xf0, 0x90, 0x7f, 0xa5, 0xe0, 0x30, 0xe0, 0xf9, 0x90, 0x7f, 0xa5, 0xe0, 0x44, 0x20, 0xf0, 0x90 } },
    { 1877, 16, { 0x7f, 0xa6, 0xe0, 0xff, 0x90, 0x7f, 0xa5, 0xe0, 0x30, 0xe0, 0xf9, 0x90, 0x7f, 0xa5, 0xe0, 0x44 } },
    { 1893, 9, { 0x40, 0xf0, 0x90, 0x7f, 0xa6, 0xe0, 0xff, 0x8e, 0xe8 } },
    { 1902, 1, { 0x22 } },
    { 0, 3, { 0x2, 0x07, 0xf4 } },
    { 2036, 12, { 0x78, 0x7f, 0xe4, 0xf6, 0xd8, 0xfd, 0x75, 0x81, 0x42, 0x02, 0x03, 0x6b } },
    { 2136, 16, { 0xbb, 0x01, 0x06, 0x89, 0x82, 0x8a, 0x83, 0xe0, 0x22, 0x50, 0x02, 0xe7, 0x22, 0xbb, 0xfe, 0x02 } },
    { 2152, 9, { 0xe3, 0x22, 0x89, 0x82, 0x8a, 0x83, 0xe4, 0x93, 0x22 } },
    { 2161, 16, { 0xbb, 0x01, 0x0c, 0xe5, 0x82, 0x29, 0xf5, 0x82, 0xe5, 0x83, 0x3a, 0xf5, 0x83, 0xe0, 0x22, 0x50 } },
    { 2177, 16, { 0x6, 0xe9, 0x25, 0x82, 0xf8, 0xe6, 0x22, 0xbb, 0xfe, 0x06, 0xe9, 0x25, 0x82, 0xf8, 0xe2, 0x22 } },
    { 2193, 13, { 0xe5, 0x82, 0x29, 0xf5, 0x82, 0xe5, 0x83, 0x3a, 0xf5, 0x83, 0xe4, 0x93, 0x22 } },
    { 2206, 16, { 0xeb, 0x9f, 0xf5, 0xf0, 0xea, 0x9e, 0x42, 0xf0, 0xe9, 0x9d, 0x42, 0xf0, 0xe8, 0x9c, 0x45, 0xf0 } },
    { 2222, 1, { 0x22 } },
    { 32658, 1, { 0x1 } }, /* reset=1 */
    { 32658, 1, { 0x0 } }, /* reset=0 */
    { 0xffff, 0, {0x00}}
  };


static const struct sunlite_hex_record   sunlite_firmware_in[] = {
{0x7f92, 0x1, {0x01}},
{0x7f92, 0x1, {0x01}},
{0x146c, 0x10, {0xC2, 0x00, 0x90, 0x7F, 0xA5, 0xE0, 0x54, 0x18, 0xFF, 0x13, 0x13, 0x13, 0x54, 0x1F, 0x44, 0x50}},
{0x147c, 0x10, {0xF5, 0x1C, 0x13, 0x92, 0x01, 0xD2, 0xE8, 0x90, 0x7F, 0xAB, 0x74, 0xFF, 0xF0, 0x90, 0x7F, 0xA9}},
{0x148c, 0x10, {0xF0, 0x90, 0x7F, 0xAA, 0xF0, 0x53, 0x91, 0xEF, 0x90, 0x7F, 0x95, 0xE0, 0x44, 0xC0, 0xF0, 0x90}},
{0x149c, 0x10, {0x7F, 0xAF, 0xE0, 0x44, 0x01, 0xF0, 0x90, 0x7F, 0xAE, 0xE0, 0x44, 0x05, 0xF0, 0xD2, 0xAF, 0x12}},
{0x14ac, 0xd, {0x17, 0x5F, 0x30, 0x00, 0xFD, 0x12, 0x11, 0x00, 0xC2, 0x00, 0x80, 0xF6, 0x22}},
{0x1100, 0x10, {0x90, 0x7F, 0xE9, 0xE0, 0x24, 0x5D, 0x60, 0x0D, 0x14, 0x70, 0x03, 0x02, 0x12, 0x44, 0x24, 0x02}},
{0x1110, 0x10, {0x60, 0x03, 0x02, 0x12, 0x4A, 0x90, 0x7F, 0xEA, 0xE0, 0x75, 0x08, 0x00, 0xF5, 0x09, 0xA3, 0xE0}},
{0x1120, 0x10, {0xFE, 0xE4, 0x25, 0x09, 0xF5, 0x09, 0xEE, 0x35, 0x08, 0xF5, 0x08, 0x90, 0x7F, 0xEE, 0xE0, 0x75}},
{0x1130, 0x10, {0x0A, 0x00, 0xF5, 0x0B, 0xA3, 0xE0, 0xFE, 0xE4, 0x25, 0x0B, 0xF5, 0x0B, 0xEE, 0x35, 0x0A, 0xF5}},
{0x1140, 0x10, {0x0A, 0x90, 0x7F, 0xE8, 0xE0, 0x64, 0xC0, 0x60, 0x03, 0x02, 0x11, 0xD4, 0xE5, 0x0B, 0x45, 0x0A}},
{0x1150, 0x10, {0x70, 0x03, 0x02, 0x12, 0x4A, 0xC3, 0xE5, 0x0B, 0x94, 0x40, 0xE5, 0x0A, 0x94, 0x00, 0x50, 0x08}},
{0x1160, 0x10, {0x85, 0x0A, 0x0C, 0x85, 0x0B, 0x0D, 0x80, 0x06, 0x75, 0x0C, 0x00, 0x75, 0x0D, 0x40, 0x90, 0x7F}},
{0x1170, 0x10, {0xE9, 0xE0, 0xB4, 0xA3, 0x25, 0xAE, 0x0C, 0xAF, 0x0D, 0xAA, 0x08, 0xA9, 0x09, 0x7B, 0x01, 0xC0}},
{0x1180, 0x10, {0x03, 0xC0, 0x02, 0xC0, 0x01, 0x7A, 0x7F, 0x79, 0x00, 0x78, 0x00, 0x7C, 0x7F, 0xAD, 0x03, 0xD0}},
{0x1190, 0x10, {0x01, 0xD0, 0x02, 0xD0, 0x03, 0x12, 0x13, 0x56, 0x80, 0x0F, 0xAF, 0x09, 0xAE, 0x08, 0xAD, 0x0D}},
{0x11a0, 0x10, {0x7A, 0x7F, 0x79, 0x00, 0x7B, 0x00, 0x12, 0x15, 0xA4, 0x90, 0x7F, 0xB5, 0xE5, 0x0D, 0xF0, 0xE5}},
{0x11b0, 0x10, {0x0D, 0x25, 0x09, 0xF5, 0x09, 0xE5, 0x0C, 0x35, 0x08, 0xF5, 0x08, 0xC3, 0xE5, 0x0B, 0x95, 0x0D}},
{0x11c0, 0x10, {0xF5, 0x0B, 0xE5, 0x0A, 0x95, 0x0C, 0xF5, 0x0A, 0x90, 0x7F, 0xB4, 0xE0, 0x20, 0xE2, 0x03, 0x02}},
{0x11d0, 0x10, {0x11, 0x4C, 0x80, 0xF4, 0x90, 0x7F, 0xE8, 0xE0, 0x64, 0x40, 0x70, 0x6E, 0xE5, 0x0B, 0x45, 0x0A}},
{0x11e0, 0x10, {0x60, 0x68, 0xE4, 0x90, 0x7F, 0xC5, 0xF0, 0x90, 0x7F, 0xB4, 0xE0, 0x20, 0xE3, 0xF9, 0x90, 0x7F}},
{0x11f0, 0x10, {0xC5, 0xE0, 0x75, 0x0C, 0x00, 0xF5, 0x0D, 0x90, 0x7F, 0xE9, 0xE0, 0xB4, 0xA3, 0x15, 0xAE, 0x0C}},
{0x1200, 0x10, {0xAF, 0x0D, 0xA8, 0x09, 0xAC, 0x08, 0x7D, 0x01, 0x7B, 0x01, 0x7A, 0x7E, 0x79, 0xC0, 0x12, 0x13}},
{0x1210, 0x10, {0x56, 0x80, 0x0F, 0xAF, 0x09, 0xAE, 0x08, 0xAD, 0x0D, 0x7A, 0x7F, 0x79, 0x00, 0x7B, 0x00, 0x12}},
{0x1220, 0x10, {0x14, 0xB9, 0xE5, 0x0D, 0x25, 0x09, 0xF5, 0x09, 0xE5, 0x0C, 0x35, 0x08, 0xF5, 0x08, 0xC3, 0xE5}},
{0x1230, 0x10, {0x0B, 0x95, 0x0D, 0xF5, 0x0B, 0xE5, 0x0A, 0x95, 0x0C, 0xF5, 0x0A, 0x90, 0x7F, 0xB4, 0xE0, 0x44}},
{0x1240, 0xa, {0x02, 0xF0, 0x80, 0x98, 0x90, 0x7F, 0xEA, 0xE0, 0xF5, 0x1C}},
{0x124a, 0x1, {0x22}},
{0x1558, 0x6, {0xAB, 0x07, 0xAA, 0x06, 0xAC, 0x05}},
{0x155e, 0x10, {0xE4, 0xFD, 0x30, 0x01, 0x11, 0xEA, 0xFF, 0xAE, 0x05, 0x0D, 0xEE, 0x24, 0x00, 0xF5, 0x82, 0xE4}},
{0x156e, 0x10, {0x34, 0xE0, 0xF5, 0x83, 0xEF, 0xF0, 0xEB, 0xAE, 0x05, 0x0D, 0x74, 0x00, 0x2E, 0xF5, 0x82, 0xE4}},
{0x157e, 0x10, {0x34, 0xE0, 0xF5, 0x83, 0xEB, 0xF0, 0xAF, 0x05, 0x0D, 0x74, 0x00, 0x2F, 0xF5, 0x82, 0xE4, 0x34}},
{0x158e, 0x10, {0xE0, 0xF5, 0x83, 0xEC, 0xF0, 0xAF, 0x1C, 0x7A, 0xE0, 0x7B, 0x00, 0x12, 0x17, 0x20, 0x7F, 0x0A}},
{0x159e, 0x5, {0x7E, 0x00, 0x12, 0x17, 0x3C}},
{0x15a3, 0x1, {0x22}},
{0x14b9, 0xa, {0x8E, 0x0E, 0x8F, 0x0F, 0x8D, 0x10, 0x8A, 0x11, 0x8B, 0x12}},
{0x14c3, 0x10, {0xE4, 0xF5, 0x13, 0xE5, 0x13, 0xC3, 0x95, 0x10, 0x50, 0x20, 0x05, 0x0F, 0xE5, 0x0F, 0xAE, 0x0E}},
{0x14d3, 0x10, {0x70, 0x02, 0x05, 0x0E, 0x14, 0xFF, 0xE5, 0x12, 0x25, 0x13, 0xF5, 0x82, 0xE4, 0x35, 0x11, 0xF5}},
{0x14e3, 0xa, {0x83, 0xE0, 0xFD, 0x12, 0x15, 0x58, 0x05, 0x13, 0x80, 0xD9}},
{0x14ed, 0x1, {0x22}},
{0x15a4, 0xa, {0x8E, 0x0E, 0x8F, 0x0F, 0x8D, 0x10, 0x8A, 0x11, 0x8B, 0x12}},
{0x15ae, 0x10, {0xE4, 0xFD, 0x30, 0x01, 0x12, 0xE5, 0x0E, 0xFF, 0xAE, 0x05, 0x0D, 0xEE, 0x24, 0x03, 0xF5, 0x82}},
{0x15be, 0x10, {0xE4, 0x34, 0xE0, 0xF5, 0x83, 0xEF, 0xF0, 0xE5, 0x0F, 0xAE, 0x05, 0x0D, 0x74, 0x03, 0x2E, 0xF5}},
{0x15ce, 0x10, {0x82, 0xE4, 0x34, 0xE0, 0xF5, 0x83, 0xE5, 0x0F, 0xF0, 0xAF, 0x1C, 0x7A, 0xE0, 0x7B, 0x03, 0x12}},
{0x15de, 0xd, {0x17, 0x20, 0xAF, 0x1C, 0xAD, 0x10, 0xAB, 0x12, 0xAA, 0x11, 0x12, 0x17, 0x04}},
{0x15eb, 0x1, {0x22}},
{0x166e, 0x10, {0xC0, 0xE0, 0xC0, 0x83, 0xC0, 0x82, 0xC0, 0x85, 0xC0, 0x84, 0xC0, 0x86, 0x75, 0x86, 0x00, 0xD2}},
{0x167e, 0x10, {0x00, 0x53, 0x91, 0xEF, 0x90, 0x7F, 0xAB, 0x74, 0x01, 0xF0, 0xD0, 0x86, 0xD0, 0x84, 0xD0, 0x85}},
{0x168e, 0x7, {0xD0, 0x82, 0xD0, 0x83, 0xD0, 0xE0, 0x32}},
{0x1644, 0x10, {0xC0, 0xE0, 0xC0, 0x83, 0xC0, 0x82, 0xC0, 0x85, 0xC0, 0x84, 0xC0, 0x86, 0x75, 0x86, 0x00, 0x90}},
{0x1654, 0x10, {0x7F, 0xC4, 0xE4, 0xF0, 0x53, 0x91, 0xEF, 0x90, 0x7F, 0xAB, 0x74, 0x04, 0xF0, 0xD0, 0x86, 0xD0}},
{0x1664, 0xa, {0x84, 0xD0, 0x85, 0xD0, 0x82, 0xD0, 0x83, 0xD0, 0xE0, 0x32}},
{0x1695, 0x10, {0xC0, 0xE0, 0xC0, 0x83, 0xC0, 0x82, 0xC0, 0x85, 0xC0, 0x84, 0xC0, 0x86, 0x75, 0x86, 0x00, 0x53}},
{0x16a5, 0x10, {0x91, 0xEF, 0x90, 0x7F, 0xAB, 0x74, 0x02, 0xF0, 0xD0, 0x86, 0xD0, 0x84, 0xD0, 0x85, 0xD0, 0x82}},
{0x16b5, 0x5, {0xD0, 0x83, 0xD0, 0xE0, 0x32}},
{0x16ba, 0x10, {0xC0, 0xE0, 0xC0, 0x83, 0xC0, 0x82, 0xC0, 0x85, 0xC0, 0x84, 0xC0, 0x86, 0x75, 0x86, 0x00, 0x53}},
{0x16ca, 0x10, {0x91, 0xEF, 0x90, 0x7F, 0xAB, 0x74, 0x10, 0xF0, 0xD0, 0x86, 0xD0, 0x84, 0xD0, 0x85, 0xD0, 0x82}},
{0x16da, 0x5, {0xD0, 0x83, 0xD0, 0xE0, 0x32}},
{0x14ff, 0x1, {0x32}},
{0x16df, 0x10, {0xC0, 0xE0, 0xC0, 0x83, 0xC0, 0x82, 0xC0, 0x85, 0xC0, 0x84, 0xC0, 0x86, 0x75, 0x86, 0x00, 0x53}},
{0x16ef, 0x10, {0x91, 0xEF, 0x90, 0x7F, 0xAB, 0x74, 0x08, 0xF0, 0xD0, 0x86, 0xD0, 0x84, 0xD0, 0x85, 0xD0, 0x82}},
{0x16ff, 0x5, {0xD0, 0x83, 0xD0, 0xE0, 0x32}},
{0x1767, 0x1, {0x32}},
{0x1768, 0x1, {0x32}},
{0x1769, 0x1, {0x32}},
{0x176a, 0x1, {0x32}},
{0x176b, 0x1, {0x32}},
{0x176c, 0x1, {0x32}},
{0x176d, 0x1, {0x32}},
{0x176e, 0x1, {0x32}},
{0x176f, 0x1, {0x32}},
{0x1770, 0x1, {0x32}},
{0x1771, 0x1, {0x32}},
{0x1772, 0x1, {0x32}},
{0x1773, 0x1, {0x32}},
{0x1774, 0x1, {0x32}},
{0x1775, 0x1, {0x32}},
{0x1776, 0x1, {0x32}},
{0x43, 0x3, {0x02, 0x15, 0x00}},
{0x1500, 0x10, {0x02, 0x16, 0x6E, 0x00, 0x02, 0x16, 0x95, 0x00, 0x02, 0x16, 0x44, 0x00, 0x02, 0x16, 0xDF, 0x00}},
{0x1510, 0x10, {0x02, 0x16, 0xBA, 0x00, 0x02, 0x14, 0xFF, 0x00, 0x02, 0x17, 0x67, 0x00, 0x02, 0x17, 0x68, 0x00}},
{0x1520, 0x10, {0x02, 0x17, 0x69, 0x00, 0x02, 0x17, 0x6A, 0x00, 0x02, 0x17, 0x6B, 0x00, 0x02, 0x17, 0x6C, 0x00}},
{0x1530, 0x10, {0x02, 0x17, 0x6D, 0x00, 0x02, 0x17, 0x6E, 0x00, 0x02, 0x17, 0x6F, 0x00, 0x02, 0x17, 0x70, 0x00}},
{0x1540, 0x10, {0x02, 0x17, 0x71, 0x00, 0x02, 0x17, 0x72, 0x00, 0x02, 0x17, 0x73, 0x00, 0x02, 0x17, 0x74, 0x00}},
{0x1550, 0x8, {0x02, 0x17, 0x75, 0x00, 0x02, 0x17, 0x76, 0x00}},
{0x173c, 0x10, {0x8E, 0x14, 0x8F, 0x15, 0xE5, 0x15, 0x15, 0x15, 0xAE, 0x14, 0x70, 0x02, 0x15, 0x14, 0x4E, 0x60}},
{0x174c, 0x7, {0x05, 0x12, 0x14, 0xEE, 0x80, 0xEE, 0x22}},
{0x175f, 0x8, {0xE4, 0xF5, 0x1B, 0xD2, 0xE9, 0xD2, 0xAF, 0x22}},
{0x1619, 0x10, {0xA9, 0x07, 0xE5, 0x1B, 0x70, 0x23, 0x90, 0x7F, 0xA5, 0xE0, 0x44, 0x80, 0xF0, 0xE9, 0x25, 0xE0}},
{0x1629, 0x10, {0x90, 0x7F, 0xA6, 0xF0, 0x8D, 0x16, 0xAF, 0x03, 0xA9, 0x07, 0x75, 0x17, 0x01, 0x8A, 0x18, 0x89}},
{0x1639, 0xb, {0x19, 0xE4, 0xF5, 0x1A, 0x75, 0x1B, 0x01, 0xD3, 0x22, 0xC3, 0x22}},
{0x15ec, 0x10, {0xA9, 0x07, 0xE5, 0x1B, 0x70, 0x25, 0x90, 0x7F, 0xA5, 0xE0, 0x44, 0x80, 0xF0, 0xE9, 0x25, 0xE0}},
{0x15fc, 0x10, {0x44, 0x01, 0x90, 0x7F, 0xA6, 0xF0, 0x8D, 0x16, 0xAF, 0x03, 0xA9, 0x07, 0x75, 0x17, 0x01, 0x8A}},
{0x160c, 0xd, {0x18, 0x89, 0x19, 0xE4, 0xF5, 0x1A, 0x75, 0x1B, 0x03, 0xD3, 0x22, 0xC3, 0x22}},
{0x4b, 0x3, {0x02, 0x13, 0x7F}},
{0x137f, 0x10, {0xC0, 0xE0, 0xC0, 0x83, 0xC0, 0x82, 0xC0, 0x85, 0xC0, 0x84, 0xC0, 0x86, 0x75, 0x86, 0x00, 0xC0}},
{0x138f, 0x10, {0xD0, 0x75, 0xD0, 0x00, 0xC0, 0x00, 0xC0, 0x01, 0xC0, 0x02, 0xC0, 0x03, 0xC0, 0x06, 0xC0, 0x07}},
{0x139f, 0x10, {0x90, 0x7F, 0xA5, 0xE0, 0x30, 0xE2, 0x06, 0x75, 0x1B, 0x06, 0x02, 0x14, 0x4E, 0x90, 0x7F, 0xA5}},
{0x13af, 0x10, {0xE0, 0x20, 0xE1, 0x0C, 0xE5, 0x1B, 0x64, 0x02, 0x60, 0x06, 0x75, 0x1B, 0x07, 0x02, 0x14, 0x4E}},
{0x13bf, 0x10, {0xAF, 0x1B, 0xEF, 0x24, 0xFE, 0x60, 0x48, 0x14, 0x60, 0x2C, 0x24, 0xFE, 0x60, 0x77, 0x24, 0x04}},
{0x13cf, 0x10, {0x60, 0x03, 0x02, 0x14, 0x4E, 0xAB, 0x17, 0xAA, 0x18, 0xA9, 0x19, 0xAF, 0x1A, 0x05, 0x1A, 0x8F}},
{0x13df, 0x10, {0x82, 0x75, 0x83, 0x00, 0x12, 0x12, 0x4B, 0x90, 0x7F, 0xA6, 0xF0, 0xE5, 0x1A, 0x65, 0x16, 0x70}},
{0x13ef, 0x10, {0x5E, 0x75, 0x1B, 0x05, 0x80, 0x59, 0x90, 0x7F, 0xA6, 0xE0, 0xAB, 0x17, 0xAA, 0x18, 0xA9, 0x19}},
{0x13ff, 0x10, {0xAE, 0x1A, 0x8E, 0x82, 0x75, 0x83, 0x00, 0x12, 0x12, 0x78, 0x75, 0x1B, 0x02, 0x80, 0x40, 0xE5}},
{0x140f, 0x10, {0x16, 0x24, 0xFE, 0xB5, 0x1A, 0x07, 0x90, 0x7F, 0xA5, 0xE0, 0x44, 0x20, 0xF0, 0xE5, 0x16, 0x14}},
{0x141f, 0x10, {0xB5, 0x1A, 0x0A, 0x90, 0x7F, 0xA5, 0xE0, 0x44, 0x40, 0xF0, 0x75, 0x1B, 0x00, 0x90, 0x7F, 0xA6}},
{0x142f, 0x10, {0xE0, 0xAB, 0x17, 0xAA, 0x18, 0xA9, 0x19, 0xAE, 0x1A, 0x8E, 0x82, 0x75, 0x83, 0x00, 0x12, 0x12}},
{0x143f, 0x10, {0x78, 0x05, 0x1A, 0x80, 0x0A, 0x90, 0x7F, 0xA5, 0xE0, 0x44, 0x40, 0xF0, 0x75, 0x1B, 0x00, 0x53}},
{0x144f, 0x10, {0x91, 0xDF, 0xD0, 0x07, 0xD0, 0x06, 0xD0, 0x03, 0xD0, 0x02, 0xD0, 0x01, 0xD0, 0x00, 0xD0, 0xD0}},
{0x145f, 0xd, {0xD0, 0x86, 0xD0, 0x84, 0xD0, 0x85, 0xD0, 0x82, 0xD0, 0x83, 0xD0, 0xE0, 0x32}},
{0x1704, 0x10, {0x12, 0x15, 0xEC, 0xE5, 0x1B, 0x24, 0xFA, 0x60, 0x0E, 0x14, 0x60, 0x06, 0x24, 0x07, 0x70, 0xF3}},
{0x1714, 0xc, {0xD3, 0x22, 0xE4, 0xF5, 0x1B, 0xD3, 0x22, 0xE4, 0xF5, 0x1B, 0xD3, 0x22}},
{0x1720, 0x10, {0x12, 0x16, 0x19, 0xE5, 0x1B, 0x24, 0xFA, 0x60, 0x0E, 0x14, 0x60, 0x06, 0x24, 0x07, 0x70, 0xF3}},
{0x1730, 0xc, {0xD3, 0x22, 0xE4, 0xF5, 0x1B, 0xD3, 0x22, 0xE4, 0xF5, 0x1B, 0xD3, 0x22}},
{0x14ee, 0x10, {0x74, 0x00, 0xF5, 0x86, 0x90, 0xFD, 0xA5, 0x7C, 0x05, 0xA3, 0xE5, 0x82, 0x45, 0x83, 0x70, 0xF9}},
{0x14fe, 0x1, {0x22}},
{0x0, 0x3, {0x02, 0x17, 0x53}},
{0x1753, 0xc, {0x78, 0x7F, 0xE4, 0xF6, 0xD8, 0xFD, 0x75, 0x81, 0x20, 0x02, 0x14, 0x6C}},
{0x124b, 0x10, {0xBB, 0x01, 0x0C, 0xE5, 0x82, 0x29, 0xF5, 0x82, 0xE5, 0x83, 0x3A, 0xF5, 0x83, 0xE0, 0x22, 0x50}},
{0x125b, 0x10, {0x06, 0xE9, 0x25, 0x82, 0xF8, 0xE6, 0x22, 0xBB, 0xFE, 0x06, 0xE9, 0x25, 0x82, 0xF8, 0xE2, 0x22}},
{0x126b, 0xd, {0xE5, 0x82, 0x29, 0xF5, 0x82, 0xE5, 0x83, 0x3A, 0xF5, 0x83, 0xE4, 0x93, 0x22}},
{0x1278, 0x10, {0xF8, 0xBB, 0x01, 0x0D, 0xE5, 0x82, 0x29, 0xF5, 0x82, 0xE5, 0x83, 0x3A, 0xF5, 0x83, 0xE8, 0xF0}},
{0x1288, 0x10, {0x22, 0x50, 0x06, 0xE9, 0x25, 0x82, 0xC8, 0xF6, 0x22, 0xBB, 0xFE, 0x05, 0xE9, 0x25, 0x82, 0xC8}},
{0x1298, 0x2, {0xF2, 0x22}},
{0x129a, 0x10, {0xE7, 0x09, 0xF6, 0x08, 0xDF, 0xFA, 0x80, 0x46, 0xE7, 0x09, 0xF2, 0x08, 0xDF, 0xFA, 0x80, 0x3E}},
{0x12aa, 0x10, {0x88, 0x82, 0x8C, 0x83, 0xE7, 0x09, 0xF0, 0xA3, 0xDF, 0xFA, 0x80, 0x32, 0xE3, 0x09, 0xF6, 0x08}},
{0x12ba, 0x10, {0xDF, 0xFA, 0x80, 0x6E, 0xE3, 0x09, 0xF2, 0x08, 0xDF, 0xFA, 0x80, 0x66, 0x88, 0x82, 0x8C, 0x83}},
{0x12ca, 0x10, {0xE3, 0x09, 0xF0, 0xA3, 0xDF, 0xFA, 0x80, 0x5A, 0x89, 0x82, 0x8A, 0x83, 0xE0, 0xA3, 0xF6, 0x08}},
{0x12da, 0x10, {0xDF, 0xFA, 0x80, 0x4E, 0x89, 0x82, 0x8A, 0x83, 0xE0, 0xA3, 0xF2, 0x08, 0xDF, 0xFA, 0x80, 0x42}},
{0x12ea, 0x10, {0x80, 0xD2, 0x80, 0xFA, 0x80, 0xC6, 0x80, 0xD4, 0x80, 0x55, 0x80, 0xF2, 0x80, 0x29, 0x80, 0x10}},
{0x12fa, 0x10, {0x80, 0xA6, 0x80, 0xEA, 0x80, 0x9A, 0x80, 0xA8, 0x80, 0xDA, 0x80, 0xE2, 0x80, 0xCA, 0x80, 0x29}},
{0x130a, 0x10, {0x88, 0x84, 0x8C, 0x85, 0x89, 0x82, 0x8A, 0x83, 0xE4, 0x93, 0xA3, 0x05, 0x86, 0xF0, 0xA3, 0x05}},
{0x131a, 0x10, {0x86, 0xDF, 0xF5, 0xDE, 0xF3, 0x80, 0x0B, 0x89, 0x82, 0x8A, 0x83, 0xE4, 0x93, 0xA3, 0xF6, 0x08}},
{0x132a, 0x10, {0xDF, 0xF9, 0xEC, 0xFA, 0xA9, 0xF0, 0xED, 0xFB, 0x22, 0x88, 0x84, 0x8C, 0x85, 0x89, 0x82, 0x8A}},
{0x133a, 0x10, {0x83, 0xE0, 0xA3, 0x05, 0x86, 0xF0, 0xA3, 0x05, 0x86, 0xDF, 0xF6, 0xDE, 0xF4, 0x80, 0xE3, 0x89}},
{0x134a, 0x10, {0x82, 0x8A, 0x83, 0xE4, 0x93, 0xA3, 0xF2, 0x08, 0xDF, 0xF9, 0x80, 0xD6, 0x88, 0xF0, 0xED, 0x24}},
{0x135a, 0x10, {0x02, 0xB4, 0x04, 0x00, 0x50, 0xCC, 0xF5, 0x82, 0xEB, 0x24, 0x02, 0xB4, 0x04, 0x00, 0x50, 0xC2}},
{0x136a, 0x10, {0x23, 0x23, 0x45, 0x82, 0xF5, 0x82, 0xEF, 0x4E, 0x60, 0xB8, 0xEF, 0x60, 0x01, 0x0E, 0xE5, 0x82}},
{0x137a, 0x5, {0x23, 0x90, 0x12, 0xEA, 0x73}},
{0x7f92, 0x1, {0x00}},
{0x7f92, 0x1, {0x01}},
{0xb29, 0x10, {0xD2, 0x00, 0x90, 0x7F, 0xA1, 0x74, 0x01, 0xF0, 0xE4, 0x90, 0x7F, 0x93, 0xF0, 0x90, 0x7F, 0x94}},
{0xb39, 0x10, {0xF0, 0x90, 0x7F, 0x95, 0x74, 0x03, 0xF0, 0x90, 0x7F, 0x9C, 0x74, 0x30, 0xF0, 0xE4, 0x90, 0x7F}},
{0xb49, 0x10, {0x9D, 0xF0, 0x90, 0x7F, 0x9E, 0x74, 0xF2, 0xF0, 0xE4, 0x90, 0x7F, 0x96, 0xF0, 0x90, 0x7F, 0x98}},
{0xb59, 0x10, {0x74, 0xF2, 0xF0, 0x12, 0x0D, 0x28, 0x12, 0x0D, 0xFE, 0x90, 0x7F, 0xDE, 0xE0, 0x44, 0x04, 0xF0}},
{0xb69, 0x10, {0x90, 0x7F, 0xDF, 0xE0, 0x44, 0x02, 0xF0, 0x90, 0x7F, 0xAD, 0xE0, 0x44, 0x02, 0xF0, 0x12, 0x09}},
{0xb79, 0x2, {0x26, 0x22}},
{0xe32, 0x4, {0x12, 0x03, 0x4F, 0x22}},
{0xe3a, 0x2, {0xD3, 0x22}},
{0xe3c, 0x2, {0xD3, 0x22}},
{0xe3e, 0x2, {0xD3, 0x22}},
{0xbf8, 0x8, {0x90, 0x7F, 0xEA, 0xE0, 0xF5, 0x0F, 0xD3, 0x22}},
{0xe0e, 0xe, {0x90, 0x7F, 0x00, 0xE5, 0x0F, 0xF0, 0x90, 0x7F, 0xB5, 0x74, 0x01, 0xF0, 0xD3, 0x22}},
{0xe2a, 0x8, {0x90, 0x7F, 0xEA, 0xE0, 0xF5, 0x0E, 0xD3, 0x22}},
{0xe1c, 0xe, {0x90, 0x7F, 0x00, 0xE5, 0x0E, 0xF0, 0x90, 0x7F, 0xB5, 0x74, 0x01, 0xF0, 0xD3, 0x22}},
{0xe40, 0x2, {0xD3, 0x22}},
{0xe42, 0x2, {0xD3, 0x22}},
{0xe44, 0x2, {0xD3, 0x22}},
{0xce4, 0x10, {0x90, 0x7F, 0xE8, 0xE0, 0x30, 0xE6, 0x1A, 0xA3, 0xE0, 0x24, 0xF0, 0x70, 0x12, 0x7F, 0x06, 0x12}},
{0xcf4, 0x10, {0x0A, 0xCF, 0x90, 0x7F, 0x00, 0xEF, 0xF0, 0x90, 0x7F, 0xB5, 0x74, 0x01, 0xF0, 0x80, 0x02, 0xD3}},
{0xd04, 0x3, {0x22, 0xC3, 0x22}},
{0xd5f, 0x10, {0xC0, 0xE0, 0xC0, 0x83, 0xC0, 0x82, 0xD2, 0x01, 0x53, 0x91, 0xEF, 0x90, 0x7F, 0xAB, 0x74, 0x01}},
{0xd6f, 0x8, {0xF0, 0xD0, 0x82, 0xD0, 0x83, 0xD0, 0xE0, 0x32}},
{0xda6, 0x10, {0xC0, 0xE0, 0xC0, 0x83, 0xC0, 0x82, 0x53, 0x91, 0xEF, 0x90, 0x7F, 0xAB, 0x74, 0x04, 0xF0, 0xD0}},
{0xdb6, 0x6, {0x82, 0xD0, 0x83, 0xD0, 0xE0, 0x32}},
{0xdbc, 0x10, {0xC0, 0xE0, 0xC0, 0x83, 0xC0, 0x82, 0x53, 0x91, 0xEF, 0x90, 0x7F, 0xAB, 0x74, 0x02, 0xF0, 0xD0}},
{0xdcc, 0x6, {0x82, 0xD0, 0x83, 0xD0, 0xE0, 0x32}},
{0xdd2, 0x10, {0xC0, 0xE0, 0xC0, 0x83, 0xC0, 0x82, 0x53, 0x91, 0xEF, 0x90, 0x7F, 0xAB, 0x74, 0x10, 0xF0, 0xD0}},
{0xde2, 0x6, {0x82, 0xD0, 0x83, 0xD0, 0xE0, 0x32}},
{0xe46, 0x1, {0x32}},
{0xd77, 0x10, {0xC0, 0xE0, 0xC0, 0x83, 0xC0, 0x82, 0xD2, 0x03, 0x53, 0x91, 0xEF, 0x90, 0x7F, 0xAB, 0x74, 0x08}},
{0xd87, 0x8, {0xF0, 0xD0, 0x82, 0xD0, 0x83, 0xD0, 0xE0, 0x32}},
{0xe47, 0x1, {0x32}},
{0xe48, 0x1, {0x32}},
{0xe49, 0x1, {0x32}},
{0xe4a, 0x1, {0x32}},
{0xe4b, 0x1, {0x32}},
{0xe4c, 0x1, {0x32}},
{0xe4d, 0x1, {0x32}},
{0xe4e, 0x1, {0x32}},
{0xe4f, 0x1, {0x32}},
{0xe50, 0x1, {0x32}},
{0xe51, 0x1, {0x32}},
{0xe52, 0x1, {0x32}},
{0xe53, 0x1, {0x32}},
{0xe54, 0x1, {0x32}},
{0xe55, 0x1, {0x32}},
{0xe56, 0x1, {0x32}},
{0xa5f, 0x10, {0x12, 0x01, 0x00, 0x01, 0x00, 0x00, 0x00, 0x40, 0x62, 0x09, 0x01, 0x30, 0x01, 0x11, 0x01, 0x02}},
{0xa6f, 0x10, {0x00, 0x01, 0x09, 0x02, 0x20, 0x00, 0x01, 0x01, 0x00, 0xA0, 0x64, 0x09, 0x04, 0x00, 0x00, 0x02}},
{0xa7f, 0x10, {0xFF, 0x00, 0x00, 0x00, 0x07, 0x05, 0x82, 0x02, 0x40, 0x00, 0x00, 0x07, 0x05, 0x01, 0x02, 0x40}},
{0xa8f, 0x10, {0x00, 0x00, 0x04, 0x03, 0x09, 0x04, 0x26, 0x03, 0x44, 0x00, 0x69, 0x00, 0x67, 0x00, 0x69, 0x00}},
{0xa9f, 0x10, {0x74, 0x00, 0x61, 0x00, 0x6C, 0x00, 0x20, 0x00, 0x41, 0x00, 0x72, 0x00, 0x74, 0x00, 0x20, 0x00}},
{0xaaf, 0x10, {0x53, 0x00, 0x79, 0x00, 0x73, 0x00, 0x74, 0x00, 0x65, 0x00, 0x6D, 0x00, 0x12, 0x03, 0x53, 0x00}},
{0xabf, 0x10, {0x49, 0x00, 0x55, 0x00, 0x44, 0x00, 0x49, 0x00, 0x2D, 0x00, 0x49, 0x00, 0x4E, 0x00, 0x00, 0x00}},
{0x524, 0x10, {0xE4, 0xF5, 0x2C, 0xF5, 0x2B, 0xF5, 0x2A, 0xF5, 0x29, 0xC2, 0x03, 0xC2, 0x00, 0xC2, 0x02, 0xC2}},
{0x534, 0x10, {0x01, 0x12, 0x0B, 0x29, 0x7E, 0x0A, 0x7F, 0x5F, 0x8E, 0x08, 0x8F, 0x09, 0x75, 0x0A, 0x0A, 0x75}},
{0x544, 0x10, {0x0B, 0x71, 0x75, 0x0C, 0x0A, 0x75, 0x0D, 0x91, 0xEE, 0x54, 0xE0, 0x70, 0x02, 0xC1, 0x37, 0x75}},
{0x554, 0x10, {0x2D, 0x00, 0x75, 0x2E, 0x80, 0x8E, 0x2F, 0x8F, 0x30, 0xC3, 0x74, 0xCD, 0x9F, 0xFF, 0x74, 0x0A}},
{0x564, 0x10, {0x9E, 0xCF, 0x24, 0x02, 0xCF, 0x34, 0x00, 0xFE, 0xE4, 0x8F, 0x28, 0x8E, 0x27, 0xF5, 0x26, 0xF5}},
{0x574, 0x10, {0x25, 0xF5, 0x24, 0xF5, 0x23, 0xF5, 0x22, 0xF5, 0x21, 0xAF, 0x28, 0xAE, 0x27, 0xAD, 0x26, 0xAC}},
{0x584, 0x10, {0x25, 0xAB, 0x24, 0xAA, 0x23, 0xA9, 0x22, 0xA8, 0x21, 0xC3, 0x12, 0x08, 0x2C, 0x50, 0x2A, 0xE5}},
{0x594, 0x10, {0x2E, 0x25, 0x24, 0xF5, 0x82, 0xE5, 0x2D, 0x35, 0x23, 0xF5, 0x83, 0x74, 0xCD, 0xF0, 0xE4, 0xFA}},
{0x5a4, 0x10, {0xF9, 0xF8, 0xE5, 0x24, 0x24, 0x01, 0xF5, 0x24, 0xEA, 0x35, 0x23, 0xF5, 0x23, 0xE9, 0x35, 0x22}},
{0x5b4, 0x10, {0xF5, 0x22, 0xE8, 0x35, 0x21, 0xF5, 0x21, 0x80, 0xC0, 0xE4, 0xF5, 0x24, 0xF5, 0x23, 0xF5, 0x22}},
{0x5c4, 0x10, {0xF5, 0x21, 0xAF, 0x28, 0xAE, 0x27, 0xAD, 0x26, 0xAC, 0x25, 0xAB, 0x24, 0xAA, 0x23, 0xA9, 0x22}},
{0x5d4, 0x10, {0xA8, 0x21, 0xC3, 0x12, 0x08, 0x2C, 0x50, 0x35, 0xAE, 0x23, 0xAF, 0x24, 0xE5, 0x30, 0x2F, 0xF5}},
{0x5e4, 0x10, {0x82, 0xE5, 0x2F, 0x3E, 0xF5, 0x83, 0xE0, 0xFD, 0xE5, 0x2E, 0x2F, 0xF5, 0x82, 0xE5, 0x2D, 0x3E}},
{0x5f4, 0x10, {0xF5, 0x83, 0xED, 0xF0, 0xE4, 0xFA, 0xF9, 0xF8, 0xEF, 0x24, 0x01, 0xF5, 0x24, 0xEA, 0x3E, 0xF5}},
{0x604, 0x10, {0x23, 0xE9, 0x35, 0x22, 0xF5, 0x22, 0xE8, 0x35, 0x21, 0xF5, 0x21, 0x80, 0xB5, 0x85, 0x2D, 0x08}},
{0x614, 0x10, {0x85, 0x2E, 0x09, 0x74, 0x5F, 0x24, 0x80, 0xFF, 0x74, 0x0A, 0x34, 0xFF, 0xFE, 0xC3, 0xE5, 0x0B}},
{0x624, 0x10, {0x9F, 0xF5, 0x0B, 0xE5, 0x0A, 0x9E, 0xF5, 0x0A, 0xC3, 0xE5, 0x0D, 0x9F, 0xF5, 0x0D, 0xE5, 0x0C}},
{0x634, 0x10, {0x9E, 0xF5, 0x0C, 0xD2, 0xE8, 0x43, 0xD8, 0x20, 0x90, 0x7F, 0xAB, 0x74, 0xFF, 0xF0, 0x90, 0x7F}},
{0x644, 0x10, {0xAF, 0xE0, 0x44, 0x01, 0xF0, 0x90, 0x7F, 0xAE, 0xE0, 0x44, 0x1D, 0xF0, 0xD2, 0xAF, 0x20, 0x01}},
{0x654, 0x10, {0x45, 0x20, 0x01, 0x05, 0xD2, 0x05, 0x12, 0x0B, 0x7B, 0xE4, 0xF5, 0x2C, 0xF5, 0x2B, 0xF5, 0x2A}},
{0x664, 0x10, {0xF5, 0x29, 0x7F, 0x40, 0x7E, 0x92, 0x7D, 0x04, 0x7C, 0x00, 0xAB, 0x2C, 0xAA, 0x2B, 0xA9, 0x2A}},
{0x674, 0x10, {0xA8, 0x29, 0xC3, 0x12, 0x08, 0x2C, 0x50, 0xD6, 0x20, 0x01, 0xD3, 0xE4, 0xFA, 0xF9, 0xF8, 0xE5}},
{0x684, 0x10, {0x2C, 0x24, 0x01, 0xF5, 0x2C, 0xEA, 0x35, 0x2B, 0xF5, 0x2B, 0xE9, 0x35, 0x2A, 0xF5, 0x2A, 0xE8}},
{0x694, 0x10, {0x35, 0x29, 0xF5, 0x29, 0x80, 0xCC, 0x53, 0x8E, 0xF8, 0x30, 0x01, 0x05, 0x12, 0x00, 0x80, 0xC2}},
{0x6a4, 0x10, {0x01, 0x30, 0x03, 0x1A, 0x12, 0x0E, 0x3A, 0x50, 0x15, 0xC2, 0x03, 0x12, 0x0D, 0x07, 0x20, 0x00}},
{0x6b4, 0x10, {0x07, 0x90, 0x7F, 0xD6, 0xE0, 0x20, 0xE7, 0xF3, 0x12, 0x0D, 0x45, 0x12, 0x0E, 0x3C, 0x12, 0x0E}},
{0x6c4, 0x3, {0x32, 0x80, 0xD6}},
{0x6c7, 0x1, {0x22}},
{0x80, 0x10, {0x90, 0x7F, 0xE9, 0xE0, 0x70, 0x02, 0x21, 0xFD, 0x14, 0x70, 0x02, 0x41, 0x74, 0x24, 0xFE, 0x70}},
{0x90, 0x10, {0x02, 0x41, 0xE7, 0x24, 0xFB, 0x70, 0x02, 0x21, 0xF8, 0x14, 0x70, 0x02, 0x21, 0xF3, 0x14, 0x70}},
{0xa0, 0x10, {0x02, 0x21, 0xE9, 0x14, 0x70, 0x02, 0x21, 0xEE, 0x24, 0x05, 0x60, 0x02, 0x61, 0x3B, 0x12, 0x0E}},
{0xb0, 0x10, {0x3E, 0x40, 0x02, 0x61, 0x47, 0x90, 0x7F, 0xEB, 0xE0, 0x24, 0xFE, 0x60, 0x17, 0x14, 0x60, 0x41}},
{0xc0, 0x10, {0x24, 0x02, 0x60, 0x02, 0x21, 0xE0, 0xE5, 0x08, 0x90, 0x7F, 0xD4, 0xF0, 0xE5, 0x09, 0x90, 0x7F}},
{0xd0, 0x10, {0xD5, 0xF0, 0x61, 0x47, 0x90, 0x7F, 0xEA, 0xE0, 0xFF, 0x12, 0x0C, 0xA2, 0xAA, 0x06, 0xA9, 0x07}},
{0xe0, 0x10, {0x7B, 0x01, 0x8B, 0x31, 0x8A, 0x32, 0x89, 0x33, 0xEA, 0x49, 0x60, 0x0C, 0xEE, 0x90, 0x7F, 0xD4}},
{0xf0, 0x10, {0xF0, 0xEF, 0x90, 0x7F, 0xD5, 0xF0, 0x61, 0x47, 0x90, 0x7F, 0xB4, 0xE0, 0x44, 0x01, 0xF0, 0x61}},
{0x100, 0x10, {0x47, 0x90, 0x7F, 0xEA, 0xE0, 0xFF, 0x12, 0x0B, 0xCC, 0xAA, 0x06, 0xA9, 0x07, 0x7B, 0x01, 0x8B}},
{0x110, 0xb, {0x31, 0x8A, 0x32, 0x89, 0x33, 0xEA, 0x49, 0x70, 0x02, 0x21, 0xD7}},
{0x11b, 0x10, {0xAB, 0x31, 0x8B, 0x38, 0x8A, 0x39, 0x89, 0x3A, 0x12, 0x06, 0xC8, 0xF5, 0x3B, 0x90, 0x7F, 0xEE}},
{0x12b, 0x10, {0xE0, 0xFF, 0xE5, 0x3B, 0xD3, 0x9F, 0x40, 0x03, 0xE0, 0xF5, 0x3B, 0xE5, 0x3B, 0x70, 0x02, 0x21}},
{0x13b, 0x10, {0xCA, 0xE4, 0xF5, 0x37, 0xF5, 0x36, 0xF5, 0x35, 0xF5, 0x34, 0xE5, 0x3B, 0xC3, 0x94, 0x40, 0x50}},
{0x14b, 0x10, {0x04, 0xAF, 0x3B, 0x80, 0x02, 0x7F, 0x40, 0xE4, 0xFC, 0xFD, 0xFE, 0xAB, 0x37, 0xAA, 0x36, 0xA9}},
{0x15b, 0x10, {0x35, 0xA8, 0x34, 0xC3, 0x12, 0x08, 0x2C, 0x50, 0x36, 0xE5, 0x3A, 0x25, 0x37, 0xF5, 0x82, 0xE5}},
{0x16b, 0x10, {0x39, 0x35, 0x36, 0xF5, 0x83, 0xE0, 0xFF, 0x74, 0x00, 0x25, 0x37, 0xF5, 0x82, 0xE4, 0x34, 0x7F}},
{0x17b, 0x10, {0xF5, 0x83, 0xEF, 0xF0, 0xE4, 0xFA, 0xF9, 0xF8, 0xE5, 0x37, 0x24, 0x01, 0xF5, 0x37, 0xEA, 0x35}},
{0x18b, 0x10, {0x36, 0xF5, 0x36, 0xE9, 0x35, 0x35, 0xF5, 0x35, 0xE8, 0x35, 0x34, 0xF5, 0x34, 0x80, 0xAB, 0xE5}},
{0x19b, 0x10, {0x3B, 0xC3, 0x94, 0x40, 0x50, 0x04, 0xAF, 0x3B, 0x80, 0x02, 0x7F, 0x40, 0x90, 0x7F, 0xB5, 0xEF}},
{0x1ab, 0x10, {0xF0, 0xE5, 0x3B, 0xC3, 0x94, 0x40, 0x50, 0x04, 0xAF, 0x3B, 0x80, 0x02, 0x7F, 0x40, 0xC3, 0xE5}},
{0x1bb, 0x10, {0x3B, 0x9F, 0xF5, 0x3B, 0x90, 0x7F, 0xB4, 0xE0, 0x20, 0xE2, 0x02, 0x21, 0x36, 0x80, 0xF5, 0xE4}},
{0x1cb, 0xa, {0x90, 0x7F, 0xB5, 0xF0, 0x90, 0x7F, 0xB4, 0x74, 0x02, 0xF0}},
{0x1d5, 0x10, {0x61, 0x47, 0x90, 0x7F, 0xB4, 0xE0, 0x44, 0x01, 0xF0, 0x61, 0x47, 0x90, 0x7F, 0xB4, 0xE0, 0x44}},
{0x1e5, 0x10, {0x01, 0xF0, 0x61, 0x47, 0x12, 0x0E, 0x1C, 0x61, 0x47, 0x12, 0x0E, 0x2A, 0x61, 0x47, 0x12, 0x0B}},
{0x1f5, 0x10, {0xF8, 0x61, 0x47, 0x12, 0x0E, 0x0E, 0x61, 0x47, 0x12, 0x0E, 0x40, 0x40, 0x02, 0x61, 0x47, 0x90}},
{0x205, 0x10, {0x7F, 0xE8, 0xE0, 0x24, 0x7F, 0x60, 0x23, 0x14, 0x60, 0x2F, 0x24, 0x02, 0x70, 0x58, 0xA2, 0x00}},
{0x215, 0x10, {0xE4, 0x33, 0xFF, 0x25, 0xE0, 0xFF, 0xA2, 0x02, 0xE4, 0x33, 0x4F, 0x90, 0x7F, 0x00, 0xF0, 0xE4}},
{0x225, 0x10, {0xA3, 0xF0, 0x90, 0x7F, 0xB5, 0x74, 0x02, 0xF0, 0x61, 0x47, 0xE4, 0x90, 0x7F, 0x00, 0xF0, 0xA3}},
{0x235, 0x10, {0xF0, 0x90, 0x7F, 0xB5, 0x74, 0x02, 0xF0, 0x61, 0x47, 0x90, 0x7F, 0xEC, 0xE0, 0xF4, 0x54, 0x80}},
{0x245, 0x10, {0xFF, 0xC4, 0x54, 0x0F, 0xFF, 0xE0, 0x54, 0x07, 0x2F, 0x25, 0xE0, 0x24, 0xB4, 0xF5, 0x82, 0xE4}},
{0x255, 0x10, {0x34, 0x7F, 0xF5, 0x83, 0xE0, 0x54, 0x01, 0x90, 0x7F, 0x00, 0xF0, 0xE4, 0xA3, 0xF0, 0x90, 0x7F}},
{0x265, 0x10, {0xB5, 0x74, 0x02, 0xF0, 0x61, 0x47, 0x90, 0x7F, 0xB4, 0xE0, 0x44, 0x01, 0xF0, 0x61, 0x47, 0x12}},
{0x275, 0x10, {0x0E, 0x42, 0x40, 0x02, 0x61, 0x47, 0x90, 0x7F, 0xE8, 0xE0, 0x24, 0xFE, 0x60, 0x1A, 0x24, 0x02}},
{0x285, 0x10, {0x60, 0x02, 0x61, 0x47, 0x90, 0x7F, 0xEA, 0xE0, 0xB4, 0x01, 0x04, 0xC2, 0x00, 0x61, 0x47, 0x90}},
{0x295, 0x10, {0x7F, 0xB4, 0xE0, 0x44, 0x01, 0xF0, 0x61, 0x47, 0x90, 0x7F, 0xEA, 0xE0, 0x70, 0x3B, 0x90, 0x7F}},
{0x2a5, 0x10, {0xEC, 0xE0, 0xF4, 0x54, 0x80, 0xFF, 0xC4, 0x54, 0x0F, 0xFF, 0xE0, 0x54, 0x07, 0x2F, 0x25, 0xE0}},
{0x2b5, 0x10, {0x24, 0xB4, 0xF5, 0x82, 0xE4, 0x34, 0x7F, 0xF5, 0x83, 0xE4, 0xF0, 0x90, 0x7F, 0xEC, 0xE0, 0x54}},
{0x2c5, 0x10, {0x80, 0xFF, 0x13, 0x13, 0x13, 0x54, 0x1F, 0xFF, 0xE0, 0x54, 0x07, 0x2F, 0x90, 0x7F, 0xD7, 0xF0}},
{0x2d5, 0x3, {0xE4, 0xF5, 0x38}},
{0x2d8, 0x10, {0xE0, 0x44, 0x20, 0xF0, 0x80, 0x69, 0x90, 0x7F, 0xB4, 0xE0, 0x44, 0x01, 0xF0, 0x80, 0x60, 0x12}},
{0x2e8, 0x10, {0x0E, 0x44, 0x50, 0x5B, 0x90, 0x7F, 0xE8, 0xE0, 0x24, 0xFE, 0x60, 0x18, 0x24, 0x02, 0x70, 0x4F}},
{0x2f8, 0x10, {0x90, 0x7F, 0xEA, 0xE0, 0xB4, 0x01, 0x04, 0xD2, 0x00, 0x80, 0x44, 0x90, 0x7F, 0xB4, 0xE0, 0x44}},
{0x308, 0x10, {0x01, 0xF0, 0x80, 0x3B, 0x90, 0x7F, 0xEA, 0xE0, 0x70, 0x20, 0x90, 0x7F, 0xEC, 0xE0, 0xF4, 0x54}},
{0x318, 0x10, {0x80, 0xFF, 0xC4, 0x54, 0x0F, 0xFF, 0xE0, 0x54, 0x07, 0x2F, 0x25, 0xE0, 0x24, 0xB4, 0xF5, 0x82}},
{0x328, 0x10, {0xE4, 0x34, 0x7F, 0xF5, 0x83, 0x74, 0x01, 0xF0, 0x80, 0x15, 0x90, 0x7F, 0xB4, 0xE0, 0x44, 0x01}},
{0x338, 0x10, {0xF0, 0x80, 0x0C, 0x12, 0x0C, 0xE4, 0x50, 0x07, 0x90, 0x7F, 0xB4, 0xE0, 0x44, 0x01, 0xF0, 0x90}},
{0x348, 0x6, {0x7F, 0xB4, 0xE0, 0x44, 0x02, 0xF0}},
{0x34e, 0x1, {0x22}},
{0x33, 0x3, {0x02, 0x0E, 0x36}},
{0xe36, 0x4, {0x53, 0xD8, 0xEF, 0x32}},
{0x43, 0x3, {0x02, 0x0C, 0x00}},
{0xc00, 0x10, {0x02, 0x0D, 0x5F, 0x00, 0x02, 0x0D, 0xBC, 0x00, 0x02, 0x0D, 0xA6, 0x00, 0x02, 0x0D, 0x77, 0x00}},
{0xc10, 0x10, {0x02, 0x0D, 0xD2, 0x00, 0x02, 0x0E, 0x46, 0x00, 0x02, 0x0E, 0x47, 0x00, 0x02, 0x0E, 0x48, 0x00}},
{0xc20, 0x10, {0x02, 0x0E, 0x49, 0x00, 0x02, 0x0E, 0x4A, 0x00, 0x02, 0x0E, 0x4B, 0x00, 0x02, 0x0E, 0x4C, 0x00}},
{0xc30, 0x10, {0x02, 0x0E, 0x4D, 0x00, 0x02, 0x0E, 0x4E, 0x00, 0x02, 0x0E, 0x4F, 0x00, 0x02, 0x0E, 0x50, 0x00}},
{0xc40, 0x10, {0x02, 0x0E, 0x51, 0x00, 0x02, 0x0E, 0x52, 0x00, 0x02, 0x0E, 0x53, 0x00, 0x02, 0x0E, 0x54, 0x00}},
{0xc50, 0x8, {0x02, 0x0E, 0x55, 0x00, 0x02, 0x0E, 0x56, 0x00}},
{0xd45, 0x10, {0x90, 0x7F, 0xD6, 0xE0, 0x30, 0xE7, 0x12, 0xE0, 0x44, 0x01, 0xF0, 0x7F, 0x14, 0x7E, 0x00, 0x12}},
{0xd55, 0xa, {0x0D, 0x8F, 0x90, 0x7F, 0xD6, 0xE0, 0x54, 0xFE, 0xF0, 0x22}},
{0xd07, 0x10, {0x90, 0x7F, 0xD6, 0xE0, 0x44, 0x80, 0xF0, 0x43, 0x87, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x22}},
{0xb7b, 0x7, {0x90, 0x7F, 0xD6, 0xE0, 0x44, 0x08, 0xF0}},
{0xb82, 0x3, {0xE4, 0xF5, 0x31}},
{0xb85, 0x4, {0xE0, 0x54, 0xFB, 0xF0}},
{0xb89, 0x3, {0xE4, 0xF5, 0x31}},
{0xb8c, 0x10, {0xE0, 0x44, 0x08, 0xF0, 0x30, 0x05, 0x04, 0xE0, 0x44, 0x02, 0xF0, 0x7F, 0xDC, 0x7E, 0x05, 0x12}},
{0xb9c, 0x10, {0x0D, 0x8F, 0x90, 0x7F, 0x92, 0xE0, 0x30, 0xE3, 0x07, 0x7F, 0xDC, 0x7E, 0x05, 0x12, 0x0D, 0x8F}},
{0xbac, 0x10, {0x90, 0x7F, 0xAB, 0x74, 0xFF, 0xF0, 0x90, 0x7F, 0xA9, 0xF0, 0x90, 0x7F, 0xAA, 0xF0, 0x53, 0x91}},
{0xbbc, 0x8, {0xEF, 0x90, 0x7F, 0xD6, 0xE0, 0x54, 0xF7, 0xF0}},
{0xbc4, 0x3, {0xE4, 0xF5, 0x31}},
{0xbc7, 0x5, {0xE0, 0x44, 0x04, 0xF0, 0x22}},
{0xbcc, 0x2, {0xA9, 0x07}},
{0xbce, 0x10, {0xAE, 0x0C, 0xAF, 0x0D, 0x8F, 0x82, 0x8E, 0x83, 0xA3, 0xE0, 0x64, 0x03, 0x70, 0x17, 0xAD, 0x01}},
{0xbde, 0x10, {0x19, 0xED, 0x70, 0x01, 0x22, 0x8F, 0x82, 0x8E, 0x83, 0xE0, 0x7C, 0x00, 0x2F, 0xFD, 0xEC, 0x3E}},
{0xbee, 0x9, {0xFE, 0xAF, 0x05, 0x80, 0xDF, 0x7E, 0x00, 0x7F, 0x00}},
{0xbf7, 0x1, {0x22}},
{0xca2, 0x10, {0xE4, 0xFE, 0xAC, 0x0A, 0xAD, 0x0B, 0x8D, 0x82, 0x8C, 0x83, 0xA3, 0xE0, 0x64, 0x02, 0x70, 0x2D}},
{0xcb2, 0x10, {0xAB, 0x06, 0x0E, 0xEB, 0xB5, 0x07, 0x05, 0xAF, 0x05, 0xAE, 0x04, 0x22, 0x8D, 0x82, 0x8C, 0x83}},
{0xcc2, 0x10, {0xA3, 0xA3, 0xE0, 0xF5, 0x3C, 0xA3, 0xE0, 0xF5, 0x3D, 0x62, 0x3C, 0xE5, 0x3C, 0x62, 0x3D, 0xE5}},
{0xcd2, 0x10, {0x3D, 0x62, 0x3C, 0x2D, 0xFB, 0xE5, 0x3C, 0x3C, 0xFC, 0xAD, 0x03, 0x80, 0xC9, 0x7E, 0x00, 0x7F}},
{0xce2, 0x1, {0x00}},
{0xce3, 0x1, {0x22}},
{0xd8f, 0x10, {0x8E, 0x32, 0x8F, 0x33, 0xE5, 0x33, 0x15, 0x33, 0xAE, 0x32, 0x70, 0x02, 0x15, 0x32, 0x4E, 0x60}},
{0xd9f, 0x7, {0x05, 0x12, 0x0D, 0x17, 0x80, 0xEE, 0x22}},
{0xd17, 0x10, {0x74, 0x00, 0xF5, 0x86, 0x90, 0xFD, 0xA5, 0x7C, 0x05, 0xA3, 0xE5, 0x82, 0x45, 0x83, 0x70, 0xF9}},
{0xd27, 0x1, {0x22}},
{0xde8, 0x10, {0x02, 0x46, 0x00, 0x00, 0x02, 0x49, 0x00, 0x00, 0x01, 0x48, 0x01, 0x01, 0x4B, 0x03, 0x01, 0x4C}},
{0xdf8, 0x5, {0x00, 0x02, 0x44, 0x00, 0x00}},
{0x926, 0x10, {0xE4, 0xFF, 0xFE, 0x74, 0x00, 0x2F, 0xF5, 0x82, 0x74, 0x20, 0x3E, 0xF5, 0x83, 0xE4, 0xF0, 0x74}},
{0x936, 0x10, {0x06, 0x2F, 0xF5, 0x82, 0x74, 0x22, 0x3E, 0xF5, 0x83, 0xE4, 0xF0, 0x74, 0x0C, 0x2F, 0xF5, 0x82}},
{0x946, 0x10, {0x74, 0x24, 0x3E, 0xF5, 0x83, 0xE4, 0xF0, 0x0F, 0xBF, 0x00, 0x01, 0x0E, 0xBE, 0x02, 0xD4, 0xBF}},
{0x956, 0x10, {0x01, 0xD1, 0x90, 0x22, 0x01, 0x74, 0x02, 0xF0, 0xA3, 0x14, 0xF0, 0x90, 0x24, 0x07, 0x04, 0xF0}},
{0x966, 0x10, {0xA3, 0x14, 0xF0, 0xE4, 0x90, 0x26, 0x0D, 0xF0, 0xA3, 0xF0, 0x90, 0x22, 0x03, 0x04, 0xF0, 0x90}},
{0x976, 0x10, {0x24, 0x09, 0xF0, 0xE4, 0x90, 0x26, 0x0F, 0xF0, 0x90, 0x22, 0x04, 0xF0, 0x90, 0x24, 0x0A, 0xF0}},
{0x986, 0x10, {0x90, 0x26, 0x10, 0xF0, 0x90, 0x22, 0x05, 0xF0, 0x90, 0x24, 0x0B, 0xF0, 0x90, 0x26, 0x11, 0xF0}},
{0x996, 0x10, {0x75, 0x3E, 0x01, 0x75, 0x3F, 0x20, 0x75, 0x40, 0x00, 0x75, 0x41, 0x01, 0x75, 0x42, 0x24, 0x75}},
{0x9a6, 0x10, {0x43, 0x0C, 0xF5, 0x46, 0xF5, 0x47, 0xD2, 0x04, 0x75, 0x48, 0x01, 0x75, 0x4B, 0x03, 0x90, 0x7F}},
{0x9b6, 0x10, {0x9B, 0xE0, 0x44, 0x20, 0x90, 0x7F, 0x98, 0xF0, 0x90, 0x7F, 0x9B, 0xE0, 0x44, 0x40, 0x90, 0x7F}},
{0x9c6, 0xc, {0x98, 0xF0, 0x90, 0x7F, 0x9B, 0xE0, 0x44, 0x80, 0x90, 0x7F, 0x98, 0xF0}},
{0x9d2, 0x1, {0x22}},
{0xd28, 0x10, {0xD2, 0x9F, 0xD2, 0x9E, 0xD2, 0x9D, 0xD2, 0x9C, 0xC2, 0x9A, 0xD2, 0xBC, 0xC2, 0xC9, 0xC2, 0xCC}},
{0xd38, 0xd, {0xD2, 0xCD, 0x75, 0xCB, 0xFF, 0x75, 0xCA, 0xFD, 0xD2, 0xAC, 0xD2, 0xCA, 0x22}},
{0xdfe, 0x10, {0xC2, 0x8C, 0x75, 0x89, 0x0A, 0x75, 0x8C, 0xB0, 0x75, 0x8A, 0xB0, 0xD2, 0xA9, 0xD2, 0x8C, 0x22}},
{0x34f, 0x10, {0xE4, 0xF5, 0x31, 0xF5, 0x32, 0x90, 0x7F, 0xB8, 0xE0, 0x30, 0xE1, 0x02, 0xA1, 0x23, 0xAB, 0x3E}},
{0x35f, 0x10, {0xAA, 0x3F, 0xA9, 0x40, 0x90, 0x02, 0x03, 0x12, 0x06, 0xE1, 0x64, 0x01, 0x60, 0x02, 0xA1, 0x15}},
{0x36f, 0x10, {0x90, 0x02, 0x05, 0x12, 0x06, 0xE1, 0x60, 0x02, 0xA1, 0x15, 0x30, 0x04, 0x25, 0x90, 0x02, 0x01}},
{0x37f, 0x10, {0x12, 0x07, 0x5B, 0xAE, 0xF0, 0x90, 0x7E, 0x00, 0xF0, 0xEE, 0xFF, 0x33, 0x95, 0xE0, 0xEF, 0xA3}},
{0x38f, 0x10, {0xF0, 0x75, 0x32, 0x02, 0xC2, 0x04, 0x90, 0x7F, 0x9B, 0xE0, 0x64, 0x80, 0x90, 0x7F, 0x98, 0xF0}},
{0x39f, 0x10, {0x80, 0x03, 0xE4, 0xF5, 0x32, 0xAB, 0x3E, 0xAA, 0x3F, 0xA9, 0x40, 0x90, 0x02, 0x01, 0x12, 0x07}},
{0x3af, 0x10, {0x5B, 0xFF, 0xAD, 0x32, 0xED, 0x33, 0x95, 0xE0, 0xFC, 0xC3, 0x74, 0x40, 0x9D, 0xFD, 0xE4, 0x9C}},
{0x3bf, 0x10, {0xFC, 0xD3, 0xEF, 0x9D, 0xEC, 0x64, 0x80, 0xF8, 0xE5, 0xF0, 0x64, 0x80, 0x98, 0x50, 0x02, 0x81}},
{0x3cf, 0x10, {0x51, 0xE4, 0xF5, 0x31, 0xC3, 0x74, 0x40, 0x95, 0x32, 0xC3, 0x64, 0x80, 0xF8, 0xE5, 0x31, 0x64}},
{0x3df, 0x10, {0x80, 0x98, 0x50, 0x3C, 0xAB, 0x3E, 0xAA, 0x3F, 0xA9, 0x40, 0x85, 0x47, 0x82, 0x85, 0x46, 0x83}},
{0x3ef, 0x10, {0x12, 0x06, 0xE1, 0xFF, 0xE5, 0x32, 0xFD, 0x33, 0x95, 0xE0, 0xFC, 0xE5, 0x31, 0xFB, 0x33, 0x95}},
{0x3ff, 0x10, {0xE0, 0xFA, 0xEB, 0x2D, 0xFD, 0xEA, 0x3C, 0xFC, 0x74, 0x00, 0x2D, 0xF5, 0x82, 0x74, 0x7E, 0x3C}},
{0x40f, 0x10, {0xF5, 0x83, 0xEF, 0xF0, 0x05, 0x47, 0xE5, 0x47, 0x70, 0x02, 0x05, 0x46, 0x05, 0x31, 0x80, 0xB4}},
{0x41f, 0x10, {0x90, 0x7F, 0xB9, 0x74, 0x40, 0xF0, 0xAB, 0x3E, 0xE5, 0x40, 0x24, 0x01, 0xF9, 0xE5, 0x3F, 0x34}},
{0x42f, 0x10, {0x02, 0xFA, 0x12, 0x07, 0x30, 0xFF, 0xAD, 0x32, 0xED, 0x33, 0x95, 0xE0, 0xFC, 0xC3, 0x74, 0x40}},
{0x43f, 0x10, {0x9D, 0xFD, 0xE4, 0x9C, 0xFC, 0xC3, 0xEF, 0x9D, 0xFF, 0xE5, 0xF0, 0x9C, 0x8F, 0xF0, 0x12, 0x07}},
{0x44f, 0x10, {0xE0, 0x22, 0xE4, 0xF5, 0x31, 0xAB, 0x3E, 0xAA, 0x3F, 0xA9, 0x40, 0x90, 0x02, 0x01, 0x12, 0x07}},
{0x45f, 0x10, {0x5B, 0xFF, 0xAD, 0x32, 0xED, 0x33, 0x95, 0xE0, 0xFC, 0xC3, 0xEF, 0x9D, 0xFF, 0xE5, 0xF0, 0x9C}},
{0x46f, 0x10, {0xFE, 0xAD, 0x31, 0xED, 0x33, 0x95, 0xE0, 0xFC, 0xC3, 0xED, 0x9F, 0xEE, 0x64, 0x80, 0xF8, 0xEC}},
{0x47f, 0x10, {0x64, 0x80, 0x98, 0x50, 0x36, 0x85, 0x47, 0x82, 0x85, 0x46, 0x83, 0x12, 0x06, 0xE1, 0xFF, 0xE5}},
{0x48f, 0x10, {0x32, 0xFD, 0x33, 0x95, 0xE0, 0xFC, 0xE5, 0x31, 0xFB, 0x33, 0x95, 0xE0, 0xFA, 0xEB, 0x2D, 0xFD}},
{0x49f, 0x10, {0xEA, 0x3C, 0xFC, 0x74, 0x00, 0x2D, 0xF5, 0x82, 0x74, 0x7E, 0x3C, 0xF5, 0x83, 0xEF, 0xF0, 0x05}},
{0x4af, 0x10, {0x47, 0xE5, 0x47, 0x70, 0x02, 0x05, 0x46, 0x05, 0x31, 0x80, 0x9A, 0xAB, 0x3E, 0xAA, 0x3F, 0xA9}},
{0x4bf, 0x10, {0x40, 0x90, 0x02, 0x01, 0x12, 0x07, 0x5B, 0x25, 0x32, 0x90, 0x7F, 0xB9, 0xF0, 0xE4, 0xF5, 0x46}},
{0x4cf, 0x10, {0xF5, 0x47, 0x90, 0x02, 0x03, 0x12, 0x07, 0x0E, 0xD2, 0x04, 0x90, 0x02, 0x04, 0x74, 0x01, 0x12}},
{0x4df, 0x10, {0x07, 0x0E, 0xE5, 0x48, 0x24, 0xFE, 0x60, 0x14, 0x14, 0x60, 0x1E, 0x24, 0x02, 0x70, 0x35, 0x75}},
{0x4ef, 0x10, {0x3E, 0x01, 0x75, 0x3F, 0x22, 0x75, 0x40, 0x06, 0x75, 0x48, 0x02, 0x22, 0x75, 0x3E, 0x01, 0x75}},
{0x4ff, 0x10, {0x3F, 0x24, 0x75, 0x40, 0x0C, 0x75, 0x48, 0x03, 0x22, 0x75, 0x3E, 0x01, 0x75, 0x3F, 0x20, 0x75}},
{0x50f, 0x10, {0x40, 0x00, 0x75, 0x48, 0x01, 0x22, 0x90, 0x7E, 0x00, 0x74, 0xFF, 0xF0, 0xA3, 0xF0, 0x90, 0x7F}},
{0x51f, 0x4, {0xB9, 0x74, 0x02, 0xF0}},
{0x523, 0x1, {0x22}},
{0x23, 0x3, {0x02, 0x0C, 0x58}},
{0xc58, 0x10, {0xC0, 0xE0, 0xC0, 0xF0, 0xC0, 0x83, 0xC0, 0x82, 0xC0, 0xD0, 0x75, 0xD0, 0x10, 0x75, 0x8A, 0xB0}},
{0xc68, 0x10, {0xD2, 0x8C, 0xC2, 0x98, 0xAB, 0x41, 0xAA, 0x42, 0xA9, 0x43, 0x85, 0x4A, 0x82, 0x85, 0x49, 0x83}},
{0xc78, 0x10, {0xE5, 0x99, 0x12, 0x07, 0x0E, 0x05, 0x4A, 0xE5, 0x4A, 0x70, 0x02, 0x05, 0x49, 0x90, 0x02, 0x01}},
{0xc88, 0x10, {0xE4, 0x75, 0xF0, 0x01, 0x12, 0x07, 0x93, 0x90, 0x02, 0x03, 0x74, 0x01, 0x12, 0x07, 0x0E, 0xD0}},
{0xc98, 0xa, {0xD0, 0xD0, 0x82, 0xD0, 0x83, 0xD0, 0xF0, 0xD0, 0xE0, 0x32}},
{0xb, 0x3, {0x02, 0x08, 0x53}},
{0x853, 0x10, {0xC0, 0xE0, 0xC0, 0xF0, 0xC0, 0x83, 0xC0, 0x82, 0xC0, 0xD0, 0x75, 0xD0, 0x00, 0xC0, 0x00, 0xC0}},
{0x863, 0x10, {0x01, 0xC0, 0x02, 0xC0, 0x03, 0xC2, 0x8C, 0x90, 0x7F, 0x9B, 0xE0, 0x64, 0x40, 0x90, 0x7F, 0x98}},
{0x873, 0x10, {0xF0, 0xAB, 0x41, 0xAA, 0x42, 0xA9, 0x43, 0x90, 0x02, 0x03, 0x12, 0x06, 0xE1, 0x64, 0x01, 0x70}},
{0x883, 0x10, {0x6B, 0xE5, 0x4B, 0x24, 0xFE, 0x60, 0x23, 0x14, 0x60, 0x42, 0x24, 0x02, 0x70, 0x5E, 0x90, 0x24}},
{0x893, 0x10, {0x0A, 0xE0, 0x64, 0x01, 0x70, 0x56, 0x90, 0x02, 0x05, 0x12, 0x07, 0x0E, 0x75, 0x41, 0x01, 0x75}},
{0x8a3, 0x10, {0x42, 0x22, 0x75, 0x43, 0x06, 0x75, 0x4B, 0x02, 0x80, 0x42, 0x90, 0x26, 0x10, 0xE0, 0x64, 0x01}},
{0x8b3, 0x10, {0x70, 0x3A, 0xAB, 0x41, 0xAA, 0x42, 0xA9, 0x43, 0x90, 0x02, 0x05, 0x12, 0x07, 0x0E, 0x75, 0x41}},
{0x8c3, 0x10, {0x01, 0x75, 0x42, 0x24, 0x75, 0x43, 0x0C, 0x75, 0x4B, 0x03, 0x80, 0x20, 0x90, 0x22, 0x04, 0xE0}},
{0x8d3, 0x10, {0xB4, 0x01, 0x19, 0xAB, 0x41, 0xAA, 0x42, 0xA9, 0x43, 0x90, 0x02, 0x05, 0xE4, 0x12, 0x07, 0x0E}},
{0x8e3, 0x10, {0x75, 0x41, 0x01, 0x75, 0x42, 0x20, 0x75, 0x43, 0x00, 0x75, 0x4B, 0x01, 0xAB, 0x41, 0xAA, 0x42}},
{0x8f3, 0x10, {0xA9, 0x43, 0x90, 0x02, 0x05, 0x74, 0x01, 0x12, 0x07, 0x0E, 0x90, 0x02, 0x04, 0xE4, 0x12, 0x07}},
{0x903, 0x10, {0x0E, 0x75, 0x49, 0x00, 0x75, 0x4A, 0x00, 0x90, 0x02, 0x01, 0xE4, 0xF5, 0xF0, 0x12, 0x07, 0xFF}},
{0x913, 0x10, {0xD0, 0x03, 0xD0, 0x02, 0xD0, 0x01, 0xD0, 0x00, 0xD0, 0xD0, 0xD0, 0x82, 0xD0, 0x83, 0xD0, 0xF0}},
{0x923, 0x3, {0xD0, 0xE0, 0x32}},
{0xacf, 0x10, {0xAE, 0xE8, 0xC2, 0xE9, 0x90, 0x7F, 0xA5, 0xE0, 0x44, 0x80, 0xF0, 0x90, 0x7F, 0xA6, 0x74, 0xA0}},
{0xadf, 0x10, {0xF0, 0x90, 0x7F, 0xA5, 0xE0, 0x30, 0xE0, 0xF9, 0x90, 0x7F, 0xA6, 0xEF, 0xF0, 0x90, 0x7F, 0xA5}},
{0xaef, 0x10, {0xE0, 0x30, 0xE0, 0xF9, 0x90, 0x7F, 0xA5, 0xE0, 0x44, 0x80, 0xF0, 0x90, 0x7F, 0xA6, 0x74, 0xA1}},
{0xaff, 0x10, {0xF0, 0x90, 0x7F, 0xA5, 0xE0, 0x30, 0xE0, 0xF9, 0x90, 0x7F, 0xA5, 0xE0, 0x44, 0x20, 0xF0, 0x90}},
{0xb0f, 0x10, {0x7F, 0xA6, 0xE0, 0xFF, 0x90, 0x7F, 0xA5, 0xE0, 0x30, 0xE0, 0xF9, 0x90, 0x7F, 0xA5, 0xE0, 0x44}},
{0xb1f, 0x9, {0x40, 0xF0, 0x90, 0x7F, 0xA6, 0xE0, 0xFF, 0x8E, 0xE8}},
{0xb28, 0x1, {0x22}},
{0x0, 0x3, {0x02, 0x09, 0xD3}},
{0x9d3, 0xc, {0x78, 0x7F, 0xE4, 0xF6, 0xD8, 0xFD, 0x75, 0x81, 0x4C, 0x02, 0x0A, 0x1A}},
{0x6c8, 0x10, {0xBB, 0x01, 0x06, 0x89, 0x82, 0x8A, 0x83, 0xE0, 0x22, 0x50, 0x02, 0xE7, 0x22, 0xBB, 0xFE, 0x02}},
{0x6d8, 0x9, {0xE3, 0x22, 0x89, 0x82, 0x8A, 0x83, 0xE4, 0x93, 0x22}},
{0x6e1, 0x10, {0xBB, 0x01, 0x0C, 0xE5, 0x82, 0x29, 0xF5, 0x82, 0xE5, 0x83, 0x3A, 0xF5, 0x83, 0xE0, 0x22, 0x50}},
{0x6f1, 0x10, {0x06, 0xE9, 0x25, 0x82, 0xF8, 0xE6, 0x22, 0xBB, 0xFE, 0x06, 0xE9, 0x25, 0x82, 0xF8, 0xE2, 0x22}},
{0x701, 0xd, {0xE5, 0x82, 0x29, 0xF5, 0x82, 0xE5, 0x83, 0x3A, 0xF5, 0x83, 0xE4, 0x93, 0x22}},
{0x70e, 0x10, {0xF8, 0xBB, 0x01, 0x0D, 0xE5, 0x82, 0x29, 0xF5, 0x82, 0xE5, 0x83, 0x3A, 0xF5, 0x83, 0xE8, 0xF0}},
{0x71e, 0x10, {0x22, 0x50, 0x06, 0xE9, 0x25, 0x82, 0xC8, 0xF6, 0x22, 0xBB, 0xFE, 0x05, 0xE9, 0x25, 0x82, 0xC8}},
{0x72e, 0x2, {0xF2, 0x22}},
{0x730, 0x10, {0xBB, 0x01, 0x0A, 0x89, 0x82, 0x8A, 0x83, 0xE0, 0xF5, 0xF0, 0xA3, 0xE0, 0x22, 0x50, 0x06, 0x87}},
{0x740, 0x10, {0xF0, 0x09, 0xE7, 0x19, 0x22, 0xBB, 0xFE, 0x07, 0xE3, 0xF5, 0xF0, 0x09, 0xE3, 0x19, 0x22, 0x89}},
{0x750, 0xb, {0x82, 0x8A, 0x83, 0xE4, 0x93, 0xF5, 0xF0, 0x74, 0x01, 0x93, 0x22}},
{0x75b, 0x10, {0xBB, 0x01, 0x10, 0xE5, 0x82, 0x29, 0xF5, 0x82, 0xE5, 0x83, 0x3A, 0xF5, 0x83, 0xE0, 0xF5, 0xF0}},
{0x76b, 0x10, {0xA3, 0xE0, 0x22, 0x50, 0x09, 0xE9, 0x25, 0x82, 0xF8, 0x86, 0xF0, 0x08, 0xE6, 0x22, 0xBB, 0xFE}},
{0x77b, 0x10, {0x0A, 0xE9, 0x25, 0x82, 0xF8, 0xE2, 0xF5, 0xF0, 0x08, 0xE2, 0x22, 0xE5, 0x83, 0x2A, 0xF5, 0x83}},
{0x78b, 0x8, {0xE9, 0x93, 0xF5, 0xF0, 0xA3, 0xE9, 0x93, 0x22}},
{0x793, 0x10, {0xBB, 0x01, 0x0D, 0xC5, 0x82, 0x29, 0xC5, 0x82, 0xC5, 0x83, 0x3A, 0xC5, 0x83, 0x02, 0x08, 0x3D}},
{0x7a3, 0x10, {0x50, 0x11, 0xC5, 0x82, 0x29, 0xF8, 0x08, 0xE5, 0xF0, 0x26, 0xF6, 0x18, 0xF5, 0xF0, 0xE5, 0x82}},
{0x7b3, 0x10, {0x36, 0xF6, 0x22, 0xBB, 0xFE, 0x11, 0xC5, 0x82, 0x29, 0xF8, 0x08, 0xE2, 0x25, 0xF0, 0xF5, 0xF0}},
{0x7c3, 0x10, {0xF2, 0x18, 0xE2, 0x35, 0x82, 0xF2, 0x22, 0xF8, 0xE5, 0x82, 0x29, 0xF5, 0x82, 0xE5, 0x83, 0x2A}},
{0x7d3, 0xd, {0xF5, 0x83, 0x74, 0x01, 0x93, 0x25, 0xF0, 0xF5, 0xF0, 0xE4, 0x93, 0x38, 0x22}},
{0x7e0, 0x10, {0xBB, 0x01, 0x0A, 0x89, 0x82, 0x8A, 0x83, 0xF0, 0xE5, 0xF0, 0xA3, 0xF0, 0x22, 0x50, 0x06, 0xF7}},
{0x7f0, 0xf, {0x09, 0xA7, 0xF0, 0x19, 0x22, 0xBB, 0xFE, 0x06, 0xF3, 0xE5, 0xF0, 0x09, 0xF3, 0x19, 0x22}},
{0x7ff, 0x10, {0xF8, 0xBB, 0x01, 0x11, 0xE5, 0x82, 0x29, 0xF5, 0x82, 0xE5, 0x83, 0x3A, 0xF5, 0x83, 0xE8, 0xF0}},
{0x80f, 0x10, {0xE5, 0xF0, 0xA3, 0xF0, 0x22, 0x50, 0x09, 0xE9, 0x25, 0x82, 0xC8, 0xF6, 0x08, 0xA6, 0xF0, 0x22}},
{0x81f, 0xd, {0xBB, 0xFE, 0x09, 0xE9, 0x25, 0x82, 0xC8, 0xF2, 0xE5, 0xF0, 0x08, 0xF2, 0x22}},
{0x82c, 0x10, {0xEB, 0x9F, 0xF5, 0xF0, 0xEA, 0x9E, 0x42, 0xF0, 0xE9, 0x9D, 0x42, 0xF0, 0xE8, 0x9C, 0x45, 0xF0}},
{0x83c, 0x1, {0x22}},
{0x9df, 0x10, {0x02, 0x05, 0x24, 0xE4, 0x93, 0xA3, 0xF8, 0xE4, 0x93, 0xA3, 0x40, 0x03, 0xF6, 0x80, 0x01, 0xF2}},
{0x9ef, 0x10, {0x08, 0xDF, 0xF4, 0x80, 0x29, 0xE4, 0x93, 0xA3, 0xF8, 0x54, 0x07, 0x24, 0x0C, 0xC8, 0xC3, 0x33}},
{0x9ff, 0x10, {0xC4, 0x54, 0x0F, 0x44, 0x20, 0xC8, 0x83, 0x40, 0x04, 0xF4, 0x56, 0x80, 0x01, 0x46, 0xF6, 0xDF}},
{0xa0f, 0x10, {0xE4, 0x80, 0x0B, 0x01, 0x02, 0x04, 0x08, 0x10, 0x20, 0x40, 0x80, 0x90, 0x0D, 0xE8, 0xE4, 0x7E}},
{0xa1f, 0x10, {0x01, 0x93, 0x60, 0xBC, 0xA3, 0xFF, 0x54, 0x3F, 0x30, 0xE5, 0x09, 0x54, 0x1F, 0xFE, 0xE4, 0x93}},
{0xa2f, 0x10, {0xA3, 0x60, 0x01, 0x0E, 0xCF, 0x54, 0xC0, 0x25, 0xE0, 0x60, 0xA8, 0x40, 0xB8, 0xE4, 0x93, 0xA3}},
{0xa3f, 0x10, {0xFA, 0xE4, 0x93, 0xA3, 0xF8, 0xE4, 0x93, 0xA3, 0xC8, 0xC5, 0x82, 0xC8, 0xCA, 0xC5, 0x83, 0xCA}},
{0xa4f, 0x10, {0xF0, 0xA3, 0xC8, 0xC5, 0x82, 0xC8, 0xCA, 0xC5, 0x83, 0xCA, 0xDF, 0xE9, 0xDE, 0xE7, 0x80, 0xBE}},
{0xdfd, 0x1, {0x00}},
{0x83d, 0x10, {0xC5, 0xF0, 0xF8, 0xA3, 0xE0, 0x28, 0xF0, 0xC5, 0xF0, 0xF8, 0xE5, 0x82, 0x15, 0x82, 0x70, 0x02}},
{0x84d, 0x6, {0x15, 0x83, 0xE0, 0x38, 0xF0, 0x22}},
{0x7f92, 0x1, {0x01}},
{0x7f92, 0x1, {0x00}},
{0xffff, 0, {0x00}}
};

#endif
