/*
 * XmsBuildThumb.c
 * Copyright (C) Michael Stickel <michael@cubic.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

#define UseThumb thumb0_pm

static char * thumb0_pm[] = {
  "                 ",
  "                .",
  "  XXXXXXXXXXXXX..",
  "  XXXXXXXXXXXXX..",
  "  XXXXXXXXXXXXX..",
  "  XXXXXXXXXXXXX..",
  "  XXXXXXXXXXXXX..",
  " ................",
  "                .",
  "  IIIIIIIIIIIII..",
  "  IIIIIIIIIIIII..",
  "  IIIIIIIIIIIII..",
  "  IIIIIIIIIIIII..",
  "  IIIIIIIIIIIII..",
  "  IIIIIIIIIIIII..",
  "  IIIIIIIIIIIII..",
  "  IIIIIIIIIIIII..",
  "  IIIIIIIIIIIII..",
  "  IIIIIIIIIIIII..",
  "  IIIIIIIIIIIII..",
  "  IIIIIIIIIIIII..",
  "  IIIIIIIIIIIII..",
  " ................",
  "                .",
  "  XXXXXXXXXXXXX..",
  "  XXXXXXXXXXXXX..",
  "  XXXXXXXXXXXXX..",
  "  XXXXXXXXXXXXX..",
  "  XXXXXXXXXXXXX..",
  "  ...............",
  " ................",
  NULL 
};

static char *thumb1_pm[] = {
  "                 ",
  "                .",
  "  ...............",
  "  XXXXXXXXXXXXX..",
  "  ...............",
  "  XXXXXXXXXXXXX..",
  "  ...............",
  "  XXXXXXXXXXXXX..",
  "  ...............",
  "  XXXXXXXXXXXXX..",
  "  ...............",
  "  XXXXXXXXXXXXX..",
  "  ...............",
  " IIIIIIIIIIIIIII.",
  " IIIIIIIIIIIIIII.",
  " IIIIIIIIIIIIIII.",
  "               ..",
  "  XXXXXXXXXXXXX..",
  "               ..",
  "  XXXXXXXXXXXXX..",
  "               ..",
  "  XXXXXXXXXXXXX..",
  "               ..",
  "  XXXXXXXXXXXXX..",
  "               ..",
  "  XXXXXXXXXXXXX..",
  "               ..",
  "  XXXXXXXXXXXXX..",
  "               ..",
  " ................",
  ".................",
  NULL
};

static char *thumb2_pm[] = {
  "                .",
  "               ..",
  "  XXXXXXXXXXXXX..",
  "  XXXXXXXXXXXXX..",
  "  ...............",
  "B             ..B",
  "B  XXXXXXXXXXX..B",
  "B  XXXXXXXXXXX..B",
  "B  .............B",
  "BB           ..BB",
  "BB  XXXXXXXXX..BB",
  "BB  XXXXXXXXX..BB",
  "BB  ...........BB",
  "BB          ...BB",
  "BB  IIIIIIII...BB",
  "BB  IIIIIIII...BB",
  "BB  IIIIIIII...BB",
  "BB  ...........BB",
  "BB           ..BB",
  "BB  XXXXXXXXX..BB",
  "BB  XXXXXXXXX..BB",
  "B   ............B",
  "B             ..B",
  "B  XXXXXXXXXXX..B",
  "B  XXXXXXXXXXX..B",
  "   ..............",
  "               ..",
  "  XXXXXXXXXXXXX..",
  "  XXXXXXXXXXXXX..",
  "  ...............",
  " ................",
  NULL
};

static char * thumb3_pm[] = {
  "                 ",
  "                .",
  "  XXXXXXXXXXXXX..",
  "  XXXXXXXXXXXXX..",
  "  XXXXXXXXXXXXX..",
  "  .XXXXXXXXXXX.. ",
  "B  .XXXXXXXXX.. B",
  "BB  XXXXXXXXX. BB",
  "BBB XXXXXXXXX.BBB",
  "BBB XXXXXXXXX.BBB",
  "BBB XXXXXXXXX.BBB",
  "BBB XXXXXXXXX.BBB",
  "BBB XXXXXXXXX.BBB",
  "BBB XXXXXXXXX.BBB",
  "BBB X       X.BBB",
  "BBB X IIIII.X.BBB",
  "BBB X IIIII.X.BBB",
  "BBB X.......X.BBB",
  "BBB XXXXXXXXX.BBB",
  "BBB XXXXXXXXX.BBB",
  "BBB XXXXXXXXX.BBB",
  "BBB XXXXXXXXX.BBB",
  "BBB XXXXXXXXX.BBB",
  "BB  XXXXXXXXX. BB",
  "B   XXXXXXXXX.. B",
  "   XXXXXXXXXXX.. ",
  "  XXXXXXXXXXXXX..",
  "  XXXXXXXXXXXXX..",
  "  XXXXXXXXXXXXX..",
  " ................",
  ".................",
  NULL};

char **thumbs[] = {thumb0_pm, thumb1_pm, thumb2_pm, thumb3_pm};

static void thumb_put_pixel (Display *d, XsFaderWidget w, int x, int y, int c)
{
  if (w)
    switch (c)
      {
      case 'B': XDrawPoint(d,w->fader.th.pm, w->fader.GC_bg, x, y); break; /*backgr.*/
      case 'F': XDrawPoint(d,w->fader.th.pm, w->fader.GC_fg, x, y); break; /*foregr.*/
      case ' ': XDrawPoint(d,w->fader.th.pm, w->fader.GC_shadow1, x, y); break; /*shadow1*/
      case '.': XDrawPoint(d,w->fader.th.pm, w->fader.GC_shadow2, x, y); break; /*shadow2*/
      case 'X': XDrawPoint(d,w->fader.th.pm, w->fader.GC_slider,  x, y); break; /*slider*/
      case 'I': XDrawPoint(d,w->fader.th.pm, w->fader.GC_ident,   x, y); break; /*ident*/
      }
}

static void XmsBuildThumb (XsFaderWidget w, int width, int height, int num)
{
  int y=0, x=0;
  Display *d  = XtDisplay(w);
  char *t_data;
  char **thumb = thumbs[num%4];

#ifdef DEBUG
  printf ("XmsBuildThumb (?, %d, %d, %d)\n", width, height, num);
#endif
  /* check the abbruchbedinung! error? */
  for (y=0; (t_data = thumb[y]); y++)
    {
      int pwidth = strlen (t_data);
      for (x=0; x < (width/2+(width%2))  &&  x < ((pwidth/2)+(pwidth%2)); x++)
	{
          thumb_put_pixel (d, w, x, y, t_data[x]);
          thumb_put_pixel (d, w, (width-1)-x, y, t_data[(pwidth-1)-x]);
	}
#ifdef DEBUG
      for (; x < (width/2); x++)
        thumb_put_pixel (d, w, x, y, t_data[pwidth/2]);
#endif
    }
#ifdef DEBUG
  printf ("end-XmsBuildThumb\n");
#endif
}
