#!/usr/bin/env python
#
# Copyright 2009 Canonical Ltd.
#
# This file is part of desktopcouch.
#
#  desktopcouch is free software: you can redistribute it and/or modify
# it under the terms of the GNU Lesser General Public License version 3
# as published by the Free Software Foundation.
#
# desktopcouch is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with desktopcouch.  If not, see <http://www.gnu.org/licenses/>.
"""setup.py"""

from setuptools import setup, find_packages
from DistUtilsExtra.command import *

setup(
    name='desktopcouch',
    version='0.6.6',
    description='A Desktop CouchDB instance.',
    url='https://launchpad.net/desktopcouch',
    license='LGPL-3',
    author='Stuart Langridge',
    author_email='stuart.langridge@canonical.com',
    test_suite="runtests.get_test_suite",
    packages=find_packages(),
    scripts=['bin/desktopcouch-pair'],
    data_files = [('/usr/lib/desktopcouch/', ['bin/desktopcouch-service',
                                              'bin/desktopcouch-get-port',
                                              'bin/desktopcouch-stop']),
                  # Be sure all additions are reflected in MANIFEST.in !
                  ('/usr/share/doc/python-desktopcouch-records/api/',
                      ['desktopcouch/records/doc/records.txt',
                      'desktopcouch/records/doc/field_registry.txt',
                      'desktopcouch/contacts/schema.txt']),
                  ('/etc/xdg/desktop-couch/',
                      ['config/desktop-couch/compulsory-auth.ini']),
                  ('/usr/share/desktopcouch/', ['data/couchdb.tmpl']),
                  ('/usr/share/dbus-1/services/', ['org.desktopcouch.CouchDB.service']),
                  ('share/man/man1/', ['docs/man/desktopcouch-pair.1'])],
    cmdclass = { "build" : build_extra.build_extra,
                 "build_i18n" :  build_i18n.build_i18n }
)
