/*
 * Decompiled with CFR 0.152.
 */
package se.idonex.servlet;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.ParseException;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.servlet.ServletContext;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import se.idonex.servlet.HTTPInputStream;
import se.idonex.servlet.RoxenServletContext;

class ServletRequest
implements HttpServletRequest {
    ServletContext context;
    int contentLength;
    String contentType;
    String protocol;
    String scheme;
    String serverName;
    int serverPort;
    String remoteAddr;
    String remoteHost;
    String data;
    String servletPath;
    String pathInfo;
    String method;
    String remuser;
    String requestURI;
    String queryString;
    String pathTranslated;
    Dictionary parameters = new Hashtable();
    Dictionary attributes = new Hashtable();
    Dictionary headers = new Hashtable();
    BufferedReader reader = null;
    ServletInputStream inputStream = null;

    ServletRequest(ServletContext servletContext, int n, String string, String string2, String string3, String string4, int n2, String string5, String string6, String string7, String string8, String string9, String string10, String string11, String string12, String string13, String string14) {
        this.context = servletContext;
        this.contentLength = n;
        this.contentType = string;
        this.protocol = string2;
        this.scheme = string3;
        this.serverName = string4;
        this.serverPort = n2;
        this.remoteAddr = string5;
        this.remoteHost = string6;
        this.data = string7;
        this.servletPath = string8;
        this.pathInfo = string9;
        this.method = string10;
        this.remuser = string11;
        this.requestURI = string12;
        this.queryString = string13;
        this.pathTranslated = string14;
    }

    protected static native String blockingIPToHost(String var0);

    public Object getAttribute(String string) {
        return this.attributes.get(string);
    }

    public String getAuthType() {
        if (this.remuser != null) {
            return "Basic";
        }
        return null;
    }

    public String getCharacterEncoding() {
        return "8859_1";
    }

    public int getContentLength() {
        return this.contentLength;
    }

    public String getContentType() {
        return this.contentType;
    }

    public Cookie[] getCookies() {
        String string = this.getHeader("Cookie");
        if (string == null) {
            return new Cookie[0];
        }
        HeaderTokenizer headerTokenizer = new HeaderTokenizer(string);
        Vector<Cookie> vector = new Vector<Cookie>();
        Cookie cookie = null;
        int n = 0;
        while (headerTokenizer.more()) {
            String string2 = headerTokenizer.getToken();
            headerTokenizer.discard('=');
            String string3 = headerTokenizer.getValue();
            if (headerTokenizer.more()) {
                headerTokenizer.discard(headerTokenizer.lookingAt(',') ? (char)',' : ';');
            }
            if (string2.startsWith("$")) {
                if (string2.equals("$version")) {
                    n = Integer.parseInt(string3);
                    continue;
                }
                if (cookie == null) continue;
                if (string2.equals("$domain")) {
                    cookie.setDomain(string3);
                    continue;
                }
                if (!string2.equals("$path")) continue;
                cookie.setPath(string3);
                continue;
            }
            cookie = new Cookie(string2, string3);
            vector.add(cookie);
            if (n == 0) continue;
            cookie.setVersion(n);
        }
        return vector.toArray(new Cookie[vector.size()]);
    }

    public long getDateHeader(String string) throws IllegalArgumentException {
        String string2 = this.getHeader(string);
        try {
            if (string2 == null) {
                return -1L;
            }
            return RoxenServletContext.dateformat.parse(string2).getTime();
        }
        catch (ParseException parseException) {
            throw new IllegalArgumentException(parseException.getMessage());
        }
    }

    public String getHeader(String string) {
        if (this.headers == null) {
            return null;
        }
        return (String)this.headers.get(string.toLowerCase());
    }

    public Enumeration getHeaderNames() {
        if (this.headers == null) {
            return null;
        }
        return this.headers.keys();
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this.inputStream == null) {
            this.inputStream = new HTTPInputStream(this.data);
        }
        return this.inputStream;
    }

    public int getIntHeader(String string) throws NumberFormatException {
        String string2 = this.getHeader(string);
        if (string2 == null) {
            return -1;
        }
        return Integer.parseInt(string2);
    }

    public String getMethod() {
        return this.method;
    }

    public String getParameter(String string) {
        String[] stringArray = this.getParameterValues(string);
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        return stringArray[0];
    }

    public Enumeration getParameterNames() {
        return this.parameters.keys();
    }

    public String[] getParameterValues(String string) {
        String string2 = (String)this.parameters.get(string);
        if (string2 == null) {
            return null;
        }
        int n = 0;
        int n2 = 0;
        int n3 = string2.length();
        int n4 = 1;
        while (--n3 >= 0) {
            if (string2.charAt(n3) != '\u0000') continue;
            ++n4;
        }
        String[] stringArray = new String[n4];
        --n4;
        n3 = 0;
        while (n2 < n4) {
            if (string2.charAt(n3) == '\u0000') {
                stringArray[n2++] = string2.substring(n, n3);
                n = n3 + 1;
            }
            ++n3;
        }
        stringArray[n4] = string2.substring(n3);
        return stringArray;
    }

    public String getPathInfo() {
        return this.pathInfo;
    }

    public String getPathTranslated() {
        return this.pathTranslated;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public BufferedReader getReader() throws IOException {
        if (this.reader == null) {
            this.reader = new BufferedReader(new InputStreamReader((InputStream)this.getInputStream(), this.getCharacterEncoding()));
        }
        return this.reader;
    }

    public String getRealPath(String string) {
        return this.context.getRealPath(string);
    }

    public String getRemoteAddr() {
        return this.remoteAddr;
    }

    public String getRemoteHost() {
        if (this.remoteHost == null) {
            this.remoteHost = ServletRequest.blockingIPToHost(this.remoteAddr);
        }
        return this.remoteHost;
    }

    public String getRemoteUser() {
        return this.remuser;
    }

    public String getRequestURI() {
        return this.requestURI;
    }

    public String getRequestedSessionId() {
        return null;
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getServerName() {
        return this.serverName;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public String getServletPath() {
        return this.servletPath;
    }

    public HttpSession getSession(boolean bl) {
        return null;
    }

    public boolean isRequestedSessionIdFromCookie() {
        return false;
    }

    public boolean isRequestedSessionIdFromUrl() {
        return false;
    }

    public boolean isRequestedSessionIdValid() {
        return false;
    }

    protected static class HeaderTokenizer {
        String header;
        int pos;
        int len;

        public HeaderTokenizer(String string) {
            this.header = string;
            this.pos = 0;
            this.len = string.length();
        }

        public void discard(char c) {
            if (!this.lookingAt(c)) {
                throw new IllegalArgumentException("header: " + this.header);
            }
            ++this.pos;
        }

        public String getToken() {
            this.skipWS();
            int n = this.pos;
            while (this.pos < this.len && Character.isJavaIdentifierPart(this.header.charAt(this.pos))) {
                ++this.pos;
            }
            if (this.pos == n) {
                throw new IllegalArgumentException("header: " + this.header);
            }
            return this.header.substring(n, this.pos).toLowerCase();
        }

        public String getValue() {
            if (!this.lookingAt('\"')) {
                return this.getToken();
            }
            int n = this.pos++;
            while (this.pos < this.len && this.header.charAt(this.pos) != '\"') {
                if (this.header.charAt(this.pos) == '\\') {
                    this.pos += 2;
                    continue;
                }
                ++this.pos;
            }
            if (this.pos >= this.len) {
                throw new IllegalArgumentException("header: " + this.header);
            }
            String string = this.header.substring(n, this.pos++);
            n = 0;
            while ((n = string.indexOf(92, n)) >= 0) {
                string = String.valueOf(string.substring(0, n)) + string.substring(n + 1);
                ++n;
            }
            return string;
        }

        public boolean lookingAt(char c) {
            this.skipWS();
            return this.pos < this.len && this.header.charAt(this.pos) == c;
        }

        public boolean more() {
            this.skipWS();
            return this.pos < this.len;
        }

        protected final void skipWS() {
            while (this.pos < this.len && this.header.charAt(this.pos) <= ' ') {
                ++this.pos;
            }
        }
    }
}

